;************************************************************************
;
; 	$Workfile:   vgadac.inc  $
; 
; 	Copyright 1989, 1990 Quadtel Corporation.
; 	All rights reserved.
; 
; 	Modification History:
; 	$Log:   E:/vcs/vga/vgadac.inv  $
;      
;         Rev 1.0   21 Dec 1990 11:03:04   Darryl
;      Initial checkin to VCS.
;
;************************************************************************

if 0
	%OUT	Assembling VGA DAC Table

	PUBLIC	DAC_Color_200_Table
	PUBLIC	DAC_Gray_200_Table
	PUBLIC	DAC_Color_400_Table
	PUBLIC	DAC_Gray_400_Table
	PUBLIC	DAC_Mono_Table
	PUBLIC	DAC_Color_13_Table
	PUBLIC	DAC_Gray_13_Table
	PUBLIC	DAC_Default_Gray_Table
	PUBLIC	DAC_256_Color_Table

;****************************************************************
;   This table contains the 64 red, green, blue DAC values for
;   a color display when using modes 0-3 (200 scan mode),
;   modes 4-6, and modes 9-0EH.
;****************************************************************

DAC_Color_200_Table	LABEL	BYTE
	DB_DAC	00H, 00H, 00H				;00H
	DB_DAC	00H, 00H, 2AH
	DB_DAC	00H, 2AH, 00H
	DB_DAC	00H, 2AH, 2AH
	DB_DAC	2AH, 00H, 00H
	DB_DAC	2AH, 00H, 2AH
	DB_DAC	2AH, 15H, 00H
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	00H, 00H, 00H				;08H
	DB_DAC	00H, 00H, 2AH
	DB_DAC	00H, 2AH, 00H
	DB_DAC	00H, 2AH, 2AH
	DB_DAC	2AH, 00H, 00H
	DB_DAC	2AH, 00H, 2AH
	DB_DAC	2AH, 15H, 00H
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	15H, 15H, 15H				;10H
	DB_DAC	15H, 15H, 3FH
	DB_DAC	15H, 3FH, 15H
	DB_DAC	15H, 3FH, 3FH
	DB_DAC	3FH, 15H, 15H
	DB_DAC	3FH, 15H, 3FH
	DB_DAC	3FH, 3FH, 15H
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	15H, 15H, 15H				;18H
	DB_DAC	15H, 15H, 3FH
	DB_DAC	15H, 3FH, 15H
	DB_DAC	15H, 3FH, 3FH
	DB_DAC	3FH, 15H, 15H
	DB_DAC	3FH, 15H, 3FH
	DB_DAC	3FH, 3FH, 15H
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	00H, 00H, 00H				;20H
	DB_DAC	00H, 00H, 2AH
	DB_DAC	00H, 2AH, 00H
	DB_DAC	00H, 2AH, 2AH
	DB_DAC	2AH, 00H, 00H
	DB_DAC	2AH, 00H, 2AH
	DB_DAC	2AH, 15H, 00H
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	00H, 00H, 00H				;28H
	DB_DAC	00H, 00H, 2AH
	DB_DAC	00H, 2AH, 00H
	DB_DAC	00H, 2AH, 2AH
	DB_DAC	2AH, 00H, 00H
	DB_DAC	2AH, 00H, 2AH
	DB_DAC	2AH, 15H, 00H
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	15H, 15H, 15H				;30H
	DB_DAC	15H, 15H, 3FH
	DB_DAC	15H, 3FH, 15H
	DB_DAC	15H, 3FH, 3FH
	DB_DAC	3FH, 15H, 15H
	DB_DAC	3FH, 15H, 3FH
	DB_DAC	3FH, 3FH, 15H
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	15H, 15H, 15H				;38H
	DB_DAC	15H, 15H, 3FH
	DB_DAC	15H, 3FH, 15H
	DB_DAC	15H, 3FH, 3FH
	DB_DAC	3FH, 15H, 15H
	DB_DAC	3FH, 15H, 3FH
	DB_DAC	3FH, 3FH, 15H
	DB_DAC	3FH, 3FH, 3FH				;3FH

;****************************************************************
;   This table contains the 64 red, green, blue DAC values for
;   a monochrome display to produce different shades of gray.
;   This table is used for modes 0-3 (200 scan mode), modes 4-6,
;   and modes 9-0EH.
;****************************************************************

DAC_Gray_200_Table	LABEL	BYTE
	DB_DAC	00H, 00H, 00H				;00H
	DB_DAC	05H, 05H, 05H
	DB_DAC	11H, 11H, 11H
	DB_DAC	1CH, 1CH, 1CH
	DB_DAC	08H, 08H, 08H
	DB_DAC	0BH, 0BH, 0BH
	DB_DAC	14H, 14H, 14H
	DB_DAC	28H, 28H, 28H
	DB_DAC	00H, 00H, 00H				;08H
	DB_DAC	05H, 05H, 05H
	DB_DAC	11H, 11H, 11H
	DB_DAC	1CH, 1CH, 1CH
	DB_DAC	08H, 08H, 08H
	DB_DAC	0BH, 0BH, 0BH
	DB_DAC	14H, 14H, 14H
	DB_DAC	28H, 28H, 28H
	DB_DAC	0EH, 0EH, 0EH				;10H
	DB_DAC	18H, 18H, 18H
	DB_DAC	2DH, 2DH, 2DH
	DB_DAC	32H, 32H, 32H
	DB_DAC	20H, 20H, 20H
	DB_DAC	24H, 24H, 24H
	DB_DAC	38H, 38H, 38H
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	0EH, 0EH, 0EH				;18H
	DB_DAC	18H, 18H, 18H
	DB_DAC	2DH, 2DH, 2DH
	DB_DAC	32H, 32H, 32H
	DB_DAC	20H, 20H, 20H
	DB_DAC	24H, 24H, 24H
	DB_DAC	38H, 38H, 38H
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	00H, 00H, 00H				;20H
	DB_DAC	05H, 05H, 05H
	DB_DAC	11H, 11H, 11H
	DB_DAC	1CH, 1CH, 1CH
	DB_DAC	08H, 08H, 08H
	DB_DAC	0BH, 0BH, 0BH
	DB_DAC	14H, 14H, 14H
	DB_DAC	28H, 28H, 28H
	DB_DAC	00H, 00H, 00H				;28H
	DB_DAC	05H, 05H, 05H
	DB_DAC	11H, 11H, 11H
	DB_DAC	1CH, 1CH, 1CH
	DB_DAC	08H, 08H, 08H
	DB_DAC	0BH, 0BH, 0BH
	DB_DAC	14H, 14H, 14H
	DB_DAC	28H, 28H, 28H
	DB_DAC	0EH, 0EH, 0EH				;30H
	DB_DAC	18H, 18H, 18H
	DB_DAC	2DH, 2DH, 2DH
	DB_DAC	32H, 32H, 32H
	DB_DAC	20H, 20H, 20H
	DB_DAC	24H, 24H, 24H
	DB_DAC	38H, 38H, 38H
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	0EH, 0EH, 0EH				;38H
	DB_DAC	18H, 18H, 18H
	DB_DAC	2DH, 2DH, 2DH
	DB_DAC	32H, 32H, 32H
	DB_DAC	20H, 20H, 20H
	DB_DAC	24H, 24H, 24H
	DB_DAC	38H, 38H, 38H
	DB_DAC	3FH, 3FH, 3FH				;3FH

;****************************************************************
;   This table contains the 64 red, green, blue DAC values for
;   a color display when displaying 350 or 400 lines. This table
;   is used for modes 0-3 (350 scan mode), modes 8, and modes
;   10H through 12H.
;****************************************************************

DAC_Color_400_Table	LABEL	BYTE
	DB_DAC	00H, 00H, 00H				;00H
	DB_DAC	00H, 00H, 2AH
	DB_DAC	00H, 2AH, 00H
	DB_DAC	00H, 2AH, 2AH
	DB_DAC	2AH, 00H, 00H
	DB_DAC	2AH, 00H, 2AH
	DB_DAC	2AH, 2AH, 00H
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	00H, 00H, 15H				;08H
	DB_DAC	00H, 00H, 3FH
	DB_DAC	00H, 2AH, 15H
	DB_DAC	00H, 2AH, 3FH
	DB_DAC	2AH, 00H, 15H
	DB_DAC	2AH, 00H, 3FH
	DB_DAC	2AH, 2AH, 15H
	DB_DAC	2AH, 2AH, 3FH
	DB_DAC	00H, 15H, 00H				;10H
	DB_DAC	00H, 15H, 2AH
	DB_DAC	00H, 3FH, 00H
	DB_DAC	00H, 3FH, 2AH
	DB_DAC	2AH, 15H, 00H
	DB_DAC	2AH, 15H, 2AH
	DB_DAC	2AH, 3FH, 00H
	DB_DAC	2AH, 3FH, 2AH
	DB_DAC	00H, 15H, 15H				;18H
	DB_DAC	00H, 15H, 3FH
	DB_DAC	00H, 3FH, 15H
	DB_DAC	00H, 3FH, 3FH
	DB_DAC	2AH, 15H, 15H
	DB_DAC	2AH, 15H, 3FH
	DB_DAC	2AH, 3FH, 15H
	DB_DAC	2AH, 3FH, 3FH
	DB_DAC	15H, 00H, 00H				;20H
	DB_DAC	15H, 00H, 2AH
	DB_DAC	15H, 2AH, 00H
	DB_DAC	15H, 2AH, 2AH
	DB_DAC	3FH, 00H, 00H
	DB_DAC	3FH, 00H, 2AH
	DB_DAC	3FH, 2AH, 00H
	DB_DAC	3FH, 2AH, 2AH
	DB_DAC	15H, 00H, 15H				;28H
	DB_DAC	15H, 00H, 3FH
	DB_DAC	15H, 2AH, 15H
	DB_DAC	15H, 2AH, 3FH
	DB_DAC	3FH, 00H, 15H
	DB_DAC	3FH, 00H, 3FH
	DB_DAC	3FH, 2AH, 15H
	DB_DAC	3FH, 2AH, 3FH
	DB_DAC	15H, 15H, 00H				;30H
	DB_DAC	15H, 15H, 2AH
	DB_DAC	15H, 3FH, 00H
	DB_DAC	15H, 3FH, 2AH
	DB_DAC	3FH, 15H, 00H
	DB_DAC	3FH, 15H, 2AH
	DB_DAC	3FH, 3FH, 00H
	DB_DAC	3FH, 3FH, 2AH
	DB_DAC	15H, 15H, 15H				;38H
	DB_DAC	15H, 15H, 3FH
	DB_DAC	15H, 3FH, 15H
	DB_DAC	15H, 3FH, 3FH
	DB_DAC	3FH, 15H, 15H
	DB_DAC	3FH, 15H, 3FH
	DB_DAC	3FH, 3FH, 15H
	DB_DAC	3FH, 3FH, 3FH				;3FH

;****************************************************************
;   This table contains the 64 red, green, blue DAC values for
;   a monochrome display to produce different shades of gray.
;   This table is used for modes 0-3 (350 scan mode), modes 8,
;   and modes 10H through 12H.
;****************************************************************

DAC_Gray_400_Table	LABEL	BYTE
	DB_DAC	00H, 00H, 00H				;00H
	DB_DAC	05H, 05H, 05H
	DB_DAC	11H, 11H, 11H
	DB_DAC	1CH, 1CH, 1CH
	DB_DAC	08H, 08H, 08H
	DB_DAC	0BH, 0BH, 0BH
	DB_DAC	25H, 25H, 25H
	DB_DAC	28H, 28H, 28H
	DB_DAC	02H, 02H, 02H				;08H
	DB_DAC	07H, 07H, 07H
	DB_DAC	1BH, 1BH, 1BH
	DB_DAC	20H, 20H, 20H
	DB_DAC	0FH, 0FH, 0FH
	DB_DAC	14H, 14H, 14H
	DB_DAC	28H, 28H, 28H
	DB_DAC	2CH, 2CH, 2CH
	DB_DAC	0CH, 0CH, 0CH
	DB_DAC	11H, 11H, 11H				;10H
	DB_DAC	25H, 25H, 25H
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	14H, 14H, 14H
	DB_DAC	1EH, 1EH, 1EH
	DB_DAC	32H, 32H, 32H
	DB_DAC	36H, 36H, 36H
	DB_DAC	0FH, 0FH, 0FH
	DB_DAC	13H, 13H, 13H				;18H
	DB_DAC	27H, 27H, 27H
	DB_DAC	2CH, 2CH, 2CH
	DB_DAC	1BH, 1BH, 1BH
	DB_DAC	20H, 20H, 20H
	DB_DAC	34H, 34H, 34H
	DB_DAC	39H, 39H, 39H
	DB_DAC	06H, 06H, 06H
	DB_DAC	0BH, 0BH, 0BH				;20H
	DB_DAC	1FH, 1FH, 1FH
	DB_DAC	24H, 24H, 24H
	DB_DAC	13H, 13H, 13H
	DB_DAC	18H, 18H, 18H
	DB_DAC	2CH, 2CH, 2CH
	DB_DAC	30H, 30H, 30H
	DB_DAC	09H, 09H, 09H
	DB_DAC	0DH, 0DH, 0DH				;28H
	DB_DAC	21H, 21H, 21H
	DB_DAC	26H, 26H, 26H
	DB_DAC	15H, 15H, 15H
	DB_DAC	1AH, 1AH, 1AH
	DB_DAC	2EH, 2EH, 2EH
	DB_DAC	33H, 33H, 33H
	DB_DAC	13H, 13H, 13H
	DB_DAC	17H, 17H, 17H
	DB_DAC	2BH, 2BH, 2BH				;30H
	DB_DAC	30H, 30H, 30H
	DB_DAC	1FH, 1FH, 1FH
	DB_DAC	24H, 24H, 24H
	DB_DAC	38H, 38H, 38H
	DB_DAC	3DH, 3DH, 3DH
	DB_DAC	0EH, 0EH, 0EH
	DB_DAC	18H, 18H, 18H
	DB_DAC	2DH, 2DH, 2DH				;38H
	DB_DAC	32H, 32H, 32H
	DB_DAC	20H, 20H, 20H
	DB_DAC	24H, 24H, 24H
	DB_DAC	38H, 38H, 38H
	DB_DAC	3FH, 3FH, 3FH				;3FH

;****************************************************************
;   This table contains the 64 red, green, blue DAC values for
;   a monochrome or color display to produce different shades
;   of gray. This table is used for monochrome modes 7 and 0FH.
;****************************************************************

DAC_Mono_Table	LABEL	BYTE
	DB_DAC	00H, 00H, 00H				;00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	2AH, 2AH, 2AH				;08H
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH

IFDEF ADAPTER
	DB_DAC	2AH, 2AH, 2AH				;10H
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
ELSE
	DB_DAC	00H, 00H, 00H				;10H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
ENDIF

	DB_DAC	3FH, 3FH, 3FH				;18H
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	00H, 00H, 00H				;20H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	2AH, 2AH, 2AH				;28H
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH

IFDEF ADAPTER
	DB_DAC	2AH, 2AH, 2AH				;30H
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	2AH, 2AH, 2AH
ELSE
	DB_DAC	00H, 00H, 00H				;30H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
	DB_DAC	00H, 00H, 00H
ENDIF

	DB_DAC	3FH, 3FH, 3FH				;38H
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	3FH, 3FH, 3FH
	DB_DAC	3FH, 3FH, 3FH				;3FH

;****************************************************************
;   This table for mode 13 contains the red, green, and blue
;   DAC values for a color display. These are the 16 standard
;   VGA colors.
;****************************************************************

DAC_Color_13_Table	LABEL	BYTE
	DB_DAC	00H, 00H, 00H				;00H
	DB_DAC	00H, 00H, 2AH
	DB_DAC	00H, 2AH, 00H
	DB_DAC	00H, 2AH, 2AH
	DB_DAC	2AH, 00H, 00H
	DB_DAC	2AH, 00H, 2AH
	DB_DAC	2AH, 15H, 00H
	DB_DAC	2AH, 2AH, 2AH
	DB_DAC	15H, 15H, 15H				;08H
	DB_DAC	15H, 15H, 3FH
	DB_DAC	15H, 3FH, 15H
	DB_DAC	15H, 3FH, 3FH
	DB_DAC	3FH, 15H, 15H
	DB_DAC	3FH, 15H, 3FH
	DB_DAC	3FH, 3FH, 15H
	DB_DAC	3FH, 3FH, 3FH				;0FH

;****************************************************************
;   This table for mode 13 contains the red, green, and blue
;   DAC values for a monochrome display. These are the 16
;   standard VGA colors (gray shades).
;****************************************************************

DAC_Gray_13_Table	LABEL	BYTE
	DB_DAC	00H, 00H, 00H				;00H
	DB_DAC	05H, 05H, 05H
	DB_DAC	11H, 11H, 11H
	DB_DAC	1CH, 1CH, 1CH
	DB_DAC	08H, 08H, 08H
	DB_DAC	0BH, 0BH, 0BH
	DB_DAC	14H, 14H, 14H
	DB_DAC	28H, 28H, 28H
	DB_DAC	0EH, 0EH, 0EH				;08H
	DB_DAC	18H, 18H, 18H
	DB_DAC	2DH, 2DH, 2DH
	DB_DAC	32H, 32H, 32H
	DB_DAC	20H, 20H, 20H
	DB_DAC	24H, 24H, 24H
	DB_DAC	38H, 38H, 38H
	DB_DAC	3FH, 3FH, 3FH				;0FH

;****************************************************************
;   This table contains the  red, green, and blue DAC values
;   for DAC registers 10H-1FH in mode 13. These are default
;   gray shades and should always be loaded regardless of the
;   monitor type.
;****************************************************************

DAC_Default_Gray_Table	LABEL	BYTE
	DB_DAC	00H, 00H, 00H				;10H
	DB_DAC	05H, 05H, 05H
	DB_DAC	08H, 08H, 08H
	DB_DAC	0BH, 0BH, 0BH
	DB_DAC	0EH, 0EH, 0EH
	DB_DAC	11H, 11H, 11H
	DB_DAC	14H, 14H, 14H
	DB_DAC	18H, 18H, 18H
	DB_DAC	1CH, 1CH, 1CH				;18H
	DB_DAC	20H, 20H, 20H
	DB_DAC	24H, 24H, 24H
	DB_DAC	28H, 28H, 28H
	DB_DAC	2DH, 2DH, 2DH
	DB_DAC	32H, 32H, 32H
	DB_DAC	38H, 38H, 38H
	DB_DAC	3FH, 3FH, 3FH				;1FH

;****************************************************************
;   This table contains the  red, green, and blue DAC values
;   for DAC registers 20H-F7H in mode 13. These values are
;   for a color system only. Gray scale summing will be
;   performed on monochrome monitors.
;****************************************************************

DAC_256_Color_Table	LABEL	BYTE
	DB_DAC	00H, 00H, 3FH				;20H
	DB_DAC	10H, 00H, 3FH
	DB_DAC	1FH, 00H, 3FH
	DB_DAC	2FH, 00H, 3FH
	DB_DAC	3FH, 00H, 3FH
	DB_DAC	3FH, 00H, 2FH
	DB_DAC	3FH, 00H, 1FH
	DB_DAC	3FH, 00H, 10H
	DB_DAC	3FH, 00H, 00H				;28H
	DB_DAC	3FH, 10H, 00H
	DB_DAC	3FH, 1FH, 00H
	DB_DAC	3FH, 2FH, 00H
	DB_DAC	3FH, 3FH, 00H
	DB_DAC	2FH, 3FH, 00H
	DB_DAC	1FH, 3FH, 00H
	DB_DAC	10H, 3FH, 00H
	DB_DAC	00H, 3FH, 00H				;30H
	DB_DAC	00H, 3FH, 10H
	DB_DAC	00H, 3FH, 1FH
	DB_DAC	00H, 3FH, 2FH
	DB_DAC	00H, 3FH, 3FH
	DB_DAC	00H, 2FH, 3FH
	DB_DAC	00H, 1FH, 3FH
	DB_DAC	00H, 10H, 3FH
	DB_DAC	1FH, 1FH, 3FH				;38H
	DB_DAC	27H, 1FH, 3FH
	DB_DAC	2FH, 1FH, 3FH
	DB_DAC	37H, 1FH, 3FH
	DB_DAC	3FH, 1FH, 3FH
	DB_DAC	3FH, 1FH, 37H
	DB_DAC	3FH, 1FH, 2FH
	DB_DAC	3FH, 1FH, 27H
	DB_DAC	3FH, 1FH, 1FH				;40H
	DB_DAC	3FH, 27H, 1FH
	DB_DAC	3FH, 2FH, 1FH
	DB_DAC	3FH, 37H, 1FH
	DB_DAC	3FH, 3FH, 1FH
	DB_DAC	37H, 3FH, 1FH
	DB_DAC	2FH, 3FH, 1FH
	DB_DAC	27H, 3FH, 1FH
	DB_DAC	1FH, 3FH, 1FH				;48H
	DB_DAC	1FH, 3FH, 27H
	DB_DAC	1FH, 3FH, 2FH
	DB_DAC	1FH, 3FH, 37H
	DB_DAC	1FH, 3FH, 3FH
	DB_DAC	1FH, 37H, 3FH
	DB_DAC	1FH, 2FH, 3FH
	DB_DAC	1FH, 27H, 3FH
	DB_DAC	2DH, 2DH, 3FH				;50H
	DB_DAC	31H, 2DH, 3FH
	DB_DAC	36H, 2DH, 3FH
	DB_DAC	3AH, 2DH, 3FH
	DB_DAC	3FH, 2DH, 3FH
	DB_DAC	3FH, 2DH, 3AH
	DB_DAC	3FH, 2DH, 36H
	DB_DAC	3FH, 2DH, 31H
	DB_DAC	3FH, 2DH, 2DH				;58H
	DB_DAC	3FH, 31H, 2DH
	DB_DAC	3FH, 36H, 2DH
	DB_DAC	3FH, 3AH, 2DH
	DB_DAC	3FH, 3FH, 2DH
	DB_DAC	3AH, 3FH, 2DH
	DB_DAC	36H, 3FH, 2DH
	DB_DAC	31H, 3FH, 2DH
	DB_DAC	2DH, 3FH, 2DH				;60H
	DB_DAC	2DH, 3FH, 31H
	DB_DAC	2DH, 3FH, 36H
	DB_DAC	2DH, 3FH, 3AH
	DB_DAC	2DH, 3FH, 3FH
	DB_DAC	2DH, 3AH, 3FH
	DB_DAC	2DH, 36H, 3FH
	DB_DAC	2DH, 31H, 3FH
	DB_DAC	00H, 00H, 1CH				;68H
	DB_DAC	07H, 00H, 1CH
	DB_DAC	0EH, 00H, 1CH
	DB_DAC	15H, 00H, 1CH
	DB_DAC	1CH, 00H, 1CH
	DB_DAC	1CH, 00H, 15H
	DB_DAC	1CH, 00H, 0EH
	DB_DAC	1CH, 00H, 07H
	DB_DAC	1CH, 00H, 00H				;70H
	DB_DAC	1CH, 07H, 00H
	DB_DAC	1CH, 0EH, 00H
	DB_DAC	1CH, 15H, 00H
	DB_DAC	1CH, 1CH, 00H
	DB_DAC	15H, 1CH, 00H
	DB_DAC	0EH, 1CH, 00H
	DB_DAC	07H, 1CH, 00H
	DB_DAC	00H, 1CH, 00H				;78H
	DB_DAC	00H, 1CH, 07H
	DB_DAC	00H, 1CH, 0EH
	DB_DAC	00H, 1CH, 15H
	DB_DAC	00H, 1CH, 1CH
	DB_DAC	00H, 15H, 1CH
	DB_DAC	00H, 0EH, 1CH
	DB_DAC	00H, 07H, 1CH
	DB_DAC	0EH, 0EH, 1CH				;80H
	DB_DAC	11H, 0EH, 1CH
	DB_DAC	15H, 0EH, 1CH
	DB_DAC	18H, 0EH, 1CH
	DB_DAC	1CH, 0EH, 1CH
	DB_DAC	1CH, 0EH, 18H
	DB_DAC	1CH, 0EH, 15H
	DB_DAC	1CH, 0EH, 11H
	DB_DAC	1CH, 0EH, 0EH				;88H
	DB_DAC	1CH, 11H, 0EH
	DB_DAC	1CH, 15H, 0EH
	DB_DAC	1CH, 18H, 0EH
	DB_DAC	1CH, 1CH, 0EH
	DB_DAC	18H, 1CH, 0EH
	DB_DAC	15H, 1CH, 0EH
	DB_DAC	11H, 1CH, 0EH
	DB_DAC	0EH, 1CH, 0EH				;90H
	DB_DAC	0EH, 1CH, 11H
	DB_DAC	0EH, 1CH, 15H
	DB_DAC	0EH, 1CH, 18H
	DB_DAC	0EH, 1CH, 1CH
	DB_DAC	0EH, 18H, 1CH
	DB_DAC	0EH, 15H, 1CH
	DB_DAC	0EH, 11H, 1CH
	DB_DAC	14H, 14H, 1CH				;98H
	DB_DAC	16H, 14H, 1CH
	DB_DAC	18H, 14H, 1CH
	DB_DAC	1AH, 14H, 1CH
	DB_DAC	1CH, 14H, 1CH
	DB_DAC	1CH, 14H, 1AH
	DB_DAC	1CH, 14H, 18H
	DB_DAC	1CH, 14H, 16H
	DB_DAC	1CH, 14H, 14H				;A0H
	DB_DAC	1CH, 16H, 14H
	DB_DAC	1CH, 18H, 14H
	DB_DAC	1CH, 1AH, 14H
	DB_DAC	1CH, 1CH, 14H
	DB_DAC	1AH, 1CH, 14H
	DB_DAC	18H, 1CH, 14H
	DB_DAC	16H, 1CH, 14H
	DB_DAC	14H, 1CH, 14H				;A8H
	DB_DAC	14H, 1CH, 16H
	DB_DAC	14H, 1CH, 18H
	DB_DAC	14H, 1CH, 1AH
	DB_DAC	14H, 1CH, 1CH
	DB_DAC	14H, 1AH, 1CH
	DB_DAC	14H, 18H, 1CH
	DB_DAC	14H, 16H, 1CH
	DB_DAC	00H, 00H, 10H				;B0H
	DB_DAC	04H, 00H, 10H
	DB_DAC	08H, 00H, 10H
	DB_DAC	0CH, 00H, 10H
	DB_DAC	10H, 00H, 10H
	DB_DAC	10H, 00H, 0CH
	DB_DAC	10H, 00H, 08H
	DB_DAC	10H, 00H, 04H
	DB_DAC	10H, 00H, 00H				;B8H
	DB_DAC	10H, 04H, 00H
	DB_DAC	10H, 08H, 00H
	DB_DAC	10H, 0CH, 00H
	DB_DAC	10H, 10H, 00H
	DB_DAC	0CH, 10H, 00H
	DB_DAC	08H, 10H, 00H
	DB_DAC	04H, 10H, 00H
	DB_DAC	00H, 10H, 00H				;C0H
	DB_DAC	00H, 10H, 04H
	DB_DAC	00H, 10H, 08H
	DB_DAC	00H, 10H, 0CH
	DB_DAC	00H, 10H, 10H
	DB_DAC	00H, 0CH, 10H
	DB_DAC	00H, 08H, 10H
	DB_DAC	00H, 04H, 10H
	DB_DAC	08H, 08H, 10H				;C8H
	DB_DAC	0AH, 08H, 10H
	DB_DAC	0CH, 08H, 10H
	DB_DAC	0EH, 08H, 10H
	DB_DAC	10H, 08H, 10H
	DB_DAC	10H, 08H, 0EH
	DB_DAC	10H, 08H, 0CH
	DB_DAC	10H, 08H, 0AH
	DB_DAC	10H, 08H, 08H				;D0H
	DB_DAC	10H, 0AH, 08H
	DB_DAC	10H, 0CH, 08H
	DB_DAC	10H, 0EH, 08H
	DB_DAC	10H, 10H, 08H
	DB_DAC	0EH, 10H, 08H
	DB_DAC	0CH, 10H, 08H
	DB_DAC	0AH, 10H, 08H
	DB_DAC	08H, 10H, 08H				;D8H
	DB_DAC	08H, 10H, 0AH
	DB_DAC	08H, 10H, 0CH
	DB_DAC	08H, 10H, 0EH
	DB_DAC	08H, 10H, 10H
	DB_DAC	08H, 0EH, 10H
	DB_DAC	08H, 0CH, 10H
	DB_DAC	08H, 0AH, 10H
	DB_DAC	0BH, 0BH, 10H				;E0H
	DB_DAC	0CH, 0BH, 10H
	DB_DAC	0DH, 0BH, 10H
	DB_DAC	0FH, 0BH, 10H
	DB_DAC	10H, 0BH, 10H
	DB_DAC	10H, 0BH, 0FH
	DB_DAC	10H, 0BH, 0DH
	DB_DAC	10H, 0BH, 0CH
	DB_DAC	10H, 0BH, 0BH				;E8H
	DB_DAC	10H, 0CH, 0BH
	DB_DAC	10H, 0DH, 0BH
	DB_DAC	10H, 0FH, 0BH
	DB_DAC	10H, 10H, 0BH
	DB_DAC	0FH, 10H, 0BH
	DB_DAC	0DH, 10H, 0BH
	DB_DAC	0CH, 10H, 0BH
	DB_DAC	0BH, 10H, 0BH				;F0H
	DB_DAC	0BH, 10H, 0CH
	DB_DAC	0BH, 10H, 0DH
	DB_DAC	0BH, 10H, 0FH
	DB_DAC	0BH, 10H, 10H
	DB_DAC	0BH, 0FH, 10H
	DB_DAC	0BH, 0DH, 10H
	DB_DAC	0BH, 0CH, 10H				;F7H

endif	;0

