/*==========================================================================
  LINE.C

  Example code to draw a line given start and end points. The Mach 64 engine
  does not natively support line drawing in 24 bpp. However, 24 bpp lines
  can be drawn a pixel at a time using the Bressenham or similar algorithm.

  Copyright (c) 1994-1995 ATI Technologies Inc. All rights reserved
 =========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "..\util\atim64.h"
#include "..\util\sample.h"

#define INSTANCE 0

int main (int argc, char *argv[])
{
    // check if Mach64 adapter is installed
    if (detect_mach64 (INSTANCE) != YES_MACH64)
    {
        printf ("mach64 based adapter was not found.\n");
        return (1);
    }

    // fill global query structure by calling Mach 64 ROM
    if (query_hardware () != NO_ERROR)
    {
        printf ("Failed ROM call to query mach64 hardware.\n");
        return (1);
    }

    // Process the command line arguments to override default resolution
    // and color depth settings.
    process_command_line (argc, argv);

    // set an accelerator mode
    if (open_mode (gmode_res, PITCH_XRES, gclr_depth) != NO_ERROR)
    {
        printf ("Error in setting display mode.\n");
        return (1);
    }

    // initialize standard engine context
    init_engine ();
    clear_screen (0, 0, modeinfo.xres, modeinfo.yres);


    /* ---- Draw a line in each octant ---- */

    // The line draw direction is determined in DST_CNTL. These bits are
    // determined in the draw_line() routine from the given start and end
    // point coordinates. Note that the engine does not support lines in 24
    // bpp. However, it is possible to use the engine to draw each 24 bpp
    // pixel of a line and use a line drawing algorithm such as bressenham
    // to determine where the pixels are drawn. The side effect is a great
    // loss in performance especially if patterned lines are considered.

    // source = foreground color
    wait_for_fifo (1);
    regw (DP_SRC, FRGD_SRC_FRGD_CLR);

    // foreground color = WHITE
    set_fg_color (get_color_code (WHITE));

    // top horizontal line
    draw_line (0, 0, modeinfo.xres - 1, 0);

    // right vertical line
    draw_line (modeinfo.xres - 1, 0, modeinfo.xres - 1, modeinfo.yres - 1);

    // bottom horizontal line
    draw_line (modeinfo.xres - 1, modeinfo.yres - 1, 0, modeinfo.yres - 1);

    // left vertical line
    draw_line (0, modeinfo.yres - 1, 0, 0);

    // octant 0 line
    set_fg_color (get_color_code (LIGHTBLUE));
    draw_line (modeinfo.xres / 2, modeinfo.yres / 2,
               modeinfo.xres - 1, modeinfo.yres / 2);

    // octant 1 line
    set_fg_color (get_color_code (LIGHTGREEN));
    draw_line (modeinfo.xres / 2, modeinfo.yres / 2, modeinfo.xres - 1, 0);

    // octant 2 line
    set_fg_color (get_color_code (LIGHTCYAN));
    draw_line (modeinfo.xres / 2, modeinfo.yres / 2, modeinfo.xres / 2, 0);

    // octant 3 line
    set_fg_color (get_color_code (LIGHTRED));
    draw_line (modeinfo.xres / 2, modeinfo.yres / 2, 0, 0);

    // octant 4 line
    set_fg_color (get_color_code (LIGHTMAGENTA));
    draw_line (modeinfo.xres / 2, modeinfo.yres / 2, 0, modeinfo.yres / 2);

    // octant 5 line
    set_fg_color (get_color_code (LIGHTGRAY));
    draw_line (modeinfo.xres / 2, modeinfo.yres / 2, 0, modeinfo.yres - 1);

    // octant 6 line
    set_fg_color (get_color_code (YELLOW));
    draw_line (modeinfo.xres / 2, modeinfo.yres / 2,
               modeinfo.xres / 2, modeinfo.yres - 1);

    // octant 7 line
    set_fg_color (get_color_code (WHITE));
    draw_line (modeinfo.xres / 2, modeinfo.yres / 2,
               modeinfo.xres - 1, modeinfo.yres - 1);

    // wait for a carriage return
    getch ();

    // disable accelerator mode and switch back to VGA text mode
    close_mode ();

    return (0);
}

