/************************************************************************
 *   DPMIMEM.C                                                          *
 *      -uses DPMI functions to allocate and free memory.               *
 *      This is useful for bus mastering, as bm hardware requires       *
 *      physical memory addresses.  malloc/calloc doesn't               *
 *      provide this, they provide linear/virtual addresses.            *
 *                                                                      *
 ************************************************************************/
#include <stdlib.h>
#include <stdio.h>
#include <dos.h>
#include <i86.h>


/************************************************************************
 *    DPMI_allocdosmem                                                  *
 *     purpose: To allocate contiguous memory for which a physical      *
 *              address can be obtained.                                *
 *      inputs: paragraphs - the total amount of paragraphs (16 bytes)  *
 *                           requested.                                 *
 *              segment - a pointer to the segment where the allocated  *
 *                        memory is located.                            *
 *              selector - a pointer to the selector of the allocated   *
 *                         memory.                                      *
 *     outputs: returns a 1 on success.                                 *
 *              returns a 0 on failure.                                 *
 ************************************************************************/
unsigned long DPMI_allocdosmem ( unsigned long paragraphs,
								 unsigned long *segment,
								 unsigned long *selector )
{
	
	union REGS r;
	
	memset (&r, 0, sizeof (r));

	// setup DPMI call 100 using int 31h
	r.w.ax = 0x0100;
	r.w.bx = paragraphs;
	
	int386 (0x31, &r, &r);

	if (r.w.cflag == 0)
	{
		*segment = r.w.ax;
		*selector = r.w.dx;
		return (1);
	}

	return (0);        
}

/************************************************************************
 *   DPMI_freedosmem                                                    *
 *    purpose:  To free previously allocated memory by the              *
 *              DPMI_allocdosmem function.                              *
 *     inputs:  selector - the selector of the memory to be freed.      *
 *    outputs:  return 1 on success.                                    *
 *              returns 0 on failure.                                   *
 ************************************************************************/
unsigned long DPMI_freedosmem ( unsigned long selector )
{
	union REGS r;

	memset (&r, 0, sizeof (r));

	// setup DPMI call 101 using int 31h
	r.w.ax = 0x101;
	r.w.dx = selector;

	int386 (0x31, &r, &r);

	if (r.w.cflag == 0)
	{
		return (1);
	}

	return (0);
}


