/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * mach64 Chapter 8 sample code                                        *
 *                                                                     *
 * csc.c - Program to demonstrate Colour Space Conversion.             *
 *                                                                     *
 * Copyright (c) 1994-1998 ATI Technologies Inc.  All rights reserved. *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include <i86.h>

#include <stdio.h>

#include <stdlib.h>
#include "..\util\atim64vt.h"
#include "..\util\definevt.h"
#include "..\util\main.h"


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * Main Program to demonstrate Colour Space Conversion.                *
 *  Function: demonstrates Colour Space Conversion.                    *
 *    Inputs: Arguments for mode spatial and colour resolution         *
 *   Outputs: NONE                                                     *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

void main (int argc, char *argv[])
{
    int Counter;
    unsigned long int ISREVB = 0, ISVTGT = 0;
    int moveX, moveY;
    int x, y;
    int multiplier;

    printf ("\nmach64 Chapter 8 sample code\n"
            "\n"
            "csc.c\n"
            "\n"
            "This program is only available in 16bpp pixel depth.\n"
            "Spatial resolution (640, 800, 1024, 1280, 1600) should be passed as\n"
            "an argument. Default setting is 640x480 spatial resolution.\n");

    // Batch command to detect the mach64, perform a hardware query, Save old
    // mode information, process mode info arguments, load and set mode, enable
    // aperture, set up palettes, initialize engine to known state, and reset
    // all engine queues.

    // Cases when program fails to set color depth and/or spatial resolution.
    // Program will terminate immediately and returns user to dos prompt.
    if (!(start (argc, argv)))
    {
        printf("\nPress any key to exit...\n");
        getch();
        finish();
        exit(1);
    }

    //  Detect for VT/GT.  Program will terminate if neither GT nor VT exists.
    ISREVB = is_revb_or_greater();
    ISVTGT = is_vtgt();

    if(!ISVTGT)
    {
        finish();
        printf("\nWarning: Unable to detect a VT or a GT!\n");
        printf("Reminder: This program only works with a VT or a GT!\n");
        exit(1);
    }

    // Make sure we are in 16bpp mode.
    if (MODE_INFO.bpp != 16)
    {
        // Disable accelerator mode and switch back to VGA text mode.
        finish ();
        printf ("CSC requires colour depth of 16 bpp.\n");
        exit (1);
    } // if

    // Run startup overlay procedure.
    start_overlay();

    // Detect if a 3D RAGE PRO is installed, and init overlay (co-eff regs)
    if(is_pro())
    {
        pro_overlay_init();
    }

    // Display each of the 7 test images with and without C.S.C.
    csc("..\\image\\test15.img", SCALE_IN_15BPP);
    getch();


    csc("..\\image\\test16.img", SCALE_IN_16BPP);
    getch();


    change_overlay_pitch(32);
    csc("..\\image\\test32.img", SCALE_IN_32BPP);
    getch();

    change_overlay_pitch(16);
    if (!ISREVB)
    {
        csc("..\\image\\testYVYU.img", SCALE_IN_YVYU422 | 0xC);
    }
    else
    {
        csc("..\\image\\testYVYU.img", SCALE_IN_YVYU422);
        
    }
    getch();

    if (!ISREVB)
    {
        csc("..\\image\\testVYUY.img", SCALE_IN_VYUY422 | 0xB);
    }
    else
    {
        csc("..\\image\\testVYUY.img", SCALE_IN_VYUY422);
    }
    getch();

    disable_overlay();
    
    // Disable the scaler/overlay.
    finish_overlay();

    // Batch command to restore old mode.
    finish ();
    exit (0);                           // No errors.

} // main


void csc(char *filename, int img_bpp)
{
    img_handle *ReturnPtr;
    int iReturnValue;

    clear_screen (0, 0, MODE_INFO.xres, MODE_INFO.yres);

    // Allocate memory to pointer ReturnPtr
    ReturnPtr = (img_handle *) malloc(sizeof(img_handle));

    ReturnPtr = get_img_header(filename);

    if ( ReturnPtr == NULL)
    {
        finish();
        printf("Program was not able to load the image file header.");
        exit(1);
    }

    iReturnValue = load_img(ReturnPtr, 0, 0);
    if (iReturnValue == LOAD_FAILED)
    {
        finish();
        printf("Program was not able to load the image file.");
        exit(1);
    }

    // Deallocate memory to pointer ReturnPtr
    free(ReturnPtr);

    // Setup overlay.
    setup_overlay(img_bpp, 0);

    // Set overlay location (upper left corner of display) and mix key.
    set_overlay (MODE_INFO.xres-320, MODE_INFO.yres-200, 320, 200);
    if (MODE_INFO.xres>1024)
    {
        set_scale (320, 200, 320, 100);
    }
    else
    {
        set_scale (320, 200, 320, 200);
    }

    enable_overlay();
    
    return;

} // csc
