/******************************************************************************
 * defines file for mach64 Chapter 4 sample code                              *
 *                                                                            *
 * Copyright (c) 1994-1998 ATI Technologies Inc.  All rights reserved.        *
 ******************************************************************************/

#ifndef _DEFINES_H
#define _DEFINES_H

// Miscellaneous.

#define OFF 0
#define ON  1

// I/O ports.

#define FIXED       0
#define RELOCATABLE 1

// Generic colour definitions for use in get_colour_code ().

#define BLACK            0
#define DARKBLUE         1
#define DARKGREEN        2
#define DARKCYAN         3
#define DARKRED          4
#define DARKMAGENTA      5
#define BROWN            6
#define LIGHTGRAY        7
#define DARKGRAY         8
#define LIGHTBLUE        9
#define LIGHTGREEN      10
#define LIGHTCYAN       11
#define LIGHTRED        12
#define LIGHTMAGENTA    13
#define YELLOW          14
#define WHITE           15
#define NUM_COLOURS     16

// Colour depth support for MODE_INFO.

#define DEPTH_SUPPORT_ARGB  0x80        // support 32 bpp, xRGB, x is byte 0
#define DEPTH_SUPPORT_BGRA  0x40        // support 32 bpp, BGRx, B is byte 0
#define DEPTH_SUPPORT_RGBA  0x20        // support 32 bpp, RGBx, R is byte 0
#define DEPTH_SUPPORT_ABGR  0x10        // support 32 bpp, xBGR, x is byte 0
#define DEPTH_SUPPORT_BGR   0x08        // support 24 bpp, BGR
#define DEPTH_SUPPORT_RGB   0x04        // support 24 bpp, RGB
#define DEPTH_SUPPORT_555   0x02        // support 16 bpp (15), 555
#define DEPTH_SUPPORT_565   0x01        // support 16 bpp, 565

#endif // _DEFINES_H
