/******************************************************************************
 * mach64 Chapter 3 sample code                                               *
 *                                                                            *
 * BMODE.EXE - mach64 sample code                                             *
 * This program performs mach64 detection and mode setting.                   *
 *                                                                            *
 * Copyright (c) 1994-1998 ATI Technologies Inc.  All rights reserved.        *
 ******************************************************************************/

#include <stdio.h>
#include <i86.h>
#include "defines.h"
#include "main.h"


/******************************************************************************
 * Main Program                                                               *
 *  Function: Demonstrates mach64 detection and mode setting                  *
 *    Inputs: NONE                                                            *
 *   Outputs: NONE                                                            *
 ******************************************************************************/

void main (int argc, char *argv[])
{
    union REGS r;
    int xres;                           // Screen width in pixels to set mode.
    int num;                            // Pixel depth used to set the mode.

    printf ("mach64 Chapter 3 sample code\n"
            "\n"
            "bmode.c\n"
            "This program performs mach64 detection and mode setting.\n"
            "Spatial resolution (640, 800, 1024, 1280, 1600) and Colour Depth\n"
            "(8, 15, 16, 24, 32) may be passed as arguments.\n"
            "Default setting is 640x480 spatial resolution and 8bpp pixel depth.\n"
            "\n"
            "Do not be alarmed if you see garbage on the screen.  That is simply\n"
            "the current contents of the memory.  You should be able to see the\n"
            "screen change by setting different resolutions and pixel depths.  Do\n"
            "not be afraid to play around with it.\n");

    // Detect mach64.
    if (!init_graphics ())
    {
        printf ("ERROR: Graphics not initialized properly!\n");
        exit (1);
    } // if


    // Fill QUERY_DATA using BIOS calls 08h and 09h.
    if (!long_query ())
    {
        printf ("ERROR: long query failed!\n");
        exit (1);
    } // if


    // Save old video mode.
    get_old_mode ();

    // Process the command line arguments to override default resolution
    // and colour depth settings.
    process_command_line (argc, argv);
    printf ("Spatial X-Resolution: %d\n", GMODE_RES);
    printf ("         Pixel Depth: %d\n", GCLR_DEPTH);
    printf (" Press Any Key To Begin\n");
    getch ();

    // Load and set mode.  '2' indicates pitch is same as xres.
    if (!load_and_set_mode (GMODE_RES, GCLR_DEPTH, 2))
    {
        printf ("ERROR: mode setting failed!\n");
        exit (1);
    } // if


    // Wait for key pressed to continue.
    getch ();

    // Restore mode.
    set_old_mode ();

    exit (0);                           // No errors.
    
} // main
