/*==========================================================================
* VGABLANK.C - Copyright (c) 1994 ATI Technologies Inc. All rights reserved*
*                                                                          *
* PGL functions to blank the screen for VGA modes.                         *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <memory.h>
#include <dos.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

/* --------------------------------------------------------------------------
  pgl_blankvgascreen - blank the VGA screen
  
  This is useful for avoiding visible artifacts on screen during a mode
  change.
-------------------------------------------------------------------------- */
void pgl_blankvgascreen(void)
{
    // blank screen
    outp(0x3c4, 0x01);
    outp(0x3c5, inp(0x3c5) | 0x20);
}

/* --------------------------------------------------------------------------
  pgl_unblankvgascreen - unblank the VGA screen
  
  This is the counterpart function for BLANKVGASCREEN().
-------------------------------------------------------------------------- */
void pgl_unblankvgascreen(void)
{
    // unblank screen
    outp(0x3c4, 0x01);
    outp(0x3c5, inp(0x3c5) & 0xdf);
}

