; ===========================================================================
; ROMCAL06.ASM
;
; Mach64 ROM interface function 06h - Short query information.
;
; Compiling:
;   masm /Ml /D<memory model> romcalls.asm;
;       <memory model> = mem_S for SMALL model,
;                        mem_M for MEDIUM model,
;                        mem_L for LARGE model
;
; Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved
; ===========================================================================

include ..\inc\atim64.inc

IFDEF mem_S
PARM        equ     4   ; passed parameters start at bp+4 for small model
ELSE
PARM        equ     6   ; passed parameters start at bp+6 for other models
ENDIF

IFDEF mem_S
.MODEL  SMALL, C
ELSEIFDEF mem_M
.MODEL  MEDIUM, C
ELSE
.MODEL  LARGE, C
ENDIF

.DATA

rom_addr    dw      64h
            dw      0c000h
            db      0

.CODE
.286

; Macro for 'call' model handling
Mcall       macro   routine
IFDEF mem_S
            call    NEAR PTR routine
ELSE
            call    FAR PTR routine
ENDIF
	        endm

; Externals
IFDEF mem_S
extrn   pgl_getrombase:NEAR
ELSE
extrn   pgl_getrombase:FAR
ENDIF

; ---------------------------------------------------------------------------
; ROM_SHORTQUERY - ROM function 06h
;
; Get short query information - aperture config, color support, mem size,
; and asic ID. Input parameters are fetched from the stack. See PGL.H for
; symbolic values.
;
; Inputs : DWORD PTR to short query structure
;
; Outputs: Return codes
;            0 - no error
;            1 - function complete with error
;            2 - function not supported
; ---------------------------------------------------------------------------
            public  ROM_shortquery

IFDEF mem_S
ROM_shortquery proc near
ELSE
ROM_shortquery proc far
ENDIF
            ; create frame pointer
            push    bp
            mov     bp, sp

            ; save registers used
            push    bx
            push    cx
            push    dx
            push    di
            push    es

            ; setup parameters for call to ATI rom
            Mcall   pgl_getrombase              ; get rom segment in ax
            mov     rom_addr+2, ax

            ; setup ROM call
            mov     ax, 6                       ; function 06h
            mov     rom_addr, 64h
            call    DWORD PTR rom_addr          ; call ROM using FAR CALL

            ; fill short query structure
            push    ax
            mov     di, WORD PTR [bp+PARM]      ; get pointer offset
            mov     ax, WORD PTR [bp+PARM+2]    ; get pointer segment
            mov     es, ax
            pop     ax
            mov     es:[di], al                 ; fill aperture config
            inc     di
            mov     es:[di], bx                 ; fill aperture address
            add     di, 2
            mov     es:[di], ch                 ; fill color depth support
            inc     di
            mov     es:[di], cl                 ; fill memory size
            inc     di
            mov     es:[di], dx                 ; fill asic id

            ; setup error code in AL
            mov     al, ah
            xor     ah, ah

            ; restore saved registers
            pop     es
            pop     di
            pop     dx
            pop     cx
            pop     bx

            ; remove frame pointer
            mov     sp, bp
            pop     bp

            ret

ROM_shortquery endp

            end

