; ===========================================================================
; ROMCAL05.ASM
;
; Mach64 ROM interface function 05h - Memory aperture service.
;
; Compiling:
;   masm /Ml /D<memory model> romcalls.asm;
;       <memory model> = mem_S for SMALL model,
;                        mem_M for MEDIUM model,
;                        mem_L for LARGE model
;
; Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved
; ===========================================================================

include ..\inc\atim64.inc

IFDEF mem_S
PARM        equ     4   ; passed parameters start at bp+4 for small model
ELSE
PARM        equ     6   ; passed parameters start at bp+6 for other models
ENDIF

IFDEF mem_S
.MODEL  SMALL, C
ELSEIFDEF mem_M
.MODEL  MEDIUM, C
ELSE
.MODEL  LARGE, C
ENDIF

.DATA

rom_addr    dw      64h
            dw      0c000h
            db      0

.CODE
.286

; Macro for 'call' model handling
Mcall       macro   routine
IFDEF mem_S
            call    NEAR PTR routine
ELSE
            call    FAR PTR routine
ENDIF
	        endm

; Externals
IFDEF mem_S
extrn   pgl_getrombase:NEAR
ELSE
extrn   pgl_getrombase:FAR
ENDIF

; ---------------------------------------------------------------------------
; ROM_APERTURECONTROL - ROM function 05h
;
; Enable/disable the linear and/or VGA aperture. Input parameters are fetched
; from the stack. See PGL.H for symbolic values.
;
; Inputs : WORD aperture control
;            all bits 0 - disable aperture
;            bit 0 = 1  - enable linear aperture
;            bit 2 = 1  - enable VGA aperture
;
; Outputs: Return codes
;            0 - no error
;            1 - function complete with error
;            2 - function not supported
; ---------------------------------------------------------------------------
            public  ROM_aperturecontrol

IFDEF mem_S
ROM_aperturecontrol proc near
ELSE
ROM_aperturecontrol proc far
ENDIF
            ; create frame pointer
            push    bp
            mov     bp, sp

            ; save registers used
            push    cx

            ; setup parameters for call to ATI rom
            Mcall   pgl_getrombase              ; get rom segment in ax
            mov     rom_addr+2, ax
            mov     cx, WORD PTR [bp+PARM]      ; get aperture control

            ; setup ROM call
            mov     ax, 5                       ; function 05h
            mov     rom_addr, 64h
            call    DWORD PTR rom_addr          ; call ROM using FAR CALL

            ; setup error code in AL
            mov     al, ah
            xor     ah, ah

            ; restore saved registers
            pop     cx

            ; remove frame pointer
            mov     sp, bp
            pop     bp

            ret

ROM_aperturecontrol endp

            end

