/*==========================================================================
* PGLQUERY.C - Copyright (c) 1994 ATI Technologies Inc. All rights reserved*
*                                                                          *
* PGL functions to fill PGL structures 'modeconfig' and 'queryheader'.     *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <memory.h>
#include <dos.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

/* --------------------------------------------------------------------------
  PGL_getmodeconfig - query information for the current mode
  
  The given structure is filled with modal information for the current mode
  based on the latest call to PGL_initmode(). Information such as resolution,
  color depth, and pitch is contained in the filled structure. If the
  resolution is 0, this indicates that no accelerator mode is currently set.
  See PGL_initmode() for mode number meanings.
-------------------------------------------------------------------------- */
void PGL_getmodeconfig(PGL_modeconfig *modeconfig)
{
    memcpy(modeconfig, &PGL_modecfg, sizeof(PGL_modeconfig));
}

/* --------------------------------------------------------------------------
  PGL_getqueryheader - query header information from PGL's internal copy
  
  This function fills the given structure with the PGL's internal query
  header information. This saves the need to call PGL_getquerysize() &
  PGL_queryhardware(). Note that the internal query header structure is
  filled after calling PGL_initaperture().
-------------------------------------------------------------------------- */
void PGL_getqueryheader(PGL_queryheader *queryinfo)
{
    memcpy(queryinfo, &PGL_querydata, sizeof(PGL_queryheader));
}

