/*==========================================================================
* INTERNAL.C - Copyright (c) 1994 ATI Technologies Inc. All rights reserved*
*                                                                          *
* Special PGL functions to allow an application to change elements of the  *
* PGL's internal structures.                                               *
* ======================================================================== */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <conio.h>
#include <memory.h>
#include <dos.h>

#include "..\inc\atim64.h"
#include "..\inc\pgl.h"
#include "..\inc\pglglob.h"

/* --------------------------------------------------------------------------
  PGL_getqueryheaderptr - get the internal pointer to PGL query header
                          structure
  
  This function allows an application to modify the PGL's internal query
  header structure. This is useful for special applications.
-------------------------------------------------------------------------- */
PGL_queryheader *PGL_getqueryheaderptr(void)
{
    return(&PGL_querydata);
}

/* --------------------------------------------------------------------------
  PGL_getmodeconfigptr - get the internal pointer to PGL modeconfig structure
  
  This function allows an application to modify the PGL's internal modeconfig
  structure. This is useful for special applications.
-------------------------------------------------------------------------- */
PGL_modeconfig *PGL_getmodeconfigptr(void)
{
    return(&PGL_modecfg);
}

/* --------------------------------------------------------------------------
  PGL_getattributeptr - get the internal pointer to PGL attribute structure
  
  This function allows an application to modify the PGL's internal attribute
  structure. This is useful for special applications.
-------------------------------------------------------------------------- */
PGL_attribute *PGL_getattributeptr(void)
{
    return(&PGL_attr);
}

