/*==========================================================================
  RECT.C

  Example code to draw a filled rectangle.

  Copyright (c) 1994-1995 ATI Technologies Inc. All rights reserved
 =========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "..\util\atim64.h"
#include "..\util\sample.h"

#define INSTANCE 0

int main (int argc, char *argv[])
{
    int color;

    // check if Mach64 adapter is installed
    if (detect_mach64 (INSTANCE) != YES_MACH64)
    {
        printf ("mach64 based adapter was not found.\n");
        return (1);
    }

    // fill global query structure by calling Mach 64 ROM
    if (query_hardware () != NO_ERROR)
    {
        printf ("Failed ROM call to query mach64 hardware.\n");
        return (1);
    }

    // Process the command line arguments to override default resolution
    // and color depth settings.
    process_command_line (argc, argv);

    // set an accelerator mode
    if (open_mode (gmode_res, PITCH_XRES, gclr_depth) != NO_ERROR)
    {
        printf ("Error in setting display mode.\n");
        return (1);
    }

    // setup engine context and clear screen
    init_engine ();
    clear_screen (0, 0, modeinfo.xres, modeinfo.yres);

    // draw filled rectangles
    for (color = BLACK; color < WHITE; color++)
    {
        // set fill color
        set_fg_color (get_color_code(color+1));

        // draw filled rectangle
        draw_rectangle ((modeinfo.xres / 32) + (color * (modeinfo.xres / 32)),
                        (modeinfo.yres / 32) + (color * (modeinfo.yres / 32)),
                        modeinfo.xres - (modeinfo.xres / 32) -
                                        (color * 2 * (modeinfo.xres / 32)),
                        modeinfo.yres - (modeinfo.yres / 32) -
                                        (color * 2 * (modeinfo.yres / 32)));
    }

    // wait for a carriage return
    getch ();

    // disable accelerator mode and switch back to VGA text mode
    close_mode ();

    return (0);
}

