
SDLC LIBRARY FILENAME:  libsdlc.a

FLUSH     Clears reception buffer.
          int flush()
          Returns:    3 = Receive buffer overflow

GETIME    Gets the elapsed milliseconds since the system was 
          started.
          #include mtosux.h
          int getime(msbfr)
          unsigned char *msbfr;

GETPORT   Identifies which port is communicating with the     
          library.
          int getport()
          Returns:
            0=Port A selected
            1=Port B selected.

INITP1    Initializes P1 and loads software. 
          int initp1(type1,type2,encode,bitrate)
          int  type1;   0=DCE
                        1=DTE
                        2=ISDN
          int  type2;   0=Primary
                        1=Secondary
          int  encode;  0=NRZ
                        1=NRZI
          unsigned long bitrate;   50 - 64000
          Returns:
            0=Successful
           -1=Invalid parameter(s)
           -2=P1 program not loaded

INITTIME  Initializes the interrupt system to start and
          maintain the .01 second and 1 second timer.
          inittime()

P1RESET   Restarts or stops P1 simulation. 
          int p1reset(kind)
          int kind;     0=Restart
                        1=Stop
          Returns:
            0=Successful
            1=Parameter error

RECEIVE   Receives a frame from P1 and places it at 
          address in packet.
          char receive (packet)
          char *packet;
          Returns:
            0=Successful
            1=Link not established
            2=initp1 not performed

SET_ADR   Sets transmit and receive address
          int set_adr(val)
          int val;    Range: 0 - 255
          Returns:
            0=Successful
           -1=Parameter error

SETLEDS   Controls which port's LEDs are displayed on the 
          front panel of a Dual Port machine.
          int setleds(port)
          int port;  0=Port A LEDS displayed
                     1=Port B LEDS displayed
          Returns
            0=Successful
            1=Invalid parameter
            2=Dual Port board not installed

SET_N2    Sets N2 (number of retransmissions).
          int set_n2(val)
          int val;     Range: 1 - 255
          Returns:
            0=Successful
           -1=val outside of range
            5=Not a primary station

SETPORT   Selects Port A or Port B for library.
          #include cham.h
          int  setport(port)
          int port;  0=Port A
                     1=Port B
          Returns
            0=Successful
           -1=Parameter out of range
           -2=Selected Port B, but not available

SET_T1    Sets T1 timer.
          int set_t1(val)
          int val;    Range: 1 - 255
          Returns:
            0=Successful
           -1=val outside of range
            5=Not a primary station

SET_T2    Sets T2 frame level timer.
          int set_t2(val)
          int val;      Range: 0 - 255
          Returns:
            0=Successful
           -1=val outside of range
            5=Not a primary station

SETTIMER   Sets the timer value.
           int settimer(number,value)
           int number;   0=.01 timer (down)
                         1=.01 timer (up)
                         2=seconds (down)
                         3=seconds (up)
          unsigned int value;       timer setting
          Returns:
            0=Successful
            1=Invalid number
            2=inittime not performed

SLOF      Disconnects link.
          int slof()
          Returns:  5=Not a primary station

SLON      Establishes link by sending a SABM.
          int slon()
          Returns:  5=Not a primary station

STATUS    Indicates status of frame level.
          int status()

          Chameleon 32 as Primary returns:
            0=Normal disconnected mode
            1=Link request state
            2=Disconnect request state
            3=Information Transfer state
            4=Local station busy
            5=Remote station busy
            6=Local & remote stations busy

          Chameleon 32 as Secondary returns:
            0=Normal disconnected mode
            1=Initialization mode
            2=Frame reject 
            3=Information Transfer
            4=Local station busy
            5=Remote station busy
            6=Local & remote stations busy

TIMER     Returns the value of the timer.
          int timer(number)
          int number;  0=.01 (down)
                       1=.01 (up)
                       2=seconds (down)
                       3=seconds (up)

TRANSMIT  Transmits I-frame with I-field of length, starting 
          at address in packet.
          int transmit(packet, length)
          char *packet;
          int length;
          Returns:
            0=Successful
            1=P1 busy
            2=initp1 not performed
            3=Link not established
            4=Length error (if length > 510)

TRNSI     Transmits a non-sequenced I-frame with I-field of 
          length, starting at address in packet.
          int trnsi (packet, length)
          char *packet;
          int length;
          Returns:
            0=Successful
            1=P1 busy
            2=initp1 not performed
            3=Link not established
            4=Length error (if length > 510)

TRSIFR    Transmits a sequenced I-frame with I-field of 
          length, starting at address in packet.
          int trsifr(packet, length)
          char *packet;
          int length;
          Returns:
            0=Successful
            1=P1 busy
            2=initp1 not performed
            3=Link not established
            4=Length error (if length > 510)

TRTST     Transmits a test frame with I-field of length, 
          starting at address in packet.
          int trtst (packet, length)
          char *packet;
          int length;
          Returns:
            0=Successful
            1=P1 busy
            2=initp1 not performed
            3=Link not established
            4=Illegal frame (if secondary)
            5=Not a primary station

TRUI      Transmits an unnumbered I-frame with I-field of 
          length, starting at address in packet.
          int trui (packet, length)
          char *packet;
          int length;
          Returns:
            0=Successful
            1=P1 busy
            2=initp1 not performed
            3=Link not established
            4=Length error (if length > 510)

XID       Transmits an XID frame containing the data in the 
          externally available character array ident[ ].
          extern char ident[ ]; /* 6 bytes */
          char xid();
          Returns:
            0=Successful
            1=P1 not initialized
            2=P1 fails to respond
            3=Not in normal response mode
            4=Illegal frame (if secondary)


