
FRAMEM HDLC/SDLC COMMANDS AND VARIABLES

ABORTRAN  Transmits a frame with an abort sequence.
          The transmitted frame should be longer than 4 bytes.
          ABORTRAN

BADTRAN   Transmits a frame with a bad CRC.
          The transmitted frame should be longer than 4 bytes.
          BADTRAN

CRC       Indicates if received frame had a good or bad CRC.
          Returns:  0=Good CRC
                    1=Bad CRC

DEFINE    Defines new mnemonics.
          DEFINE "NAME",I=x    LAPD
          DEFINE"name"=x    All others
          name =mnemonic name;   x is a numeric expression
          I=I-field permission (LAPD)

DEFSUB    Defines line number to jump to when the received 
          frame matches a specific mnemonic.
          DEFSUB"NAME"=xxxx
          name=defined mnemonic;    xxxx=line number

EXTEND    Selects extended mode addressing.
          EXTEND

GET       Gets 2 bytes (low byte, high byte) from an I-field.
          x=GET exp
          PRINT GET exp

MOD       Specifies modulo 8 or modulo 128 sequencing.
          MOD8
          MOD128

NORM      Selects normal mode addressing.
          NORM

PUT       Defines an I-field for transmission.
          PUT exp1,exp2
            exp1=byte no. from start of I-field
            exp2=value assigned to that byte

REC       Takes next received frame from acquisition buffer.
          REC

RXADDR    Returns address field of the received frame.

RXC/R     Returns C/R bit extracted from an FRMR field.

RXDIAG    Returns last byte of an FRMR (WXYZ bits)

RXFCTL    control field of received frame
          without P/F bit, N(S), and N(R).

RXFRLEN   Returns length of the received frame.

RXN(R)    Returns N(R) of a rec'd S-or I-frame.

RXN(S)    Returns N(S) of a rec'd S-or I-frame

RXP/F     Returns P/F bit of the received frame.

RXRFCTL   Returns rejected frame control field of rec'd frame.

RXRP/F    Returns P/F bit of a rec'd rejected frame 
          control field.

RXV(R)    Returns  V(R) of the rejecting station for a 
          rejected frame.

RXV(S)    Returns V(S) of the rejecting station for a 
          rejected frame.

STATUS    Displays the current addressing mode and modulo.
          STATUS

TPRINT    Displays the contents of the trace buffer.
          TPRINT

TRAN      Transmits a frame with a good CRC.
          TRAN

TXADDR    Sets address field of frame being transmitted.  
          TXADDR = xx

TXC/R     Sets C/R bit of the FRMR frame being transmitted.
          TXC/R = 1
          TXC/R = 0

TXDIAG    Sets the last byte (WXYZ bits) of an FRMR field.
          TXDIAG = &xx
            xx is a 2-digit hex value

TXFCTL    Sets frame control field of frame being transmitted.
          TXFCTL = udm
            udm = user-defined mnemonic

TXIFIELD  Sets or adds to the contents of an I-field for 
          a frame being transmitted.  
          TXIFIELD = $A           Sets I-field to $A.
          TXIFIELD+$A             Adds $A to I-field
          TXIFIELD = HEX>ABCD
          TXIFIELD = ASC>ABCD
          TXIFIELD = EBC>ABCD
          TXIFIELD + HEX>0D0A
          TXIFIELD + ASC>ABCD
          TXIFIELD + EBC>ABCD

TXN(R)    Sets N(R) of the frame being transmitted.
          TXN(R) = x

TXN(S)    Sets N(S) of the frame being transmitted.
          TXN(S) = x
          

TXP/F     Sets the P/F bit of the frame being transmitted.  
          TXP/F = x

TXRFCTL   Sets rejected frame control field of a 
          frame being transmitted.
          TXRFCTL = RXFCTL

TXRP/F    Sets the P/F bit of a rejected frame control field 
          for the frame being transmitted.
          TXRP/F = RXRP/F

TXV(R)    Sets V(R) for the frame being transmitted.
          TXV(R) = TXN(R)

TXV(S)    Sets V(S) for the frame being transmitted.
          TXV(S) = TXN(S)


