DASS 2

This HELP begins with a brief overview of DASS2 
(Digital Access Signalling System No. 2).  For more
detailed coverage of DASS 2, see British Telecom
Network Requirement (BTNR) 190, Part 1; Volume 1
Core Document, Issue 2/Draft 2, September 1988.

DASS 2 is an outgrowth of DASS 1, and was developed:
(1) to enable Private Branch Exchanges (PBXs) to have
access to ISDN; (2) to allow the implementation of
multiple PBXs over an ISDN-switched or tie-line
connection; (3) to incorporate supplementary facilities
beyond those available over DASS 1; (4) to provide a
foundation for the development of DPNSS 1.


Traffic Display

Because DASS 2 and DPNSS function over Layers
1, 2 and 3, the display of corresponding messages
shares certain features.  For any given message,
Address, Control and DLC data will be identical.
This also applies to warnings, error messages, and
notifications of invalid data.

When traffic is first displayed, messages follow one
another without separation.  You can use PMDS
commands to separate and isolate messages and levels
of data within messages.  These procedures are valid
only for History pages, not Real Time pages.


Separating Messages

To insert message separators:

Enter `:'

Enter `set separator on'

Press Return.

Separators are inserted between messages.  

The message identifier (0, 1, 2, 3, etc.) in the middle of a
separator identifies the message following the separator.

To remove message separators:

Enter `:'

Enter `set separator off'

Press Return.

Isolating Levels

Using F-keys 1 through 4, you can isolate each level of
data.

To isolate Physical Level data:

Set F1 to either + or *

Set F2, F3 and F4 to -

To isolate DLC data:

Set F2 to either + or *

Set F1, F3 and F4 to -

To isolate DASS 2 data:

Check to see that you have selected the 
DASS2 page.

Set F3 to either + or *

Set F1, F2 and F4 to -

To isolate Application Layer data:

Set F4 to either + or *

Set F1, F2 and F3 to -

Interpretation

The following interpretation of DASS 2 data follows
the order shown on-screen: Physical Layer, Layer 2,
Layer 3.

Physical Level Data

Physical Layer (L1) data is displayed in white on
one line.  For example,
	PortB  15:27:15  668  140  fl=2      FCS=0030

You interpret this data in the following way:

PortB	This is the port over which the traffic data
	is coming and which you configured in the
	Setup Mode and Applications Selection
	menus.

15:27:15  668  140	This is the time at which the
		corresponding message
		appeared at the port.
		In this example, `15' is the hour,
		`27' is the minutes, `15' is the
		seconds, and `668   140' are the
		microseconds.

fl=2	This is the number of flags separating this
	message from the next one.

FCS=0030	This is the Frame Check Sequence value, which
	serves the same function as a Cyclic Redundancy
	Check: i.e., it is an error-checking mechanism.

Layer 2 Data

DLC data is Layer 2 data.  This data is shown in the Address
Control, Information and Frame Check Sequence fields.  Also,
although Maintenance messages originate in Level 3, they are
conveyed to Level 2 and displayed with the data of that level.

There are four types of DLC frames, two for link control and
two for information transfer.  These four types are:

SABMR - Set Asynchronous Balanced Mode Restricted
UA - Unnumbered Acknowledgement
UI(C) - Unnumbered Information - Command
UI(R) -  Unnumbered Information - Response

For DASS2, these frames are displayed as follows:

Address - followed by  SABMR, UA, UI(C), UI(R)
	or Invalid. 

	Invalid means that a frame has been
	received the address of which does not
	conform to any defined in the BTNR
	Issues.

	SABMR frames can only be transmitted
	as Commands.  The transmitting device
	expects either a UA or SABMR to be 
	returned from the receiving device.  
	When either of these two messages is
	received by the transmitting device,
	it will return a UA message.  When the
	address is SABMR, the Control field
	will also display SABMR.  The C/R field
	will display . . . - Commnd.  

	UA frames are only transmitted as 
	response frames.

	UI frames are of two types: Command
	and Response.  The Command type 
	conveys network-control information
	ranging in length from 1 to 45 octets.
	The Response type acknowledges that
	network-control information has been
	correctly received.

	C/R - followed by:
		PBX (A or B) - Command
		PBX (A or B) - Response
		ET (A or B) - Command
		ET (A or B) - Response

		This identifies the category of
		the message - Command or
		Response - and its point of
		origin: a PBX or other network
		node (ET).
		These are derived from bits 2 
		and 3 of the first Address Octet.

	Channel -  followed by:
		B-Channel. D-Channel, or Undefined
		These are derived from bits 4 
		and 5 of the first Address Octet.

	Signalling -  followed by:
		Tie-Line (only one followed by traffic)
		DASS2 MUX
		MUX/CONC
		These are derived from bits 6,7, and 8 of
		the first Address Octet.

	Time Slot - followed by 01 through 31.
		These are derived from bits 2 through 
		6 of the second Address Octet.

Control	followed by  SABMR, UA, UI(C), UI(R)
	or Invalid. 
		UI(C), UI(R) are derived from bits
		1, 2 and 5.
		SABMR, is derived from bits 1
		through 4 and 6 through 8.
		This is a command frame only.
		UA is dervied from bits 1, 2, 6 and 7.
		This is a response frame only.

	The data shown on this line is derived from
	the bit settings of the one-byte Control octet.

Layer 3 Data

Layer 3 data displays the message type, group, contents
and other information conveyed in Information frames.
Depending on the actual message, an SIC may also be
shown.

