
BOP LIBRARY FILENAME:   libbop.a


FLUSH     Clears the reception buffer.
          int flush()
          Returns:  3=Receive buffer overflow


GETPHY    Indicates the physical interface setting.
          int getphy()
          Returns 2-byte integer as shown below.

                          Byte 0 
          Bit    7     6     5     4     3     2     1     0
          Pin   105   108   140   141   104   103   114   115
          Pin    4    20                 3     2    15    17
          Sig   RTS   DTR    SQ          RD    TD   SCT   SCR
       
                          Byte 1 
          Bit    7     6     5     4     3     2   1    0
          Pin   106   107   109   122   125   142
          Pin    5     6     8    12    22
          Sig   CTS   DSR   CD   SDCD   RI


GETIME    Get the elapsed milliseconds since the system was 
          started.
          #include mtosux.h
          int getime(msbfr)
          unsigned char *msbfr;


GETPORT   Identifies which port is communicating with the     
          library.
          #include cham.h
          int getport()
          Returns:
            0=Port A selected
            1=Port B selected


INITP1    Initializes the FEP and loads the simulation 
          software
          int initp1(type, encode, bitrate, flag)
          int  type;    0=DCE
                        1=DTE
                        2=ISDN
          int  encode;  0=NRZ
                        1=NRZI
          unsigned long bitrate;    50-64000
          int  flag;    0=FF
                        1=7E
          Returns:
            0=Successful
           -1=Invalid parameter(s)
           -2=P1 program not loaded


INITTIME  Initialzes the interrupt system to start and
          maintain the .01 second and 1 second timers.
          inittime()

P1RESET   Restarts or stops simulation.
          int p1reset(kind)
          int  kind;    0=Restart
                        1=Stop
          Returns:
            0=Successful
           -1=Invalid parameter


RECEIVE   Receives a frame and places it at the address 
          pointed to by frame.
          char receive(frame)
          char *frame;
          Returns:
            0=Good CRC or no frame waiting
            1=Bad CRC
            2=initp1 not performed
            3=Overflow

SETFLG    Changes the idle fill pattern.
          int  setflg(flag)
          int  flag;    0=FF
                        1=7E


SETLEDS   Controls which port's LEDs are displayed on the 
          front panel of a Dual Port machine.
          int setleds(port)
          int port;  0=Port A LEDS displayed
                     1=Port B LEDS displayed
          Returns
            0=Successful
            1=Invalid parameter
            2=Dual Port board not installed


SETPHY   Sets the physical interface lines.
         setphy(val)
         int  val;

                 SIMULATING DCE 
          Bit    7     6     5     4     3     2   1    0
          Pin   106   107   109   122   125   142
          Pin    5     6     8     12    22
          Sig   CTS   DSR   CD    SDCD   RI

                SIMULATING DTE 
          Bit    7     6     5     4   3   2   1    0
          Pin   105   108   140   141
          Pin    4     20
          Sig   RTS   DTR    SQ


SETPORT   Selects Port A or Port B for library.
          #include cham.h
          int  setport(port)
          int port;  0=Port A
                     1=Port B
          Returns
            0=Successful
           -1=Parameter out of range
           -2=Selected Port B, but not available


SETTIMER   Sets the timer value.
           int settimer(number,value)
           int  number;   0=.01 timer (down)
                          1=.01 timer (up)
                          2=seconds (down)
                          3=seconds (up)
           unsigned int value;       timer setting
           Returns:
             0=Successful
             1=Invalid number
             2=inittime not performed


TIMER     Returns the value of the timer.
          int timer(number)
          int number;  0=.01 (down)
                       1=.01 (up)
                       2=seconds (down)
                       3=seconds (up)


TRANSMIT  Transmits the number of bytes n length, starting at    

         address in frame.
          int transmit(mode, frame, length)
          int  mode;   0=Good CRC 
                       1=Bad CRC
                       2=Abort sequence
          char *frame;
          int   length;
          Returns:
            0=Successful
            1=P1 busy
            2=initp1 not performed
            3=Parameter error
            4=Buffer overflow


TREADY    Returns the status of the P1 transmitter.
          int tready()
          Returns:
            0=Transmitter ready
            1=Transmitter not ready
            2=initp1 not performed
            3=Overflow

