HISTORY PAGE

The History function keys control the interpreted display of 
acquired traffic, according to protocol specific options set up 
in the menu. Options are:
   F1  User data format: HEX, HEXS (HEX with a space 
       between each pair), ASCII, and EBCDIC.  User data is
       the data which is not interpreted.
   F2  Specifies what acquisition information to display. This 
       information is displayed near the center of the screen 
       on the opposite side of the other interpreted data. For 
       example, the DCE acquisition information is shown on 
       the left half of the page. The acquisition information 
       includes the Port (A or B), unless None is selected.  
          None    No information
          Number  Event number in decimal
          Flags   No. of flags preceding frames in decimal
          Time    Timestamp of the end of the event in the 
                  format hh:mm:ss ddd ddd  (hours, minutes, 
                  seconds, microseconds (in decimal)
          dTime   Elapsed time since previous event
          CRC     The CRC in hex, and OK or BAD 
   F3  Determines types of events that will be displayed. This 
       is not available for Async or BSC.
         I     Information frames only are displayed
         IU    Information and Unnumbered frames only  
         IUS   Information, Unnumbered, and Supervisory frames 
         IUSL  All frames, plus lead events are displayed 

   F4 - F9  Protocol-specific.  For each protocol, they 
            determine whether or not a specific element is 
            displayed.  These use the following conventions:
            *   Displayed interpreted and uninterpreted
            "   Element is displayed uninterpreted
            +   Element is displayed interpreted
            -   Element is acquired, but not displayed
        For example, in X.25 Analysis, if the F4 key displays 
        HDLC+, it indicates that the HDLC component will be 
        displayed in interpreted format.  If displayed in an 
        uninterpreted format, the component is displayed in 
        the code selected using the F1 key.  
   F10  Selects the user data display. The options are:
             User-   No user data shown (only interpreted data 
                     is displayed)
             User+   User data shown in code selected in F1
             Raw     All data is shown as user data (no 
                     interpretation) 

For a description of SS#7 History, select the SS7ANAL option in 
the Applications Selection menu and press the HELP key.


Control Keys:
     Ctrl B   Turns on/off display of a line between events 
     Ctrl C   For Dual Port machines, changes History function 
              key control between port A and port B 
     Ctrl E   Switches the display of "Incomplete event"
              message on/off
     Ctrl P   Activates analysis to disk/printer feature
     Ctrl S   Activates highlight/search feature for current 
              protocol when Chameleon is controlled locally
     Ctrl U   Activates highlight/search feature for current 
              protocol when Chameleon is controlled remotely
     Ctrl Z   Enables User Parts Editor (SS7 only)
     A or a   For Dual Port machines, changes History function 
              key display to port A
     B or b   For Dual Port machines, changes History function 
              key display to port B

Position Keys:
   Scroll-UP          Scrolls data upward one line at a time
   SHIFT-Scroll-UP    Scrolls data upward one page at a time
   Scroll-DOWN        Scrolls data down one line at a time
   SHIFT-Scroll-DOWN  Scrolls data downward one page at a time
   0-9                Displays specific area of the History 
                      buffer, where the digit represents the 
                      location within the buffer, as follows:
                      (0 = beginning of buffer, 5 = middle of 
                      buffer (50%), 9 = end of data (90%)
   Left-Arrow         Displays the oldest events in the buffer
   Right-Arrow        Displays most recent events in buffer
   Up-Arrow           Scrolls data upward continuously. Press 
                      multiple times to increase upward speed 
                      or to decrease the speed if data is 
                      scrolling downward 
   Down-Arrow         Scrolls data downward continuously. 
                      Press multiple times to increase 
                      downward speed or to decrease the speed 
                      if data is scrolling upward
   Space bar          Stops scrolling in either direction
   :jump x            Displays event number x at the top of 
                      the history page.

   :merge on          For SS#7 only, includes the Spare bit
                      values in the field display .  
   :merge off         For SS#7 only, excludes the Spare bit
                      values in the field display.  
   F or f             Invokes freeze mode.  Freeze mode causes 
                      the most recent 32k of data to be put in 
                      a temporary buffer.  In freeze mode, 
                      only this 32k of data can be accessed in 
                      the History page; however, it will not 
                      be overwritten as data continues to be 
                      acquired by the Chameleon.  See U below.
   U or u             Cancels freeze mode and displays data
                      from the normal acquisiton buffer in the
                      History page.

History Trigger Feature

The Triggering application enables you to filter captured
data according to user-defined criteria.  One of the 
triggering options is DISPLAY which causes the History 
display to differentiate between data which meets the 
criteria and data which does not.  

Beginning with system software 4.2, you have two DISPLAY 
modes to choose from:

-  In normal mode, data which meets the triggering criteria is
   shown in low intensity color.  All other data is shown
   in high intensity color.

-  In trigger mode, only data which meets the triggering
   criteria is displayed in the History page.  All other
   data is suppressed from the display. 

The triggering DISPLAY mode is controlled from the History 
page using two commands:

  :normal    Selects normal triggering display mode.  
             This is the default mode.

  :trigger   Selects trigger mode.

Note that when using these command, you must include the colon
(:) as part of the command to invoke the command line.

