/* @(#)msfsuse.h	1.4 2/7/91 */
/*
Filename:   MSFS_USE.H
Programmer: Ron Mills
Date:       9-27-86
 
Purpose:
 
This file contains many commonly used values and structures of the
MS-DOS compatable file system.
 
*/
 
/*-------------------------------------------------------------------------*/
 
/*  MSFS Opcode values */
#define        OPEN          0x01L        /* Open a file */
#define        READ          0x02L        /* Read from a file */
#define        WRITE         0x03L        /* Write to a file */
#define        CLOSE         0x04L        /* Close a file */
#define        CHANGE        0x05L        /* Change a file */
#define        SEEK          0x06L        /* Seek to file position */
#define        SRCH          0x07L        /* Search for file */
#define        FORM          0x08L        /* Format Disk */
#define        SETV          0x09L        /* Set current volume */
#define        SETD          0x0AL        /* Set current directory */
#define        FLUSH         0x0BL        /* Flush file system changes */
#define        PATH          0x0CL        /* Get current path */
#define        CHKPT         0x0DL        /* Checkpoint a file */
 
/*-------------------------------------------------------------------------*/
 
/* Completion codes */
#define SUCCESS                0            /* FS completed successfully */
#define CNFERR                -1            /* Configuration Error */
#define OPCERR                -2            /* Opcode Error */
#define PRMERR                -3            /* Parameter Error */
#define VOLERR                -4            /* Error in volume access */
#define FNFERR                -5            /* File not Found Error */
#define FEXERR                -6            /* File already exists error */
#define QUEERR                -7            /* Queue Empty Error */
#define RDSERR                -8            /* Physical Read Error */
#define WRSERR                -9            /* Physical Write Error */
#define DIRERR                -10           /* Directory full error */
#define FODERR                -11           /* Files open on directory */
#define FOPERR                -12           /* File already open */
#define FNCERR                -13           /* Error in Filename */
#define LOCERR                -14           /* File locked */
#define OPTERR                -15           /* Function Option Error */
#define ATTERR                -16           /* Attribute Error */
#define EOFERR                -17           /* End of file unexpected error */
#define POFERR                -18           /* EOF with partial record */
#define FTLERR                -19           /* Fatal Error */
#define DKFERR				  -20			/* Disk full error */
#define FULERR				  -20			/* Disk full error - alternate */
#define RDOERR				  -21			/* File is read only */
 
/*-------------------------------------------------------------------------*/
 
/* Function Option Flags */
 
/* Open-Close option flags */
#define FL_RND                0x01                /* random operations */
#define FL_SEQ                0x02                /* sequential operations */
#define FL_DIR                0x04                /* directory operations */
#define FL_CRT                0x08                /* open create option */
#define FL_LCK                0x40                /* file access lock */
 
/* Search option flags */
#define SF_FST                0x00                /* search for first file */
#define SF_NXT                0x01                /* search for next file */
 
/* Read-Write option flags */
#define RWF_RR                0x00         /* Random read */
#define RWF_SR                0x01         /* Sequencial read */    
#define RWF_SS                0x02         /*   Record size in parms */
#define RWF_ST                0x04         /*   End record with terminator */
#define RWF_WC                0x08         /* Create record if not existant */
#define RWF_SA                0x10         /* Append record to seq. file */
 
/* Seek option flags */
#define SK_ORB                0x00       /* Offset from begining of file */
#define SK_ORP                0x01       /* Offset from current position */
#define SK_ORE                0x02       /* Offset from end of file */
#define SK_CPS                0x03       /* Get current position */
#define SK_SZE                0x04       /* Get file size */
 
/* Change file function flags */
#define CF_DIR                0x01              /* Change a directory */
#define CF_REN                0x02              /* Rename file option */
#define CF_DEL                0x04              /* Delete file option */
#define CF_ATT                0x08              /* Change attributes option */
 
/* Flush volume(s) function flags */
#define FF_SPC                0x01        /* Specify volume */
#define FF_UPD                0x02        /* Update with structure changes */
#define FF_DAL                0x04        /* Deallocate all FS structures */
 
/*-------------------------------------------------------------------------*/
 
/* Directory values */
 
/* Directory record data lengths */
#define FN_LEN                8                /* filename length */
#define EX_LEN                3                /* extension length */
#define AT_LEN                1                /* file attributes length */
#define RS_LEN                10               /* reserved bytes length */
 
/* File Attributes */
#define FA_RDF                0x01                /* Read Only file */
#define FA_HDF                0x02                /* Hidden File */
#define FA_SYS                0x04                /* System File */
#define FA_VOL                0x08                /* Volume */
#define FA_SDR                0x10                /* Sub-directory */
#define FA_ARF                0x20                /* Archive */
 
/* Directory Record Structure */
struct DREC
        {
        char                dc_fn[FN_LEN];       /* file name */
        char                dc_ex[EX_LEN];       /* file extension */
        char                dc_at;               /* file attributes */
        char                dc_rs[RS_LEN];        /* reserved bytes */
        unsigned short        dc_tim;        /* time file was created */
        unsigned short        dc_dat;        /* date of file creation */
        unsigned short        dc_str;        /* starting cluster number */
        unsigned long         dc_fsz;        /* file size (bytes) */
        };
 
/*-------------------------------------------------------------------------*/
 
/* MSFS Function Request Parameter Blocks (RPBs) */
 
union   RPB
        {
        /* OPEN */
        struct
                {
                char                      *op_fn;       /* filename to open */
                char                      *op_ch;       /* channel number */
                unsigned short        op_at;        /* file attributes */
                unsigned short        op_rsz;       /* record size */
                unsigned short        op_opt;       /* user options */
                } op_fl;
 
        /* READ or WRITE */
        struct
                {
                char                      *rw_ch;       /* channel number */
                char                      *rw_buf;      /* addr. of buffer */
                unsigned short        rw_opt;       /* user options */
                unsigned short        *rw_btr;      /* bytes transfered */
                unsigned short        rw_nrc;       /* number of records */
                union
                        {
                        /* random operation */
                        unsigned long        rw_rec; /* record number */
                        /* sequential operation */
                        struct                           /* buffer size */
                                {                        /* terminator */
                                unsigned short  rw_rsz;
                                char                rw_trm;
                                } rw_seq;
                        } rw_req;
                } rw_fl;
 
        /* CLOSE */
        struct
                {
                char                      *cl_ch;         /* channel number */
                unsigned short        cl_opt;         /* attributes */
                } cl_fl;
 
        /* SEEK */
        struct
                {
                char                  *sk_ch;         /* channel number */
                unsigned short        sk_opt;         /* seek option */
                long                  sk_pos;         /* file position */
                } sk_fl;
 
        /* CHANGE FILE */
        struct {
                char                  *ch_fn;       /* current filename */
                unsigned short        ch_opt;       /* change options */
                union {
                   char               *ch_nfn;      /* new filename */
                   unsigned short     ch_nat;       /* new attributes */
                   } ch_req;
                } ch_fl;
 
        /* SEARCH */
        struct
                {
                char                      *sr_fn;       /* file to search */
                unsigned short        sr_opt;       /* search options */
                struct DREC               *sr_drc;      /* directory record */
                unsigned short        *sr_drn;      /* directory number */
                } sr_fl;
 
        /* FORMAT */
        struct
                {
                char                      fm_vol;       /* volume to format */
                unsigned short        fm_ind;       /* VDB index value */
                } fm_fl; 
 
        /* SET CURRENT VOLUME */
        char                        sv_vol;      /* new volume */
 
        /* SET CURRENT DIRECTORY */
        char                        *sd_dnm;    /* ptr to dir. name */
 
        /* FLUSH FILE SYSTEM */
        struct
                {
                unsigned short        fh_opt;           /* flush option */
                char                      fh_vol;           /* flush volume */
                } fh_fl;
 
        /* GET CURRENT PATH */
        struct
                {
                char                     *cu_vol;          /* volume name */
                char                     *cu_dir;          /* dir. name ptr */
                } cu_fl;
 
        /* CHECKPOINT FILE */
        char                             *cp_ch;           /* channel */
 
        };
