/* @(#)loader.h	1.4 11/16/90 */
/*	LOADER.H
*/

#define  TMAGIC			0x0107L		/*	Tekelec magic number	*/

#define  MAX_LD			20			/*	Maximum number of loaded programs	*/
#define  MAX_NA			20			/*	Maximum file name length			*/
#define  LKEY	KEY('L','K','E','Y')/*	Loader's key (for Malloc)			*/
#define  LSEM	KEY('L','S','E','M')/*	Loader's semaphore key				*/

#define  L_SETGONE		0
#define  L_SETNRUN		1
#define  L_SETRUN		2

/*	Loader errors
*/
#define  L_NOERR		0L		/*	no error								*/
#define  L_OPNERR		-1L		/*	file open error (probably not found)	*/
#define  L_MEMERR		-2L		/*	memory allocation error (not enough)	*/
#define  L_REDERR		-3L		/*	file read error							*/
#define  L_COMERR		-4L		/*	command line error (no file name found)	*/
#define  L_RELERR		-5L		/*	relocation error (external reference)	*/
#define  L_FMTERR		-6L		/*	file format error (bad magic number)	*/
#define  L_OPRERR		-7L		/*	unknown loader option					*/
#define  L_RUNERR		-8L		/*	try to restore or remove a running pgm 	*/
#define  L_FULERR		-9L		/*	Too many programs currently loaded		*/
#define  L_PNRERR		-10L	/*	Tried to restore a non resident pgm		*/
#define  L_RLDERR		-11L	/*	Needs to be re-loaded					*/
#define  L_BSYERR		-12L	/*	Could not get semaphore to use loader	*/
#define  L_IDERR		-13L	/*	Invalid id number						*/
#define  L_FNFERR		-14L	/*	File Not Found							*/

#define  L_LOAD			1L
#define  L_RESTORE		2L
#define  L_REMOVE		3L
#define  L_MARK			4L
#define  L_FINDN		5L
#define  L_FINDID		6L
#define  L_FREE			7L
#define  L_GETKEY		8L

/*	Header prepended to each a.out file.
*/
typedef struct {
	long				a_magic;	/* magic number						*/
	long				a_text;		/* size of text segment				*/
	long				a_data;		/* size of initialized data			*/
	long				a_bss;		/* size of uninitialized data		*/
	long				a_syms;		/* size of symbol table				*/
	long				a_entry;	/* entry poshort						*/
	long				a_trsize;	/* size of text relocation			*/
	long				a_drsize;	/* size of data relocation			*/
	}
	exec;

/*	Format of a relocation datum.
*/
typedef struct {
	long				r_address;		/* address which is relocated		*/
	unsigned long		r_info;			/* r_symbolnum, r_pcrel, r_length,	*/
										/* r_extern.						*/
	}
	reloc_info;

/*	Fields for r_info (above)
*/
#define  r_symbolnum(x)	((x>>8) & 0xffffffL)
#define  r_pcrel(x)		((x>>7) & 0x1L)
#define  r_length(x)	((x>>5) & 0x3L)
#define  r_extern(x)	((x>>4) & 0x1L)

/*	Symbol table entry
*/
typedef struct {
	char					*n_name;
	char					n_type;		/* type flag, i.e. N_TEXT etc		*/
	char					n_other;	/* unused							*/
	char					n_desc;		/* currently not used				*/
	long					n_value;	/* value of this sym				*/
	}
	nlist;

/*	Values for n_type (above)
*/
#define  N_UNDF		0x0		/*	undefined							*/
#define  N_ABS		0x2		/*	absolute							*/
#define  N_TEXT		0x4		/*	text								*/
#define  N_DATA		0x6		/*	data								*/
#define  N_BSS		0x8		/*	bss									*/

#define  N_EXT		0x01	/*	external bit, or'ed in				*/
#define  N_TYPE		0x1e	/*	mask for all the type bits			*/

extern long	loader();

