/* @(#)ctype.h	1.2 11/16/90 */
/*
	Character type tables

	NOTE
	If changes/additions are made, please ensure that the argument
	to the macro is referenced ONLY ONCE in the macro.  
*/
#ifndef DL_CTYPE
#define DL_CTYPE

#define	ctUCASE	0x01
#define	ctLCASE	0x02
#define	ctDIGIT	0x04
#define	ctSPACE	0x08
#define	ctPUNCT	0x10
#define	ctCNTRL	0x20
#define	ctHEXDG 0x40

extern char _ct_[];

#define	isalpha(c)	(_ct_[(c) + 1] & (ctUCASE | ctLCASE))
#define	isupper(c)	(_ct_[(c) + 1] & ctUCASE)
#define	islower(c)	(_ct_[(c) + 1] & ctLCASE)
#define	isdigit(c)	(_ct_[(c) + 1] & ctDIGIT)
#define	isxdigit(c)	(_ct_[(c) + 1] & (ctDIGIT | ctHEXDG))
#define	isspace(c)	(_ct_[(c) + 1] & ctSPACE)
#define	ispunct(c)	(_ct_[(c) + 1] & ctPUNCT)
#define	isalnum(c)	(_ct_[(c) + 1] & (ctUCASE | ctLCASE | ctDIGIT))
#define	isprint(c)	(_ct_[(c) + 1] & (ctPUNCT | ctUCASE | ctLCASE | ctDIGIT))
#define	iscntrl(c)	(_ct_[(c) + 1] & ctCNTRL)
#define	isascii(c)	((unsigned) c <= 0x7F)
#define	toupper(c)	((c) - 'a' + 'A')
#define	tolower(c)	((c) - 'A' + 'a')
#define	toascii(c)	((c) & 0x7F)

#endif /* DL_CTYPE */
