TCP MONITORING


TCP Monitoring supports the following protocol stack:

         Layer 1      (supports any Chameleon I/O Module)
         Layer 2       HDLC
         Layer 3       X.25 and IP
         Layer 4       TCP


TCP FUNCTION KEYS

The function keys control how the data is displayed and
interpreted.  The following conventions are used for function 
keys F1 - F6:

   +   The data for that layer is displayed in an interpreted 
       format.

   "   The data for that layer is displayed in an 
       uninterpreted format.  The format is determined by 
       the selection made with the F10 key.

   *   The data for that layer is displayed in both 
       interpreted and uninterpreted formats.

   -   The data for that layer is acquired, but is 
       not displayed.


F1 PHYS:  F1 PHYS specifies how the physical layer (layer 1)
          data is displayed.  The physical layer protocol is 
          determined by the Physical Interface parameter
          in the Chameleon Main Configuration Menu.   PHYS data 
          is displayed in white.

          When the physical layer is uninterpreted (PHYS" 
          or PHYS*), the upper layers are not interpreted,
          regardless of their function key selections.
          This causes all data above layer 1 to be displayed 
          uninterpreted in the format selected with F10.


F2 HDLC:  F2 HDLC determines how layer 2 (HDLC) is displayed.
          HDLC is displayed in green.


F3 X25:   F3 X25 determines how layer 3 (X.25) is displayed.  
          The X.25 data is displayed in yellow. 


F4 IP    F4 determines how IP data is displayed.IP data 
          is displayed in cyan.

F5 TCP    F5 determines how TCP is displayed.  TCP data is 
          displayed in magenta.


F6  APPL  F6 toggles the display of Layer 4 application data,    
          except when F5TCP is set to TCP-.   APPL+ means Layer  
          4 data is being displayed; APPL- means such data is not  
          being displayed.  APPL data is displayed in white.


F9        F9 determines how the upper layer data (layers 3 
          and above) is displayed.  The options are:

          Summary  Layers 1 and 2 are fully interpreted.  
                   Summarized interpretations of layers 3 and 
                   above are displayed.
          Full     All layers are fully decoded and displayed.


F10       F10 determines the display format of data item 
          values.  The options are:

          Meaning   When possible, the interpretation of 
                    the value  is displayed. If the meaning is 
                    not defined by the protocol, the value is 
                    displayed in hex.  
           Hex      The value is displayed in hex.
           Decimal  The value is displayed in decimal. 
           Binary   The value is displayed in binary.
           ASCII    The value is displayed in ASCII.
           EBCDIC   The value is displayed in EBCDIC.
           Offset   The offset of the item from the start of 
                    the acquired event is shown in the format
                    n.m, where n is the number of octets 
                    and m is the number of bits within the 
                    octet.
           Length   The length of the item is shown in the 
                    format n.m, where n is the number of octets
                    and m is the number of bits.


TCP COMMANDS

The following commands can be used when a TCPIP page is 
selected.

   ?     This command displays the current software version 
         and monitoring mode.  The syntax is:

                ?

   \     This command can be used only within a configuration 
         file.  It is a literal escape character which 
          executes a Function-key command from within a 
          Configuration file.  The syntax is: 

             \ n

         'n' is in the range of 1 through 0, and represents the 
          function keys F1 - F10, respectively.  Each time 
          this command is used for a specific Function key, it 
          is as though that key were pressed.  


:close    This command closes the currently selected   TCPIP    
          page and its associated Real Time page.  This command  
          also closes the TRIGGERING EDITOR.  The syntax is:

             :close


:data     This command should be used when the Chameleon is 
          in internal mode only.  (Internal mode enables the 
          Chameleon to analyze data from a text file.)

          The :data command opens a text file with the data in 
          hex, builds events from the contents, and processes 
          them with the monitoring application.  The 
          text file must adhere to the following format:

           - Contain event data in hex with one event per line
           - Maximum event length of 256 bytes
           - Optional first character of the event can specify 
             which side of the line the data comes from:

                <   DTE event
                >   DCE event (default)

            You can use either of the following commands to 
            analyze a hex file:

                :data "filename"
                :data "filename" HEX

            "filename" may include a path.  If a path is not 
            included, it searches the directory :

                a:\tekelec\data\hex\


:filter     Filters the traffic in the acquisition buffer so 
            that only events matching user-defined criteria are 
            displayed in TCPIP and Real Time pages.  The filter-  
            ing criteria are defined using the TRIGGERING EDITOR, 
            which is invoked by the :trigger command.  You can 
            define a maximum of 64 criteria at a time.

                              CAUTION
               Entering a filter triggering value which does 
               not in fact exist will hang up the Chameleon, 
               requiring you to re-boot the system.
   
              :filter number op number...

            'number' is the criterion number as shown in the 
            TRIGGERING EDITOR.  'op' is one of the following
            logical operators:

               &    AND
               !    NOT
               ?    OR

           To stop filtering so that all data from the 
           acquisition buffer is displayed, Use:

              :filter off


:freeze    This command freezes the TCPIP display so that it is
           not updated with new data being acquired.  This can be
           used to view selected data without it being over-
           written by newly-acquired data.

              :freeze        Freezes the TCPIP display to show   
                             the 500 most-recently acquired     
                             events.

              :freeze n1 n2  Freezes the TCPIP display, showing 
                             only a user-specified range of    
                             events from the acquisition buffer. 
                             'n1' is the first event in the    
                             range, and 'n2' is the last event  
                             in the range. 


:jump      This command displays a specified event at the top 
           of the TCPIP page.  The syntax is:
  
              :jump n

           'n' is the number of the event you want to display.


:open      This command opens a new TCPIP page.  A maximum of    
           seven TCPIP pages can be open at a time.  The syntax  
           is:

             :open COLOR name PORT

           COLOR is the color of the page banner, as one of the 
           following, and must be in UPPER CASE letters:

               RED     GREEN     YELLOW
               BLUE    MAGENTA   CYAN
               WHITE (default color, if no color is specified)

           'name' is the page name of 1 to 12 upper and lower 
           case characters.  If you include blank spaces in the  
           name, the string must be enclosed in quotation marks.  
           PORT is the port being monitored, either A or B.


:print     This command outputs the interpretation of specified 
           events to a disk file or to a printer.  The syntax is:

              :print "name" first last  Saves specified range of
                                        events to filename.

              :print .PRT first last    Outputs specified range  
                                        of events to the printer.  
                                        PRT must be UPPER CASE.

           "name" may also include a path.  If path is not 
           included, the file is saved to the directory:

               a:\tekelec\data\hist\

           'first' is the first event number in the range and 
           'last' is the last event number in the range. If last 
           is not specified, only the first event is saved.  If a
           range is not specified (first and last are omitted),
           all events are saved in the file until a :print
           command is given with a different filename or no
           filename.


:quit      This command closes all pagesand, unloads the 
           monitoring application(s), and returns you to the     
           Applications Selection Menu..  The syntax is:

              :quit

           You can also exit monitoring by selecting the         
           Configuration page and using the Stop or Exit function  
           keys.  


:read      This command executes a configuration file.  The      
           syntax is:

              :read "filename"


:restore   This command loads a triggering criteria file into 
           memory.  The criteria can then be edited by entering 
           :trigger to access the TRIGGERING EDITOR, or used for 
           filtering or scanning the data in the acquisition 
           buffer by entering :filter or :scan.

              :restore            Loads the DEFAULT triggering   
                                  criteria file from the 
                                  directory using the command    
                                  string:

                                  a:\tekelec\analysis\x25\trig

              :restore filename   Loads a user-specified file 
                                  from disk.  filename may also 
                                  include a path.  If a path is 
                                  not specified, it searches 
                                  the directory:

                                  a:\tekelec\analysis\x25\trig


:save     This command outputs the specified events in hex to 
          a disk file.  This generates a file in the 
          correct format to be accessed by the :data 
          command. 

             :save "filename" first last 

          'first' is the first event number in the range and    
          'last' is the last event number in the range.  If      
          'last' is not specified, only the first event is       
          saved.

          If a range is not specified (first and last are        
          omitted), all events are saved in the file until a     
          :save command is given with a different filename or no  
          filename.


:scan      Displays the next event matching user-defined 
           criteria as defined using the TRIGGERING EDITOR, 
           The syntax is:

              :scan number op number...

           'number' is the criterion number as shown in the 
           TRIGGERING EDITOR  'op' is one of the following 
           logical operators:

              &   AND
              !   NOT
              ?   OR

           To stop scanning so that all data from the 
           acquisition buffer is displayed, Use:

              :scan off


:set cham32  Selects the monitoring mode, as follows:

             'External mode' is the normal mode which causes the 
             Chameleon to analyze data from its acquisition 
             buffer.   This is the default mode.  The syntax is:

                set cham32 on        Selects external mode

             'Internal mode' enables the Chameleon to analyze 
             data that has been saved in a text file.
             The syntax is:

                set cham32 off       Selects internal mode


:set separator  Toggles the event separator on and off.  
                When on, a white line with the event number 
                appears below each event, acting as a 
                delimiter between events.  When off, there is 
                no separation between events.  The syntax is:

                   :set separator on    Event separator is on. 
                   :set separator off   Event separator is off.


:set timebase   This command uses a specified event as the time 
                base.  Time stamps for all other events are 
                shown relative to that event.  The syntax is:

                   :set timebase n

                'n' is the event number to use as the time base.


:show        Displays the number of the criteria currently being 
             used for filtering or scanning. The syntax is:

                :show filter
                :show scan


:store       This command stores a triggering criteria file 
             to disk.  

                :store           Saves the DEFAULT triggering 
                                 criteria file from the 
                                 directory using the command 
                                 string:
 
                                 a:\tekelec\analysis\x25\trig

                :store filename  Saves a user-specified file 
                                 to disk.  filename may also 
                                 include a path.  If a path is 
                                 not specified, it saves to 
                                 the directory:

                                 a:\tekelec\analysis\x25\trig


:trigger     Invokes the TRIGGERING EDITOR, which allows you to 
             define up to 64 criteria for searching the data in 
             the acquisition buffer.  You can then use the 
             :filter or :scan commands to use one or more 
             criteria.  The syntax is:

                :trigger


:unfreeze    This command unfreezes a TCPIP display which has 
             been frozen using the :freeze command.  The syntax 
             is:

                :unfreeze

