
AUTO HDLC LIBRARY FILENAME:  libhdlc.a


FLUSH     Clears reception buffer.
          int flush()
          Returns:   3=Receive buffer overflow


GETIME    Gets the elapsed milliseconds since the system was 
          started.
          #include mtosux.h
          int getime(msbfr)
          unsigned char *msbfr;


GETPHY     Returns state of the physical interface.
           int getphy()
           Returns a 16-bit integer, bit encoded as:

                Byte 0
           Bit    7     6     5     4     3     2     1     0
           Pin   105   108   140   141   104   103   114   115
           Pin    4     20                3     2     15    17
           Sig   RTS   DTR   SQ          RD    TD    SCT   SCR

                Byte 1
           Bit    7     6     5     4     3     2   1    0
           Pin   106   107   109   122   125   142
           Pin    5     6     8     12    22
           Sig   CTS   DSR   CD    SDCD   RI


GETPORT   Identifies which port is communicating with the     
          library.
          #include cham.h
          int getport()
          Returns:
            0=Port A selected
            1=Port B selected


INITP1    Initializes P1 and loads software. 
          int initp1(type1,type2,encode,bitrate)
          int  type1;   0=DCE
                        1=DTE
                        2=ISDN
          int  type2;   0=Network
                        1=Subscriber
          int  encode;  0=NRZ
                        1=NRZI
          unsigned long bitrate;    50 - 64000
          Returns:
            0=Successful
           -1=Invalid parameter(s)
           -2=P1 program not loaded
           -3=Port is busy

INITTIME  Initializes the interrupt system to start and 
          maintain the .01 second and 1 second timers.
          inittime()


P1RESET   Restarts or stops P1 simulation. 
          int p1reset(kind)
          int  kind;  0=Restart
                      1=Stop
          Returns:
            0=Successful
           -1=Error


RECEIVE   Receives a frame from P1 and places it at address in  
          packet.
          char receive(packet)
          char *packet;
          Returns:
            0=Successful
            1=Link not established
            2=initp1 not performed


SET_N1    Sets N1 (maximum packet size).
          int set_n1(val)
          int val;      Range: 1 - 512
          Returns:
            0=Successful
           -1=Invalid value


SET_N2    Sets N2 (number of retransmissions).
          int set_n2(val)
          int val;     Range: 1 - 255
          Returns:
            0=Successful
           -1=Invalid value


SET_T1    Sets T1 timer.
          int set_t1(val)
          int val;    Range: 1 - 255
          Returns:
            0=Successful
           -1=Invalid value


SETLEDS   Controls which port's LEDs are displayed on the 
          front panel of a Dual Port machine.
          int setleds(port)
          int port;  0=Port A LEDS displayed
                     1=Port B LEDS displayed
          Returns
            0=Successful
            1=Invalid parameter
            2=Dual Port board not installed


SETPHY     Sets physical interface lines as below.
           setphy()

               DCE
           Bit    7     6     5     4     3     2   1    0
           Pin   106   107   109   122   125   142
           Pin    5     6     8     12    22
           Sig   CTS   DSR   CD    SDCD   RI

               DTE
           Bit    7     6     5   4   3   2   1    0
           Pin   105   108   140   
           Pin    4     20
           Sig   RTS   DTR    SQ


SETPORT   Selects Port A or Port B for library.
          #include cham.h
          int  setport(port)
          int port;  0=Port A
                     1=Port B
          Returns
            0=Successful
           -1=Parameter out of range
           -2=Selected Port B, but not available


SETTIMER   Sets the timer value.
           int settimer(number,value)
           int number;   0=.01 timer (down)
                          1=.01 timer (up)
                          2=seconds (down)
                          3=seconds (up)
           unsigned int value;       timer setting
           Returns:
            0=Successful
            1=Invalid number
            2=inittime not performed


SET_WINDOW    Sets window size.
              int set_window(val)
              int val;    Range: 1 - 7
              Returns:
                0=Successful
               -1=Invalid value


SLOF      Disconnects link.
          int slof()


SLON      Establishes link by sending a SABM.
          int slon()


STATUS    Indicates status of frame level.
          int status()
          Returns:
            0=Disconnected
            1=Link connection requested
            2=Frame reject 
            3=Link disconnection requested
            4=Information transfer
            5=Local station busy
            6=Remote station busy
            7=Local & remote stations busy


TIMER     Returns the value of the timer.
          int timer(number)
          int number;  0=.01 (down)
                       1=.01 (up)
                       2=seconds (down)
                       3=seconds (up)


TRANSMIT  Transmits I-frame.
          transmit(packet,length)
          char *packet;
          int length;
          Returns:
            0=Successful
            1=P1 busy
            2=initp1 not performed
            3=Link not established


