
BERT

The Chameleon BERT application provides synchronous 
or asynchronous Bit-Error Rate Testing (BERT) data testing 
for a variety of data communications systems.  The 
Chameleon can be configured to emulate either a DTE or 
a DCE over any of the Chameleon I/O modules.

To use the BERT application, perform the following steps:

     1.    Complete the BERT Setup menu as required by
           your testing application.  


     2.  When the Setup menu is complete, press Go.  
         One of the following screens is then displayed:

          -If you selected USER for the Pattern parameter in
           the Setup menu, the Pattern Editor screen appears.  

          -If you selected something other than USER for 
           the Pattern,the first of the BERT run-time displays 
           will appear.  


     3.  The BERT run-time pages display bit and block 
         error statistics and enable you to start and stop 
         testing intervals.  When your entire testing 
         session is complete, press F10 Exit to stop the BERT 
         application and return to the Applications Selection 
         menu.


BERT Setup Menu Parameter

Framing       The Framing parameter selects Synchronous or 
              Asynchronous timing.  

Interface     The Interface parameter specifies whether the 
              Chameleon will simulate a DCE or a DTE device. 

Data Bits     The Data Bits parameter specifies the number 
              of data bits in each byte as 8, 7, 6, or 5 
              bits.  This parameter is displayed only when 
              using asynchronous framing and must be the 
              same as the remote device.

Stop Bits     The Stop Bits parameter specifies the number 
              of stop bits being used in each byte of data 
              as 1, 1.5, or 2.  This parameter is displayed 
              only when using asynchronous framing and must 
              be the same as the remote device.

Parity        The Parity parameter specifies the parity setting
              being used as None, Odd, or Even.  This parameter
              is displayed only when using asynchronous framing
              and must be the same as the remote device.

Baud Rate     The Baud Rate parameter specifies the speed 
              (in bits per second) that the Chameleon will use 
              to transmit or receive data.  This parameter 
              is displayed only when the Chameleon 
              is configured for asynchronous framing, or as a 
              DCE using synchronous framing.  If the Chameleon 
              is configured as a DTE using synchronous framing, 
              the Chameleon will match the received clock.

Pattern    The Pattern parameter specifies the type of 
           data that the Chameleon will transmit or expect 
           to receive on the line.  The following pattern 
           options are available:  

             -You can select a pseudo-random bit pattern of 63, 
              511, 2047, 4095, or 32767 bits in length.  

             -You can select the pattern 1010101 by pressing 
              F6 01010101.

             -You can select a standard FOX message by pressing 
              F7 FOX.  The FOX message used by the Chameleon 
              is as follows:
 
THE QUICK BROWN FOX JUMPS OVER THE LAZY DOGS BACK 1234567890 CR

              -You can define your own pattern of 3 - 200 bytes 
               in length.  To use a user-specified data pattern 
               press F8 USER.  

User Defined 
Preamble       This parameter enables you to enter a 2-byte 
               preamble which may be required by the remote 
               device in order to synchronize the line.  When 
               you select YES, the User Preamble parameter 
               appears, as described below.

User Preamble    This parameter appears only when the User 
                 Defined Preamble parameter is YES.  Enter the 
                 2 hex bytes for your required preamble and 
                 press Return.

Block Length   The Block Length parameter enables you to 
               select the block length required for your 
               testing application.  The block length varies 
               by standard and may correspond to the pattern 
               length or to a fixed number of bytes, such as 
               1000 or 10000.

Mode           The Mode parameter determines what the Chameleon 
               will do during the testing session. 

              -F1 REMOTE   Chameleon performs a remote loopback 
                           test.  In this mode, the 
                           Chameleon transmits the bit pattern 
                           to the remote device and expects the 
                           pattern to be looped back on the 
                           line to the Chameleon.  The 
                           Chameleon then analyzes the received 
                           pattern for errors.

              F2 LOCAL    Chameleon performs a local loopback 
                          test.  The Chameleon will wait to 
                          receive data from the remote device, 
                          analyze the data for errors, and then 
                          loop the received data back to the 
                          remote device. 

              F3 RECEIVE  The Chameleon receives and analyzes a 
                          bit stream, but will not transmit 
                          anything back to the remote device.

Duration of Test   This parameter determines how long the 
                   test will run when in continuous mode. Enter 
                   the test duration in the format: hh:mm:ss

                   A value of 00:00:00 causes the test to run 
                   forever, until manually stopped

                   The maximum duration for a test is 97 hours, 
                   59 minutes, and 59 seconds (97:59:59).


BERT Pattern Editor

The BERT Pattern Editor enables you to define a data 
pattern that the Chameleon will transmit on the line.  
To use the editor, do the following:

     1.  Access the BERT Pattern Editor.  To do this:

          a.  In the BERT Setup menu, select USER for 
              the Pattern parameter.

          b.  When the BERT Setup menu is complete, press 
              Go.  This displays the Pattern Editor screen.

     2.  Select an Entry Mode.

          The data pattern will be shown in hex pattern on 
          the left and in ASCII on the right of the editor 
          screen.  You can enter data in either hex or ASCII, 
          by pressing either F1 HEX or F2 ASCII. 

          The current entry mode (hex or ASCII) is displayed 
          above the data and is also indicated by the blinking 
          cursor in the data entry area.

     3.  Enter the pattern.

          The pattern must be 3 - 200 bytes in length.  The 
          data is displayed in 10 lines of 20 bytes each.  
          If you enter more than 200 bytes, the cursor will 
          loop back to the top of the data and begin 
          overwriting the first part of the pattern.  
          The current pattern length is displayed above 
          the data entry area.

     4.  When your pattern is complete, position the cursor 
         on the last byte of the data pattern.  The 
         cursor position determines the last byte of data 
         in the pattern, regardless of the data that 
         is displayed in the editor screen.

     5.  If you want to save the pattern to a file for future 
         use, press F3 Save. 

     6.  Press Go to display the first BERT run-time display.

BERT Run-time Display

There are two BERT run-time pages which display the statistics 
resulting from the Chameleon's analysis of the data received 
on the line.  

The function keys for the two BERT run-time pages 
are identical, as described below.

F1 1block     This key is relevant only for Remote Loopback 
              and Local Loopback testing.  It causes 
              the Chameleon to transmit one block of data to 
              the remote device.  The block size is specified 
              in the Block Length parameter in the Setup menu.
              The data pattern is specified in the Pattern 
              parameter in the Setup menu.

F2 Contins    In Remote Loopback mode, this key causes the 
              Chameleon to transmit data continuously. In 
              Local Loopback mode, the Chameleon will begin 
              to transmit data continuously once the line is 
              in sync.

              In Receive Only mode, this key causes the 
              Chameleon to begin receiving and analyzing data 
              from the remote device.

              In continuous mode, testing continues until:

               -F3 Stop is pressed, or
               -F6 Reset is pressed, or
               -The test has run its duration.

F3 Stop      This key stops continuous testing mode.  To 
             continue testing, press F2 Contins or F6 Reset.

F4 Ins Err   This key causes the Chameleon to transmit 
             an errored bit into the data being transmitted 
             to the remote device.  It is relevant for Remote 
             Loopback or Local Loopback test mode.

F5 Resync    This key causes the Chameleon to attempt 
             to resynchronize the line.  

F6 Reset     This key resets all statistical fields in 
             both pages to zero.  In continuous mode, F6 
             Reset, resets all statistical fields 
             and automatically resumes testing.

F7 Setup     This key stops the test session and exits 
             to the BERT Setup menu.

F9 Next      This key toggles between the two run-time pages.

F10 Exit     This key stops the BERT application and returns 
             you to the Applications Selection menu.

The top of both run-time pages display identical fields.  
These fields are:

     Elapsed 
     Seconds    Displays the number of seconds which have 
                elapsed since the test was started.  This timer 
                is restarted when F1 1block, F2 Contins, 
                or F6 Reset is pressed.  This timer is stopped 
                when the F3 Stop key is pressed.

     Time       Displays the system time as derived from the
                Chameleon clock in the format hh:mm:ss.

     Mode       Displays the current testing Mode as configured 
                in the Setup menu.  The field will display one 
                of the following: Remote L/B (loop back), Local 
                L/B, or Receive Only.

     Pattern    Displays the current Pattern as configured 
                in the Setup menu.  If a user-defined pattern 
                is being used, this field displays the message 
                USER DEFINED.

     Block 
     Length     This field displays the current Block Length.

     User 
     Preamble    Displays the User Preamble as configured in 
                 the Setup menu.  

     Status     This field displays the testing status between 
                the Chameleon and the remote device.  It will 
                display one of the following:

                Idle   The Chameleon is not actively 
                       performing a test.  Testing has not 
                       yet been started or a single block or 
                       timed test has been completed.

                No Sync   The test is proceeding, but the 
                          line is not synchronized.  In this 
                          state, the Chameleon continuously 
                          attempts to resynchronize the line .

                In Sync    The line is synchronized and the 
                           test is proceeding.  


In addition to the above fields, the first BERT run-time 
page displays these additional fields:

     Number 
     of Bits     For Transmit, this field displays the
                 total number of bits transmitted by the 
                 Chameleon to the remote device.

                 For Receive, this field displays the total 
                 number of bits received by the Chameleon from 
                 the remote device.

     Errored Bits  For Receive, this field displays the 
                   number of errored bits received from the 
                   remote device according to the data pattern.

                   For Transmit, this field displays the number 
                   of errored bits transmitted by the Chameleon 
                   to the remote device.  To transmit an 
                   errored bit from the Chameleon, you must 
                   press the F4 Ins. Err key.

     Bit Error
     Rate       For Receive, this field displays the number 
                of errored bits received since the beginning of 
                the test session, or since the run-time display 
                was reset using F6 Reset.  It is calculated as 
                the ratio of the number of bit errors to the 
                total number of bits received.

                For Transmit, this field is not applicable.

     Number 
     of Blocks     For Transmit, this field displays the 
                   total number of blocks transmitted by the 
                   Chameleon to the remote device.

                   For Receive, this field displays the total 
                   number of blocks received by the Chameleon 
                   from the remote device.

     Errored 
     Blocks      For Receive, this field displays the number of 
                 blocks received from the remote device with 
                 one or more bit errors.

                 For Transmit, this field is not applicable.

     Block Error 
     Rate        For Receive, this field displays the number 
                 of errored blocks received since the beginning 
                 of the test session, or since the run-time 
                 display was reset using F6 Reset.  It is 
                 calculated as the ratio of the number of 
                 block errors to the total number of blocks 
                 received.

                 For Transmit, this field is not applicable.


The second BERT run-time displays additional statistics 
based on the bit error rate of the received data. 

     Error Free
     Seconds       This field displays the number of 
                   available seconds in which no bit errors 
                   have occurred on the line.

     Errored 
     Seconds     This field displays the number of seconds in 
                   which at least one bit error has occurred.

     Severely
     Errored 
     Seconds    This field displays the number of seconds
                in which an available second has a bit 
                error rate worse then 10E-3.

     Consecutively
     Severely
     Error
     Seconds       This field displays the number of 
                   consecutive seconds with bit error rates 
                 worse then 10E-3.

     Degraded
     Minutes     This field displays the number of 
                 degraded minutes.  A degraded minute is a 60-
                 second block of non-severely errored 
                 available seconds in which the average 
                 bit error rate, measured over the 60 
                 seconds, is worse than 10E-6.

     Unavailable
     Seconds     This field displays the number of unavailable 
                 seconds.  An unavailable second is a second in 
                 which the line quality is degraded enough that 
                 the Chameleon received data with more than 10 
                 consecutive severely errored seconds.

