
ASYNC LIBRARY FILENAME:   libasync.a

FLUSH     Clears reception buffer.
          int flush()
          Returns:    3 = Receive buffer overflow


GETPHY    Returns state of the physical interface.
          int getphy()
          Returns a 16-bit integer, bit encoded as:

             Byte 0 
          Bit    7     6     5     4     3     2     1     0
          Pin   105   108   140   141   104   103   114   115
          Pin    4     20                3     2    15    17
          Sig   RTS   DTR   SQ          RD   TD   SCT   SCR

             Byte 1 
          Bit    7     6     5     4     3     2   1    0
          Pin   106   107   109   122   125   142
          Pin    5     6     8     12   22
          Sig   CTS   DSR   CD   SDCD   RI


GETIME    Gets the number of milliseconds elapsed since the 
          system was started.
          #include mtosux.h
          int getime(msbfr)
          unsigned char *msbfr;


GETPORT   Identifies which port is communicating with the     
          library.
          int getport()
          Returns:
            0=Port A selected
            1=Port B selected.


INITP1    Initializes P1 and loads simulation software. 
          int initp1(type, encode)
          int type;   0=DCE
                      1=DTE
          struct ASC_CTRL *encode
          
          struct ASC_CTRL
             {
             int bitrate;
             int parity;
             int stop;
             int data;
             int duplex;
             int block;
             int eob;
             };

          bitrate   1   50        7   1200
                    2   75        8   2400
                    3   110       9   4800
                    4   150       10  9600
                    5   300       11  19200
                    6   600

          parity    0   None
                    1   Odd
                    2   Even

          stop      0   1 Stop bit
                    1   1.5 Stop bits
                    2   2 Stop bits

          data      5   5 Data bits
                    6   6 Data bits
                    7   7 Data bits
                    8   8 Data bits

          duplex    0   Full duplex
                    1   Half duplex

          block     0   Block mode
                    1   Character mode

          eob (End of block character): 0-0xFF

          Returns:
            0=Successful
           -1=Invalid parameter(s)
           -2=P1 program not loaded
           -3=Port is busy


INITTIME   Initializes the interrupt system to start and
           maintain the .01 second and 1 second timers.
           inittime()


P1RESET   Restarts or stops P1 simulation. 
          int p1reset(kind)
          int kind;   0=Restart
                       1=Stop
          Returns:
            0=Successful
           -1=Invalid parameter(s)
           -2=Simulation program not loaded

RECEIVE   Receives a block or character from P1 and places it 
          at address pointed to by frame.
          char receive(frame)
          char *frame;
          Returns:
            0=Good BCC or no frame waiting
            1=Bad BCC
            2=initp1 not performed
            3=Overflow


SETLEDS   Controls which port's LEDs are displayed on the 
          front panel of a Dual Port machine.
          int setleds(port)
          int port;  0=Port A LEDS displayed
                     1=Port B LEDS displayed
          Returns
            0=Successful
            1=Invalid parameter
            2=Dual Port board not installed


SETPHY    Sets physical interface lines as below.
          int setphy()

              DCE
          Bit    7     6     5     4     3     2   1    0
          Pin   106   107   109   122   125   142
          Pin    5     6     8     12    22
          Sig   CTS   DSR   CD    SDCD   RI

              DTE
          Bit    7     6     5   4   3   2   1    0
          Pin   105   108   140   
          Pin    4     20
          Sig   RTS   DTR    SQ


SETPORT   Selects Port A or Port B for library.
          #include cham.h
          int  setport(port)
          int port;  0=Port A
                     1=Port B
          Returns
            0=Successful
           -1=Parameter out of range
           -2=Selected Port B, but not available


SETTIMER   Sets the timer value.
           int settimer(number,value)
           int number;   0=.01 timer (down)
                         1=.01 timer (up)
                         2=seconds (down)
                         3=seconds (up)
          unsigned int value;       timer setting
          Returns:
            0=Successful
            1=Invalid number
            2=inittime not performed


TBREAK    Transmits a break sequence.
          int tbreak()


TIMER     Returns the value of the timer.
          int timer(number)
          int number;  0=.01 (down)
                       1=.01 (up)
                       2=seconds (down)
                       3=seconds (up)


TRANSMIT  Transmits number of bytes in length, starting at 
          address pointed to by *frame, with the control 
          characters and BCC as specified by mode.  
          int transmit(frame, length)
          char *frame;
          int length;
          Returns:
            0=Successful
            1=P1 busy
            2=initp1 not performed
            3=Parameter error
            4=Buffer overflow


TREADY    Returns status of P1 transmitter.
          int tready()
          Returns:
            0=Transmitter ready
            1=Transmitter not ready
            2=initp1 not performed
            3=Overflow


