...System Interface
...set NLUS before compiling

...********* Console *********

PutC:	PROC  ...put out 1 char. (in R.A) to console
	...save all regs.
	PUSH AF; PUSH BC; PUSH HL
	LD HL,(SYSRET+1)
	LD BC,CONOUTOFF-WBOOTOFF; R.HL+R.BC
	CALLBIOS(LD C,A)
	POP HL; POP BC; POP AF
	RET

GetC:	PROC  ...get 1 char. from console->R.A if ready; ret. Z=0 iff got one
	...save other regs.
	PUSH BC; PUSH HL
	LD HL,(SYSRET+1)
	PUSH HL
	LD BC,CONSTOFF-WBOOTOFF; R.HL+R.BC
	CALLBIOS()
	POP HL
	if R.A<>0 then begin
	  LD BC,CONINOFF-WBOOTOFF; R.HL+R.BC
	  CALLBIOS()
	  LD B,0; INC B  ...set Z=0
	end
	POP HL; POP BC
	RET

CALLBIOS: ...save regs.<>AF,BC,HL & call @HL
	PUSH DE; PUSH IX; PUSH IY
	JPaHL()
	POP IY; POP IX; POP DE
	RET

JPaHL:	JP (HL)


......the following code gets modified by IO_Init
...StatC:	IO_Init(); BYTE CONSTOFF-WBOOTOFF
...GetCh:	IO_Init(); BYTE CONINOFF-WBOOTOFF
...PutCh:	IO_Init(); BYTE CONOUTOFF-WBOOTOFF
...StatIO:	IO_Init(); BYTE LSTSTOFF-WBOOTOFF  ...uses list status
...GetIO_:	IO_Init(); BYTE RDROFF-WBOOTOFF
...PutIO_: IO_Init(); BYTE PUNCHOFF-WBOOTOFF

...SAVREGS: ...save regs. except AF (clobbers HL)
...	EX (SP),HL; PUSH BC; PUSH DE; PUSH IX; PUSH IY; JP (HL)

...RESREGS: ...restore regs. except preserve AF
...	POP HL; POP IY; POP IX; POP DE; POP BC; EX (SP),HL; RET

...PutC:	PROC  ...put out 1 char. (in R.A) to console
...	...save all regs.
...	PUSH AF; SAVREGS()
...	PutCh(LD C,A)
...	RESREGS(); POP AF; RET

...GetC:	PROC  ...get 1 char. from console->R.A if ready; ret. Z=0 iff got one
...	...save other regs.
...	SAVREGS()
...	if B.StatC() <> 0 then begin
...	  B.GetCh()->R.A; LD B,0; INC B  ...Z=0
...	end
...	CALL RESREGS; RET  ...watch out for Q optimizer making this JP

...PutIO:	PROC  ...put to serial port (PUNCH)
...	PUSH AF; SAVREGS()
...	PutIO_(LD C,A);
...	RESREGS(); POP AF; RET

...GetIO:	PROC  ...get from serial port if ready (READER)
...	SAVREGS()
...	if B.StatIO() <> 0 then begin
...	    B.GetIO_()->R.A; LD B,0; INC B  ...Z=0
...	end
...	CALL RESREGS; RET

...IO_Init: PROC	...replaces CALL inst of caller with JP to BIOS+3+@retadr
...	...then goes there (preserve C)
...	LD HL,(SYSRET+1); POP DE; R.HL+@DE->R.HL; EX DE,HL
...	...DE=addr, HL=retadr
...	DEC HL; LD (HL),D; DEC HL; LD (HL),E; DEC HL; LD (HL),0C3
...	JP (HL)

...********************************* Disk Interface ***************************
...LUN:	BYTE	0
DMABEG:	WORD	0

LUOFFSET: EQU 0 ...4
FCBSZ:	EQU 36
FCBS:	DEFS NLUS*FCBSZ	...File Control Blocks (correspond to LU's 0..NLUS-1)

CCPM:	PUSH IX;PUSH IY;PUSH BC;PUSH DE;PUSH HL
	CALL CPM
	POP HL;POP DE;POP BC;POP IY;POP IX
	RET

DskInit: PROC
	CCPM(LD C,RESDSK)
	B.CDISK->R.E
	CCPM(LD C,SELDSK)
	00; RET

...Reset:	PROC
...	PUSH BC; CCPM(LD C,RESET); POP BC;
...	00;
...	RET

GetFCB:	PROC	...expects LUN A returns FCB DE
	PUSH HL;
	^FCBS->R.HL; LD DE,FCBSZ;
	R.A-(LUOFFSET-1)  ...LU#'s start at 4
...	INC A;
	while DEC A not do R.HL+R.DE->R.HL
	EX DE,HL;
	POP HL;
	RET

CloseF: PROC
	GetFCB(R.B); CCPM(LD C,CLOSEF);
	if R.A < 4 then 00;
	RET

OpenF:	PROC	...expects name+delim @HL; LU R.B
	...returns error A file length CDE
	GetFCB(R.B);
	if ParseName() then OpenIT(OPENF);
	RET

CreateF: PROC	...expects name+delim @HL; LU R.B
	...returns error A file length CDE
	GetFCB(R.B);
	if ParseName() then begin
	    CCPM(LD C,DELETEF); OpenIT(CREATEF);
	end
	RET

OpenIT:	PROC	...expects DEFT @HL, FCB @DE returns error A file length CDE
	LD C,A
	if B.CCPM() < 4 then begin
	    B.CCPM(LD C,FILSZ); LD HL,FCBSZ-3;
	    RanRecF(R.HL+R.DE);
	    00->@HL->@(R.HL+1)->@(R.HL+1);
	end
	if R.A<>0 then FNF_ERR
	RET

RanRecF: PROC	...expects Random Record Field @HL returns CDE with @HL*128
	PUSH HL;
	LD D,(HL); R.HL+1; LD C,(HL); @(R.HL+1)->R.A; LD E,0;
	RRA; RR C; RR D; RR E;	...length*128
	POP HL;
	RET

ParseName: PROC	...expects name+delim @HL, FCB @DE returns error A
	PUSH BC; PUSH DE; PUSH HL
	PUSH DE
	LD B,FCBSZ; 00->R.A
	repeat R.A->@DE; INC DE until DEC B zero; ...zero out FCB
	POP DE
...	R.HL+1;	...skip DEFT length $$$
	@(R.HL+1)->R.A; R.HL-1
	if R.A=':' then begin   ...drive given
	    @HL-'@'->@DE	...SAVE DRIVE NUMBER
	    R.HL+2->R.HL	...GO PAST DRIVE ID
	end
	...else current drive
	INC DE	...GO TO NEXT PART OF FCB

	PUSH DE
	MoveTxt(8)
	if @HL='.' then begin R.HL+1; MoveTxt(3) end
	else MoveSp(3)
	POP DE
	if @DE=' ' then 0FF else 00
	POP HL; POP DE; POP BC
	OR A;
	RET

MoveTxt: PROC  ...while characters valid move
	R.A->R.B
	while R.B<>0 and ValidChar(@HL) do begin
	    R.A->@DE; INC HL; INC DE; DEC B;
	end
	R.B->R.A
	...
MoveSp:	PROC  ...R.A spaces->@DE
	R.A+1->R.B; ' '->R.A
	while DEC B not zero do begin R.A->@DE; INC DE end
	RET

ValidChar: PROC
	if 	R.A>='@' and R.A<='Z'		...includes A-Z
		or R.A>='`' and R.A<='}'	...includes a-z
		or R.A>='/' and R.A<='9'	...includes 0-9
		or R.A>='!' and R.A<=')'	...includes "#$%&'(
		or R.A='+'
		or R.A='-'
		or R.A='\'
		or R.A='^'
	then
		CP A
	else R.A|0FF
	RET

SeekF:	PROC	...expects B LUN, CDE=abs. or rel. file pos. to seek to
	... R.A=0=>abs., =1=>rel., =2=>rel to eof
	...ret. CDE=abs. file pos.
	PUSH IX
	PUSH DE; PUSH BC
	PUSH AF
	GetFCB(R.B); PUSH DE; POP IX  ...DE,IX=^FCB
	POP AF
	if R.A<>0 then begin
	  if R.A<>1 then B.CCPM(LD C,FILSZ)
	  LD HL,FCBSZ-3;
	  RanRecF(R.HL+R.DE)  ...CDE=file pos. (current/end)
	end else R.A->R.C->R.D->R.E  ...CDE=0
	POP HL; R.L->R.A; POP HL  ...AHL=entered offset
	R.HL+R.DE; R.A+carry+R.C
	R.HL->R.DE; R.A->R.C  ...CDE=new abs. offset
	PUSH BC
	00; R.HL*2->R.HL; RL C; RLA; LD L,H; LD H,C  ...offset/128->AHL
	POP BC  ...CDE preserved
	R.HL->@2IX(FCBSZ-3); R.A->@IX(FCBSZ-1)
	POP IX
	00; RET

ReadF:	PROC	...expects B LUN, DE=buffer addr, HL length
		...returns A=err code (Z=0=>err), HL amount read
	PUSH IX
	InitRW();
	while R.B|R.C not and RanRW(READR) do DEC BC
	ExitRW();
	POP IX; RET

WriteF: PROC	...expects B LUN, CDE file address, HL length, IX DMA address
		...if R.C=0FF then write sequentially
		...returns HL amount written, CDE, IX updated
	PUSH IX
	InitRW();
	while R.B|R.C not and RanRW(WRITER) do DEC BC
	ExitRW();
	POP IX; RET

...GetRRP: PROC  ...expects A LUN; returns FCB @DE; Random Record Pointer @HL
...	GetFCB(R.A); LD HL,FCBSZ-3; R.HL+R.DE->R.HL;	...Rec_Ptr->HL
...	RET

InitRW:	PROC  ...enter B LUN, DE=buffer addr, HL len.
	...returns IX=addr, BC record count, FCB @DE, Random Record Pointer @HL
...	R.B->LUN
	LD (DMABEG),DE; PUSH DE; POP IX
	LD DE,07F; R.HL+R.DE; 00; R.HL*2; RLA; LD L,H; LD H,A;	...(HL+127)/128
	PUSH HL;
	GetFCB(R.B); LD HL,FCBSZ-3; R.HL+R.DE->R.HL;	...Rec_Ptr->HL
...	GetRRP(R.B)
	POP BC;
	RET
	
...InitRW:	PROC  ...returns BC record count; FCB @DE; Random Record Pointer @HL
...	R.B->LUN; LD (DMABEG),IX;
...	R.HL+07F; 00; R.HL*2; RLA; LD L,H; LD H,A;	...HL/128
...	PUSH HL;
...	if R.C<>0FF then begin
...	    00; R.DE*2->R.HL; RL C; RLA; LD L,H; LD H,C;	...CDE/128
...	    PUSH HL; PUSH AF; GetRRP(R.B); POP AF; POP BC;
...	    PUSH DE; PUSH HL;
...		LD (HL),C; INC HL; LD (HL),B; INC HL; LD (HL),A;
...	    POP HL; POP DE;
...	end else GetRRP(R.B)
...	POP BC;
...	RET
	
RanRW:	PROC  ...enter IX=^buffer, A=CPM code (READR/WRITER),
	... DE=^FCB, HL=^Random Record field
	...read record; ret. A,Z=err code, IX updated, BC,DE,HL preserved
	PUSH BC;
	R.A->R.B;
	PUSH DE; PUSH IX; POP DE; CCPM(LD C,SETDMA); POP DE;
	if B.CCPM(LD C,B)=0 then begin
	    PUSH HL;
	      while INC (HL) zero do R.HL+1;	...increment record count
	    POP HL;
	    LD BC,080; ADD IX,BC; ...increment DMA address and length
	    00->R.A;
	end
	if R.A<>0 then
	   if R.A=1 then EOF_ERR else 0FF
	POP BC;
	OR A;
	RET
	
ExitRW:	PROC
	PUSH AF;
...	LUN->R.B;
...	RanRecF(R.HL);	...get file address in CDE
...	PUSH BC
	LD BC,(DMABEG); R.IX-R.BC->R.HL  ...len->HL
...	POP BC;
	POP AF;
	RET
	
...*ZAP	SAVREGS RESREGS GetCh PutCh GetIO_ PutIO_ IO_Init
*ZAP	CALLBIOS JPaHL
*ZAP	DMABEG LUOFFSET FCBSZ FCBS CCPM GetFCB OpenIT RanRecF
*ZAP	ParseName MoveTxt MoveSp ValidChar InitRW RanRW ExitRW
*PACK ALL

*ZAP	DMABEG LUOFFSET FCBSZ FCB