...8-17-82
LSTLU:	EQU 0  ...list file log. unit
IMGLU:	EQU 1  ...image file log. unit
EOF:	EQU 0FF  ...2nd type of eof char.
...RECL:	EQU	0200
...DATE:	EQU	013AB ...where date stored
...COMMON: EQU	0FA80 ...start of common code area for both banks (need 0100)
...SP2: ...@@@	EQU 0FC00  ...top of bank 2 stack (must leave room below here)
...ASkip2:	EQU 0101C ...addr. of Skip2 (in prom's stack below what's used)
STAK2:	DEFS 040
SP2:	...init'n for R_SP
ATMPCD:	EQU	STAK2 ...@@@01098  ...temp. code area (in prom's stack below what's used)
...IV:	EQU	0FF ...value of I reg. (high-order of int. vectors)
...CTC0:	EQU	070 ...CTC channel 0
...CTC2:	EQU	072 ...CTC channel 2
...I2_JMP:	WORD at 0FFF4 ...@@@ at 013E6 ...CTC2 int. vec. loc.
BRKFLG:	BYTE 0 ...@@@ at 013CD ...=1xxxxxxx if BRKRTN jumped to (else=020)
BRKJMP:	BYTE at 066
BRKRTN:	WORD at 067 ...@@@ at 013CE ...RIO jump address if BRKFLG set
D_PC:	WORD 0 ...@@@ at 012D5 ...RIO saves PC here
D_SP:	WORD 0 ...@@@ at 012D7 ...RIO saves SP here
RR_AF:	WORD 0 ...@@@ at 01000 ...start of stored regs on remote cpu (AF,BC,DE,HL,IX,IY)
RR_SP:	WORD 0 ...@@@ at 0100C ...stored SP on remote cpu
RR_PC:	WORD 0 ...@@@ at 0100E ...ditto PC
SRR_AF:	WORD 0 ...@@@ at 01010 ...start of stored shadow regs. on remote cpu
...IOP:	BYTE 1 ...1 if IOP; 0 if not

BKINIT:	0C3->BRKJMP; ^NMI_Rtn->W.BRKRTN; RET  ...set brk ret addr

RSTS:	PROC
        7; LD BC,3; ^JPR; LD DE,8  ...
        repeat
                PUSH BC;LDIR;PUSH HL            ...move jump into place
                W.5+R.DE;EX DE,HL               ...advance to next rst loc.
                POP HL;POP BC
        until DEC A zero
	RET
JPR:	JP Err0; JP Test; JP Icopy; JP Out; JP OutN; JP BrkRtn; JP BrkRtn

NMI_Rtn: PROC
	EI; EX (SP),HL; JR BrkRtn2
	...
BrkRtn:	PROC  ...*****temporary break routine********
	EX (SP),HL;R.HL-1;
BrkRtn2: R.HL->D_PC; PUSH AF; W.4+R.SP->D_SP; POP AF; EX (SP),HL
	JP B_RTN

I_INIT:	PROC  ...make sure set up right for interrupts
...	BYTE 0ED 057;  ...LD A,I;
...	if R.A=0FF then 1 else 0;
...	R.A->IOP;

...	0E0; OUT (CTC0),A  ...program CTC int. vector reg.
...	IV; DEFB 0ED 047  ...013->R.I
...	DEFB 0ED 05E  ...set IM 2
	RET

Put1:	PROC  ...put out 1 char. (in R.A) to console
	PUSH AF; PutC(); POP AF; RET

Get1if:	PROC  ...get 1 char. from console->R.A if ready; ret. Z=0 iff got one
	JP GetC;

START0:	PROC
	LD SP,MYSP
	^INPTR->R.HL
	LD C,(HL); LD B,0  ...len.
	R.HL+1->R.DE
	0D->@(R.HL+R.BC)  ...make sure CR at end of input in sys cmd buff
	JP START1

...	LD DE,05D	...DEF FCB
...	if @DE=020 then JP START
...	PUSH DE;^SLSHDO;LD DE,DATA1;LD BC,4;LDIR;POP HL
...	LD B,8
...	repeat
...	  if @HL<>020 then begin R.A->@DE; INC DE end
...	  INC HL
...	until DEC B zero;
...	if @HL<>020 then begin
...		'.'->@DE;INC DE
...		LD B,3
...		repeat
...			if @HL<>020 then begin R.A->@DE; INC DE end
...			INC HL
...		until DEC B zero;
...	end
...	JP START2
...SLSHDO:	DEFM '/DO '


...	THE ASSIGN VECTOR FOLLOWS
...FILASN:	BYTE	4 ...logical unit no.
...	BYTE	02H ...ASSIGN
FILNM:	WORD	0 ...points to filename
...	WORD	0 0 0
...	BYTE	0 ...CC
...	WORD	ASNSUP
...ASNSUP:	BYTE	0 ...indicates system will parse filename and put in vector
...	DEFS	1 ...for drive no.
...FNML:	DEFS	1 ...for file name length
...FNAME:	DEFS	020 ...for filename

...	THE INPUT OPEN VECTOR FOLLOWS
...FILINO:
LOGUN:	BYTE	SWCON ...unit 5 (actually will be put in range 6-10 when used)
...	BYTE	04H ...OPEN
...	WORD	BUFF ...where attributes returned
...FOPNLA:	WORD	96 ...get 96 bytes of attribute info
...	WORD	0 0
...	BYTE	0 ...completion code
...	WORD	FOPNSP
...FOPNSP:	BYTE	8 ...open for input and random access
...	BYTE	'*' ...DRIVE ADDRESS (not needed if use ASSIGN)
...	BYTE	-1 ...because ASSIGN handles filename

...	THE READ & WAIT VECTOR FOLLOWS
...FILRD:	BYTE	5 ...logical unit
...RDTYP:	BYTE	0A ...read binary or read direct (022)
...	WORD	DATA1 ...read into low buffer
...FILRDL:	WORD	RECL ...bytes to read
...	WORD	0 0
...	BYTE	0 ...completion code
...	WORD	RCADR1 ...3-byte area for disk address

...	THE READ & NO WAIT VECTOR FOLLOWS
...FILIN:	BYTE	5 ...log. unit
...	BYTE	0B ...read binary, return immediately
...	WORD	DATA2 ...read into high buffer
...FILINL:	WORD	RECL ...bytes to read
...	WORD	0 ...RDDUN ...completion return address
...	WORD	0
...FILINC:	BYTE	0 ...completion code
...	WORD	RCADR2 ...3-byte area for disk address

...	THE OUTPUT OPEN VECTOR FOLLOWS
FILPTO:	BYTE	4 ...logical unit
...	BYTE	4 ...open code
...	WORD	0 0 0 0 ...use default attributes
...	BYTE	0 ...completion code
...	WORD	FILPSP ...^supplemental
...FILPSP:	BYTE	1 ...open output, overwriting
...	BYTE	'*'
...	BYTE	-1 ...name length set to -1 because ASSIGN handles name

...	THE OUTPUT WRITE VECTOR FOLLOWS
...FILPUT:	BYTE	4 ...unit no.
...	BYTE	0EH ...write binary, wait
...FPUTAD:	WORD	FPUTBF ...file output buffer
...FPUTL:	WORD	RECL ...length
...	WORD	0 0
...	BYTE	0 ...completion

...	THE UPDATE VECTOR FOLLOWS
...UPDATE:	BYTE	5 ...unit no. (used only when imaging)
...	BYTE	02C ...update
...	WORD	FPUTBF ...loc. of attributes
...	WORD	116 ...no. of bytes of attr.
...	WORD	0 0
...	BYTE	0 ...CC

...	THE CLOSE VECTOR FOLLOWS
...FILCLO:	BYTE	4 ...unit no.
...	BYTE	6 ...CLOSE
...	WORD	0 0 0 0
...	BYTE	0 ...completion code

CLOSFL:	PUSH DE; PUSH HL
	CloseF(R.A->R.B)
	POP HL; POP DE
	00; RET

...CLOSFL:	R.A->B.FILCLO ...logical unit no.
...	LD IY,FILCLO	
...SYSTEM:	... fake entry
...	DI; EX AF,AF'; EXX  ...shadow regs. saved for QBUGing progs. using them
...	PUSH HL; PUSH DE; PUSH BC; PUSH AF
...	EXX; EX AF,AF'; P.C_EI
...	PUSH HL; PUSH DE; PUSH BC; PUSH IX
...	CALL SYSTM  ...@1403
...	POP IX; POP BC; POP DE; POP HL
...	DI; EX AF,AF'; EXX
...	POP AF; POP BC; POP DE; POP HL
...	EXX; EX AF,AF'
...	LD A,(IY+10)  ...CC
...	CP 080H  ...check if call was successful
...	...
C_EI:	PROC  ...do EI iff I_SW=0
	PUSH AF; if B.I_SW=0 then EI; POP AF; RET

EOFSEQ:	BYTE CPMEOF 0D EOF
LEOFSEQ: EQU $-EOFSEQ

PUTEOF:	...put out eof seq. to list file
	PUSH DE
	^EOFSEQ->R.HL; LD DE,EOFSEQ+LEOFSEQ; PUTFILE()
	POP DE; RET

FINBUF:	...if list file open, fill rem. buffer with spaces +CR at end & put out
	B.DIAGSW; BIT 2,A; RET Z
	LD BC,(FPUTRM); W.FPUTNX->R.HL
	repeat LD (HL),' '; INC HL; DEC BC until R.B|R.C zero;
	DEC HL; LD (HL),0D  ...fall thru:
	...
PUTOUT:	LD BC,RECL; LD (FPUTRM),BC; ^FPUTBF->W.FPUTNX
PUTO2:
	PUSH DE
	EX DE,HL; R.BC->R.HL
	WriteF(B.FILPTO->R.B)
	POP DE
...	LD (FPUTL),BC; R.HL->W.FPUTAD
...	SYSTEM(LD IY,FILPUT)
	RET Z
WRTERR:	PUSH AF
	B.FILPTO=LSTLU; CALL Z,ZDGSW  ...if list file, zero DIAGSW
	CLFPT()  ...close output file without trying to empty buffer
	POP AF
	CALL ERRMCC; DEFT 'WRITE'

CLFPT:	CLOSFL(B.FILPTO)  ...close file; ret. Z=1
	...
LNEWLU:	LSTLU->R.A  ...restore list file LU#
ONEWLU:	R.A->B.FILPTO; CP A; RET
...	R.A->B.FILASN->B.FILPTO->B.FILPUT; CP A; RET  ...set LU#->outpt vectors

LFILOPN: ...open list file; DE pts. to filename followed by a delimiter
	LD (FILNM),DE
	OFILOPN(LSTLU)  ...open output file with LU=LSTLU
	^DIAGSW; SET 2,(HL)  ...mark for file output ...(ret. HL=^DIAGSW)
	RET

OFILOPN: ONEWLU(R.A)
	CreateF(FILNM->R.HL; R.A->R.B)
	RET Z
	...
...OFILOPN: ONEWLU(R.A)  ...store log. unit # (in R.A)->output vectors
...	SYSTEM(LD IY,FILASN); JR NZ,RESLLU  ...assign
...	SYSTEM(LD IY,FILPTO)  ...open output file
...	RET Z
RESLLU:	LNEWLU(); JR OPNERR  ...restore LU=list file in output vectors

FILOPN:	...enter with FILNM=^filename +delim.; open file for input
	...ret. R.A=080 if "LOAD" file, else 020 ("DO"); CDE=file len.
	OpenF(FILNM->R.HL; B.LOGUN->R.B)
	JR NZ,RESLU
	if B.DOFLG=0 then 020 else 080
	RET

...FILOPN:	SYSTEM(LD IY,FILASN); JR NZ,RESLU  ...assign
...	SYSTEM(LD IY,FILINO); JR NZ,RESLU  ...open input file
...	B.DOFLG->R.B
...	B.FLTYP(); BIT 7,A; RET NZ  ...chk if proc. type
...	if BIT 5,A not zero then begin INC B; DEC B; RET Z end
...	  ...check if file type ascii and not doing "/GET"
...	CLOSFL(B.LOGUN)  ...close file if not ascii or proc.
...	0D2->R.A  ...error code for invalid type
RESLU:	PUSH AF; @^LOGUN-1->@HL; NEWLU(); POP AF  ...restore old log. unit no.
...	^FOPNLA; LD (HL),96  ...reset no. bytes of attributes to get
OPNERR:	CALL ERRMCC; DEFT 'OPEN'

...MVDATA:	^DATA1; if B.DOFLG<>0 then LDIR; CALL Z,WRLDIR; RET

NEWFIL:	PROC  ...enter with DE at CR; FILNM contains ptr. to input file name
	...	 followed by delimiter
	@^LOGUN->R.A
	CP SWCON+5; JP NC,TUDEEP  ...files go from log. units 6-10
	R.A+1->@HL  ...increment log. unit no.
	NEWLU()  ...store new log. unit no. in vectors
	LD IY,RECPTR-SWCON-1
	R.A->R.C; LD B,0; ADD IY,BC  ...position IY
	INC DE; SCF  ...move DE past CR
	if ^DATA2-carry-R.DE<zero then begin  ...chk if in low or high buffer
	  ^RECL; EX DE,HL; R.HL-R.DE; EX DE,HL  ...if in high buffer, pt. DE to same rel. pos. in low
	  W.RCADR2->R.HL; B.RCAD2H->R.A end  ...addr. of record in high buffer
	else begin
	  W.RCADR1->R.HL; B.RCAD1H->R.A end  ...addr. of record in low buffer
	endif
	LD (IY+0),E; LD (IY+5),D  ...store old DE (normally pts. after CR)
	LD (IY+10),L; LD (IY+15),H; R.A->@IY(20)  ...store disk addr. of record
	FILOPN()  ...open file (rets. R.A=FTYPE, CDE=len.)
	R.A->B.FILTYP  ...save for RDERR
	if BIT 7,A not zero then begin  ...if procedure (instead of ascii) type
	  LOADFL()
	  JR FILDN2
	end
...	  ^SEGDES  ...start of segment descriptors
...NXTSEG:	  LD E,(HL); INC HL; LD D,(HL); INC HL  ...DE=beg. seg. addr.
...	  LD C,(HL); INC HL; LD B,(HL)  ...BC=seg. len.
...	  R.B|R.C; JR Z,FILDN2  ...test done
...	  B.DOFLG=0; CALL NZ,SETTB0  ...if "/GET", bank 1 NCODE->DE
...	  INC HL; PUSH HL; PUSH BC; W.0; PUSH HL  ...initialize len. read to 0
...CNTSEG:	  RDREC()  ...read in one record
...	  POP BC; W.RECLEN  ...BC=len. read prev.
...	  R.HL+R.BC->R.HL  ...new len. read (also resets carry)
...	  EX (SP),HL; POP BC  ...HL=len. of segment, BC=len. read
...	  PUSH HL; PUSH BC
...	  if begin SBC HL,BC; LD BC,(RECLEN) end >zero then begin
...	    MVDATA(); JR CNTSEG  ...segment not done; transfer data
...	  end
...	  R.HL+R.BC->R.BC  ...seg. done, BC=no. bytes to store
...	  MVDATA()
...	  POP HL; POP HL; POP HL; JR NXTSEG  ...HL pts. to next seg. des.
...	end
	00->R.A->R.H->R.L  ...init. file pos. $$$
	READFL() ...read binary into low buffer, waiting; then into high buffer, not waiting
	LD DE,DATA1 ...pt. DE to start of buffer
	JP ST1  ...reset SP, get line of input & start parsing

FILDN0:	LOGUN=SWCON; RET Z
FILDUN:	if B.NUMERR<>0 then ?"ERROR TOTAL=",R.A
FILDN2:	CLOSFL(@^LOGUN)  ...close input file
	DEC (HL)  ...decrement logical unit no.
	if @HL<>SWCON then begin  ...check if back to $CON or still a file
	  NEWLU()  ...store revised logical unit nos.
	  LD IY,RECPTR-SWCON; R.A->R.C; LD B,0; ADD IY,BC  ...position IY to pt. to stored old DE & record addr.
	  LD E,(IY+0); LD D,(IY+5)  ...recall old DE
	  LD L,(IY+10); LD H,(IY+15); @IY(20)->R.A  ...get old record address
...	  R.HL->W.RCADR1; R.A->B.RCAD1H
...	  RDFL2(022)  ...read direct RECL bytes starting at record with stored address; then fill high buffer, not waiting
	  READFL()  ...$$$
	end
...	B.DOFLG=0; CALL NZ,GETSUB
	...
GetrecD: ...test if to jp to debugger or do Getrec
	if B.LOGUN=SWCON and W.SAVSP<>0 then begin LD SP,HL; JP DBUG2 end
	...
Getrec: PROC  ...enter with DE pointing after CR (or START)
	...assure another CR in buffer
	if B.LOGUN<>SWCON then begin  ...chk if getting from file or console
	  ^DATA2
	  if @DE=0A then INC DE	 ...skip linefeeds $$$
	  R.HL-R.DE; CALL Z,CHKRD  ...if at 1st spot in high buffer, call CHKRD
	  @DE=EOF; JP Z,FILDUN  ...check if at EOF (RIO)
	  R.A=CPMEOF; JP Z,FILDUN  ...check if at EOF (CPM) $$$
	  if R.HL+R.DE-R.DE<=zero then begin  ...chk if DE in hi or low buffer
	    LD BC,RECL; R.HL+R.BC->R.BC  ...in high buffer
	    PUSH DE; ^DATA2-R.BC; EX DE,HL; POP HL
	    PUSH DE; LDIR; POP DE
	      ...move remaining portion of high buffer to same rel. pos. in low
	    W.RCADR2->W.RCADR1; B.RCAD2H->B.RCAD1H  ...move record address
...	    GETFIL()  ...fill high buffer, returning immediately
	    RDFIL2()  ...$$$
	  end else begin  ...in low buffer
	    R.HL->R.BC; R.DE->R.HL
	    0D->R.A; CPIR  ...check if CR before end of buffer
	    CALL NZ,CHKRD  ...if no CR, wait for high buffer to be full
	  end
	end else begin
GETCNS:	  ...reads in a line from $CON, 1st char.->R.DE
	  LD A,'-'
Getcon:	  PROC  ...come here with R.A=prompt char.
	  Put1(R.A)
	  00->B.NUMERR  ...zero error count
	  GetN(LD DE,DATA1)  ...get new chars; DE pts. to beg. of buffer
	end
GETRCX:	LD (LASTCR),DE; LD (LASTDE),DE ...LASTDE needed in case Errm before set
	RET

...READFL:	0A->R.A  ...read binary
...RDFL2:	RDFIL(^RECL)  ...read into low buffer, waiting
...	CALL Z,GETFIL  ...if no error (such as EOF), fill high buffer, returning immediately
...	CALL NZ,RDERR  ...if error
...	RET

READFL:	...read in file, LU LOGUN, starting from fpos AHL; also set FPOS,FPOSH
	R.A->FPOSH; R.HL->FPOS
	RDFIL1()
	RDFIL2()
	RET

RDFIL1: ...read RECL bytes @file pos. FPOS,FPOSH to @DATA1, LU LOGUN
	...set RCADR1,RCAD1H; update FPOS,FPOSH
	FPOS->RCADR1->R.HL; FPOSH->RCAD1H->R.A
	READFIL(LD BC,DATA1)
	RET

RDFIL2: ...read RECL bytes @file pos. FPOS,FPOSH to @DATA2, LU LOGUN
	...set RCADR2,RCAD2H; update FPOS,FPOSH
	FPOS->RCADR2->R.HL; FPOSH->RCAD2H->R.A
	LD BC,DATA2
	...
READFIL: ...enter with AHL=file pos. to read at, BC=^dest., LU=LOGUN, len=RECL
	...do read, update FPOS,FPOSH; call RDERR if err
	PUSH DE
	PUSH BC
	R.A->R.C; EX DE,HL  ...CDE=fpos
	POP HL
	PUSH BC; PUSH DE
	PUSH HL
	SeekF(LOGUN->R.B; 00->R.A)
	POP DE  ...^dest.
	ReadF(LOGUN->R.B; ^RECL->R.HL)
	POP DE; POP BC
	PUSH AF
	00->R.A; R.HL+R.DE; R.A+carry+R.C  ...AHL=updated file pos.
	R.HL->FPOS; R.A->FPOSH
	POP AF
	POP DE
	CALL NZ,RDERR
	RET

...RDFIL:	R.A->B.RDTYP  ...type of read (binary or direct)
...	R.HL->W.FILRDL  ...len. to read
...	SYSTEM(LD IY,FILRD); RET  ...read into low buffer, waiting

...GETFIL:	1->B.RDFLG  ...set RDFLG to indicate reading in progress
...	^RECL->W.FILINL  ...len. to read
...	SYSTEM(LD IY,FILIN)  ...read binary into high buffer, not waiting
...	00; RET

...RDREC:	RDFIL(0A; W.RECLEN)  ...read binary 1 record
...	RET Z; JR RDERR2

LOADFL:	...load proc. file into memory; CDE=len
	if R.C<>0 or R.D>=060 then begin 0FF; JR RDERR2 end  ...chk too big
	EX DE,HL  ...len->HL
	ReadF(LD DE,TBASE; LOGUN->R.B)
	JR NZ,RDERR2
	RET

RDERR:	R.A=EOF_ERR; RET Z  ...if EOF error, return $$$
RDERR2:	PUSH AF; Quit()  ...close files (return to console after CALL Err)
	if begin B.FILTYP; BIT 5,A end zero then begin
	  ^DATA1->W.LASTCR; LD (HL),0D  ...for printing if not ascii file
	end
	POP AF; CALL ERRMCC; DEFT 'READ'

NEWLU:	...puts old (or new) logical unit no. in input vectors
...	R.A->B.FILINO ...input open vector (comment since ^LOGUN=^FILINO)
...	R.A->B.FILASN ...assign vector
...	R.A->B.FILRD ...file read & wait vector
...	R.A->B.FILIN ...file read & no wait vector
	RET

CHKRD:	repeat until B.RDFLG=0; RET  ...loop until last read complete

...RDDUN: ... this routine entered at completion of read & no wait operation
...	PUSH HL; PUSH AF
...	00->B.RDFLG  ...reset RDFLG to indicate reading complete
...	B.FILINC=080; CALL NZ,RDERR  ...check CC for error other than EOF error
...	POP AF; POP HL; RET

GET2W:	...next 2 words @HL go to DE & BC, HL inc'ed; BC tested for 0
	LD E,(HL); INC HL; LD D,(HL); INC HL
	LD C,(HL); INC HL; LD B,(HL); INC HL
	R.B|R.C; RET

IMGSUB:	...do IMAGE
	PUSH DE
	OFILOPN(IMGLU)  ...open output file (IMGLU=LU#)
	^SegDs2  ...beg. of seg. descriptors saying where to image from
	GET2W()  ...look at 1st segment descriptor only
	  ...GET2W rets. DE=seg beg adr, BC=seg len
	R.DE->R.HL
	PUTO2()  ...put out whole seg.
	CLFPT()  ...close file; restore list file LU->vectors; Z=1
	POP DE; RET

...IMGSUB:	...do IMAGE
...	PUSH DE
...	OFILOPN(5)  ...open output file (5=LU#); ...rets. HL=^DIAGSW
...	080->B.FTYP; 00->B.FPROPS...->@HL  ...set attr.; ...zero DIAGSW
...	R.A->R.H->R.L; R.HL->W.F_ST  ...ST=0
...	PUSH HL  ...HI_ADD to be kept on stack (init. set=0)
...	R.HL-1->W.LO_ADD  ...init. set LO_ADD to 0FFFF
...	^SegDes
...	...get HI_ADD=max of HiAdd's of each seg.; LO_ADD=min LoAdd's:
...	...HiAdd for each segment=BegAdr+((SegLen-1)&(0-RL))+(RL-1)
...	while GET2W() not zero do begin  ...go thru segment descriptors
...	  ...GET2W rets. DE=seg beg adr, BC=seg len
...	  PUSH HL; PUSH DE
...	  if W.LO_ADD-R.DE>=zero then LD (LO_ADD),DE  ...chk if new LO_ADD
...	  DEC BC; LD DE,(F_RL); W.0-R.DE
...	  R.B&R.H->R.H; R.C&R.L->R.L
...	  R.HL+R.DE-1
...	  POP DE; R.HL+R.DE  ...HL=HiAdd for this seg.
...	  POP DE; POP BC; PUSH BC  ...BC=prev. HI_ADD
...	  if R.HL>=R.BC then EX (SP),HL  ...compare it
...	  EX DE,HL
...	end
...	POP HL; R.HL->W.HI_ADD
...	SYSTEM(LD IY,UPDATE); JP NZ,WRTERR  ...attributes to file
...	^SegDs2  ...beg. of seg. descriptors saying where to image from
...	while GET2W() not zero do begin  ...go thru segment descriptors
...	  ...GET2W rets. DE=seg beg adr, BC=seg len
...	  PUSH HL; R.DE->R.HL
...	  if B.CODEBK=0 then  ...do fast way if in bank 1
...	    PUTO2()  ...put out whole seg.
...	  else begin  ...if in bank 2
...	    R.HL+R.BC->R.BC; EX DE,HL  ...BC=seg. end addr, HL=start seg. addr.
...	    repeat  ...do records until past end of segment
...	      PUSH BC; LD DE,FPUTBF; ...00->R.A  ...DE is ptr. to buffer
...	      LD BC,RECL; RDLDIR()  ...move bytes ->buffer
...	      PUSH HL; PUTOUT(); POP HL  ...put out 1 record (4 if RL=80)
...	      POP BC  ...recall seg. end addr.
...	    until R.HL>=R.BC or R.H<(RECL/0100);  ...chk if done segment
...	  end
...	  POP HL  ...HL pts to next seg. des. in buffer
...	end
...	POP DE; CLFPT(); RET  ...close file; restore list file LU->vectors; Z=1

...LDI_N2:	LD BC,02FF  ...move 2 chars if no., plus '-'
...	repeat if @HL&0F0=030 then LDI until DEC B zero;
...	'-'->@DE; INC DE; RET

VDATE: ...puts out Q version no. & date
	CALL Icopy; DEFT 'Q VERS '
	LD HL,QVERS+1; LD BC,4; LDIR  ...version no.
...	9->@DE; INC DE
...	LDI_N2(LD HL,DATE+2)  ...month
...	LDI_N2()  ...day
...	LDI_N2(^DATE); DEC DE  ...year, delete trailing '-'; continue below:
	Outp()
	RET

...*ZAP	SYSTM INPTR INDRJP ATMPCD CONIO CONRDY INRDY OUTRDY IV
...*ZAP	FILASN ASNSUP FNML FNAME FILINO
...*ZAP	FOPNLA FOPNSP FILRD RDTYP FILRDL FILIN FILINL FILINC FILPTO FILPSP
...*ZAP	FILPUT FPUTAD FPUTL UPDATE FILCLO FPUTBF FTYP FPROPS LO_ADD HI_ADD F_ST
...*ZAP	FPUTRM FPUTNX RCADR1 RCAD1H RCADR2 RCAD2H RECPTR NUMERR FILTYP STACK
...*ZAP	FTYPE RECLEN SEGDES DATA2 RDFLG ...R_DE R_IX R_IY
...*ZAP	CLOSFL SYSTEM ZDGSW STARS RESNST ERRMCC ERMGET Err0 ERR1 ST1 ST2 ST3
...*ZAP	START START0 START1 QINIT JPR I_INIT Echo GetN P_ESC 
...*ZAP	PUTLUP PUTOUT PUTO2 WRTERR CLFPT LNEWLU ONEWLU OFILOPN RESLLU
...*ZAP	FILOPN RESLU OPNERR MVDATA NXTSEG CNTSEG FILDN2 GetrecD GETCNS GETRCX
...*ZAP	READFL RDFL2 RDFIL GETFIL RDREC RDERR RDERR2 NEWLU RDDUN GET2W

*ZAP	LSTLU IMGLU STAK2 BRKJMP BRKRTN FILPTO
*ZAP	JPR NMI_Rtn BrkRtn BrkRtn2
*ZAP	CLOSFL PUTOUT PUTO2 WRTERR CLFPT LNEWLU ONEWLU RESLLU
*ZAP	FILOPN OPNERR FILDN2 READFL RDFIL1 RDFIL2 READFIL
*ZAP	LOADFL RDERR RDERR2 NEWLU CHKRD GET2W
...symbols common to MMETA & QSYS:
*ZAP	GetrecD GETCNS GETRCX
*PACK ALL


READFIL
*ZAP	LOADFL RDERR RDERR2 NEWLU CHKRD GET2W
...symbols common to MMETA & QSYS:
*ZAP	GetrecD GETCNS G