...ED22

ENTER:	...enter "enter" mode (inserts CR after present pos.)
	B.TAGFLG=0; RET NZ
	LD DE,(ENDDAT); INC DE
	W.ENDBUF-R.DE; JP Z,NOROOM
	  ...if no room in buffer, write "NO ROOM" on cmd. line
	'E'->B.EIRFLG
	PRCMR1(^TXTENT)  ...print 'ENTER' on cmd. line (right), return cursor
	P.FNDPOS; R.C->B.CRSCOL  ...find pos. in buffer; adjust CRSCOL
	if R.A<>0 then begin
	  @DE=CR; JR Z,EIR  ...jump if at CR but not 1st col.
	end
	P.RETCRS  ...pos. cursor right at char.
	P.INNULS  ...insert nulls before BUFPOS
	W.BUFPOS+R.BC-1; LD (HL),CR  ...replace last null with CR
	P.PRNWFB; JR EIRLUP  ...print (shifts following lines down)

INSERT:	...enter insert mode
	'I'->R.A
	^TXTINS; JR IR  ...pt. to text 'INSERT'

REPLCE:	...enter replace mode
	'R'->R.A
	^TXTRPL  ...pt. to text 'REPLACE'
IR:	R.A->B.EIRFLG
	B.TAGFLG=0; RET NZ
	PRCMR1()  ...print 'INSERT' or 'REPLACE' on cmd. line
	P.FNDPOS  ...find pos. in buffer to start (DE at char., R.C=col.)
	if @DE=EOF then begin P.BLCMR; JP QSTION end  ...if at EOF
	R.C->B.CRSCOL  ...adjust CRSCOL
EIR:	RETCRS()  ...move cursor to right at char.
	P.FNDCR  ...get row (->CRROW0) & pos. (->R.DE) of next CR
	if B.EIRFLG='I' then LD DE,(BUFPOS)  ...if insert mode
	P.INNULS  ...spread line, putting in null chars.
EIRLUP:	B.GETCHR1()->R.E  ...get a char.
	W.BUFPOS->R.HL
	if R.A=0 then  ...ctrl-@ means put in next char. (except 0) verbatim
	  repeat B.GETCHR()->R.E until R.A<>0
	else begin
	  B.RUBOUT->R.B
	  if R.E=BKSP or R.A=R.B then begin
	    P.DELCHR; JR EIRLUP  ...delete last or current char.
	  end
	  if R.A=ESC then begin PUSH HL; ABTCML(); POP HL; JR EIRX end  ...exit
	end
	if R.A=CR then begin B.EIRFLG='E'; JR NZ,EIRX end  ...exit
	if @HL=CR or R.A<>0 and B.EIRFLG='I' then begin
	  ...if all nulls replaced, add some more
	  PUSH HL; PUSH DE; EX DE,HL; P.INNULS; POP DE; POP HL
	  if B.FULFLG<>0 then begin P.NOROOM; JR EIRLUP end
	    ...if no room to add any nulls
	end
	P.NEWCHR; JR EIRLUP  ...replace with new char. & print out

EIRX:	LD BC,0  ...HL=BUFPOS coming here
	if B.EIRFLG<>'R' then begin  ...if insert or enter mode
	  while @HL=0 do begin  ...go to 1st non-null char. (->R.HL)
	    INC HL; INC BC  ...R.BC=no. nulls
	  end
	end
	else  ...jump here if replace mode
	  while @HL<>CR do begin  ...find no. nulls left in line->R.BC
	    if R.A=0 then INC BC
	    INC HL
	  end
	endif
	EX DE,HL; P.SHFTBK  ...shift file back over nulls
	00->B.FULFLG
	P.BLCMR; RET  ...blank out right part of cmd. line; ret. cursor

INNULS:	...expand line, inserting n null chars. in buffer (updating ENDDAT)
	...n=lesser of 128 or available space (returned in R.BC)
	...enter with R.DE->buffer loc. of char. to insert nulls before
	LD A,128
INNLS2:	...supply R.A when enter here
	W.ENDBUF; LD BC,(ENDDAT); INC BC
	R.HL-R.BC; LD C,A; LD B,0  ...avail. space in buffer->R.HL; R.A->R.BC
	if SBC HL,BC <zero then begin
	  R.HL+R.BC->R.BC  ...BC=min(R.A, avail. space)=no. nulls to insert
	end
	^FULFLG; LD (HL),0  ...reset flag
	if R.B|R.C zero then begin INC (HL); RET end  ...set flag for buf. full
	PUSH BC; P.SHFTFD  ...shift file past R.DE fwd. to make room for nulls
	LD (HL),0; R.HL->R.DE; INC DE  ...R.HL pts. to 1st opened-up space
	POP BC; PUSH BC; DEC BC
	if R.B|R.C not zero then LDIR  ...fill opened-up space with 0's
	POP BC; RET

DELCHR:	...if R.A=BKSP: delete char. before BUFPOS; if replace mode just bksp.
	...if R.A=RUBOUT: delete char. at BUFPOS, but not CR
	...come here with HL=BUFPOS
	if R.A<>BKSP then begin  ...if RUBOUT
	  @HL=CR; RET Z  ...don't do if at CR
	  B.EIRFLG='E'; RET Z  ...don't do if in enter mode
	  R.HL->R.DE; LD BC,0
	  if R.A='R' then begin  ...if replace mode
	    @HL=0; RET Z  ...if at null
	    PUSH HL
	    while @(R.HL+1)<>0 and R.A<>CR do INC BC
		...note: test on null above not really needed
	    if R.B|R.C not zero then begin  ...BC=dist. to 1st null or CR
	      R.DE->R.HL; INC HL; LDIR  ...shift intervening chars. back 1 sp.
	    end
	    00->@DE; POP DE  ...put in null; DE=BUFPOS
	  end else begin  ...if insert mode
	    while @DE=0 do INC DE  ...go to 1st non-null
	    R.A=CR; RET Z  ...don't do if at CR
	    00->@DE  ...replace char. with null
	  end endif
	  ^CRSROW; B.CRSCOL->R.C  ...for printing
	end else begin  ...if was BKSP
	  if @(R.HL-1)=CR then begin  ...check if char. before BUFPOS is CR
	    B.EIRFLG='E'; RET NZ  ...if not enter mode, don't delete CR
	    B.CRSROW-1; RET Z  ...if on top row, don't delete CR
	  end
	  R.HL->W.BUFPOS
	  EX DE,HL; P.CHRPOS  ...find col. of the char. at BUFPOS (->R.C)
	  ^CRSROW
	  if B.CRSCOL=0 then DEC (HL)
	  R.C->B.CRSCOL  ...update cursor pos.
	  if B.EIRFLG='R' then begin  ...if replace mode
	    P.RETCRS; RET  ...just backspace without deleting char.
	  end
	  LD DE,(BUFPOS); 00->@DE  ...put in null char.
	end endif
	@HL->B.ROWNO  ...for printing
	PUSH DE; PUSH BC; P.PRNEW  ...print starting at current pos.
	POP BC; POP DE; P.BLKEND  ...blank chars. left on scr. after CR
	@^FULFLG=0; RET Z  ...check if buffer was prev. full
	DEC (HL); BLCMR0(); RET  ...reset FULFLG; blank "NO ROOM" msg.

NEWCHR:	...put char. in R.E at HL (=BUFPOS); print updated screen
	B.CRSCOL->R.C
	if R.E=CR then LD C,LCOL  ...if CR
	R.A=TAB; CALL Z,TABPOS  ...if tab
	INC C  ...R.C=col. pos.
	PUSH DE; PUSH HL  ...save new char., BUFPOS...->DE & save
	B.CRSROW->R.B  ...for ROWNO (maybe)
	if R.C>=NCOL then begin  ...if goes to next row
	  B.CRSROW=LROW; CALL Z,MIDPBP  ...print so BUFPOS in mid. screen
	  ^CRSROW; LD B,(HL)  ...B is for ROWNO
	  INC (HL); 00->R.A
	end
	^CRSCOL; LD C,(HL); LD (HL),A  ...present CRSCOL->R.C; update CRSCOL
	POP HL; R.HL+1->W.BUFPOS-1
	POP DE  ...R.E=new char.
	if begin R.E=CR; R.B; LD B,(HL); LD (HL),E; EX DE,HL; R.A->@^ROWNO end
	    ...B->ROWNO; old char. in buffer->B; E->buffer, test if CR; HL->DE
	  then begin
	    INC (HL)  ...inc. ROWNO
	    LD BC,0-1
	    repeat INC DE; INC BC until @DE<>0;
	      ...DE->1st char. past nulls, BC=count of nulls
	    if W.128-R.BC<zero then LD C,128
	    INNLS2(128-R.C)  ...add nulls; DE pts. after last null
	    P.PRNWF0; RET  ...if entering CR, print rest of screen
	end
	PUSH DE; PUSH BC; P.PRNEW; POP BC; POP DE  ...print out
	R.B=TAB; RET NZ; B.EIRFLG='R'; RET NZ
	...if replacing a tab, print blanks at end of line:
	...
BLKEND:	...enter with DE in buffer (not at CR); R.C corres. col.
	...print up to 8 blanks at end of line
	PUSH DE; P.FNDCR; LD C,B  ...find pos. of following CR (R.B=R.C=col)
	POP DE
	LROW=@^CRROW0; RET C  ...ret. if CR is off screen
	if zero then INC B  ...if on last row
	repeat INC DE until @DE<>0;  ...go past nulls
	LD D,8; if R.A=CR then LD D,1
	if NCOL-R.B<R.D then LD D,A  ...R.D=min(8 or 1,cols. left in row)
	R.D=0; RET Z  ...D=no. spaces to print starting at CR
	POSCRS(R.C; LD B,(HL))
	repeat PUT1(' ') until DEC D zero;
	P.RETCRS; RET  ...ret. cursor

T:	@DE='1'; JP Z,TAG1  ..."T1" means go to TAG1
	R.A='2'; JP Z,TAG2  ..."T2" means go to TAG2
	R.A='3'; JP Z,TAG3
TOP:	...prints out 1st part of file, filling screen
	PRSCR0(LD DE,(EBUF)); RET

BOTTOM:	LD DE,(ENDDAT); PKLROW(); 00->B.CRSCOL
	P.PRSCRF; RET  ...print last page of file

M:	@DE & UPCASE='O'; JP Z,MOVE  ..."MO"=do MOVE
MIDDLE:	...print screen with current line in middle; cursor stays with line
	P.FNDPOS  ...fall thru:
	...
MIDPBP:	...print screen so char. at BUFPOS & cursor in middle
	LD DE,(BUFPOS)
...MIDPRT:	LD (BUFPOS),DE  ...no longer used
	CHRPOS(); R.C->B.CRSCOL; PUSH BC  ...save B
	P.LINBEG; PIKROW(LD A,LROW/2-1); POP BC; INC B; ^CRSROW
	while @HL<LROW and DEC B not zero do INC (HL)
	  ...adj. CRSROW if BUFPOS was not 1st row of line
	P.PRSCRF; RET  ...print

JOIN:	...join current line & following line into one
	B.TAGFLG=0; JP NZ,QSTION  ...don't do if tags present
	P.FNDPOS; @DE=EOF; JP Z,QSTION  ...find pos. in buf. (check if at EOF)
	P.FNDCR  ...find pos. of next CR (R.B=its col.)
	INC DE; @DE=EOF; JP Z,QSTION  ...check if on last line of file
	PUSH BC; PUSH DE; SHFTBK(LD BC,1)  ...shift file past CR back 1 space
	POP DE; POP BC; DEC DE
	B.CRROW0=NROW; RET NC  ...don't print if CR off screen
	R.A->B.ROWNO; LD C,B; P.PRSCR; RET  ...print out
...JNERR:	P.QSTION; RET  ...print "???"

LOCATE:	...starting next char., search for string taken from cmd. line
	...if at EOF, start at top
	...if found, print screen from that line; else "EOF"
	..."ctrl R" in string stands for CR
	P.SRCH0; JP NZ,QSTION
	  ...get str. from cmd. line; HL=start pos. for search-1
	EX DE,HL; @^STRBUF->R.B; LD A,CR2; PUSH HL
	repeat if R.A=@(R.HL+1) then LD (HL),CR until DEC B zero;
	  ...if a "ctrl R" in string, replace with CR
	INC DE; POP HL  ...DE=start pos.; HL->DEFT 'STRING'
	LD BC,0FFFF; P.LOCSTR  ...search till EOF for string
	  ...if found, DE pts. at 1st str. char.; else at EOF
	...fall thru:
	...
LOCPRT:	...if char. at DE (->BUFPOS) on screen, move cursor there, ret. Z=1;
	...else print screen so char. in middle, ret. Z=0
	LD (BUFPOS),DE
LOCPBP:	...enter here if BUFPOS already set
	if FNDCH0() not zero then begin MIDPBP(); OR 1; RET end
	R.C->B.CRSCOL; RETCRS(); 00; RET

...CHGERR:	P.QSTION; RET  ...illegal CHANGE cmd.

C:	@DE & UPCASE='O'; JP Z,COPY  ..."CO" means COPY routine
CHANGE:	...change STRING1 to STR2; do spec. no. of lines, once or all per line
	...start current line
	B.TAGFLG=0; JP NZ,QSTION  ...don't do if tags present
	P.TONOSP; JP NZ,QSTION  ...find delimiter
	GETSTR(^STRBUF); JP NZ,QSTION  ...get 1st string; err if no 2nd delim.
	LD B,0; R.HL+1+R.BC->W.STR2  ...where to put 2nd string (R.C=len.)
	GETSTR(R.HL)  ...get 2nd string
	if zero then begin  ...2nd string ends with delimiter, not CR or ";"
	  INC DE; if @DE='n' then LD A,'N'  ...'N' indicates do next occurrence
	  R.A->B.CHGALL  ...if ='*', indicates do all lines
	  if R.A='*' or R.A='N' then begin
	    INC DE; LD HL,0FFFF  ...no limit on no. of lines
	  end
	  else begin P.DIGIT; JR NZ,CHG1  ...check if no.
	    P.NUMBER  ...complete no.->R.HL
	  end
	  P.SPC  ...skip spaces; 1st non-space char.->R.A
	end else begin
CHG1:	  LD HL,1; 00->B.CHGALL  ...default=1 line, once per line
	end endif
	R.HL->W.NUM1; PUSH HL  ...NUM1=no. of lines to do
	R.A->@^NCPERL  ...if NCPERL<>'*' then once per line
	if B.STRBUF=0 then R.A->@HL  ...if 1st string is null, only do 1/line
	P.FNDPOS; POP HL  ...find pos.
	if @DE=EOF or R.HL=0 then begin  ...check if EOF or 0 changes
NOCHG:	  PRCMR0(^TXTNCH); RET  ...print "NO CHG" on cmd. line
	end
	00->B.CHGFLG->B.SFLFLG  ...zero flags
	R.A+1->B.ROWNO  ...start printing row 1
	if @W.STR2-@^STRBUF<zero then XOR A  ...carry reset after
	R.A->B.DIF  ...diff. in string lengths if new string longer
	LD BC,(ENDDAT); INC BC
	W.ENDBUF-carry-R.BC->R.BC  ...empty space in buffer
	R.HL+R.DE  ...same as BUFPOS+R.BC->R.HL
	PUSH HL; PUSH DE
	P.SHFTFD; POP DE  ...shift rem. part of file to end of buffer
	LD HL,STRBUF+1; LD C,(HL); POP HL  ...1st char. in STR1->R.C
CHGLUP:	while @HL<>CR do begin  ...check for CR
	  if B.STRBUF=0 then LD C,(HL)  ...if 1st string null, then want match
	  if @HL<>R.C or B.NCPERL<>'*' and B.CHLFLG<>0 then begin
	    ...check if no match with 1st str. char. or doing no more on line
CHG2:	    @HL->@DE; INC HL; INC DE; JR CHGLUP  ...move byte back down
	  end
	  PUSH HL; PUSH DE
	  CMPSTR(LD DE,STRBUF); POP DE  ...check if whole string matches
	  if not zero then begin POP HL; JR CHG2 end  ...no match
	  EX (SP),HL; PUSH HL
	  if R.HL-B.DIF-R.DE<zero then begin  ...check if STR2 fits
	    P.NOROOM  ...print "NO ROOM" on cmd. line
	    W.1->W.NUM1; POP HL; POP BC; LD C,EOF; JR CHG2
		...finish line & exit
	  end
	  POP HL; W.STR2  ...pt. to STR2
	  if @HL<>0 then begin LD B,A  ...move STR2 into place:
	    repeat INC HL; @HL->@DE; INC DE until DEC B zero;
	  end
	  if B.CHGALL='N' then begin  ...check if doing 1st ocurrence of string
	    LD (BUFPOS),DE; W.1->W.NUM1; 00->B.NCPERL  ...so will stop
	  end
	  POP HL; 1->B.CHLFLG->B.CHGFLG  ...set change on line & change flags
	end
	@HL->@DE; PUSH HL
	if @^CHLFLG<>0 then begin  ...if a change on the line
	  DEC (HL)
	  if B.CHGALL='*' then begin  ...check if doing all lines
	    PUSH DE; PUSH BC
	    P.LINBEG; LD C,0; P.PRLIN  ...print out line with change
	    if not zero then 1->B.SFLFLG  ...indicates screen full
	    POP BC; POP DE
	  end
	end
	INC DE; W.NUM1-1->W.NUM1=0  ...check if done
	POP HL; INC HL; JR Z,CHGX
	@HL=EOF; JP NZ,CHGLUP  ...if not EOF, do another line
CHGX:	PUSH HL; R.HL-R.DE->R.BC; POP DE
	P.SHFTBK  ...shift back rem. portion of file
	B.CHGFLG=0; JP Z,NOCHG  ...chk if any changes; if none, print msg.
	if B.CHGALL='*' then begin  ...if were doing all lines
	  ^ROWNO
	  if B.SFLFLG=0 then DEC (HL)
	  SCRRES(LD C,(HL)); RET
	    ...blank rem. scr.; wait for key hit; reprint scr.
	end
	if R.A='N' then begin  ...chk doing next occur.
	  B.CHGFLG=0; CALL NZ,LOCPBP; RET NZ
	    ...if change off screen, print so in middle
	end
	P.PRNWFB; RET  ...if not doing all lines, prt scr. from beg. curr. line

KOMPAR:	...compare from beg. of line with cursor with from tag 1 pos.
	...when get to differing chars., cursor moves to 1st char., tag 2 put
	... above line with 2nd char.
	B.TAGFLG-1; JP NZ,QSTION  ...must be tag 1 but not tag 2
	P.FNDPSB  ...get DE=beg. current line
	LD BC,LTAG1; W.TG1POS+R.BC  ...HL=just past "--From here:" (carry=0)
	R.HL-carry-R.DE; JP Z,QSTION  ...HL & DE must not pt. same spot
	R.HL+R.DE
	while @DE=@HL do begin INC DE; INC HL end
	PUSH DE; EX DE,HL; LINBEG()  ...DE=pos. for tag 2
	if SETTG2() zero then begin  ...put in tag 2 (Z=0 if no room)
	  ...DE at TG2POS, BC=LTAG2
	  POP HL  ...new cursor pos.
	  if R.HL>=R.DE then R.HL+R.BC  ...if cursor>=tag2 then inc. cursor ptr
	  PUSH HL
	  if W.BUFP0>=R.DE then R.HL+R.BC->W.BUFP0  ...inc. BUFP0 if>TG2POS
	  TAGSHW()  ...print "TAG 2" on cmd. line
	end
	POP DE; LD (TG3POS),DE  ...new cursor pos. (set tag 3 there)
	LOCPRT()  ...if new pos. off screen, print so in middle
	CALL Z,PRSCRN; RET  ...else reprint screen (tag 2 may change screen)

SETTG2:	...put in tag 2; enter with DE=pos. for tag
	...if room, ret. Z=1, DE=TG2POS, BC=LTAG2; else Z=0
	SHFIFR(LD BC,LTAG2); RET NZ  ...shift rem. file fwd. 11 sp. if room
	R.HL->W.TG2POS; PUSH HL  ...TG2POS pts. to 1st spot opened up
	EX DE,HL; ^TXTTOH; LD BC,LTAG2; PUSH BC; LDIR  ...put in "--To here^"
	^TAGFLG; INC (HL)  ...2->TAGFLG
	POP BC; POP DE; 00; RET

TXTFRH:	DEFM '--From here:'; DEFB CR
LTAG1:	EQU $-TXTFRH
TXTTOH:	DEFM '--To here^'; DEFB CR
LTAG2:	EQU $-TXTTOH

...TAGERR:	P.QSTION; RET  ...illegal TAG1 or TAG2 cmd.

TAG1:	B.TAGFLG=0; JP NZ,QSTION  ...don't do if tag already set
	P.FNDPSB  ...find pos. (->DE) & ROWNO of beg. current line
	SHFIFR(LD BC,LTAG1); RET NZ  ...shift rem. file fwd. 13 sp. if room
	R.HL->W.TG1POS; PUSH HL  ...TG1POS pts. to 1st spot opened up
	EX DE,HL; ^TXTFRH; LD BC,LTAG1; LDIR  ...put in "--From here:"
	^TAGFLG; INC (HL)  ...1->TAGFLG
	POP DE; JR TAGX  ...print "TAG 1", fill screen, get allow. cmds.

TAG2:	B.TAGFLG-1; JP NZ,QSTION  ...tag 1 must be already set but not tag 2
	P.FNDPSB  ...find pos. (->DE) & ROWNO of beg. current line
	W.TG1POS-R.DE; JP NC,QSTION  ...must be after TAG 1 pos.
	SETTG2(); RET NZ  ...put in tag 2 (Z=0 if no room); TG2POS->DE
TAGX:	if @^CRSROW<LROW then INC (HL)  ...keep cursor same rel. pos.
	P.TAGSHW; P.PRNWF0  ...print TAG 1/TAG 2 on cmd. line; print out screen
	RET

TAG3:	FNDPOS(); LD (TG3POS),DE; RET

OFF:	if begin @DE='2'; @^TAGFLG end then begin  ..."O2" means OFF2
	  R.A=2; JP NZ,QSTION  ...check if a TAG 2
	  DEC (HL); P.FNDPOS; P.TG2OFF  ...remove TAG 2
	end else begin
	  R.A=0; JP Z,QSTION  ...check if any tags
	  P.FNDPOS; P.TGSOFF  ...remove tags
	end
	FNDCH0(); PRSCRN(); RET  ...find CRSROW of new BUFPOS; print scr.
...OFFERR:	P.QSTION; RET  ..."???"->cmd. line

PLTAG2:	LD DE,(TG1POS); P.NXTLIN  ...find place for TG2POS if no TAG 2
	@DE=EOF; CALL NZ,NXTLIN; LD (TG2POS),DE; RET  ...end of 1 tagged line

TGSOFF:	...remove & shift file back over tags; correct BUFP0, TG2POS, BUFPOS
	...at least tag 1 must be on when come here
	^TAGFLG; DEC (HL)
	if not zero then begin  ...if there is a tag 2
	  DEC (HL); P.TG2OFF  ...remove TAG 2
	end
	else P.PLTAG2  ...if no TAG 2, TG2POS=end of line marked by TAG 1
	endif
	LD BC,LTAG1; W.TG2POS-R.BC->W.TG2POS  ...correct TG2POS
	LD DE,(TG1POS); JR TAGOFF  ...remove TAG 1

TG2OFF:	LD C,LTAG2; LD DE,(TG2POS)  ...remove TAG 2; drop thru:
	...
TAGOFF:	...enter with DE=either TG1POS or TG2POS; R.C=LTAG1 or LTAG2
	...blank tag ind. on cmd. line; shift file back over tag
	...correct BUFP0 & BUFPOS
	P.BLCMR; P.TAGSHW; LD B,0  ...blank tag ind. from cmd. line (R.C saved)
	if W.BUFP0-R.DE+R.DE>zero then R.HL-carry-R.BC->W.BUFP0
	  ...if BUFP0>TGXPOS then BUFP0=BUFP0-LTAGX
	if W.BUFPOS-R.DE>=zero and R.HL-carry-R.BC<zero then R.DE->R.HL
	else R.HL+R.DE->R.HL
	endif  ...if BUFPOS>TGXPOS then BUFPOS=max(TGXPOS,BUFPOS-LTAGX)
	R.HL->W.BUFPOS
	EX DE,HL; R.HL+R.BC; EX DE,HL; P.SHFTBK; RET  ...shift back over tag

TSTFNM:	...test if filename given in cmd. line; if not, ret. Z=0
	...if so, put drive # at STRBUF+1, followed by DEFT 'FILENAME'; Z=1
	P.FNDSPC; RET NZ  ...if CR or ';' comes before sp., Z=0
TSTFN2:	P.TONOSP; RET NZ  ...find next non-space; check not CR or ";"
	LD HL,STRBUF
...	TSTDRV()
	PUSH HL; LD C,0; @DE
	repeat R.A->@(R.HL+1); INC DE; INC C
	until @DE=CR or R.A=';' or R.A=' '  ...move filename to str. buffer
	POP HL; LD (HL),C; RET  ...put in len.; Z=1

COPY:	...copy (without deleting) text bet. tags or on tagged line if no TAG2
	... to right above current line
	...if cmd. followed by a filename, copy to the file instead
	...keep tags in place
	B.TAGFLG=0; JP Z,QSTION  ...chk if tags present
	if P.TSTFNM zero then begin  ...test if a filename given
	  P.TAGRGN  ...HL=beg. of tagged region, DE=end
	  P.PUTFIL  ...text bet. tags->file
	  P.PRSCRN; RET  ...only print so know done
	end
	P.COPY1; CALL Z,PRNWFB; RET  ...copy text; print out

COPY1:	...if all OK, copy text bet. tags, ret. Z=1; else ret. Z=0
	...update BUFP0, BUFPOS, TG1POS, TG2POS
	P.TAGRGN; R.HL->W.NUM1  ...beg. of text to be copied
	PUSH HL; P.FNDPS0; LD (BUFPOS),DE  ...BUFPOS=DE=beg. curr. line
	POP BC; W.TG2POS-R.BC->R.BC  ...len. of text to be copied
	if W.TG1POS-carry-R.DE <zero and W.TG2POS-R.DE>=zero then
	  if not zero or B.TAGFLG-1 not zero then begin
	    P.QSTION; RET  ...if DE bet. tags; Z=0
	  end
	endif
	PUSH DE; PUSH BC
	P.SHFIFR; POP BC; POP DE; RET NZ  ...shift file fwd. to make room
	if W.TG1POS-R.DE>=zero then begin
	  W.TG1POS+R.BC->W.TG1POS; W.TG2POS+R.BC->W.TG2POS; W.NUM1+R.BC->W.NUM1
	end  ...update tag positions if shifted fwd.
	W.NUM1; R.B|C; RET Z; LDIR  ...move text
	00->B.CRSCOL; RET  ...cursor->1st col.; Z=1

TAGRGN:	...beg. of text to be copied->R.HL; end->R.DE->TG2POS
	LD DE,(TG2POS)
	B.TAGFLG-1; CALL Z,PLTAG2  ...if no TAG 2, find pos. for it->DE
	LD BC,LTAG1; W.TG1POS+R.BC->R.HL; RET

G:	if @DE>='1' and R.A<'4' then begin  ...goto tag 1, 2 or 3
	  R.A-'1'*2->R.C; LD B,0; ^TG1POS+R.BC
	  LD E,(HL); INC HL; LD D,(HL)
	  if W.ENDDAT<R.DE or W.EBUF-carry-R.DE+R.DE>=zero then EX DE,HL
	  LOCPRT(); RET
	end
GET:	...get a file, inserting above current line
	@DE & UPCASE='E'; JR NZ,DGTERR; B.TAGFLG=0; JR NZ,DGTERR
	P.TSTFNM; JR NZ,DGTERR  ...get filename
	P.FNDPSB  ...get BUFPOS + DE=pos. & ROWNO=row at beg. of line
	PUSH DE
	GETFIL(); POP DE  ...read in file
	if zero then begin  ...read in file
	  LD (BUFPOS),DE; 00->B.CRSCOL  ...for printing (beg. of read-in text)
	  B.ROWNO->B.CRSROW  ...adjust cursor row
	end
	P.PRNWFB; RET  ...print out (BUFPOS=start of new text)

DGTERR: JP QSTION  ...ill. cmd.; print "???"

DELETE:	...delete n lines starting at current line
	...if tags present, delete bet. tags
	@DE & UPCASE='E'; JR NZ,DGTERR  ...must be "DE"
	INC DE
	if B.TAGFLG<>0 then begin
	  @DE & UPCASE='T'; JR NZ,DGTERR  ...if tags, must have "DET"
	  P.FNDPOS; P.DELBTG; RET  ...del. bet. tags; remove tags; print
	end
	P.GETNUM  ...get no. lines to delete->HL; default=1
	PUSH HL
	P.FNDPS0; PUSH DE  ...find pos. in buffer; save beg. of line
	P.CHRPOS  ...get rows in line-1->R.B
	B.CRSROW-R.B->B.CRSROW->B.ROWNO  ...1st row of line
	00->B.CRSCOL->R.B->R.C  ...0->CRSCOL->BC
	POP HL; POP DE; PUSH HL  ...HL=beg. line pos.; DE=no. lines to delete
	while R.D|R.E not zero and @HL<>EOF do begin
	  ...go thru buffer counting lines until n lines or EOF
	  DEC DE; LD A,CR; CPIR  ...find beg. next line
	end
	EX DE,HL; W.0-R.BC->R.BC  ...no. of chars. to delete->R.BC
	P.SHFTBK  ...shift file past deleted lines back; update ENDDAT
	POP DE; P.PRNWF0; RET  ...print out

MOVE:	...move (& delete) text bet. tags or on tagged line if omly 1 tag
	... to right above current line
	...if a filename given, move to the file instead
	B.TAGFLG=0; JR Z,DGTERR  ...chk if tags present
	if P.TSTFNM zero then begin  ...test if a filename given
	  P.FNDPOS  ...get BUFPOS
	  P.TAGRGN; P.PUTFIL  ...copy text to file
	end
	else P.COPY1  ...copy text to above curr. line
	endif
	RET NZ  ...cont. below:
	...
DELBTG:	...delete text bet. tags, removing tags; correct BUFP0, BUFPOS; print
	P.TGSOFF  ...remove tags; TG1POS=beg. & TG2POS=end of text to be del.
	LD BC,(TG1POS); PUSH BC; W.TG2POS->R.DE-R.BC->R.BC  ...BC=len bet. tags
	PUSH BC; P.SHFTBK  ...shift back file over deleted portion
	POP BC; POP DE  ...BC=len. deleted; DE=TG1POS
	if W.BUFP0-R.DE<zero then begin  ...if BUFP0<TG1POS
	  LD DE,(BUFPOS)
	  if W.TG2POS-R.DE<zero then begin  ...if TG2POS<BUFPOS
	    EX DE,HL; R.HL-R.BC->W.BUFPOS  ...BUFPOS=BUFPOS-len. bet. tags
	  end else  ...if TG2POS>=BUFPOS
	    if W.TG1POS-carry-R.DE<zero then R.HL+R.DE->W.BUFPOS endif
	      ...if BUFPOS bet. tags, BUFPOS=TG1POS
	  endif
	end else begin  ...if BUFP0>=TG1POS
	  R.HL+R.DE; LD DE,(TG2POS)  ...HL=BUFP0
	  if R.HL-carry-R.DE>=zero then begin  ...if BUFP0>=TG2POS
	    R.HL+R.DE-carry-R.BC->W.BUFP0  ...BUFP0=BUFP0-len. bet. tags
	    W.BUFPOS-carry-R.BC->W.BUFPOS  ...BUFPOS=BUFPOS-len. bet. tags
	  end else begin  ...if BUFP0 bet. tags
	    W.TG1POS->W.BUFP0->R.BC
	    if W.BUFPOS-R.DE<zero then  ...if BUFPOS<TG2POS
	      LD (BUFPOS),BC  ...then BUFPOS=TG1POS
	    else R.HL+R.BC->W.BUFPOS  ...else BUFPOS=TG1POS+(BUFPOS-TG2POS)
	    endif
	  end endif
	end endif
	FNDCH0(); PRSCRN(); RET ...find row corr. to BUFPOS->CRSROW; print scr.

FORWRD:	...if no. given, print screen starting n lines down from top
	...if string given, do FIND; else print starting at current line
	...cursor stays with curr. line unless off screen
	if P.GETNUM not zero then begin  ...check if a no. follows cmd.
	  P.SRCH0; JR Z,FIND  ...chk if a string follows cmd.
	  P.FNDPS0  ...no no. or str.: get BUFPOS & DE=next BUFP0
	end
	else begin  ...if no. (now in HL)
FWD1:	  LD DE,(BUFP0)  ...count from top line (alternate entrance here)
	  while R.HL<>0 and @DE<>EOF do begin  ...check done or EOF
	    DEC HL; PUSH HL; P.NXTLIN; POP HL  ...go to next line
	  end
	  PUSH DE; P.FNDPOS; POP DE  ...get BUFPOS; DE=next BUFP0
	end endif
	if P.FNDCHR not zero then begin P.PRSCRH; RET end
	PRSCRN(); RET  ...get new cursor pos.; print out

FIND:	...search for string taken from cmd. line at beginning of a line
	...if found, print screen from that point; else "EOF"
	...entered with HL=start pos. for search:
	...start search line after cursor pos.; if at EOF, start at top
FNDLUP:	CR; LD BC,0; CPIR  ...find next CR
	if @HL<>EOF then begin  ...check if to EOF
	  LD DE,STRBUF; P.CMPSTR  ...test string with text following CR
	  JR NZ,FNDLUP  ...if test failed
	end
	EX DE,HL; P.LINBEG  ...find beg. of line
	P.PRSCR0; RET  ...print out screen

NAME:	...print name of file currently being edited
	POSCRS(00; LD B,1); ERASL()  ...go to 1st line & erase it
	PRTNAM();
	LD C,1  ...fall thru:
	...
SCRRES:	...blank rem. screen after row R.C; wait for key hit; reprint scr.
	P.BLNKLS  ...fill rem. scr. with blank lines
	P.HITKEY  ...print "HIT KEY" on cmd. line
	POSCRS(00;LD B,1)  ...move cursor to home pos.
	P.WAITCH  ...wait for key to be hit; test if esc.; blank cmd line msg
	P.PRSCRN; RET  ...print out scr. starting same spot as before

N:	@DE & UPCASE='A'; JR Z,NAME  ..."NA" means NAME
NEXT:	...present last line becomes 1st line next page; repeat n times; print
	P.GETNUM  ...get no. after cmd., default=1
	LD DE,(BUFP0)  ...in case 0
	while R.HL<>0 do begin
	  DEC HL; PUSH HL; FNDPS0(LROW->B.CRSROW; 00->B.CRSCOL)
	  LD (BUFP0),DE; POP HL  ...beg. last line on page->DE->BUFP0
	end
	P.PRSCR0; RET  ...print out screen

PREV:	...back up to prev. page: curr. 1st line becomes last line if possible
	...do n times, then print page
	P.GETNUM  ...get no. after cmd.; default=1
	LD DE,(BUFP0)
	while R.HL<>0 do begin
	  DEC HL; PUSH HL; PKLROW(); POP HL
	end
	P.PRSCR0; RET

...B:	@DE & UPCASE='O'; JP Z,BOTTOM  ..."BO" means BOTTOM
...BACK:	...if number given, go back that many lines & print screen
...	...if no number, current line->last line
...	...cursor stays with current line unless off screen
...	if P.GETNUM not zero then begin
...	  P.FNDPS0; W.BUFPOS; PUSH HL; PKLROW(); POP HL; R.HL->W.BUFPOS
...	    ...if no no. given: get BUFPOS & DE=next BUFP0
...	end
...	else begin  ...if no. given (in HL)
BAK1:	  LD DE,(BUFP0)  ...alternate entry pt.
	  while begin PUSH HL; W.EBUF-R.DE; POP HL end not zero
	    and R.HL<>0 do begin  ...check if done or to beg. of file
	      DEC HL; PUSH HL
	      DEC DE; P.LINBEG; POP HL  ...go to beg. of prev. line
	  end
	  PUSH DE; P.FNDPOS; POP DE  ...get BUFPOS; DE=next BUFP0
...	end endif
	P.FNDCHR; PUSH AF  ...get new cursor pos. if char. on screen (Z=1)
	P.PRSCRN; POP AF  ...print screen
	CALL NZ,CRSBTL; RET  ...if Z=0, set cursor to bottom line

XEQ:	...execute command line
	LD E,A; P.BLCMR  ...'X'->R.E; blank right part cmd. line
	^XCMBUF; PUSH HL  ...start of "X" cmd. buffer
	LD D,NCOL-R1+1  ...R.D=beg. col. for cmd. print
	LD A,NCOL-R1+4  ...R.A=last col. for "X" cmd (not counting CR)
	P.FILCL2; POP DE  ...fill "X" cmd line; DE=beg.
	1->B.BLCMRF  ...flag something on rt. part cmd. line
	if not zero then begin  ...chk if to execute
	  INC DE
	  if P.GETNUM not zero then begin  ...chk if no. follows 'X'
	    ...note: HL set=1 in GETNUM
	    if @DE='*' then R.HL-2  ...if "*", then HL=0FFFF
	  end
	  repeat R.HL=0; JR Z,XEQX
	    PUSH HL; 00->B.ESCFLG
	    P.XEQCML; POP HL; DEC HL
	  until B.ESCFLG<>0 or P.GET1IF not zero and R.A=ESC;
	    ...execute cmd. line HL times or until escape
	end
XEQX:	...if tags, replace tag indicators:
	...
TAGSHW:	...print "TAG 1" / "TAG 2" on right part cmd. line
	B.TAGFLG=0; RET Z  ...if no tags
	PUSH AF; PRCMR1(^TXTTG1)  ...print "TAG 1"
	^TXTBL7; POP AF; if R.A-1 not zero then ^TXTTG2
	PRCMR0()  ...if 2nd tag, print "TAG 2" to right of "TAG 1", else blanks
	INC (HL); RET  ...set BLCMRF (@HL) to 2

WAIT:	...wait for keystroke; if not escape, go do next cmd. on cmd. line
	...else return to cmd. mode
	P.HITKEY  ...print "HIT KEY" on cmd. line
	P.WAITCH  ...wait for char. from keybrd; test esc.; blank cmd line msg.
	JR TAGSHW  ...if tags, restore tag msgs.

WAITCH:	B.P.GETCHR->R.C; P.BLCMR0  ...get char. from cons.; blank "HIT KEY" msg
	R.C=ESC; RET NZ  ...ret. if not escape
ABTCML:	...enter here with R.A<>0
	R.A->B.ESCFLG  ...so XEQ cmd. knows there was escape
	NXTLIN(LD DE,CMDBUF)
	DEC DE; LD (CBUFPS),DE; RET  ...pt. CBUFPS to end of cmd. line

SHOW:	...print screen, either showing CR's as "~" or tabs as "~"+spaces
	if begin @DE & UPCASE='T'; LD A,'~' end then begin  ..."ST"=>show tabs
	  R.A->B.SHOWTB; P.PRSCRN; ' '->B.SHOWTB; RET
	end
	R.A->B.SHOWCR; P.PRSCRN; 00->B.SHOWCR; RET

QUIT:	...quit edit session
	@DE & UPCASE='U'; JP NZ,QSTION  ...must be "QU"
	INC DE; ^DUNFLG; INC (HL)  ...set DUNFLG=1
	if P.SPC and R.A & UPCASE='N' then INC (HL)
	  ...if "QU N", don't write out file (DUNFLG=2)
	B.TAGFLG=0; CALL NZ,TGSOFF  ...remove tags if present
	POSCRS(00;LD B,LROW); ERASL()  ...cursor->last line & clear it
	RET

.TAGFLG=0; CALL NZ,TGSOFF  ...remove tags if present
	POSCRS(00;LD B,LROW); ERASL()  ...cursor->last li