...	Full Screen Editor - Part 2

EDIT:	00->B.DUNFLG  ...zero DUNFLG; will be set to 1 when done
	CLRSCR(); PUT1('T')  ...clear screen; print 'T' on cmd. line
	R.A->@^CMDBUF; INC HL; LD (HL),CR  ...'T'->cmd. buff.
	P.TOP  ...print 1st part of file
	repeat
	  B.P.GETCHR->R.A  ...get a character from keybd (or cmd file)
	  R.A->R.E
	  B.TAGFLG=0; CALL Z,BLCMR  ...if no tags, blank right part cmd. line
	  B.BLCMRF=2; CALL NZ,TAGSHW  ...in case tags & tag ind. erased
	  CMD(R.E;^CMDTBC)  ...look for cursor move or mode enter cmds.
	  CALL NZ,FILCML  ...if not found, start filling cmd. line
	until B.DUNFLG<>0;
	RET

FNDPOS:	...char. in buffer corresponding to cursor location->R.DE->BUFPOS
	...sets ROWNO=CRSROW, R.C=col. of char.
	LD DE,(BUFP0); LD C,0  ...start col. 0, row 1
	1->@^ROWNO
	while B.CRSROW<>@HL do begin  ...check if cursor past current row
	  @DE=EOF; RET Z  ...needed by "NEXT"
	  PUSH HL; P.ENDROW  ...go to beg. of next row
	  POP HL; INC (HL)
	end
	FNDCOL(B.CRSCOL->R.C)
	  ...find char. & col. of char. corres. to cursor col.
	LD (BUFPOS),DE; RET

FNDPS0:	...do FNDPOS + LINBEG
	P.FNDPOS
LINBEG:	...enter with R.DE in buffer; return beginning pos. current line->R.DE
	EX DE,HL; DEC HL; LD BC,0; LD A,CR; CPDR; R.HL+2; EX DE,HL; RET

ENDROW:	...enter with R.DE in buffer & R.C at corresponding pos. in row
	...returns R.DE at 1st char. in next row; R.C=0
	...if row ends with CR, its col.->R.B
ENRLUP:	repeat
	  @DE; INC DE
	  R.A=0; JR Z,ENRLUP  ...if at null char.
	  if R.A=CR then begin LD B,C; JR ENDRX end  ...if at CR (col.->R.B)
	  R.A=TAB; CALL Z,TABPOS  ...if at tab
	  INC C
	until LCOL<R.C;  ...check if past end of row
ENDRX:	LD C,0; RET

FNDCOL:	...enter with R.DE in buffer at 1st char. in row; R.C=cursor col.
	...return with R.DE at char. corres. to cursor pos.; R.C=its col. no.
	LD B,C; LD C,0  ...R.B saves cursor col.
FCLUP:	R.B=R.C; RET Z  ...go thru row until R.C=cursor col.
	@DE=CR; RET Z  ...if at CR
	R.A=EOF; RET Z  ...if at EOF
	if R.A=TAB then begin  ...if at tab
	  LD L,C; P.TABPOS; LD A,C; LD C,L  ...1 before next tab pos->R.A
	  R.A=R.B; RET NC  ...if cursor within tab area, R.C=col. of tab char.
	  LD C,A  ...R.C=1 before next tab pos.
	end
	INC DE; INC C
	JR FCLUP

CHRPOS:	...enter with R.DE in buffer; ret. col. of char. at BUFPOS->R.C
	...no. of rows to BUFPOS (past first)->R.B
	...ret. Z=0 if R.B gets bigger than no. rows that fit on scr., else Z=1
	P.LINBEG; 00->R.C->R.B  ...go to beg. of line; 0->row count
CHPLUP:	W.BUFPOS-R.DE; RET Z; RET C  ...check if to BUFPOS (or if DE>BUFPOS)
	if @DE=CR then LD C,LCOL  ...if at CR
	R.A=TAB; CALL Z,TABPOS  ...if at tab
	INC DE; INC C
	R.C-NCOL; JR C,CHPLUP  ...check if goes to next row
	LD C,A; INC B; LD A,NROW-2; CP B; RET C  ...R.B>no. rows/scr.
	JR CHPLUP

FNDCH0:	LD DE,(BUFP0)
FNDCHR:	...enter with DE=next 1st scr. char.; set BUFP0=DE
	...if char. at BUFPOS on screen, its row->CRSROW, col.->R.C, BUFPOS->DE
	... Z=1; else Z=0
	LD (BUFP0),DE; P.CHRPOS; RET NZ
	R.B+1->B.CRSROW; XOR A; RET

FNDCR:	...enter with R.DE at char. in buffer; R.C corres. col.
	...find CR ending curr. line: buffer pos.->R.DE; row->CRROW0; col.->R.B
	B.CRSROW->B.CRROW0
FCRLUP:	P.ENDROW; DEC DE; @DE=CR; RET Z
	INC DE; ^CRROW0; INC (HL); JR FCRLUP

NXTLIN:	...enter with R.DE in buffer; go to beg. of next line (->R.DE)
	EX DE,HL; CR; LD BC,0; CPIR; EX DE,HL; RET

TABPOS:	...enter with R.C=col. of tab; return with R.C 1 before next tab pos.
	R.C|7->R.C; RET

FNDPSB:	...do FNDPOS + PRTB
	P.FNDPOS
PRTB:	...set DE=1st char. & ROWNO=1st row of line with char. at BUFPOS
	LD DE,(BUFPOS); P.CHRPOS; B.CRSROW-R.B->B.ROWNO; P.LINBEG; RET

PKLROW:	LROW->R.A  ...pick last row
PIKROW:	...enter with DE at beg. of line, R.A=desired row for line to start
	...adjust the row up if necs. to start scr. with beg. of a line
	...note: changes BUFPOS
	...set up for printing screen:
	... DE at beg. 1st scr. line; CRSROW=row with orig. line
	R.A->B.CRSROW-1->B.ROWNO
	repeat
	  W.EBUF-R.DE; JR Z,ADJROW  ...chk if at beg. of file
	  DEC DE; LD (BUFPOS),DE; P.CHRPOS  ...no. rows prev. line-1->R.B
	  if not zero or begin INC B; B.ROWNO-R.B end <zero then begin
	    P.NXTLIN  ...printing will start next line
ADJROW:	    B.ROWNO->R.B; B.CRSROW-R.B->B.CRSROW; RET  ...adjust cursor row
	  end
	until begin R.A->B.ROWNO; PUSH AF; P.LINBEG; POP AF end zero
	  ...go back till beg. of line at 1st scr. pos.
	RET

SHFTBK:	...shift file starting at R.DE back R.BC places; update ENDDAT
	R.B|R.C; RET Z  ...if BC=0
	PUSH DE; EX DE,HL; SBC HL,BC; EX DE,HL  ...R.DE-R.BC->R.DE
	W.ENDDAT-carry-R.BC->W.ENDDAT
	R.HL-carry-R.DE+1->R.BC; POP HL
	LDIR; RET  ...shift file back

SHFTFD:	...shift file starting at R.DE forward R.BC places; update ENDDAT
	...return R.HL at 1st opened-up spot
	R.B|R.C; RET Z  ...if BC=0
	W.ENDDAT; PUSH HL; PUSH BC; R.HL-carry-R.DE+1->R.BC
	POP HL; POP DE; R.HL+R.DE->W.ENDDAT; EX DE,HL  ...ENDDAT+n->ENDDAT->DE
	LDDR; INC HL; RET  ...shift

SHFIFR:	...do SHFTFD except if no room do P.NOROOM
	PUSH DE; LD DE,(ENDDAT); INC DE
	if begin W.ENDBUF-R.DE-carry-R.BC; POP DE end carry then begin
	  P.NOROOM; OR 1; RET  ...print "NO ROOM"; set Z=0
	end
	P.SHFTFD; XOR A; RET  ...do SHFTFD; set Z=1

GETSTR:	...enter R.DE in cmd. buffer at delimiter before a string
	...R.HL->beginning of where DEFT-like string should go (saved)
	...returns Z=1 if string ends with orig. delim. (not CR)
	...R.DE at final delim. (also ->CBUFPS); R.C contains length
	@DE->R.B; INC DE  ...delim.->R.B
	LD C,0; PUSH HL  ...init. len. count
	while @DE<>R.B and R.A<>CR do begin  ...check for end
	  R.A->@(R.HL+1); INC C; INC DE  ...copy string into "DEFT" area
	end
	LD (CBUFPS),DE  ...advance CBUFPS to after string
	POP HL; LD (HL),C  ...store len. at beg. of "DEFT" (may be 0)
	R.A=R.B  ...set Z flag if ended with orig. delim. instead of CR
	RET

GETNUM:	...enter with R.DE in cmd. buffer; go past spaces till to num. & get it
	...Z=1 if no. found; no.->R.HL; else Z=0, HL=1
	P.TONOSP; W.1; RET NZ
	P.DIGIT; RET NZ
	P.NUMBER; RET  ...no.->R.HL; Z=1

SRCH0:	...get string from cmd. line, store in string buffer; Z=0 if fail
	...pos. in text buffer to start search for string after->R.HL
	P.TONOSP; RET NZ  ...no string in cmd. line
	GETSTR(^STRBUF)  ...copy string to string buffer
	if @HL=0 then begin INC A; RET end  ...set Z=0 if len=0
	P.FNDPOS; EX DE,HL  ...R.HL=buffer pos.
	if @HL=EOF then W.EBUF-1  ...if at EOF, pt. before beginning
	XOR A; RET  ...set Z=1

CMPSTR:	...enter R.DE at "DEFT"; R.HL at text to be compared; saves R.C
	...return Z=1 if compares equal; else Z=0, HL=1st unsuccessful char.
	@DE=0; RET Z  ...if null string
	LD B,A  ...len.
	repeat INC DE; @DE=@HL; RET NZ  ...unsuccessful
	  INC HL
	until DEC B zero;
	RET  ...successful (Z=1)

	...search text to find string
	...BC count; DE points to DEFT 'STRING'; HL points to text
	...returns: HL after 1st char. of string in text; Z=1 if found
CPILUP:	POP HL; POP DE; POP BC
CPSIR:	INC DE; @DE; DEC DE; CPIR; @DE; JP PO,CPIX ...1st character
	if DEC A not zero then begin PUSH BC; PUSH DE; PUSH HL
	    R.A->R.B; INC DE
	    INC DE; @DE; CP (HL); JR NZ,CPILUP; INC HL; DJNZ $-6
	    POP HL; POP DE; POP BC end ...remaining characters
	RET
CPIX:	RET NZ; DEC A; RET  ...ret. Z=1 if len.=1

...	cursor move cmds. follow:

CRSRT:	...move cursor 1 space to right (with wrap-around)
	if B.CRSCOL+1=NCOL then begin  ...check if at right margin
	  B.LSTROW->R.B
	  @^CRSROW=R.B; RET Z  ...check if on last row
	  INC (HL); 00->R.A
	end
	R.A->B.CRSCOL; P.RETCRS; RET  ...move cursor right

CRSLT:	...move cursor 1 space to left (with wrap-around)
	if B.CRSCOL=0 then begin  ...check if at 1st col.
	  @^CRSROW-1; RET Z  ...check if on 1st printed row
	  DEC (HL); LD A,NCOL
	end
	R.A-1->B.CRSCOL; P.RETCRS; RET  ...move cursor

CRSCR:	...move cursor to beginning of next row
	00->B.CRSCOL; P.RETCRS  ...move cursor to beg. of row

CRSDN:	...move cursor down 1 space (but not past EOF)
	if B.LSTROW=@^CRSROW then begin  ...test if on last row
	  B.EOFFLG=0; RET NZ  ...ret. if at EOF
	  ...(for fake scroll do FWD1(W.1);B.LSTROW=@^CRSROW;RET Z;JR LastLine)
	  FNDPOS()  ...get current BUFPOS, ROWNO
	  LD DE,(BUFP0); NXTLIN()  ...DE=new BUFP0 after print
	  FNDCHR()  ...DE->BUFP0; if char. at BUFPOS on scr., new row->CRSROW,
		... col.->R.C, BUFPOS->DE, Z=1; else Z=0
	  JP NZ,PRSCRH  ...if not on screen (only when top line>page), print
	  		... screen + do home
	  B.ROWNO-@^CRSROW->B.SCLFLG  ...no. of lines to scroll
	  PUSH HL
	  PRSCR()  ...print from current pos.
	  while @^SCLFLG<>0 do begin  ...in case got to EOF before n scrolls
	    DEC (HL); ^LSTROW; DEC (HL)
	    POSCRS(LD B,LROW;00); PUT1(CR) ...(LF)
	  end
	  R.A->B.ROWNO  ...0->ROWNO for CONOUT below
	  LD DE,CMDBUF; PUSH DE
	  ENDROW(); POP HL  ...get DE after CR in cmd buf., R.C=0
	  CONOUT()  ...reprint cmd. line
	  TAGSHW()  ...replace tag indicators
	  POP HL  ...^CRSROW
	end
	INC (HL); P.RETCRS; RET  ...move cursor down

CRSUP:	...move cursor up 1 space
	if B.CRSROW-1 zero then begin
	  LD DE,(EBUF); W.BUFP0-R.DE; W.1; CALL NZ,BAK1
	    ...if top line & not beg. of file, do fake scroll down
	end
	@^CRSROW-1; RET Z  ...do nothing if on top line
	DEC (HL); P.RETCRS; RET  ...move cursor up

CRSHM:	...move cursor home (row 1, col. 0)
	00->B.CRSCOL; R.A+1->B.CRSROW
	P.RETCRS; RET

CRSBTL:	...move cursor to bottom left corner of screen
	00->B.CRSCOL; B.LSTROW->B.CRSROW; P.RETCRS; RET

CRSTAB:	...move cursor to next tab pos.
	B.CRSCOL->R.C; P.TABPOS; INC C  ...find next tab pos.
	if R.C-NCOL>=zero then begin  ...check if goes to new row
	  LD C,A; B.LSTROW->R.B; @^CRSROW=R.B; RET Z  ...check if on last row
	  INC (HL)
	end
	R.C->B.CRSCOL; P.RETCRS; RET  ...move cursor

CRSLTB:	...move cursor left to tab pos.
	if B.CRSCOL=0 then begin  ...check if in col. 0
	  @^CRSROW-1; RET Z  ...ret. if in 1st row
	  DEC (HL); LD A,NCOL
	end
	R.A-1&0F8->B.CRSCOL
	P.RETCRS; RET  ...move cursor

RSROW-1; RET Z  ...ret. if in 1st row
	  DEC (HL); LD A,NCOL
	end
