...	FULL SCREEN EDITOR

NROW:	EQU 24  ...no. of rows on screen
NCOL:	EQU 80  ...no. of columns on screen
LROW:	EQU NROW-1
LCOL:	EQU NCOL-1
DEFRL:	EQU 080  ...RIO default file record length
EOF:	EQU 0FF  ...end-of-file char.
R1:	EQU 15  ...dist. from right margin to start cmd. line messages
CR:	EQU 0D  ...carriage return
TAB:	EQU 9  ...tab
LF:	EQU 0A  ...line feed
BKSP:	EQU 8  ...backspace (cursor left)
ESC:	EQU 01B  ...escape
RUB:	EQU 07F  ...used for deleting current character
CR2:	EQU 18  ...ctrl R; used to stand for CR in LOCATE string
CLRI2:	EQU 0C  ...clear screen (Infoton 200)
CLRV2:	EQU 'v'  ...clear screen (Visual 200); see CLRSCR routine below
ERSLI2:	EQU 0B  ...erase line (Infoton 200)
ERSLV2:	EQU 't'  ...erase line (Visual 200); see ERASL routine below
CRSXYI2: EQU 23  ...cursor pos. I200 (next 2 bytes are X & Y coordinates+32)
CRSYXV2: EQU 'Y'  ...ditto Visual 200 but Y,X (+32); see POSCRS routine below
CSADROI2: EQU 0A0  ...cursor addr offset (+ X,Y order) for I200
CSADROV2: EQU 020  ...ditto V200
INSLV2:	EQU 'L'  ...insert line (V200) (not used)
I200:	EQU 0  ...code for Infoton 200 CRT type
V200:	EQU 1  ...code for Visual 200 CRT type
SHOWCH:	EQU 023  ...'#': char. printed out in place of special chars.
UPCASE:	EQU 0DF  ...'AND' with lower case to get uppercase

EE:	JP E0
	ORG EE+0100  ...put stack here so can reenter
MYSP:

E0:	PROC; JP EDIT0  ...normal entry & reentry
E1:	PROC; JP EDIT1  ...always ask for filename
	WORD	SCRVEC
	WORD	KEYVEC

CRT:	BYTE	0FF  ...if<>0FF, holds CRT type (0=Infoton 200, 1=Visual 200)
E_VERS:	BYTE	2  ...@beg.+0B; inc. when E version changed

...addr. here=beg.+0C
EEX0:	WORD	EEX  ...addr. of EEX if defined; else =0
ECODE0:	WORD	ECODE  ...addr. of ECODE if defined; else =0
...next 24 bytes for reference by extensions (here ^EBUF=E0+010)
EBUF:	WORD	EBUF0  ...start of edit buffer (must have 1 free space before)
ENDDAT:	WORD	EBUF0  ...pos. in buffer of 'FF' at end of file
ENDBUF:	WORD	EBUF9  ...end of edit buffer (^ENDBUF=beg.+014)
	WORD	LOCSTR  ...store addr. of LOCSTR routine
	WORD	NEWSTR  ...store addr. of NEWSTR routine
	WORD	LINBEG  ...ditto these other routines:
	WORD	NXTLIN
	WORD	LTOCR
	WORD	DIGIT
	WORD	NUMBER
	WORD	HEXD
	WORD	HNUM

EFLG:	BYTE	0  ...set=1 when have file in
OLDFLG:	BYTE	0  ...if<>0, make .OLD file
DUNFLG:	BYTE	0  ...set by QUIT to 1 (or 2 if not to write file out)
CMDSW:	BYTE	0  ...if =0, cmds. from cons.; =1, cmds. from cmd file
SVENDB:	WORD	0  ...save orig. ENDBUF when allocate sp. for cmd file buff.
CMFPOS:	WORD	0  ...pos. in cmd. file buffer for next char. to be gotten
BUFP0:	WORD	EBUF0  ...position in buffer corresponding to 1st printed char.
BUFPOS:	WORD	EBUF0  ...pos. in buffer for action
LSTROW:	BYTE	0  ...row no. of last row printed out
ROWNO:	BYTE	1  ...row no.
CRSROW:	BYTE	0  ...row cursor is in (0-LROW)
CRSCOL:	BYTE	0  ...column cursor is in (0-LCOL)
EIRFLG:	BYTE	'E'  ...set='E', 'I', or 'R' for enter, insert, or replace mode
FULFLG:	BYTE	0  ...set=1 when buffer full
CRROW0:	BYTE	0  ...row of CR before ins./repl.
SHOWCR:	BYTE	0  ...if not 0, char. printed out at CR pos.
SHOWTB:	BYTE	' '  ...if set='~', print '~' at 1st pos. in tab
CBUFPS:	WORD	CMDBUF  ...command buffer position
LCMCOL:	BYTE	0  ...last col. except CR in cmd. buffer or "X" cmd. buffer
NUM1:	WORD	0  ...stores no. from cmd.
STR2:	WORD	STRBUF  ...pos. start of where 2nd string stored
NCPERL:	BYTE	0  ...if <>'*', 1 chg. per line; else chg. all
CHGALL:	BYTE	0  ...set='*' when looking for changes on all lines
CHGFLG:	BYTE	0  ...0=no changes; 1=at least 1 change
CHLFLG:	BYTE	0  ...0=no changes on line; 1=at least 1 chg. on line
DIF:	BYTE	0  ...if pos., diff. in length of STR2 vs. STR1
SFLFLG:	BYTE	0  ...if set=1, indicates screen full
TAGFLG:	BYTE	0  ...if set=1, indicates a tag in place; =2, tag 2 in place
...the following 3 words must be in order:
TG1POS:	WORD	EBUF0  ...pos. of 1st tag ("from")
TG2POS:	WORD	EBUF0  ...pos. of 2nd tag ("to")
TG3POS:	WORD	EBUF0  ...pos. of invisible tag 3
EOFFLG:	BYTE	0  ...set<>0 if "EOF" on current screen
ESCFLG:	BYTE	0  ...set<>0 if escape during WAITCH proc.
BLCMRF:	BYTE	0  ...set<>0 if something on right part cmd. line
SCLFLG:	BYTE	0  ...if<>0, CONOUT allows this many scrolls

...TABTAB: DEFS	NCOL+1  ...table of tab positions
CMDBUF:	DEFS	NCOL-R1  ...command line buffer
STRBUF:	DEFS	NCOL-R1-2  ...string buffer
XCMBUF:	DEFS	5  ...buffer for "X" cmd.

CMDTBC:	...table of char. cmds. for moving cursor, entering a mode, or
	... executing cmd. line & address to go to
	DEFB	18  'E' 'I' 'R' 'X'
CMDTBC2: DEFB	'4' '6' '8' '2' '7' '1' TAB '_'  ...this line set from KEYVEC
	DEFB	BKSP ' ' '-' LF CR CR2
	DEFW	CRSCR CRSCR CRSDN CRSUP CRSRT CRSLT
	DEFW	CRSLTB CRSTAB CRSBTL CRSHM CRSDN CRSUP CRSRT CRSLT
	DEFW	XEQ REPLCE INSERT ENTER
CMDTB2:	...table of 1st char. of cmds. that go on cmd. line & addr. to go to
	DEFT	'.;KPGWSBMOCLDFQTNJ'
	DEFW	JOIN N T QUIT FORWRD DELETE LOCATE C OFF M BOTTOM SHOW WAIT G
	DEFW	PREV KOMPAR NULL EXTN

KEYVEC:	...def'n of keys for cursor move cmds + poss. redef'n of RUBOUT
	...left,right,up,down,home,bottom corner,tab,back tab
	BYTE '4' '6' '8' '2' '7' '1' TAB '_'
LKEYVEC: EQU $-KEYVEC
RUBOUT:	BYTE RUB

SCRVEC:	...screen function codes
CSADRO:	BYTE CSADROI2  ...cursor addr offset; bit 7=1 =>X-coord. sent first
LEADIN:	BYTE 0  ...lead-in char. (i.e. ESC); 0=>none
	...in following, bit 7=1 =>requires lead-in
CLRSCRN: BYTE CLRI2  ...clear screen
CLRLIN:	BYTE ERSLI2  ...clear line (or to end of line)
ADRCRS:	BYTE CRSXYI2  ...addr cursor
INSLN:	BYTE 0  ...insert line, 0=>don't have (not used)
LSCRVEC: EQU $-SCRVEC


FIXEOF:	...make sure end-of-file proper ('FF' at EOF & CR preceding,
	... also put CR before beg. of file)
	...preserve DE
	LD BC,(EBUF)
	if W.ENDDAT<>R.BC then begin
	  @(R.HL-1)->R.A; R.HL+1
	  if R.A<>CR then R.HL+1
	end
	LD BC,(ENDBUF)
	if R.HL>=R.BC then R.BC-1->R.HL
	R.HL->ENDDAT
	LD (HL),EOF; DEC HL; LD (HL),CR; W.EBUF-1; LD (HL),CR
	RET

GETCHR:	...get char. from console or cmd. file->R.A
	B.CMDSW=0; JP NZ,GETCMF  ...if CMDSW=1, get from cmd. file; else cont:
	...
GET1:	...get 1 char. from console
	repeat GET1IF() until not zero; RET

PRCBL1:	POSCRS(R.C;LD B,0); PUT1(' ')  ...print space at col. R.C of cmd. line
	...
RETCRS:	B.CRSROW->R.B; B.CRSCOL->R.A  ...ret. cursor to spot in text
	...
POSCRS:	...position cursor; enter with X-coord. in R.A, Y-coord. in R.B
	PUSH BC; PUSH AF
	SCRCMD(B.ADRCRS)
	CSADRO->R.A->R.C; RES 7,C
	if begin BIT 7,A; R.B->R.A end zero then begin POP AF; PUSH BC end
	R.A+R.C->R.B
	POP AF; R.A+R.C->R.A
	PUT1(R.A); PUT1(R.B)
	POP BC; RET

...POSCRS:	...position cursor; enter with X-coord. in R.A, Y-coord. in R.B
...	PUSH AF
...	if B.CRT=I200 then begin  ...if Infoton 200
...	  PUT1(CRSXYI2)  ...next 2 bytes are X & Y cursor coordinates+32
...	  LD A,B
...	end else begin  ...if Visual 200
...	  PUTESC(CRSYXV2)  ...next 2 bytes are Y & X coordinates+32
...	  POP AF; PUSH BC  ...A & B swapped
...	end
...	R.A+32->R.B; POP AF; R.A+32
...	OUTTWO(); RET

CLRSCR:	...clear screen
	CLRSCRN->R.A
	...
SCRCMD:	...do screen function for code in R.A; preserve other regs.
	PUSH AF
	if BIT 7,A not zero and B.LEADIN<>0 then PUT1(R.A)
	POP AF; PUT1(R.A&07F)
	RET

...CLRSCR:	...clear screen
...	if B.CRT=I200 then begin PUT1(CLRI2); RET end  ...if I200
...	CLRV2->R.A  ...if V200
...PUTESC:	PUSH AF; PUT1(ESC); PUT1(POP AF); RET  ...put out escape+R.A

ERASL:	...erase current line
	SCRCMD(B.CLRLIN); RET

...ERASL:	...erase current line
...	if B.CRT=I200 then begin PUT1(ERSLI2); RET end  ...if Infoton 200
...	ERSLV2->R.A; JR PUTESC  ...if Visual 200

PRT0:	...print out msg. until byte 0; enter with R.HL->text
	@HL=0; RET Z; PUT1(R.A); INC HL; JR PRT0

NAMEQ:	PRT0(^TXNMQ)  ...print "NAME?"
	^CMDBUF->R.DE
	GET1IF()
	repeat B.P.GET1->@HL; PUT1(R.A); INC HL  ...get filename from console
	  if R.A=BKSP then begin  DEC HL  ...if backspace
	    if R.HL-carry-R.DE+R.DE not zero then DEC HL endif
	  end
	until R.A=CR;
	RET
...	LD B,LF
	...
...OUTTWO:	...put out the 2 chars. in R.A & R.B
...	PUT1(R.A)
...	PUT1(R.B)
...	RET

...DOTOLD:	DEFM '.OLD'

NOTASC:	DEFM 'NOT ASCII'; DEFB CR 0
TOOBIG:	DEFM 'FILE TOO BIG'; DEFB CR 0 ...LF 0
TXNMQ:	DEFM 'NAME?'; DEFB CR 0 ...LF 0
TXERR1:	DEFM 'ERROR '; DEFB 0
TXERR2:	DEFM '  ERROR'

ERROR:	...write "ERROR ##", where "##"=R.A in hex, on current line; ret. Z=0
	LD C,A; PRT0(^TXERR1); PUTHEX(R.C)
...	ERRD2();
	PUT1(CR); OR A; RET
...	OUTTWO(CR;LD B,LF); OR A; RET

FILERR:	...write "ERROR ##" on cmd. line; R.A=error no.; ret. Z=0
	LD C,A; BLCMR(); PRCMR1(^TXERR2); POSCRS(LD A,NCOL-7;LD B,0)
	PUTHEX(R.C); P.RETCRS; OR 1; RET

PRLIN:	...print from R.DE, row ROWNO, col. R.C up thru a CR
	...set Z=1 if all printed; Z=0 if got to screen bottom
	R.DE->R.HL; CR; PUSH BC; LD BC,0; CPIR  ...find next CR
	POP BC; EX DE,HL  ...R.DE=char. after CR
	...cont:
CONOUT:	...print to console from HL to DE, but not past bottom of screen
	...start at row=ROWNO, col.=R.C
	...return Z=0 if got to scr. bottom before done, else Z=1
	EX DE,HL; PUSH HL  ...save last char. to print
	POSCRS(B.ROWNO->R.B;R.C)  ...pos. cursor to start
PRTLUP:	POP HL; R.HL-R.DE; RET Z  ...test if done
	R.HL+R.DE; PUSH HL  ...save last print char.
	R.C=0; CALL Z,ERASL  ...if in 1st col., erase line
	while @DE=0 do INC DE  ...go past nulls
	case R.A of
	  TAB:begin  ...if tab
	      B.SHOWTB->R.B
TBLUP:	      if begin INC C; R.C=NCOL end <zero then begin
		...test if before last col.
		R.A&0F8=R.C  ...test if at tab pos.
		PUT1(R.B); LD B,' '  ...1st 'space'=B.SHOWTB
		JR NZ,TBLUP  ...put out spaces until at tab pos.
	      end
	    end
	 CR:begin  ...if CR
	      R.A->R.B
	      if B.SHOWCR<>0 then begin  ...if showing CR with another char.
		if begin R.C=LCOL; B.SHOWCR end <zero then PUT1(R.A)
		else R.A->R.B
	      end
...	      PUT1(CR)  ...print CR
	      LD C,NCOL
	    end
	 P.ASCPRT:begin  ...if is printable ascii char. (>=020)
	      P.CHRPRT  ...print it (note: R.B was set = the char. in ASCPRT)
	    end
	 CR2: CHRPRT(LD B,'~')  ...stands for CR in LOCATE cmd.
	 else begin  ...if any other kind of char.
	      CHRPRT(LD B,SHOWCH)  ...print SHOWCH in place of actual char.
	    end
	end  ...end of case statement
	if R.C-NCOL zero then begin  ...check if last col.
	  LD C,A  ...C=0
	  if @^ROWNO=LROW then begin
	    if @^SCLFLG=0 then begin INC A; POP HL; RET end
		...if last row & not scrolling, ret. Z=0
	    DEC (HL)  ...dec. SCLFLG
	  end else
	    INC (HL)  ...inc. ROWNO
	  endif
	  PUT1(R.B)  ...put out char. in R.B
	end
	INC DE; JP PRTLUP  ...go to next char.

ASCPRT:	...return Z=1 if R.A>=020 and <07F, else Z=0; R.B=R.A
	R.A->R.B=07E; if not zero then RET NC  ...sets Z=0 if R.A=07F
	R.A=020; RET C  ...sets Z=0 if R.A<020
	CP A; RET  ...Z=1

CHRPRT:	...print R.B unless at last col. (R.B saved)
	INC C; R.C=NCOL; LD A,B; CALL C,PUT1; RET

TXTBL7:	DEFM '       '  ...7 spaces
TXTNRM:	DEFM 'NO ROOM'
TXTHTK:	DEFM 'HIT KEY'
TXTNCH:	DEFM 'NO CHG '
TXTENT:	DEFM ' ENTER '
TXTINS:	DEFM 'INSERT '
TXTRPL:	DEFM 'REPLACE'
TXTQST:	DEFM '  ???  '
TXTTG1:	DEFM ' TAG 1 '
TXTTG2:	DEFM ' TAG 2 '

BLCMR0:	^TXTBL7; JR PRCMR0  ...blank rightmost 7 spaces on cmd line
HITKEY:	^TXTHTK; JR PRCMR0  ...print "HIT KEY" on cmd. line
...
NOROOM:	^TXTNRM  ...print "NO ROOM" on cmd. line, ret. cursor; fall thru:
	...
PRCMR0:	...enter with R.HL->7-byte string; print top row, right corner
	...ret. with HL at BLCMRF, (HL)=1
	LD A,NCOL-7; JR PRCMD7
...
PRCMR1:	...enter with R.HL->7-byte string; print top row, 15 cols. from right
	...ret. with HL at BLCMRF, (HL)=1
	LD A,NCOL-R1  ...R1=15
PRCMD7:	POSCRS(R.A;LD B,0); LD B,7
	repeat PUT1(@HL); INC HL until DEC B zero;
	P.RETCRS  ...return cursor
	^BLCMRF; LD (HL),1; RET  ...flag msg. in rt. part cmd line
...
...NOCHG:	^TXTNCH; JR PRCMR1  ...print "NO CHG" on cmd. line

BLCMR:	B.BLCMRF=0; RET Z
	PRCMR1(^TXTBL7); BLCMR0()  ...blank all right part cmd line
	DEC (HL)  ...reset BLCMRF marking rt. part cmd line blank
	RET

TXTEOF:	DEFM 'EOF'

PRNWFB:	P.PRTB  ...print rem. screen starting beg. curr. line
PRNWF0:	00->R.C  ...DE must be at beg. of a row
	R.A->B.CRROW0  ...to assure printing full screen
PRNEW:	...print from R.DE, row ROWNO, col. R.C to end of line
	...if end of line on a diff. row from prev., print till screen
	...	full & update CRROW0
	@DE=EOF; JR Z,PRFIN  ...if at EOF
	P.PRLIN  ...print till CR
	^CRROW0->R.HL
	if not zero then begin  ...Z=0 means line went to scr. bottom
	  LD (HL),LROW; JR PRFIN  ...save last print line info
	end
	if B.ROWNO-1=@HL then begin P.RETCRS; RET end
	  ...check if CR on same row as prev.
	R.A->@HL; JR PRSCR  ...update CRROW0; print rest of screen
	...
PRSCR0:	...do PRSCRF + pos. cursor at home pos.
	P.CRSHM; JR PRSCRF 
PRSCRH:	...do PRSCRN + cursor home
	CRSHM()
PRSCRN:	...set DE=BUFP0 before doing PRSCRF
	LD DE,(BUFP0)
PRSCRF:	...from row 1, print till screen full starting at R.DE in buffer
	...R.DE should be 1st char. in a line
	...cursor returned to CRSROW, CRSCOL
	LD (BUFP0),DE; 1->B.ROWNO; LD C,0  ...BUFP0=1st printed char.
PRSCR:	...print starting at R.DE, row ROWNO, col. R.C, till screen full
	W.ENDDAT; EX DE,HL; P.CONOUT  ...print till screen full or EOF
	 ...note: if CR on last row, R.DE will not be incremented to next char.
PRFIN:	B.ROWNO->B.LSTROW->R.B  ...last printed row (may be "EOF")
	00->B.EOFFLG  ...reset flag
	if @DE=EOF then begin  ...chk if EOF
	  R.A->B.EOFFLG  ...set flag
	  POSCRS(00)  ...make sure of pos.
	  ^TXTEOF; LD DE,TXTEOF+3; LD C,0; P.CONOUT  ...print "EOF"
	  BLNKLS(B.ROWNO->R.C)  ...blank rem. lines
	end
	P.RETCRS; RET  ...return cursor to prev. pos.

BLNKLS:	...erase rem. rows on screen after R.C
	POSCRS(00;LD B,C)
	INC C; R.C=NROW; RET NC
	PUT1(CR); ERASL(); JR BLNKLS
...	PUT1(LF); ERASL(); JR BLNKLS

CMD:	...routine to select a subroutine(R.A) from jump table @HL
	...if no routine is found returns NZ
	...otherwise the selected subroutine is executed returning Z=1
	...jump table structure:
	...n CMD1 CMD2 -- CMDn ADDn -- ADD2 ADD1
	CKCMDT(); RET NZ  ...no routine found
	R.HL+R.BC+R.BC+R.BC->R.HL  ...pt. to subroutine addr.
	LD B,(HL); INC HL; LD H,(HL); LD L,B  ...@2HL->R.HL=subroutine addr.
	  ...note: R.A transmitted thru to routine
	P.JPHL; CP A; RET ...call subroutine; Z=1; return

FILCML:	...fill cmd. line buffer, at same time printing out on cmd. line
	...go to routine according to 1st char. (R.DE pts. to 2nd char.)
	R.A=ESC; RET Z  ...ret. if escape
	R.A->R.E  ...save 1st char.
	CHKCMD(R.A); RET NZ  ...check if char. valid; print "???" if not
	^CMDBUF->R.HL; LD D,0  ...init. pos. in cmd. buffer
	LD A,LCOL-R1-1  ...last col. in cmd. line buffer (leaving 1 for CR)
	P.FILCL2; RET Z  ...fill buffer; ret. if not to execute
XEQCML:	...execute cmds. on cmd. line
	^CMDBUF
XCMLLP:	R.HL->W.CBUFPS; EX DE,HL  ...DE=pos. in cmd. buffer (for parsing)
	TONOSP()  ...rets. R.A=char @DE
	CHKCMD(R.A); RET NZ  ...check if valid char.
	INC DE  ...pt. to 2nd char. of cmd.
	CMD(R.A;^CMDTB2)  ...go to routine according to 1st char.
	^CMDTBC; CALL NZ,CMD  ...possibly cursor move or mode enter cmd.
	W.CBUFPS  ...char. starting or at end of string in prev. cmd.
	repeat @HL=CR; RET Z; INC HL until R.A=';'  ...find end of prev. cmd.
	  ...if another cmd follows, HL->first char., else ret.
	JR XCMLLP

FILCL2:	...enter with HL=start of cmd. buffer; R.E=1st char.
	...   R.D=starting col. for cmd. line; R.A=last cmd. line col.
	...fill cmd. buffer, at same time printing out on cmd. line
	...return Z=1 if to abort without executing, else Z=0
	R.HL->W.CBUFPS; R.A->B.LCMCOL; LD C,D
	repeat
	  if R.E=BKSP then begin  ...if backspace
	    W.CBUFPS-1->W.CBUFPS; LD (HL),CR  ...update CBUFPS; store CR there
	    P.PRCBL1  ...blank out "_"
	    DEC C  ...R.C=prev. col.
	    R.D=0; PUSH DE; LD DE,CMDBUF
	    CALL Z,FNDCOL  ...if doing main cmd buffer, get R.C=col. prev. char
	      ...note: there should not be any tabs if doing "X" cmd buffer
	    POP DE; POSCRS(R.C;LD B,0)
	    if begin R.C=R.D; '_'->R.A end then ' '->R.A
	    PUSH AF; PUT1(R.A)  ...delete prev. char.; print "_" if <>col. 0
	    P.RETCRS; POP AF; RET Z  ...return cursor; ret. if 1st col.
	    end
	  else
	    if R.A<>0 then begin  ...ignore null chars.
	      LD L,C
	      if R.A=TAB then begin R.D=0; JR NZ,FILCL3; TABPOS() end
		...get C=col. of next tab pos.-1 (no tab allowed if "X" cmd)
	      if begin B.LCMCOL=R.C; LD C,L end >=zero then begin
		...check if will fit in space on cmd line (not last 15 cols.-1)
		W.CBUFPS; LD (HL),E  ...put new char. in cmd. buffer
		PUSH DE  ...save D
		R.HL->R.DE; INC DE; LD (CBUFPS),DE  ...update CBUFPS
		00->B.ROWNO; P.CONOUT  ...print out new char. (updates R.C)
		POP DE; PUT1('_')  ...print out "_" as "cursor"
		R.C-1; CALL Z,TAGSHW  ...because CONOUT clears line when col=0
		P.RETCRS  ...return cursor
	      end
	    end
	  endif
FILCL3:	until B.P.GETCHR->R.E=CR or R.A=ESC;  ...get new char. until CR or esc.
	W.CBUFPS; LD (HL),CR  ...put in CR
	P.PRCBL1; R.E=ESC; RET  ...blank out "_"; Z=1 if last char.=escape

CKCMDT: ...chk if cmd. R.A in table @HL (if R.A=lower case, made upper)
	if R.A>=060 then RES 5,A
	LD C,(HL); LD B,0; INC HL; CPIR; RET

CHKCMD:	...chk if R.A=valid cmd. starting char. for on cmd. line
	CKCMDT(^CMDTB2); RET Z  ...chk list of reg. cmd. line cmds.
	if R.A<>CR and R.A<>'X' then begin
	  CKCMDT(^CMDTBC); RET Z  ...chk cursor move cmds. (not CR or 'X')
	end
QSTION:	PRCMR0(^TXTQST); OR 1; RET  ...print "???" on right part cmd. line; Z=0

EXTN:	...do extension
	B.TAGFLG=0; JR NZ,QSTION  ...must not be tags present
	W.EEX0=0; JR Z,QSTION  ...chk if EEX defined
	P.JPHL; LD (CBUFPS),DE  ...call EEX if defined to parse cmd.
	JR NZ,QSTION  ...no valid cmd.
	P.FNDPOS  ...pos. in buffer->DE
	W.ECODE0=0; CALL NZ,JPHL  ...go to ECODE if defined to do cmd.
	FIXEOF()  ...make sure 'FF' at EOF, CR before, & CR before beg. of text
	if P.CHKIN not zero then LD DE,(ENDDAT)  ...make sure DE in buffer
	P.LOCPRT  ...if char. at DE off screen, print so in middle
	CALL Z,PRSCRN  ...else reprint screen
NULL:	RET  ...null cmd. just rets.

JPHL:	JP (HL)  ...jump to addr.

SPC:	...move R.DE past spaces; ret. Z=0 if none, else Z=1; R.A=char. @DE
	@DE=' '; RET NZ  ...no spaces
	repeat INC DE until @DE<>' '; CP A; RET

TONOSP:	...enter with R.DE in cmd. buffer; search for 1st char. not space
	...return Z=1 if not CR or ";", else Z=0  (R.DE pts. to char; R.A=char)
	P.SPC  ...go to 1st char. not space
	if R.A=CR or R.A=';' then begin OR A; RET end  ...if CR or ";", Z=0
	CP A; RET  ...set Z=1

FNDSPC:	...move R.DE to 1st space or "," (put in R.A)
	...if CR or ";" found first, ret. Z=0, else Z=1
	@DE=' '; RET Z
	R.A=','; RET Z
	if R.A=CR or R.A=';' then begin OR A; RET end
	INC DE; JR FNDSPC

PUTHEX:	...R.A converted to hex & the 2 hex chars. put out
	PUSH AF; RRA; RRA; RRA; RRA; P.HBTHEX; POP AF
HBTHEX:	R.A&0F|R.A; DAA; R.A+0F0+carry+040; PUT1(R.A); RET

DIGIT:	...test for an ascii digit @DE (returned in R.A); if so, Z=1, DE=DE+1
	@DE='0'; RET C; if R.A<>'9' then RET NC
	INC DE; CP A; RET

HEXD:	...same as DIGIT, but testing for a hex digit
	P.DIGIT; RET Z
	R.A='A'; RET C; if R.A<>'F' then RET NC
	INC DE; CP A; RET

NUMBER:	...enter with a digit in R.A
	...get more digits from @DE (incrementing DE) as long as there are more
	...calculate value of number, return in R.HL; set Z=1
	W.0
	repeat R.HL*2->R.BC; R.HL*2*2+R.BC
	  R.A&0F->R.C; LD B,0; R.HL+R.BC->R.HL
	until P.DIGIT not zero
	XOR A; RET

HNUM:	...same as NUMBER but with hex digits
	W.0
	repeat if R.A>='A' then R.A-7
	  R.A&0F->R.C; LD B,0; R.HL*2*2*2*2+R.BC->R.HL
	until P.HEXD not zero
	XOR A; RET

LOCSTR:	...enter with DE->pos. in text; HL->DEFT 'STR'; BC=no. bytes to search
	...if BC>space in buffer, just search to end of buffer
	...ret. HL same; if string found, DE->1st char., Z=1
	...if not found, DE->after last char. searched, Z=0
	P.CHKIN; RET NZ  ...chk if DE in text in buffer
	@HL=0; RET Z  ...str. len=0
	PUSH HL; P.MINBC; POP HL  ...BC=min.(BC,dist. to EOF)
	if R.B|R.C zero then begin INC A; RET end  ...if at EOF
	EX DE,HL; P.CPSIR; if zero then DEC HL  ...do search
	EX DE,HL; RET

NEWSTR:	...enter with DE->text; R.A=no. chars. to delete starting curr. pos.
	...(don't del. past ENDDAT); R.HL->DEFT 'STR' to insert at current pos.
	...if DE not in text, or after deleting, no room to insert, ret. Z=0
	...do, adjusting ENDDAT; ret Z=1, HL same, DE->after last char inserted
	P.CHKIN; RET NZ  ...chk if DE in text
	PUSH HL; PUSH DE
	LD C,A; LD B,0; P.MINBC  ...BC=min.(R.A,dist. to EOF)
	EX DE,HL; R.HL+R.BC; EX DE,HL; P.SHFTBK  ...delete
	POP DE; POP HL; LD C,(HL); R.C=0; RET Z  ...BC=no. chars. to insert
	PUSH HL; PUSH DE; P.SHFIFR; POP DE; POP HL; RET NZ  ...shift file fwd.
	LD B,(HL); PUSH HL  ...B=no. chars. to insert
	repeat INC HL; @HL->@DE; INC DE until DEC B;  ...move in new string
	POP HL; RET

CHKIN:	...ret. Z=1 if EBUF<=DE<=ENDDAT; else Z=0; save all regs.
	PUSH HL
	if W.ENDDAT-R.DE>=zero and W.EBUF-carry-R.DE<zero then CP A
	POP HL; RET

MINBC:	W.ENDDAT-R.DE-carry-R.BC; RET NC
	R.HL+R.BC->R.BC; RET  ...BC=min.(BC,ENDDAT-DE)

LTOCR:	LD BC,0; PUSH DE
	while @DE<>CR do begin INC DE; INC BC end
	POP DE; RET  ...BC=dist. to next CR


....	i-o vectors:
...ATTR:	...file attributes returned next 5 bytes
...FILTYP:	BYTE	020  ...file type
...NUMREC:	WORD	0  ..