:TITLE[MPCodes];	*Dolphin Maintenance Panel codes.
			*Ed Fiala 1 June 1982

%This file defines Alto.Eb MP codes.  The runtime error codes are compatible
with Pilot/Cedar microcode releases after 10 September 1981 except that task
numbers are different for Pilot/Cedar.  Although EPROM and Initial MP codes
are mentioned, full documentation for them is elsewhere.  In general codes
between 0 and 99 are from the EPROM, 700 to 799 from Initial, and
100 to 255 from Alto.Eb.

Booting takes place in four steps: First, the EPROM delivers a tiny
diagnostic and boot loader into the microstore--this program is necessarily
limited for the reasons discussed in the D0 Hardware Manual.  If the
processor test fails, it shows an error MP code briefly, waits 30 seconds,
and boots again.  If all is well, registers are initialized and the first
program on the disk boot record (normally Initial) is loaded directly into
IM; if the disk won't work, Initial is obtained from the Ethernet.  Storage
is not used during any part of the EPROM boot.

Next, Initial is started at either its disk or ether boot address.  It first
initializes storage and the map; on a disk boot, it then reads the rest of
the disk boot record into storage; on an ether boot, it places either
AltoCSL.Eb or AltoLF.Eb from the Ethernet (These files are now identical)
into storage.  Finally, it exits with LoadRAM.

Alto.Eb starts the third stage boot at either KGO or EGO.  It shows the final
MP code from Initial, then StartDeviceInit, StartEtherBoot, and
GotBreathOfLife for about 0.3 seconds each; other MP codes normally flash
past too quickly to view, unless an error is detected.  If the disk is ready
(which happens about ~ 2 min. after power on), StartDiskBoot is shown instead
of StartEtherBoot, but it normally flashes past too quickly to be seen.

At this point the final microcode overlay is loaded and the number of good
pages is shown on the MP.  Then the Alto emulator is started at the
Breath-of-life program's disk boot or Ether boot starting address.

With the Initial current on 16 October 1981, the viewable MP sequence for a
"normal" disk boot is 8888, 40, 700, 720, 104, NPages (see below).  Other MP
codes are not up long enough to see unless something goes wrong.
The viewable sequence for a "normal" ether boot is 8888, [46, 60], 700, 760,
104, 114, 118, NPages (see below), where "46, 60" may repeat several times
before continuing with the rest of the sequence.  The 760 will be 758 on an
LF Dolphin.  For both of these sequences, the "8888" only appears while you
are pushing the Start button, not at all if you keyboard boot.

After showing GotBreathOfLife (118) for .3 sec, the final microcode overlay
is loaded and MP then shows the number of pages found to be good during
storage init.  For perfect storage boards, the MP will show 96K/256
pages/board which is 384 x number of storage boards (i.e., 768, 1152, 1536,
1920, 2304, or 2688).  Some MPs will show this value plus 1 occasionally for
unknown reasons.  However, if the number of good pages is less than 256,
then the NotEnoughMemory code (101) will be shown instead.

Many machines malfunction briefly when first powered up, then work correctly.
If the EPROM diagnostic detects a malfunction it will show an error MP code
briefly, then show "46" for a long time (30 sec), then boot again.  If you
get impatient during such a wait, push the power on button again to retry
immediately.  If an error is detected after StartDeviceInit (104) or if the
NotEnoughMemory error (101) occurs, initialization will loop back to
StartDeviceInit after showing the MP code for .3 seconds.  It is improbable
that retrying will succeed, so push the power on button to reboot.
%

*INITIALIZATION MP CODES

MC[StartMapInit,144];		*100d (debugging only)
  MC[BadMap,146];		  *102d (debugging only)

  MC[NotEnoughMemory,145];	  *101d (.ls. 512 functional storage pages)
MC[StartDeviceInit,150];	*104d
				*+1 (=105d started display init)
				*+1 (=106d finish loading or flushing CSL
				*	keyboard overlay)
				*+1 (=107d ordinarily, 106d when debugging
				*	with Midas--finished display init)
MC[StartDiskBoot,156];		*110d (usually invisible)
  MC[NoDiskStatus,157];		  *111d
  MC[BadBoot,160];		  *112d
MC[StartEtherBoot,162];		*114d
MC[GotBreathOfLife,166];	*118d (breath-of-life read successfully from
				*disk or Ethernet)

*Error Codes for Fault.Mc
MC[RMCSCrash,170];	*120d to 135d RM or CS parity error possibly in
			*combination with other errors.  MP code is 120d
			*plus:	1  if MC1 or MC2 error
			*	2  if RM parity error
			*	4  if CS parity error
			*	8  if Stack overflow or underflow

%The following codes imply that there was no RM or IM parity error.
Many of the following codes show a multiple of 20d + the task number
responsible for the error; e.g., if an MC1 error occurred on a reference
by task N, the code would be X+N.  NOTE: The codes which have the pipe task
added to them are offset by 15d because of the microcode's algorithm--the
comments are correct, however.
%
MC[MOBCrash,214];	*140d + current task.  Map Out of Bounds (Mesa handles
			*these itself, so should only occur for Alto emulator)
MC[H4PECrash,240];	*160d + current task.  H4PE (Never happens now)
MC[LPCrash,264];	*180d + current task.  Some fault when preceding mi
			*was a LoadPage (Indicates microcode bug--report it).

*The following codes imply that there was no RM, CS, H4PE, or MOB error
MC[MC2Crash,327];	*200d + pipe task.  MC2 error (Double bit failure or
			*microcode bug or single bit failure if specially
			*enabled)
MC[MC22Crash,165];	*117d 2 MC2 errors
MC[MCNoneCrash,210];	*136d--MC12 error with no error indication in the
			*pipe--possibly PFetch4 experienced error correction,
			*next reference faulted, and third reference
			*slipped in erroneously.

*The following codes imply no RM, CS, H4PE, MOB, or MC2 errors in combination
MC[MC1Crash,353];	*220d + pipe task.  MC1 fault (Page fault or write
			*protect fault; Mesa emulator handles these itself,
			*so this code should only occur for Alto emulator)

MC[BrkPCrash,360];	*240d + current task.  SetFault (i.e., breakpoint)
			*by task, interpreted as follows:
			* 0 emulator
			* 1 unused (bad wakeup)
			* 2 unused (bad wakeup)
			* 3 unused (bad wakeup)
			* 4 unused (bad wakeup)
			* 5 color display controller
			* 6 ethernet output
			* 7 ethernet input
			* 8 SA4000 controller
			* 9 unused (bad wakeup)
			*10 display controller
			*11 unused (bad wakeup)
			*12 unused (bad wakeup)
			*13 unused (bad wakeup)
			*14 timer (bad timer wakeup)
			*15 fault

*The following codes imply that no other errors occurred in combination
MC[eoCrash,163];	*115d Unexpected Ethernet output wakeup
			*116d NoStateVectorError for Pilot/Cedar.
*MC[NextInstMPCode,?];	*Hardware problem on some machines causing
			*ResetErrors executed at the onset of a fault to be
			*interpreted as a NextInst.  The consequence of this
			*is that SStkP _ StkP and PCX advance occurs. 
			*(NO LONGER DETECT THIS)
MC[StkCrash,167];	*119d Stack over/underflow
(1792)\6754f5 227f0
