:TITLE[DisplayDefs];	*Ed Fiala 24 January 1983

SetTask[DpTask];	*Definitions for Alto-compatible UTVFC

Set[vCReg,0];		*Control register
Set[vfCReg,Add[LShift[DpTask,4],0]];	*For IOFetch4 to vCReg
  MC[ClrNC,1]; MC[AllowWU,2]; MC[OddFld,4]; MC[VS,10]; MC[Blank,20];
  MC[BlackBackground,100]; MC[IncNC,200];
  MC[AllowWU&Blank,AllowWU,Blank]; MC[OddFld&Blank,OddFld,Blank];
  MC[ClrNC&Blank,ClrNC,Blank]; MC[IncNC&Blank,IncNC,Blank];
Set[vBufStart,1];	*Buffer Starting Address
Set[vHCRam,2];		*Horizontal control ram
Set[vLdIAR,3];		*IAR[0:5] _ Start[0:5] (data is ignored)
Set[vCursor0,4];	*Channel 0 Cursor control register
*Set[vCursor1,5];	*Channel 1 Cursor control register
Set[vCursorMem0,6];	*Channel 0 Cursor Memory
*Set[vCursorMem1,7];	*Channel 1 Cursor Memory
Set[vBuf0,10];		*Channel 0 data buffer - use with Output
Set[vfBuf0,Add[LShift[DpTask,4],10]]; *Channel 0 data buffer for IOFetch
*Channel 1, 2, and 3 data buffers are 11, 12, and 13 (unused)

*Note: because more than 20b registers, DpTask must be even.
Set[vRB,LShift[And[DpTask,3],4]]; *enforces register allocation conventions
RV4[vDBuf0,vDBuf1,vTemp1,vTemp,Add[vRB,0]];	*general temporaries
				*(vTemp1 presently unused)
RV2[vLink,vNWrds,Add[vRB,4]];	*Holds DCB link word.
RV[vSize,Add[vRB,6]];		*vSize used when transmitting a DCB 
RV2[vDBA,vSLC,Add[vRB,6]];	*vDBA used when picking up a DCB
RV2[vBase,vBasehi,Add[vRB,10]];
RV[vCR,Add[vRB,12]];		*Copy of hardware control register
RV[vCursorY,Add[vRB,13]];
RV[vCurrentY,Add[vRB,14]];	*Current Display Y
RV[vCursorControl,Add[vRB,15]];
RV[vMsg,Add[vRB,16]];
RV[vCnt,Add[vRB,17]];
RV[vMsgStatus,Add[vRB,20]];
RV[vMouseXY,Add[vRB,21]];	*These three needed only for LF keyboard
RV[vButtons,Add[vRB,22]];
RV[vKeyBuffer,Add[vRB,23]];
RV[vFieldFill,Add[vRB,24]];

***Fix Initialize.Mc if any of these move***
RV2[vMDS177400,vMDS177400hi,72];	*base reg containing 177400b
RV2[vMDS420,vMDS420hi,74];	*base reg containing 420b
RV2[vMDS,vMDShi,76];		*base reg containing 0

RM[vZero,IP[vMDS]];

Set[SingleDCBMode,0];		*1 assembles code that reduces worst-case
				*task requirements under assumption that
				*if a DCB is long, it is the only DCB
:IF[SingleDCBMode]; ***********************
RV[vSingleDCBFlag,Add[vRB,25]];	*1 if working on long dcb, else 0
MC[WordsPerLine,100];		*100b (64d) words/scanline for wide screen,
:ELSE; ************************************
MC[WordsPerLine,46];		*38d words/scanline Alto compatible
:ENDIF; ***********************************
Set[vBufSt,Sub[400,LShift[WordsPerLine!,2]]];
Set[vStart,LShift[vBufSt,6]];

MC[lfVSStart,11];	*Nscanlines - 1 before start of vert sync field B
			*(+1 added for field A).
MC[lfSyncLength,11];	*Nscanlines - 10d in which vert sync asserted
			*Spec is 18 lines of vertical sync/field
MC[lfBlankLength,15];	*Nscanlines - 3 after vert sync before starting frame

MC[cslVSStart,1];
MC[cslSyncLength,7];
MC[cslBlankLength,14];

*These are the Alto-compatible numbers
MC[vMaxYh,400];		*no. visible scan lines per field/2 -1
MC[vMaxYl,223];		*(= 808 visible scanlines/screen Alto compatible)
