	title 'Winchester Handler Module'

;    CP/M-80 Version 3     --  Modular BIOS

;	Winchester I/O Module 

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

    ; Port Address Equates

	maclib ports

    ; CP/M 3 Disk definition macros

	maclib cpm3

    ; Z80 macro library instruction definitions

	maclib Z80


	cseg


    ; Variables containing parameters passed by BDOS

	extrn	@adrv,@rdrv
	extrn	@dma,@trk,@sect   
	extrn	@dbnk,@dtbl

    ; Other externals

	extrn	u$conin$echo
	extrn   error$table,errm1

   ; Table entry point

	public	winc0, dpbw

    ; System Control Block variables

	extrn	@ermde		; BDOS error mode

    ; Utility routines in standard BIOS

	extrn	?wboot		; warm boot vector
	extrn	?pmsg		; print message @<HL> up to 00, saves <BC> & <DE>
	extrn	?pdec		; print binary number in <A> from 0 to 99.
	extrn	?pderr		; print BIOS disk error header
	extrn	?conin,?cono	; con in and out
	extrn	?const		; get console status
	extrn	?bank		; Bank select

	page


    ; Extended Disk Parameter Headers (XPDHs)


	dw	w$write
	dw	w$read
	dw	w$login
	dw	w$init
	db	0,0			; relative drive zero
winc0	
	dw	tranw			; translate table address
	db	0,0,0,0,0,0,0,0,0	; bdos scratch area
	db  	000h			; media flag
	dw	dpbw    		; disk parameter block
	dw	0     			; checksum vector
	dw	0fffeh			; alloc vector
	dw	0fffeh			; dirbcb
	dw	0fffeh			; datbcb
	dw	0fffeh			; hash
	db	0			; hash bank

	dseg
winbuf	ds	512

	cseg				; DPB must be resident
dpb$w:   
	dw	64   		; #128-byte records/track
	db	05		; Block shift
	db	31 		; Block mask
	db	1		; extent mask
	dw	0989h		; maximum block number
	dw	2047		; maximum dir entry number
	dw	0ffffh		; alloc vector for directory
	dw	08000h		; (Don't do checksumming)
	dw	0002h		; offset for system tracks
	db	01h		; 
	db	01h		;


tranw 	equ	0       

	page

;		called for first time initialization.
	dseg

w$init:
	ret
;
;RESET AND CONFIGURE THE WINCHESTER
;
w$login:

	lda	@ermde		; Get error mode
	sta	save$mode	; Save current value

	lda	@dbnk		; Get Data bank			(LEL0384)
	sta	save$bank	; Save it			(LEL0384)

	mvi	a,0ffh		; Force to FF
	sta	@ermde		; save it

	xra	a		; move 0 to data bank
	sta	@dbnk		; for reading of label

	lxi	h,winbuf 
	shld	dmaadr		; set up dma address

	lxi	h,0		; Zero
	shld	wsect		; = sector
	shld	wtrk		; and track


	CALL	WINRES
	jnz	bad$exit  	;(RETURN A=5 IF TIME OUT ERROR)
	sta    wrwf     	; wrwf=0 to read label

	CALL WINRES
	jnz bad$exit	  	;(RETURN A=5 IF TIME OUT ERROR)

	;ASSIMILATE THE BAD TRACK TABLE
	XRA A
	STA BADTRACK-1	;DEFAULT BAD TRACK COUNT TO 0
	LXI H,0
	SHLD ADH	;TRACK 0, SECTOR 0
	MVI H,1		;BLOCK COUNT OF 1
	SHLD ADL
	;XRA A

	CALL WAZ	;READ ABSOLUTE TRACK 0, SECTOR 0

	JnZ bad$exit  	;(RETURN A=5 IF TIME OUT ERROR)
	LHLD dmaadr	;BAD TRACK TABLE FROM DISK IS SOURCE
	MOV A,M

	CPI 'W'		;"SIGNATURE" SHOULD BE "WXYZ"
	JNZ notok   
	INX H
	MOV A,M
	CPI 'X'		;  BUT CHECK ONLY THE FIRST 2 BYTES
	JNZ notok   
	INX H
	INX H
	INX H		;SKIP OVER THE "SIGNATURE"

	MOV A,M
	CPI MAXBAD+1
	CNC Too$bad    ;(ERROR FF IF MORE THAN (10) BAD)

	LXI D,BADTRACK-1;BAD TRACK TABLE IN MEMORY IS DESTINATION
	LXI B,(MAXBAD*2)+1	;ROOM FOR BAD TRACK COUNT, (10) BAD TRACKS
	LDIR    	;MOVE IT

;
; Now read LOGICAL track 0, sector 0 to get label info
;

	xra	a		; A=0
	sta	wrwf		; for a read
	call	w$1		; Perform it
	jnz    bad$exit		; Jump if error

;
; Now, check that disk has one of our "signatures"
;

	lxi	b,3		; count = 3
	lxi	h,winbuf 	; Point to info read from disk
	lxi	d,signature	; and our signature

w$log$01:
	ldax	d		; Get signature character
	cci			; compare
	inx	d		; Increment ptr
	jnz	notok		; Jump if no match
	jpe	w$log$01	; if BC<>0, keep going

	mov	a,m		; Now check final char
	cpi	'0'		; For '0'
	jz	w$log$30	;
	cpi	'1'		; or '1'
	jnz	notok		;

;
; Disk is one of ours.  Move info from label into DPB.
;
w$log$30:
	lxi	h,winbuf+7	; Point to # heads
	mov	a,m		; Get into A
	ral			; *2
	sta	heds		; Store away

	lxi	b,15		; # bytes to move
	lxi	h,winbuf+32	; FROM address
	lxi	d,dpbw		; TO address
	ldir			; move it

	inx	h		; Skip skew
	ldi			; Then move in 2 more
	ldi			;    
;


	CALL	WINRES		; Set up for correct # heads
	jnz	bad$exit	; Exit if error
	jmp	login$exit
;
TOOBAD:
	push	h
	lxi	h,manybad	; Point to message
	call	?pmsg		; Print it
	pop	h        
	ret
;
;
NOTOK:
	lxi	h,nomatch	; Point to error message
	call	?pmsg
Bad$exit:
	pop	h		; pop return address
	pop	d		; and DPH pointer
	lxi	d,0		; Set DPH pointer to 0
	push	d		; save it
	push	h		; push return address
Login$exit:
 	lda	save$mode	; Get saved value of @ermde
	sta	@ermde		; restore

	lda	save$bank	; Get saved data bank		(LEL0384)
	sta	@dbnk		; restore it			(LEL0384)
	ret        

save$mode	ds	1
save$bank	ds	1
	page
	DSEG

;
; Read entry point
;

w$read:
	xra	a	; A=0
	sta	wrwf	; Read/write flag=0 for read
	lxi    h,read$msg
	jr w$common	; Join common code
;
; Write entry point
;
w$write:
	mvi a,1		; A=1
	sta	wrwf	; Read/write flag=1 for write
	lxi h,write$msg

;
; Common code for read/write operations
;

w$common:
	shld	operation$name	; Store "Read" or "Write"
	lhld @sect		; Get sector
	shld wsect		; store it
	lhld @trk		; Get track
	shld Wtrk		; store it
	lhld @dma		; Get dma address
	shld dmaadr		; store it
W$1:
;TRACK MAPPING: SKIP RESERVED TRACK 0, NUMBER AROUND BAD TRACKS (IF ANY)
	LHLD WTRK
	XCHG		;DE:=TRACK

	INX D		;TRACK+=1 (TRACK 0 RESERVED)

	LXI H,BADTRACK-1
	MOV C,M
	INX H		;C:=# OF BAD TRACKS, HL:=POINTS TO BADTRACK LIST

;SCHEME:  SCAN BAD TRACK LIST.  BUMP TRACK FOR EACH BAD TRACK # THAT IS
; REACHED1OR PASSED.

	INR C
MAPMOR:	DCR C
	jrz MAPDONE	;(DONE IF OUT OF BAD TRACKS)

	INX H
	MOV A,D
	CMP M
	DCX H
	jrnz MAP$0
	MOV A,E
	CMP M
MAP$0:	JC MAPDONE	;(DONE IF BADTRACK>TRACK)

	INX D		;TRACK+=1  (SKIPS BAD TRACK)

	INX H
	INX H		;POINT TO NEXT BAD TRACK

	jr MAPMOR
MAPDONE:

	XCHG		;(HL=TRACK)


;ASSEMBLE "LOGICAL ADDRESS"
	XRA A
	MVI D,5
WWW:	DAD H
	RAL
	DCR D
	jrnz WWW		;AHL:=TRACK*32

	STA ADH		;(DRIVE ALWAYS 0)
	MOV A,H
	STA ADM
	LDA wsect
	ADD L
	STA ADL		;AD(HML):=WTRK*32+WSEC

	MVI A,1
	STA INTL

;SELECT OPCODE,DIRECTION

	LDA WRWF

WAZ:	LHLD dmaadr
	LXI B,0
			;B=0(=256) BYTE COUNT FOR DATA TRANSFER
			;C=0  INPUT DIRECTION UNLESS CHANGED
	ORA A           ; check wrwf
	jrnz wwrit1	; non-zero means write

WREAD1:	MVI A,8
	jr WACTR

WWRIT1:	MVI A,10
	;JMP WACTW	;WRITE DIRECTION TO IGNORE DATA JUST IN CASE

WACTW:	INR C		;=MVI C,1	;SET WRITE DIRECTION

WACTR:	CALL WDOIT
	jrz good$exit	;(RETURN OK IF OK)


	CPI 0FEH
	jrNZ error$exit	;(RETURN ERROR (5/7) IF ERROR NOT STATUS BYTE)

	MVI A,3		;"REQUEST SENSE STATUS"
	LXI H,LSTAT	;TO LSTAT
	LXI B,256*4;=MVI B,4/MVI C,0	;4 BYTES IN
	CALL WDOIT
	jrNZ error$exit	;(RETURN ERROR STATUS (5/7/FE))

	LDA LSTAT
	ANI 03FH


	CPI 4			;IF CONTROLLER RETURNS 4 (DRIVE NOT READY)
	JRNZ	error$exit	;    				(LEL0284)
	INR A;=MVI A,5/ORA A	;  THEN CHANGE IT TO 5
error$exit:
	push psw		; Save error code

	lda @ermde		; Get error mode
	inr	a		; Is it FF?
	jrz	error$50	; If yes, return hard error
	
	call	?pderr		; Print message header
	lhld	operation$name	; Get name of operation
	call ?pmsg		; Print that out

	pop	psw		; Get status
	lxi	h,error$table	; Point to table of msgs
error$20:
	call	errm1		; Print out all errors
	lxi	h,error$msg	; Point to ",Retry (Y/N)?"
	call ?pmsg		; Print it
	call u$conin$echo	; Wait for user response
	cpi	'Y'		; Yes?
	jz	w$1		; Try again
	jr      error$51        ; No.  Leave w/hard error
error$50:
	pop	psw		; Get error code
error$51:
	mvi	a,1   		; Set hard error
	jr	w$exit		;			(LEL0284)
good$exit:
	xra	a		; Zero means good	(LEL0284)
w$exit:
        ora a            ; Set error code              		(LEL0284)
	RET		;RETURN CONTROLLER'S ERROR CODE
	page


	;RESET AND CONFIGURE THE WINCHESTER

WINRES:
;	MVI A,080H		;				(LEL0384)
;	OUT p$winch$control	;PULSE THE RESET LINE		(LEL0384)

	mvi a,01		; Recalibrate			(LEL0384)
	lxi h,wcb		;				(LEL0384)
	mvi b,8			; 8 chars			(LEL0384)
	mvi	c,1		; Direction = out		(LEL0384)
	call	wdoit		;				(LEL0384)
	rnz			; return if error		(LEL0384)

	MVI A,12		;SET DRIVE CHARS COMMAND
	LXI H,WCB1		;FROM DRIVE CHARS DATA
	LXI B,256*8+1		;=MVI B,8/MVI C,1	;8 BYTES OUT
	;JMP WDOIT		;=CALL WDOIT/RET	;RETURN A=ERROR STATUS


WDOIT:		;LOWEST LEVEL COMMAND HANDLER.

;INPUT:	DATA:	C:  DIRECTION (0=IN,1=OUT)
;		B:  HOW MANY
;		HL: WHERE TO GET/PUT THEM
;
;	CMD:	A:  COMMAND BYTE
;
;
;RETURN:		A:  STATUS BYTE

	;SETUP OPCODE
	STA OP


;
; Wait for not busy, but time out after 1 second. 
;

	lxi	d,1099    	; 1099 * 910us=1 second 	(LEL0384)

WDOIT$4:			;				(LEL0384)
	IN p$winch$control	; Get status
	ANI 2			; Busy?
	JZ	WDOIT$6		; If not busy, do cmd		(LEL0384)

	xra	a		; Do loop 256 times		(LEL0384)
WDOIT$5:			;				(LEL0384)
	dcr	a		; (waste time)			(LEL0384)
	jnz	wdoit$5		; 896us				(LEL0384)

	dcx	d		; Decrement           		(LEL0384)
	mov	a,e		; Get low byte			(LEL0384)
	ora	d		; OR with hi byte		(LEL0384)
	jrnz	wdoit$4		; Try again			(LEL0384)


;
; Time out. Set error code = 7 and return.
;
	mvi	a,7		; Set error code = 7		(LEL0384)
	ora	a		; reset Z-flag			(LEL0384)
	ret			; Return			(LEL0384)



;SELECT CONTROLLER

WDOIT$6:

	MVI A,1
	OUT p$winch$data	;p$winch$data:=DECODED CONTROLLER SELECTION (1)
	;MVI A,1
	OUT p$winch$control	;RAISE..
	DCR A			;
	OUT p$winch$control	;..THEN LOWER.. THE SELECT LINE


	IN p$winch$control
	CMA
	ANI 2
	MVI A,7
	RNZ		;(RETURN ERROR 7 IF NOT BUSY)

	;WAIT FOR REQUEST
	CALL WREQT

	RNZ		;(RETURN A=5 IF TIME OUT ERROR)

	IN p$winch$control
	CMA
	ANI 8
	MVI A,7
	RNZ		;(RETURN ERROR 7 IF REQUEST IS NOT COMMAND)

	;JAM OUT COMMAND
	PUSH H
	PUSH B
	;CALL WSND(WCB,6)



	LXI H,WCB
	MVI B,6
	CALL WSND
	POP B
	POP H

	CALL WREQ

	;IF REQ IS DATA
	IN p$winch$control
	ANI 8
	jnz NODATA

	;THEN GET/PUT DATA
	MOV A,C
	ORA A
	PUSH PSW
	CZ WREC
	POP PSW
	CNZ WSND

	;WAIT FOR REQUEST
	CALL WREQ

	IN p$winch$control
	CMA
	ANI 8
	MVI A,7
	RNZ		;(RETURN ERROR 7 IF REQUEST IS NOT COMMAND)

	;FI
NODATA:

	;GET STATUS BYTE
	IN p$winch$data
	STA STAT
	MVI A,2
	OUT p$winch$control
	;THROW AWAY NULL STATUS BYTE
	CALL WREQT
	RNZ		;(RETURN A=5 IF TIME OUT ERROR)
	MVI A,2
	OUT p$winch$control

	LDA STAT
	ANI 2
	RZ		;(RETURN ZERO IF STATUS BYTE ZERO)
	MVI A,0FEH
	RET		;(RETURN 0FEH IF STATUS BYTE NOT OK)
	page
	CSEG
	;PROCEDURE WREC(HL,B)  'RECEIVE B BYTES FROM WINCH TO (HL)
WREC:

	IF	banked
	lda	@dbnk		; Get bank for transfer
	call	?bank		; Select it
	endif

	mvi	c,p$winch$data	; Set up port
	mvi	a,2

	;(ONLY WORKS UP TO 256 BYTES)
	;REPEAT

WREC1:
	;(HL):=IN(C)  *HL+=1  *B-=1
	DW 0A2EDH;"INI"
	;[ACKNOWLEDGE] - (SHOULD BE AUTOMATIC WITH DATA)
	OUT p$winch$control
	;UNTIL B=0
	jrnz WREC1

	if	banked
	xra	a     		; Point to bank 0  
	call	?bank		; Reselect it
	endif

	;END WREC
	RET


;PROCEDURE WSND(HL,B)  'SEND B BYTES FROM (HL) TO WINCH
WSND:

	if	banked
	lda	@dbnk		; Get bank for transfer
	call	?bank		; select it
	endif

	MVI C,p$winch$data
	MVI A,2

	;(ONLY WORKS UP TO 256 BYTES)
	;REPEAT
WSND1:
	;OUT(C):=(HL)  *HL+=1  *B-=1
	DW 0A3EDH;"OUTI"
	;[ACKNOWLEDGE] - (SHOULD BE AUTOMATIC WITH DATA)
	OUT p$winch$control
	;UNTIL B=0
	jrnz WSND1

	if	banked
	xra	a		; Point to Bank 0
	call	?bank		; Reselect it
	endif

	;END WSND
	RET

	DSEG

	;WAIT FOR WINCHESTER REQUEST
WREQ:	CALL WREQT
	jrnz WREQ
	RET		;WAIT FOR "REQUEST", RETURN Z=1
;
; WAIT FOR WINCHESTER REQUEST
; TIME OUT IF TOO LONG.
;
WREQT:
	PUSH D
	LXI D,0

WREQT1:	IN p$winch$control
	ani 01
	jz WREQT2 	;DONE IF REQUEST, RETURN Z=1
	DCX D
	MOV A,D
	ORA E
	JNZ WREQT1
	;XRA A
	ORI 5	;DONE IF TIME OUT, RETURN A=5, Z=0
WREQT2: POP D
	RET



	cseg
maxbad	equ	10		; maximum # bad tracks
cyls	equ	306
reduce	equ	307		; (value > 306 means NEVER)	(LEL0384)
precomp	equ	126		; Precomp			(LEL0384)
maxecc	equ	11


WCB1:
 DW 256*(CYLS AND 255)+(CYLS/256)	;REVERSAL STORES HI-LO
HEDS:
 Db 4   
 DW 256*(REDUCE AND 255)+(REDUCE/256)
 DW 256*(PRECOMP AND 255)+(PRECOMP/256)
 DB MAXECC


WCB:
OP	DB	0
ADH	DB	0
ADM	db	0
ADL	DB	0
INTL	DB	1
	DB	4

	DSEG


WRWF:	ds	1		;Write/read/check/format flag
WPT:    ds	1		;

wsect   ds   2
wtrk    ds   2
dmaadr	ds   2


STAT:	DS 1	;COARSE STATUS BYTE (EVERYTIME)
LSTAT:	DS 4	;FINE STATUS BYTES (FROM REQUEST SENSE STATUS COMMAND)



Operation$name	dw	read$msg
Read$msg	db	', Read',0
Write$msg	db	', Write',0
Error$msg	db	' Retry (Y/N) ?',0
nomatch		db	'***WARNING***',13,10,'Disk format not recognized'
		db	13,10,0
manybad		db	'***WARNING***',13,10,'MORE THAN 10 BAD TRACKS',13,10,0

	DB 0	;NUMBER OF BAD TRACKS
BADTRACK:DS MAXBAD*2	;ROOM FOR (10) BAD TRACKS
Signature db 'FMT'      



;END OF WINCH
	END
 
