	title	'Boot loader module for CP/M 3.0'

	public	?init,?ldccp,?rlccp,?time
	public  nint, ivect 

	extrn  @civec, @covec, @aivec, @aovec, @lovec, @bnkbf
	extrn	@dtbl,winc0
	extrn	?pmsg,?conin
	extrn 	@cbnk,?bnksl
	extrn	aux$in$ptr, aux$out$ptr, kb$buf$in

	maclib ports
	maclib z80

bdos	equ 5


	dseg	; init done from banked memory

?init:
	di					; disable interrupts
	lxi h,08000h 				; hl <= device 0
	shld @covec 				; DISPLY = console output

;
; Set up interrupt vectors.  Begin by pointing them all at a null
; interrupt routine so that every interrupt is satisfied in some way.
;

	lxi d,nint				; get address of null vector
 	lxi h,ivect				; point to ivect table
ini$vec:
	mov m,e           			; store low byte of NINT
	inr l					; increment hl
	mov m,d       				; store hi byte of NINT
	inr l					; increment hl
	jrnz ini$vec				; do for all

	IF	REAL$1050
	mvi	a,0000$0000b			; Disable all interrupts
	out	p$clk$portb			; Send it out

	mvi	a,int$initial			;
	out	int$port
	ENDIF
	ei					; reenable interrupts

;
; Check location C000H.  If it has a value of 07, then we are booting
; from the winchester. Switch the addresses in LDRTBL to point to the
; winchester rather than the floppy.
;
	lda	0c000h		; Check value			(LEL0284)
	cpi	07		; Is it 7?			(LEL0284)
	rnz			; Return if not			(LEL0284)
	lxi	h,winc0		; Point to winchester		(LEL0284)
	shld	@dtbl		; Store into table		(LEL0284)
	ret	

?ldccp:
?rlccp:
?time:
	ret
;
; Null interrupt handler
;
	cseg
NINT:
	IF REAL$1050
	push psw
	mvi	a,int$initial
	out	int$port
	pop psw
	ENDIF
	ei
	ret


	aseg
	org	0ffe0h           
ivect	ds	32		; 32-byte interrupt vector


	end
