/*
    cwrap.c -- code that used to be in the wrappers for SVS externals and
    is now written in C.
*/
#ifdef VAX
#define VMS
#else
#define UNIX
#endif

#define DEBUG 1

#if defined(SUN3) || defined(SUN4)
#define SUN
#endif

#ifdef PMAX
/* PMAX Pascal does not differentiate upper case and lower case characters.
 * (as in C and Sun Pascal)
 * Everything is converted to lower case in PMAX Pascal.
 * This makes the following defines necessary.
 */
#define WRcreate wrcreate
#define PFclose pfclose
#define PFBclose pfbclose
#define TextFptr textfptr
#define BFptr bfptr
#define UXerrno uxerrno
#define NameTooLong nametoolong
#endif

#if defined(S32) || defined(PC_AT)
#define SVS
#define REVERSE
#endif

#ifdef UNIX
#include <stdio.h>
#include <errno.h>

struct cfile {
    FILE *f;
    char buffer[BUFSIZ];
    };

#ifdef SUN
struct part_of_a_pascal_file {
	int	stuff[3];
	FILE	*f;		/* ptr to stdio descriptor */
	/* plus a lot of other garbage you don't want to know about */
};
#endif SUN

#ifdef S32
extern int errno;
#include <sys/file.h>
#else
#include <fcntl.h>
#endif S32

#define TRUE 1
#define FALSE 0
#define PTRUE 1
#define PFALSE 0
#define PBOOLEAN int /* use this for return values only */

char cextfexi(str)
char *str;
{
abort();
return 0;
/*
What this used to do:

|function ext_frdperm(var fname: packed array of char): boolean;
|function ext_fexists(var fname: packed array of char): boolean;
	.globl EXT_FEXI,EXT_FRDP,EXTFXSTS,EXTFRDPR
EXT_FRDP:
EXT_FEXI:
EXTFXSTS:
EXTFRDPR:
	movl sp@+,a2	| retaddr
	movl sp@+,a1	| ->fname
	movl a1,a0
EXTlp:		| change first space to NUL
	cmpb #32,a0@+
	jne EXTlp
	clrb a0@-
	movl a0,sp@-	| remember where we clobbered
	movl #4,sp@-	| check for "readable" as well as "exists"
	movl a1,sp@-	| ->fname
	jsr access
	addql #8,sp	| we pushed 2 longs
	movl sp@+,a0	| -> byte we clobbered
	movb #32,a0@	| restore to ' '
	addql #1,d0	| access: 0==>OK, -1==>trouble; convert to 1 or 0
	movb d0,sp@	| return boolean value
	jmp a2@
*/
}

char cextfwrp(str)
char *str;
{
abort();
return 0;
/*
What this used to do:

|function ext_fwrperm(var fname: packed array of char): boolean;
| Preston Gardner @ Valid w/ help of jfr Feb '83
|
	.globl EXT_FWRP,EXTFWRPR
O_FTMP= -200		| allow 200 bytes in ./fname copy
EXT_FWRP:
EXTFWRPR:
	link a6,#O_FTMP
	tstb a6@(O_FTMP-12)
	movl	a6@(8),a1	| ->fname
	movl	a1,a0		| a0 is cursor
fblnk:
	cmpb	#32,a0@+	| is it blank?
	jne	fblnk		| if not, try next one
	clrb	a0@-		| blank loc = '\0'
	movl	#2,sp@-		| push 2 (exists & writable)
	movl	a1,sp@-		| push ->fname
	jsr	access
	addql	#8,sp		| we pushed 2 longs
	clrl	d1		| assume retval will be FALSE
	tstl	d0		| test return value
	jne	tstxist		| if no permission
	moveq	#1,d1	 	| retval = TRUE
	jra	cleanexit	| go to cleanup & exit
tstxist:
	clrl sp@-		| push 0 (exists)
	movl	a6@(8),sp@-	| push ->fname
	jsr	access
	addql	#8,sp		| we pushed 2 longs
	clrl	d1		| assume return is FALSE
	tstl	d0		| if file exists
	jeq	cleanexit	| then goto cleanup & exit
	lea a6@(O_FTMP),a0	| ->parent name
	movl a6@(8),a1		| ->fname
	cmpb	#47,a1@		| does fname start with '/'?
	jeq	precp		| yes; rooted ==> no ./ at beginning
	movb	#46,a0@+	| insert '.'
	movb	#47,a0@+	| insert '/'
precp:
docplp:
	movb	a1@+,a0@+	| copy until null
	jne	docplp		| repeat
fdslsh:
	cmpb	#47,a0@-	| find last '/'
	jne	fdslsh		| repeat
	clrb a0@(1)		| after '/' (could be "/foo")

	movl	#2,sp@-		| push 2
	pea a6@(O_FTMP)		| push parent address
	jsr	access
	addql	#8,sp		| we pushed 2 longs
	clrl	d1		| make sure d1 is all 0
	tstl	d0		| test return value
	jne	freedad		| no permission
	moveq	#1,d1 		| retval = TRUE
freedad:
cleanexit:
	movl a6@(8),a0		| a0->fname
fdnull:
	tstb	a0@+		| find null
	jne	fdnull		| repeat
	movb	#32,a0@-	| restore to blank
	unlk a6
	movl sp@+,a0		| return address
	addql #4,sp		| pop ->fname
	movb	d1,sp@		| return value
	jmp	a0@		| return
*/
}

ccmonitor(lowpc)
long lowpc;
{
#ifdef MON
    monitor(lowpc,NULL,NULL,0,0);
#else
	FILE *fp;

	if ((fp = fopen("/dev/console", "w")) != NULL) {
		fprintf(fp, "Calls to ccmonitor() are not supported\n");
		fprintf(fp, "Contact the local field service office\n");
		fflush(fp);
	}

	fclose(fp);
#endif
}

ctrmoutchr(c)
long c;
{
    /* This looks like this because SVS Pascal screws up parameter
    passing for cexternals that use chars or booleans as value parameters. */

    c = (c << 8) & 0xFF000000; 
    write(1, &c, 1);
}

PBOOLEAN
WRcreate(name)
char *name;
{
    int fd;
    fprintf(stderr, "in Wrcreate: %s  %d\n", name);
    if ((fd = open(name, O_WRONLY|O_CREAT, 0666)) < 0) return PFALSE;
#ifdef DEBUG
    fprintf(stderr, "%s created (then closed) using fd %d\n", name, fd);
#endif DEBUG
    close(fd);
    return PTRUE;
}

#ifdef SVS

long textfdsc(f)
char *f;
{
#ifdef PC_AT
return *(f+16);  /* by experiment -- the old offset was 14 for PC. bh 29Apr88 */
#else
return *(f+15);
#endif PC_AT
}

#endif SVS


#ifdef SUN

PBOOLEAN
PFclose(f)
struct part_of_a_pascal_file *f;
{
    int val;
    val = fclose(f->f);
    f->f = NULL;
    return val == 0 ? PTRUE : PFALSE;
}

PBOOLEAN
CPFclose(f)
struct cfile *f;
{
    int val;
    val = fclose(f->f);
    f->f = NULL;
    return val == 0 ? PTRUE : PFALSE;
}


PBOOLEAN
PFBclose(f)
struct part_of_a_pascal_file *f;
{
    return PFclose(f);
}


FILE *
TextFptr(f)
struct part_of_a_pascal_file *f;
{
    return f->f;
}


FILE *
BFptr(f)
struct part_of_a_pascal_file *f;
{
    return f->f;
}


long
textfdsc(f)
struct part_of_a_pascal_file *f;
{
    
    return f->f ? fileno(f->f) : -1;
}

long 
ctextfdsc(f)
struct cfile *f;
{
   return f->f ? fileno(f->f) : -1;
}

#endif SUN

#if defined(SUN) || defined(PMAX)

long
UXerrno()
{
    return errno;
}

int
NameTooLong()
{
    return ENAMETOOLONG;
}

#define SPECIAL_DUP2	599 /* My "errno" code for failed dup2 */

/* SVS PASCAL error codes */
#define S_PARITY	1	/* Parity error or CRC error. */
#define S_DEVNUM	2	/* Invalid device number. */
#define S_INVIO		3	/* Invalid input-output request. */
#define S_NEBULOUS	4	/* Nebulous Hardware Error. */
#define S_OFFLINE	5	/* Volume went off-line. */
#define S_FILELOST	6	/* File lost in directory. */
#define S_BADNAME	7	/* Bad file name. */
#define S_NOROOT	8	/* No root on volume. */
#define S_VOLNOTFOUND	9	/* Volume not found. */
#define S_FILNOTFOUND	10	/* File not found. */
#define S_DUPENTRY	11	/* Duplicate directory entry. */
#define S_ISOPEN	12	/* File already open. */
#define S_NOTOPEN	13	/* File not open. */
#define S_BADINPUT	14	/* Bad input information. */
#define S_RINGBUF	15	/* Ring buffer overflow. */
#define S_WRPROTECT	16	/* Write protect. */
                                /* (Changed to 'Permission denied' for SUN */
#define S_INVALSEEK	17	/* Invalid seek. */
#define S_UNKNOWNERR	18	/* Error of unknown type. */
#define S_DUP2		22	/* Dup to stderr failed. */
#define S_NAME_TOO_LONG 24      /* Name > 80 chars and unable to create sym link */


long
errno_to_ioresult(n)
long n;
{
    switch (n) {
	case 0:
	    return 0;
	case EROFS:		/* Read-only file system */
	case ETXTBSY:	/* Text file busy */
	case EACCES:		/* Permission denied */
	case EPERM:		/* Not owner */
	    return S_WRPROTECT;
	case ENOENT:		/* No such file or directory */
	    return S_FILNOTFOUND;
	case ENOSPC:		/* No space left on device */
	case EIO:		/* I/O error */
	case EFBIG:		/* File too large */
	    return S_NEBULOUS;
	case EEXIST:		/* File exists */
	    return S_ISOPEN;
	case ESPIPE:		/* Illegal seek */
	    return S_INVALSEEK;
	case SPECIAL_DUP2:
	    return S_DUP2;
	case ENAMETOOLONG:
            return S_NAME_TOO_LONG;
	default:
	    return S_UNKNOWNERR;
	}
}

#endif SUN || PMAX



#ifdef PMAX

PBOOLEAN
PFclose(fpp)
FILE **fpp;
{
    int val;
    val = fclose(*fpp);
    *fpp = NULL;
    return val == 0 ? PTRUE : PFALSE;
}


PBOOLEAN
PFBclose(fpp)
FILE **fpp;
{
    return PFclose(fpp);
}

FILE *
TextFptr(fpp)
FILE **fpp;
{
    return *fpp;
}


FILE *
BFptr(fpp)
FILE **fpp;
{
    return *fpp;
}

long
textfdsc(fpp)
FILE **fpp;
{
    
    return ((*fpp) ? fileno(*fpp) : -1);
}

#endif PMAX
#endif UNIX


#ifdef VMS
#include <sys/lnmdef.h>
#include <sys/descrip.h>
#define $DESCRIPTOR_STRLEN(name,string)	\
    struct dsc$descriptor_s name = \
	{ strlen(string), DSC$K_DTYPE_T, DSC$K_CLASS_S, string }


char *
util_getenv(name)
   char *name;
{
    /* The following is necessary as the VAXC library routine getenv()
       requires initialization performed by a C main (not done by a
       PASCAL main). */

    static $DESCRIPTOR(table, "LNM$PROCESS_TABLE");
    $DESCRIPTOR_STRLEN(namedesc, name);
    struct itmlst {
	unsigned short buffer_length;
	unsigned short code;
	char *buffer_address;
	unsigned short *return_length_address;
	long terminator;
	} itmlst;
    char result[256];
    unsigned short result_length;
    int code;
    char *ret_value;
    

    itmlst.code = LNM$_STRING;
    itmlst.buffer_length = 255;
    itmlst.buffer_address = &result;
    itmlst.return_length_address = &result_length;
    itmlst.terminator = 0;

    if (!((code=SYS$TRNLNM(0, &table, &namedesc, 0, &itmlst)) & 1)) result_length = 0;
    result[result_length] = '\0';
#ifdef DEBUG
    printf("TRNLNM(\"%s\") (%d chars) == \"%s\" (code == 0x%x)\n", 
           namedesc.dsc$a_pointer, namedesc.dsc$w_length, result, code);
#endif DEBUG
    if (!result_length) return(0);

    /* make a copy of result so returned value will not be volatile */

    ret_value = malloc((unsigned int)(result_length + 1));
    strcpy(ret_value, result);
    return(ret_value);
}
#endif VMS
