#ifndef PARSEBUF_H
#define PARSEBUF_H 1
#include <stream.h>
#include "Clib/GrowingBuf.h"

class parsebuf : filebuf {
    char* base2;
    char* _filename;
    GrowingBuf copy_buf;
    int _lineno;
    heap* h;



    int /* char or EOF */ skip_continuation();

    int doallocate();
    char* prev(char* p) ;
    char* succ(char* p);
    void init(heap*);

    const char* line(char* pos);// Line containing the indicated char
    int column(char* pos);	// Position within line
    int lineno(char* pos);

    int _eof;
    char* next_pptr;		// For lookahead to find newline
    char* last_pptr;		// For lookback to find newline
    char* read_ahead();

    boolean on_heap;
public:
    const char* filename() { return _filename; }
    int underflow();
    int overflow(int c=EOF);	// Disallowed -- parsebufs are read only

    void sputbackc(int c);	// sputback(EOF) works from here as long
				// as EOF is in fact the current char --
				// sputback(EOF) is implemented as a no-op
    parsebuf* open(const char* filename);

    int close() { return filebuf::close(); }

    int sgetc() { return filebuf::sgetc(); }
    int snextc()
    {
	int c = filebuf::snextc();
	if (c=='\n') _lineno++;
	return c == '~' ? skip_continuation() : c;
    }

    parsebuf(heap* hp)
    : copy_buf(*hp) 
    { 
	boolean _on_heap = !this; 
	this = this ? this : (parsebuf*)hp->mem(sizeof(*this));
	on_heap = _on_heap;
	init(hp);
    }

    parsebuf(heap* hp, const char* filename)
    : copy_buf(*hp)
    { 
	boolean _on_heap = !this; 
	this = this ? this : (parsebuf*)hp->mem(sizeof(*this)); 
	on_heap = _on_heap;
	init(hp);
	open(filename);
    }

    parsebuf(heap* hp, FILE *f)
    : (f), copy_buf(*hp)
    { 
	boolean _on_heap = !this; 
	this = this ? this : (parsebuf*)hp->mem(sizeof(*this)); 
	on_heap = _on_heap;
        _filename = 0;
        _lineno = 1;
        _eof = 0;
        h = hp;
	cout << "The value of fp is " << (int)fp << "\n";
    }
    parsebuf(heap* hp, int filedesc)
    : (filedesc), copy_buf(*hp)
    { 
	boolean _on_heap = !this; 
	this = this ? this : (parsebuf*)hp->mem(sizeof(*this)); 
	on_heap = _on_heap;
        _filename = 0;
        _lineno = 1;
        _eof = 0;
        h = hp;
    }
    ~parsebuf();

    // Error reporting -- reports char PRIOR to current char
    const char* current_line()
	{ char* p = prev(gptr); return line(p ? p : gptr); }
    int current_lineno()
	{ char* p = prev(gptr); return lineno(p ? p : gptr); }
    int current_column()
	{ char* p = prev(gptr); return column(p ? p : gptr); }
};
#endif PARSEBUF_H
