







/*
    A drawing extension and what it means within some  rule.
    Intended for internal use only.
*/
#ifndef ER_EXTENSION_H
#define ER_EXTENSION_H
#include "Clib/gring.h"
#include "Clib/stringt.h"
#include "er_heap.h"
class erule_drawing_extension;
class erule_drawing_special;
class erule_entry;
class erule_lex;

gring_define(next,erule_extension);

enum erule_extension_kind {
    UNKNOWN_EXTENSION,
    DRAWING_EXTENSION,
    SCALD_PRIM_EXTENSION,
    OTHER_PRIM_EXTENSION,
    SPECIAL_EXTENSION
 };

class erule_extension {
    friend ostream& operator<<(ostream&, const erule_extension&);
    friend boolean operator==(const erule_drawing_extension&, const erule_extension&);
    friend boolean operator==(const erule_extension&, const erule_drawing_extension&);
    friend boolean operator==(const erule_drawing_special&, const erule_extension&);
    friend boolean operator==(const erule_extension&, const erule_drawing_special&);
    gring_inst(next,erule_extension);
    string name; // If SCALD_PRIM (meaning a PRIM or PART drawing),
                 // this is the target directory type (Such as LOGIC
                 // or SIM); otherwise the extension name.
    erule_extension_kind _kind;
public:
    // Internal to erule subsystem
    erule_extension(const string& extension, const string& attribute);
    erule_extension(erule_lex*, const erule_entry* parent, boolean* ok /* returned */);
    ~erule_extension();
    erule_extension_kind kind();
};

#ifndef VAX
gring_inline(next,erule_extension);
#endif

inline erule_extension_kind erule_extension::kind() { return _kind; }

inline boolean operator==(const erule_extension& e,
                          const erule_drawing_extension& v) { return v == e; }













inline boolean operator==(const erule_extension& e,
                          const erule_drawing_special& s) { return s == e; }

inline erule_extension::~erule_extension()
    { erule_heap.memfree(this, sizeof(*this));  this = 0; }

#endif





















































