
#ifndef ER_ERULE_H
#define ER_ERULE_H
#include <stream.h>
#include "dwg_page.h"
#include "Clib/stringt.h"


/*
    This is the  programmatic  interface  to  the  expansion
    rules  package.   Including this .h file provides every-
    thing needed by a C++ user.
*/
enum erule_filetype {   ERULE_UNDEF_FILETYPE,
                        ERULE_CONNECTIVITY,
                        ERULE_EXPANSION,
                        ERULE_LIST,
                        ERULE_LINKER_LIST,
                        ERULE_SPECIAL,
                        ERULE_SCHEMA };
class erule_selection {
    class erule_drawing_entry* _drawing;
    string _context;
    class erule_drawing_extension* _extension;
    class erule_drawing_special* _special;
    boolean _extension_forced_to_primitive;
    boolean allocated;
public:
    erule_selection(const string& drawing_name, const string& context_name,
                     boolean non_existence_not_error);
    ~erule_selection();

    string special();           // 0 if no special selected
    string extension();         // 0 if no drawing selected
    int version();
    string directory_type();    // If this is a combined primitive/special,
                                // then this will reflect the directory
                                // containing the PRIM or PART.

    const char* filename(erule_filetype, unsigned page, char* context);

    erule_drawing_page* first_page();
    erule_drawing_page* next_page(erule_drawing_page*);

    boolean force_to_primitive();
        // TRUE iff non-PRIM/PART extension that is to be forced to primitive
    boolean is_primitive();
        // TRUE iff PRIM/PART || forced_to_primitive || has special model
    int is_simple_primitive();
        // TRUE iff PRIM/PART extension and single-versioned and single-paged
        // Return 0 iff FALSE, page number iff TRUE
    boolean same_drawing(erule_selection* other);        
    // TRUE iff both drawings have same ds_dwgs
};











/*
    This class sets up the table.  For now  a  compile  type
    must be specified at setup.  Later it may become part of
    the selection criteria, with all understood types  being
    entered in the table.
*/
class erule {
public:
    erule(const string& compile_type);
    boolean read(char* filename);
    boolean except(const string& compile_type,
                   const string& drawing, const string& context,
                   const string& extension, const string& attribute);
        // If context == 0, then exception applies to all contexts
        // not otherwise explicitly specified.  context == "" applies
        // to the "no parameters" context.
    void dump(ostream&); // Dump tables for debugging purposes
};

inline boolean erule_selection::force_to_primitive()
    { return _extension_forced_to_primitive; }

#ifdef PASCAL_XFACE
#ifndef INLINE_ERULE_XFACE
//#define INLINE_ERULE_XFACE 1 /* cfront bugs -- can't do this */
#endif
#endif

#if ERULE_C || INLINE_ERULE_XFACE
#include "er_heap.h"
#include "dwg_special.h"
#include "dwg_page.h"
#include "dwg_extension.h"
#include "dwg_version.h"  // Needed for _extension->version_number below
#ifdef INLINE_ERULE_XFACE
#define inline_or_not inline
#else
#define inline_or_not
#endif
inline_or_not string erule_selection::special()
    { string s;  if (_special) s = _special->name();  return s; }

inline_or_not string erule_selection::extension()
    { string s;  if (_extension) s = _extension->name();  return s; }

inline_or_not int erule_selection::version()
    { return _extension ? _extension->version_number() : 0; }

inline_or_not erule_drawing_page* erule_selection::first_page()
{
    return _extension ? _extension->first_page() : 0;
}

inline_or_not erule_drawing_page*
erule_selection::next_page(erule_drawing_page *page)
{
    return _extension ? _extension->next_page(page) : 0;

}







inline_or_not
erule_selection::~erule_selection()
    { if (allocated) { erule_heap.memfree(this, sizeof(*this));  this = 0; } }
#undef inline_or_not
#endif
#endif






















































