
/*
    These two routines are call compatable with svs's pascal");

    sp -> return address");
          size (short for __NEW, long for __NEW4)");
    result is placed in d0 before return (automatically by c code)");
*/

asm("	.text");
asm("	.globl __NEW");
asm("__NEW:");
asm("	movl sp@+,savertn  | return address");
asm("	movw sp@+,d0       | size requested");
asm("	extl d0            | extend size");
asm("	movl d0,sp@-       | push size");
asm("	jsr  memSVS        | d0 contains ptr to space on return");
asm("	addql #4,sp        | pop size off stack");
asm("	movl savertn,sp@-  | push return address");
asm("	rts");

asm("	.globl __NEW4");
asm("__NEW4:");
asm("	movl sp@+,savertn  | return address");
asm("	movl sp@+,d0       | size requested");
asm("	movl d0,sp@-       | push size");
asm("	jsr  memSVS        | d0 contains ptr to space on return");
asm("	addql #4,sp        | pop size off stack");
asm("	movl savertn,sp@-  | push return address");
asm("	rts");

/*
    These two routines are call compatable with svs's pascal

    sp -> return address
          size (short for __DISP, long for __DISP4)
          address being returned
    d0 is left with the size disposed of, and a0 the address
*/

asm("	.globl __DISP");
asm("__DISP:");
asm("	movl sp@+,savertn  | return address");
asm("	movw sp@+,d0       | size requested");
asm("   extl d0            | extend size");
asm("	movl sp@+,a0       | address of space pointer");
asm("	movl d0,sp@-       | push size");
asm("	movl a0@,sp@-      | push address of space pointer");
asm("        clrl a0@      | nil the pointer to the space");
asm("  	jsr  freeSVS");
asm("	addql #8,sp        | pop address and size off stack");
asm("	movl savertn,sp@-  | push return address");
asm("	rts");

asm("	.globl __DISP4");
asm("__DISP4:");
asm("	movl sp@+,savertn  | return address");
asm("	movl sp@+,d0       | size requested");
asm("	movl sp@+,a0       | address of space pointer,");
asm("	movl d0,sp@-       | push size");
asm("	movl a0@,sp@-      | push address of space pointer");
asm("        clrl a0@      | nil the pointer to the space");
asm("  	jsr  freeSVS");
asm("	addql #8,sp        | pop address and size off stack");
asm("	movl savertn,sp@-  | push return address");
asm("	rts");

asm("	.globl __MARK");
asm("__MARK:");
asm("	jsr	abort");

asm("	.globl __RELSE");
asm("__RELSE:");
asm("	jsr	abort");

asm("	.data	");
asm("	savertn:.long 0");


#include "../mem/mem.h"
static struct main_arena *mainarenaSVS;
static struct arena *arenaSVS;


static init_arenaSVS()
{
    mem_main_arena(&mainarenaSVS);
    memarena(mainarenaSVS, &arenaSVS);
}


char *
memSVS(n)
unsigned long n;
{
    if (!arenaSVS) init_arenaSVS();
    return mem(arenaSVS, n);
}


void
freeSVS(p, n)
char *p;
unsigned n;
{
    memfree(arenaSVS, p, n);
}
