#ifdef S32
#include "stdio.h"
#include "a.out.h"
#define U_VA 0x100000

static char sccsid[]="";

/*
   Modify a.out by clobbering the following routines with JMP to the other

   %_NEW4  ==> __NEW4
   %_NEW   ==> __NEW
   %_DISP4 ==> __DISP4
   %_DISP  ==> __DISP
   %_MARK  ==> __MARK
   %_RELSE ==> __RELSE
*/

struct nlist nl[13]={
	{"%_NEW4"},  {"__NEW4"}, 
	{"%_NEW"},   {"__NEW"}, 
	{"%_DISP4"}, {"__DISP4"}, 
	{"%_DISP"},  {"__DISP"}, 
	{"%_MARK"},  {"__MARK"}, 
	{"%_RELSE"}, {"__RELSE"},
	{""}
        };

#define things_to_clobber 6


#define max(a,b) ((a)>(b) ? (a) : (b))


struct exec hdr;
typedef unsigned short ushort;


int debug;
long reloc;
ushort *p0;

main(argc,argv)
char *argv[];
{
	int f;
	register int i;
	register int missing={0}, clobbered={0};
	int padding;

	if (argc>=2 && argv[1][0]=='-' && argv[1][1]=='d') {
		debug=1; ++argv; --argc;
	}
	if (argc!=2) uerror(argv[0],"takes 1 argument (an a.out)");
	if (0>(f=open(argv[1],2))) uerror(argv[1],"cannot open executable");
	nlist(argv[1],nl);

	uread(f,&hdr,sizeof(hdr));
	if (N_BADMAG(hdr)) uerror(argv[0], "Bad magic number");
	if ((padding = N_TXTOFF(hdr) - sizeof(hdr)) > 0) {
	    if (debug) 
	        fprintf(stderr, "Going to read %d bytes after the header\n",
		        padding);
	    if (0>(p0=(ushort *)sbrk(max(hdr.a_text,padding))))
	        uerror(argv[0],"sbrk failed");
	    uread(f, p0, padding);
	    }
	else {
	    if (0>(p0=(ushort *)sbrk(hdr.a_text))) 
	        uerror(argv[0],"sbrk failed");
	    }
	reloc=((int)p0)-U_VA;
	if (debug)
	     fprintf(stderr,"p0=0x%x text_sz=0x%x top=0x%x reloc=0x%x\n",
	             p0,hdr.a_text,sbrk(0),reloc);
	uread(f,p0,hdr.a_text);

	for (i=0; i<(things_to_clobber<<1); i+=2) {
	     if (debug)
	          fprintf(stderr,"%s-0x%x %s-0x%x\n",
		                 nl[i].n_name,nl[i].n_value,
		                 nl[i+1].n_name,nl[i+1].n_value);

	     if (nl[i].n_type!=N_UNDF)
	          if (nl[i+1].n_type==N_UNDF) {
		       fprintf(stderr,"Missing entry %s\n",nl[i+1].n_name);
		       missing++;
		       }
                  else {
 	               clobber(nl[i].n_value,nl[i+1].n_value);
		       clobbered++;
		       }
             else {
 	          fprintf(stderr,"Warning: missing entry %s\n",nl[i].n_name);
		  clobbered++;
		  }
             }

        if ((clobbered==things_to_clobber) &&
	    (!missing)) {
             ulseek(f,N_TXTOFF(hdr),0);
	     uwrite(f,p0,hdr.a_text);
     	     exit(0);
	     }
        else {
	     if (missing)
	          fprintf(stderr,"%d missing entrie(s).\n",missing);
             if (clobbered!=things_to_clobber)
	          fprintf(stderr,"%d thing(s) not clobbered.\n",things_to_clobber-clobbered);
             fprintf(stderr,"No heapfix done.\n");
             exit(1);
	     }
}

clobber(a,b)
   register unsigned a,b;
{
   register ushort *c={(ushort *)(a+reloc)};
   if (debug)
        fprintf(stderr,"   c=%d\n",c);

   *c            = 0x4ef9;
   *(long *)(c+1)= b;
}


uerror(s0,s1)
char *s0,*s1;
{
	fprintf(stderr,"%s: %s\n",s0,s1);
	exit(-1);
}

int
uread(f,b,n)
char *b;
{
	if (n!=read(f,b,n)) uerror("read error","");
	return(n);
}

int
uwrite(f,b,n)
char *b;
{
	if (n!=write(f,b,n)) uerror("write error","");
	return(n);
}

int
ulseek(f,n,t)
{
	register int i;
	if (0>(i=lseek(f,n,t))) uerror("lseek error","");
	return(i);
}

#else
main()
{
    exit(0);
}
#endif S32
