#ifndef MEM_INCLUDED

#define MEM_INCLUDED

#ifndef VM_H_INCLUDED
#include "../bds/vm.h"
#endif VM_H_INCLUDED

#ifdef OBJECT

#define MEM      malloco
#define FREE     freeo
#define CMEM     calloco
#define RMEM     realloco

#define XMEM     x_allocateo
#define XFREE    x_poolo
#define XCMEM    x_callocateo
#define XRMEM    x_realloco
#define XPOOL    x_pool_arenao

#define MEMROOT  malloco_root
#define SMEMROOT set_malloco_root

#define DARENA   x_darenao
#define DUNIT    x_dunito

#else

#define MEM      malloc
#define FREE     free
#define CMEM     calloc
#define RMEM     realloc

#define XMEM     x_allocate
#define XFREE    x_pool
#define XCMEM    x_callocate
#define XRMEM    x_realloc
#define XPOOL    x_pool_arena

#define MEMROOT  malloc_root
#define SMEMROOT set_malloc_root

#define DARENA   x_darena
#define DUNIT    x_dunit

#endif OBJECT

char *MEM(), *CMEM(), *RMEM(), *XMEM(), *XCMEM(), *XRMEM(), *MEMROOT();

#endif MEM_INCLUDED
