#include "../misc/platform.h"
#include "../bds/bds.s.h"

/*
 *  System dependent defines -- our OPUS C compiler has problems with
 *  short int alignment, so we align things on long int boundaries.
 */

#ifdef PC_AT
#define WORD_IS_4_BYTES /* rather than 2 */
#endif PC_AT

/*
 *	Number of free slots.  Each slot contains one size unit, with
 *	successive slots containing units of SZW bytes (1 word) larger.
 *	The first slot starts with (SZU/SZW) words.  Don't forget that 
 *	a word is defined by ALIGN and NALIGN, not by something 
 *	foreign to this code!
 *	ie: ALIGN = short int, NALIGN = 1........
 *	    slot  0 contains 12 byte holes (6 words)
 *          slot  1 contains 14 byte holes (7 words)
 *	    slot 20 contains 52 byte holes (26 words)
 *
 *	An extra slot at the end catches everything larger, and is searched
 *	linearly, stopping at the first hole large enough to satisify the
 *	allocation request.
*/

#ifdef WORD_IS_4_BYTES
#define NUMBER_OF_SLOTS 20 /* don't need so many */
#else
#define NUMBER_OF_SLOTS 40 
#endif WORD_IS_4_BYTES

/*
 *   	Define the below keyword if the size of structure word is a power
 *	of two.  That will make this run faster because it will use shifting
 *	instead of division and multiplication.
*/

#define BYTES_PER_WORD_IS_POWER_OF_TWO            /*==> SZW is a power of 2*/

#ifdef  BYTES_PER_WORD_IS_POWER_OF_TWO
#ifdef WORD_IS_4_BYTES
#define TWO_TO_THIS_VALUE_EQUALS_BYTES_PER_WORD 2
#else
#define TWO_TO_THIS_VALUE_EQUALS_BYTES_PER_WORD 1
#endif WORD_IS_4_BYTES

#define bytes(words) ((words)<<TWO_TO_THIS_VALUE_EQUALS_BYTES_PER_WORD)
#define words(bytes) ((bytes)>>TWO_TO_THIS_VALUE_EQUALS_BYTES_PER_WORD)
#else
#define bytes(words) ((words)*SZW)
#define words(bytes) ((bytes)/SZW)
#endif BYTES_PER_WORD_IS_POWER_OF_TWO

/*
 *	The allignment mechanism was pirated from the malloc.c Berkeley file.
 *      Note that NALIGN must be 1 inorder for the size and busy macros to
 *      properly access all the bits contained in a word.  If you can figure
 *      out another way then ALIGN may be made char and the unit of storage
 *      would then depend entirely upon NALIGN to determine how many bytes
 *      it would represent.  PS Don't forget to change BUSY_BIT and SIZE_BITS,
 *      and SPACE_SIZE when dinking with ALIGN and NALIGN. (a bf comment)
 */

#ifdef WORD_IS_4_BYTES
#define ALIGN long int
#else
#define ALIGN short int
#endif WORD_IS_4_BYTES
#define NALIGN 1

struct word {                  /*unit of storage is the word*/
       ALIGN dummy[NALIGN]; 
       };
#define SZW (sizeof(struct word)) 
#define WORD struct word *

/*--------------------------------------------------------------------------*/

/*
 *	Free space of unit must be an integer number of words, hence the 
 *	following alignment. Done this way so that as(SZS==SZF) can be placed
 *	in the code. (a bf comment)
 */

#ifdef WORD_IS_4_BYTES
#define SPACE_SIZE 2
#else
#define SPACE_SIZE 4
#endif WORD_IS_4_BYTES

struct space {
       struct word space[SPACE_SIZE];
       };
#define SZS (sizeof(struct space))

union free {
      DRO(list,unit);           /*Free units are linked from a free slot*/
      struct space space;
      };
#define SZF (sizeof(union free))


struct unit {                   /*Algorithm unit of storage*/
       struct word tag1;        /*tag1 is 1st*/
       union  free free;
       struct word tag2;        /*tag2 is last in UNIT*/
       };
#define SZU (sizeof(struct unit))
#define UNIT struct unit *


/*
 *	BUSY_BIT bit cleared, i.e. 0, indicates that block is free.
 *	BUSY_BIT bit set,     i.e. 1, indicates that block is unavailable,
 *	         that is, in use.
*/

#ifdef WORD_IS_4_BYTES
#define BUSY_BIT 0x80000000
#else
#define BUSY_BIT  0x8000
#endif WORD_IS_4_BYTES
#define testbusy(p)   ((int)((p)&BUSY_BIT))
#define setbusy(p)    ((int)(p)|BUSY_BIT)
#define clearbusy(p)  ((int)(p)&~BUSY_BIT)

#ifdef WORD_IS_4_BYTES
#define SIZE_BITS 0x7FFFFFFF /* actually much larger than we could ever get */
#else
#define SIZE_BITS 0x7FFF
#endif WORD_IS_4_BYTES
#define getsize(p)       ((int)(p)&SIZE_BITS)
#define sizeovrflo(size) ((size)!=getsize(size))
#define clearsize(p)     ((int)(p)&~SIZE_BITS)
#define setsize(p,size)  (clearsize(p)|(int)(size))   
                        /*note that size is assumed constrained to SIZE_BITS*/

#define TAG(p) ((p)->dummy[0])
#define SIZE(p) (getsize(TAG(p)))

#define TAG2(p,size) (((p)+(size)-1)->dummy[0])
#define SIZE2(p,size) (getsize(TAG2(p,size)))

/*--------------------------------------------------------------------------*/

struct free_slot {
       SHO(units,unit);    
       int next_largest;  /*index to the next non-empty free_slot*/ 
       };

struct segment {
       PTRO(this,segment);    /*this segment*/
       DLO(next,segment);     /*next segment*/
       struct word lower_tag; /*algorithm requires lower and upper
                                limits of segment be marked with 
                                busy*/
       };
#define SZ_SEG (sizeof(struct segment))
#define SEG struct segment *

/*
 *	Units larger than free_slots[NUMBER_OF_SLOTS-1] are queued to
 *	free_slots[NUMBER_OF_SLOTS], so one extra free slot is required.
*/

#define FREE_SLOT_SIZE NUMBER_OF_SLOTS+1

struct arena { 
       struct segment segment;   /*definition of this segment..must be
                                   1st in any segment for reading*/
       PTRO(bottom,word);        /*lowest 'word' in arena*/
       PTRO(top,word);           /*highest 'word' in arena*/
       int size;                 /*in bytes*/
       int free_size;            /*in bytes*/
       int busy_size;            /*in bytes*/
       int num_of_seg;           /*number of segments*/
       SHO(segments,segment);    /*segments in the arena*/
       struct free_slot free_slots[FREE_SLOT_SIZE];
       struct word marker2;      /*marker helps in detection of
                                   possible arena corruption
                                   must be last due to lower_tag which
                                   it contains*/
       };
#define SZA (sizeof(struct arena))
#define ARENA struct arena *


#define Xwords_for_arena   (words(SZA+(SZW-1)))
#define Xwords_for_segment (words(SZ_SEG+(SZW-1)))

