/*LINTLIBRARY*/
#include "mem.h"
#include "malloc.h"
#include "../bds/bds.m.h"
#include "../misc/assert.h"
#include <stdio.h>


#ifdef VMS
#define write(a,b,c) /* VAXC "write" calls calloc !!! */

#define odd(x) (1 & x)
static char *
sbrk(n)
    int n;
{
    char *rslt;
    int nbytes={n};
    return(odd(LIB$GET_VM(&nbytes, &rslt)) ? rslt : (char *) -1);
}
#undef odd
#endif VMS


/*	C storage allocator:
 *	Algorithm: see pages 441-442 in Knuth, Fundamental Algorithms:
 *      1. Modified to hash the bytes asked for. Perhaps this will further
 *         reduce paging through the arena to locate a free unit which
 *	   satisifies the bytes asked for than use of a divided linked list.
 *Not yet2. The  arena may be saved into a file or restored from a file.
 *	   Restoration is transparent, that is, the arena is identical
 *	   upon restoration as it was before having been written.
 *	3. Segmented (non-linear) memory is supported.
 *	4. Multiple arenas may be created and destroyed.  The segments
 *	   for the additional arenas are allocated from the root arena
 *	   to control reuse of the segments allocated to aditional 
 *	   arenas which are subsequently destroyed.
 *      5. The code may be compiled either for OBJECT use or Berkeley
 *         compatable (except that contents of freed units are altered)
 *         use by defining OBJECT or omitting that definition.
 *	   Both resulting .o files may be included in the same program,
 *	   as the external subroutine names of the OBJECT compiled source
 *	   end in 'o' to eliminate conflict.
 * 
 *	Compile this with -DDEBUGI to turn on interface checking
 *	Compile this with -DDEBUGL to have checking not dependent on
 *	external subroutines.
 *
 *	--Robert Floyd  9/25/82
 *	--Redone 4/1/84 Robert Floyd
*/


/*
 *	Minimum request for memory to the system in bytes is the BLOCK.
 *	It must be a multiple of SZW (the number of bytes of the
 *	storage element 'word').
 *	Note that an increment of this will always be asked
 *	for from the system. 
*/

#define SBRK_FAILS (-1)
#define blocks(wds)        (bytes(wds)>>10)
#define wdsblock(blks)     (words(blks<<10))

#ifndef PAGE_SIZE
#define PAGE_SIZE 1024
#endif PAGE_SIZE
#ifndef BLOCK
#define BLOCK PAGE_SIZE
#ifndef BASE_BLOCK
#define BASE_BLOCK 32768
#define baseblocks(wds)    (bytes(wds)>>15)
#define wdsbaseblock(blks) (words(blks<<15))
#endif BASE_BLOCK
#else
#define BASE_BLOCK BLOCK
#define baseblocks(wds)    blocks(wds)
#define wdsbaseblock(blks) wdsblock(blks)
#endif BLOCK

/*    Save constants  */
#ifndef MAX_BYTES_PER_WRITE
#define MAX_BYTES_PER_WRITE 4096 /* Maximum number of bytes that can be */
#endif                           /* written with a single write system-call.
				    This should be a multiple of the most
				    efficient number of bytes to write to the
				    system eg on the vax 1024.*/


#define TOP_TAG 1  /*allow 1 'word' location for the top tag -
	             a necessity for the algorithm*/

#define segment_fault(p) (((((int)(p))>>1)<<1)!=(int)(p))
#define outofbounds(p,arena) (((p)<(WORD)Xclearobject(P(bottom,arena)))||((p)>(WORD)Xclearobject(P(top,arena))))
#define corrupt_arena(arena)\
\
((getsize(TAG(&(arena->marker2)))!=mark_value+one)||(Xclearobject(P(bottom,arena))>Xclearobject(P(top,arena))))
#define address_fault(p,arena)\
\
(segment_fault(p)||outofbounds(p,arena)||corrupt_arena(arena))


static char *marena={NULL};	          /*pointer to the arena for malloc*/

#ifdef OBJECT
static int mark_value={6}, one={1}; /*Protection against using the OBJECT*/
#else                               /*code with non-object arena*/
static int mark_value={7}, one={1}; 
#endif OBJECT


#ifdef DEBUG
#ifndef DEBUGA
#define DEBUGA
#endif DEBUGA
#ifndef DEBUGI
#define DEBUGI
#endif DEBUGI
#endif DEBUG


static char errbuf[80];


#ifdef DEBUGA
/*
 * Return TRUE iff the unit p is contained in some segment of arena.
 */
static int
full_address_check(p, arena)
   register WORD  p;      /* points to lower tag of unit */
            ARENA arena;
{
   register WORD uupper;              /* last word of unit */
   register WORD upperbound;          /* upper tag of segment */
   register WORD lowerbound;          /* lower tag of segment */
   register struct segment *segment;  /* current segment */

   RO_ADRCK(arena);

   as(!corrupt_arena(arena));

   uupper = p + SIZE(p) - 1;  /* last word in unit */

   FO(segments,arena,segment,struct segment,RW);
   while (segment) do {

       /* All units in a segment must fall between the address of 
          segment->lower_tag and the address of segments upper tag
	  which is WORD(segment) + SIZE(&(segment->lower_tag)) - 1 */

       if ((WORD)segment == (WORD)(arena)) lowerbound = &(arena->marker2);
       else lowerbound = &(segment->lower_tag);
       upperbound = (WORD)(segment) + SIZE(&(segment->lower_tag)) - 1;

       if ((p > lowerbound) && (p < upperbound) &&
           (uupper > lowerbound) && (uupper < upperbound)) {
          UNLOCK(segment);
          return(TRUE);  /* unit is in this segment */
	  }

       LO_FNEXT(next,segment,struct segment,RO);
       }

    return(FALSE);
}
#else
#define full_address_check(p, arena) TRUE
#endif DEBUGA


char *
MEM(nbytes)

   unsigned nbytes;
{
   char *XMEM();

   return(XMEM(nbytes,&marena));
}

void
FREE(ap)

   char *ap;
{
   void XFREE();

   XFREE(ap,&marena);
}


char *
CMEM(nelem,elsize)

   unsigned nelem, elsize;
{
   char *XCMEM();

   return(XCMEM(nelem,elsize,&marena));
}


char *
XCMEM(nelem,elsize,arenao)

   unsigned nelem, elsize;
   char **arenao;
{
   char *rslt, *XMEM();
   register struct word *i, *end;

   rslt = XMEM(nelem*elsize,arenao);

   if (rslt E) {
        end = ((WORD)rslt) + SIZE((((WORD)rslt)-1)) - (words(SZU)-words(SZF));
        for (i=((WORD)rslt); i < end; i++) {
           TAG( i ) = NULL;
           }
        }

   return(rslt);
}


void
SMEMROOT(p)

   register char *p;
{
   marena = p;
}


char *
MEMROOT()
{
   return(marena);
}


char *
RMEM(p, nbytes)

   register char *p;
   unsigned       nbytes;
{
   char *XRMEM();

   return(XRMEM(p, nbytes, &marena));
}



char *
XRMEM(p, nbytes, arenao)

   register char *p;
   unsigned       nbytes;
   register char **arenao;
{
   char *XMEM();
   void  grabunit(), XFREE();
   register int           i;
   register char         *new_p;
   struct word           *q = ((WORD)p)-1, *top;
   unsigned               words_needed, words_there, difference;
   struct arena          *arena;

   as(SIZE(q)==SIZE2(q,SIZE(q))); 
   as(testbusy(TAG(q)));
   as(testbusy(TAG2(q,SIZE(q))));
   
   RO_ADRCK(arenao);

/* original bf code -- calculates the usable size, not the size of the 
   unit itself.

   words_needed = words(nbytes + (SZW-1));
   words_there  = SIZE(q)-(words(SZU)-words(SZF));
*/
/* bh code -- uses the size of the actual unit */
   words_needed = words(nbytes + (SZW-1)) + (words(SZU)-words(SZF));
   words_there  = SIZE(q);
/* end of change */

   if (words_there >= words_needed) { /*shrink it*/
   
        difference = words_there - words_needed;
	if (difference > words(SZU)) {
	
             /* NOTE the use of words_needed here -- this is why the above
	        change has been made (need the size of the whole unit). */

	     TAG(q) = TAG2(q,words_needed) = setsize(TAG(q),words_needed);
	     
	     q += words_needed;
	     TAG(q) = TAG2(q,difference) = setbusy(setsize(0,difference));

	     XFREE((char *)(q+1),arenao);

	     }
	     
        return(p);

	}
   else { /*enlarge it*/

        top = q + SIZE(q);
	if (!testbusy(TAG(top))) {

             difference = words_needed - words_there;
	     if (SIZE(top) >= difference) { /*run over the top of q*/

	          VO_RO((ARENA)(*arenao),arena,struct arena,RW);
	          grabunit((UNIT)top,arena,difference);
		  UNLOCK(arena);

		  difference = SIZE(q) + SIZE(top);
		  TAG(q) = TAG2(q,difference) = setsize(TAG(q),difference);
		  return(p);
		  }
	     }

        /*must move info*/

        if ((new_p=XMEM(nbytes,arenao)) DNE)
	     return(NULL);

        for (i=0; i < SIZE(q); i++) {
           TAG(((WORD)new_p) + i) = TAG(((WORD)p) + i);
           }

        XFREE(p,arenao); 
	
	UNLOCK(p);
	     
	return(new_p);

	}
}



#ifdef MAKE_THIS_NOT_OBJECT_WHEN_THE_BELOW_IS_DEBUGGED

int 
msave(fildes)

   int fildes;
{
   return(x_save(fildes,&marena));
}


char *
mrestore(fildes,error)

   int fildes, *error;
{
   char *x_restore();

   marena = x_restore(fildes,&marena,error);
   if (marena==NULL) return(NULL);
   return(marena+SZA+SZW);
}

#endif OBJECT



void 
XPOOL(arenao)

   char **arenao;
{
   void XFREE();
   register struct arena   *arena;
   register struct segment *segment;

   RO_ADRCK(arenao);
   arena=(ARENA)(*arenao);

   as(arenao!= &marena);

   VO_RO(arena,arena,struct arena,RW);
   as(!corrupt_arena(arena));

   FO(segments,arena,segment,struct segment,RW);
   while (segment E) {
      SHO_DLO_PICK(next,segment,struct segment,segments,arena,struct arena);

      XFREE((char *)segment,&marena);

      UNLOCK(segment);
      FO(segments,arena,segment,struct segment,RW);
      }

   UNLOCK(arena);
   
   *arenao = NULL;
}




/* static */ struct word *
getblock(words_needed,arenao,words_gotten)
   int        words_needed;
   char     **arenao;
   int       *words_gotten;
{
   char *XMEM();
   char *sbrk();
   char *X_sbrk();
   char *rslt;

   RO_ADRCK(arenao);

   if (*arenao != marena) {

        /*ask to get an increment of BLOCK*/
        (*words_gotten)=wdsblock( blocks( words_needed+
	                                  TOP_TAG+
					  Xwords_for_segment+
					  words(BLOCK)
					 )
                                );

        (*words_gotten) = (*words_gotten) - Xwords_for_segment - TOP_TAG - words(SZU-SZF);
        rslt=XMEM((unsigned)bytes(*words_gotten),&marena);
#ifdef DEBUGI
        if (!rslt) 
	     fprintf(stderr,"XMEM(%d,&marena) returned NULL in getblock.\n",
	                     bytes(*words_gotten));
#endif DEBUGI
        return((rslt==NULL) ? (WORD)-1 : (WORD)rslt);
	}
   else {

        /*ask to get an increment of BASE_BLOCK*/
        (*words_gotten)=wdsbaseblock( baseblocks( words_needed+
	                                          TOP_TAG+
						  Xwords_for_segment+
						  words(BASE_BLOCK)
						 )
                                    );

#ifdef OBJECT
        rslt=X_sbrk(bytes(*words_gotten));
#ifdef DEBUGI
        if (!rslt)
	     fprintf(stderr,"X_sbrk(%d) returned NULL in getblock.\n",
	                    bytes(*words_gotten));
#endif DEBUGI
        return((WORD)rslt);     
#else

        rslt=sbrk(bytes(*words_gotten));

	if (SBRK_FAILS==(int)rslt) {
	     sprintf(errbuf,"sbrk(%d) returned failure in getblock\n",
	                     bytes(*words_gotten));
             write(2, errbuf, strlen(errbuf));
             }

        return((WORD)rslt);     
#endif OBJECT
        }
}


#define slot_index(nwords,index)\
\
if ((index=(nwords)-words(SZU)) > NUMBER_OF_SLOTS)\
     index=NUMBER_OF_SLOTS




#define free_unit(unit_ptr,arena_ptr)\
{\
unsigned index;\
register struct free_slot *slot, *saveslot;\
\
slot_index(SIZE((WORD)unit_ptr),index);\
/*            &(arena_ptr->free_slots[index]);*/\
slot=saveslot=(struct free_slot *)(((char *)(arena_ptr->free_slots))+(index<<3));\
\
if (!F(units,slot)) { /*slot changed from empty to non-empty*/\
     register struct free_slot *start;\
     start= arena_ptr->free_slots;\
     slot--;\
     if (slot >= start) {\
          if (slot->next_largest != index) {\
               do {\
                  slot->next_largest=index;\
                  if (F(units,slot)) break;\
	          slot--;\
                  }\
	          while (slot >= start);\
	       }\
          }\
     }\
SHO_DRO_FQUE(free.list,unit_ptr,struct unit,units,saveslot,struct free_slot);\
}


#define subpoena_unit(unit_ptr)\
{\
unsigned index;\
register struct free_slot *slot;\
slot_index(SIZE((WORD)(unit_ptr)),index);\
/*     &(arena->free_slots[index]);*/\
slot = (struct free_slot *)(((char *)(arena->free_slots))+(index<<3));\
SHO_DRO_PICK(free.list,unit_ptr,struct unit,units,slot,struct free_slot);\
}



/* static */ void
grabunit(unit,arena,nwords)

   struct unit           *unit;
   struct arena          *arena;
   unsigned               nwords;
{
   register struct free_slot *inslot;
   unsigned                   size, leftover;
   int                        old_index;
   unsigned                   mbytes;

   size=SIZE((WORD)unit);
   as(size >= nwords);

#ifdef DEBUG
   fprintf(stderr,"grabunit %d words from (%d-%d)\n",nwords,
           (testbusy(TAG((WORD)unit)))?1:0, size);
   fprintf(stderr,"    free_size was %d, busy_size was %d\n", 
           arena->free_size, arena->busy_size);
#endif DEBUG
   slot_index(size,old_index);
   /*      &(arena->free_slots[old_index]);*/
   inslot=(struct free_slot *)(((char *)(arena->free_slots))+(old_index<<3));
   SHO_DRO_PICK(free.list,unit,struct unit,units,inslot,struct free_slot);

   leftover = size-nwords;

   if (leftover < words(SZU) ) { /*give the entire thing*/
             
        TAG((WORD)unit) = TAG2((WORD)unit,size) = setbusy(TAG((WORD)unit));
             
        mbytes = bytes(size);

        }
   else {                                       /*give a portion of it*/
        register struct word *q;
	int                   new_index;

        q  = ((WORD)unit)+nwords;

        TAG(q) = TAG2(q,leftover) = clearbusy(setsize(TAG(q),leftover));

        DRO_NULL(free.list,(UNIT)q);
	
	slot_index(leftover,new_index);
	if (old_index==new_index) { /*no need to alter the free_slot table*/

             SHO_DRO_FQUE(free.list,(UNIT)q,struct unit,units,inslot,struct free_slot);
             
	     }
        else {                      /*unit is re-distributed in slot_table*/

	     free_unit((UNIT)q,arena);             

	     }
            
        TAG((WORD)unit) = TAG2((WORD)unit,nwords) = setbusy(setsize(TAG((WORD)unit),nwords));
	     
        mbytes = bytes(nwords);
             
        }

   arena->free_size -= mbytes;
   arena->busy_size += mbytes;

#ifdef DEBUG
   fprintf(stderr,"    free_size is %d, busy_size is %d\n", 
           arena->free_size, arena->busy_size);
#endif DEBUG
}


char *
XMEM(nbytes,arenao)

   unsigned nbytes;
   char **arenao;
{
   void XFREE();
   struct arena *arena, *arenav;
   struct unit  *unit;
   struct word  *p, *q, *vbottom, *top, *vtop;
   int           nwords, words_gotten, size;
   int           mbytes;
   register int  index;

   if (!marena) { /*need marena*/
        if (arenao != &marena) { /*not called with marena*/
	     marena=XMEM(0,&marena);
	     }
        else { /*called with marena*/
	     if (nbytes) marena=XMEM(0,&marena);
	     }
	}

   RO_ADRCK(arenao);
   arenav=(ARENA)(*arenao);

   if (!arenav) {

        as(bytes(1)==SZW);
        as(words(SZW)==1);
	as(sizeof(struct free_slot)==8);

        as((BLOCK%SZW)==0);  
        as((BASE_BLOCK%SZW)==0);  
	/*enough room for at least the arena and a unit*/
        as(words(BLOCK)>Xwords_for_arena+words(SZU)+TOP_TAG);
        as(words(BASE_BLOCK)>Xwords_for_arena+words(SZU)+TOP_TAG);

        as(words(BASE_BLOCK)==wdsbaseblock(1));
	as(1==baseblocks(words(BASE_BLOCK)));
        as(words(BLOCK)==wdsblock(1));
	as(1==blocks(words(BLOCK)));

	as((SZU%SZW)==0);
	as((SZF%SZW)==0);
        as(SZS==SZF);        /*insures a unit's members are on word bounds*/
            
        if (nbytes!=0) {
#ifdef DEBUGI
             fprintf(stderr,"arena is NULL but nbytes is %d\n",nbytes);
#endif DEBUGI
	     return(NULL);
	     }

        arena = (ARENA)getblock(Xwords_for_arena+words(SZU)+TOP_TAG,
	                        arenao,&words_gotten);

#ifdef DEBUG
        fprintf(stderr,"x_allocate Initializing arena: arena=%d, bytes_gotten=%d\n",
	               arena,bytes(words_gotten));
#endif DEBUG

        if((int)arena == -1) {  
             return(NULL);
             }

        PDO(&(arena->segment),segment.this,arena,struct segment);
        DLO_NULL(segment.next,arena);
	/*set segment's boundary tags*/
	as(!sizeovrflo(words_gotten));
        TAG(&(arena->segment.lower_tag)) = TAG(((WORD)arena)+words_gotten-1) = setbusy(setsize(0,words_gotten));
             
        PDO((WORD)arena,bottom,arena,struct word);
        PDO(((WORD)arena)+words_gotten-1,top,arena,struct word);
        arena->size                  = bytes(words_gotten);
        arena->busy_size             = bytes(Xwords_for_arena+TOP_TAG);
        arena->free_size             = bytes(words_gotten) - arena->busy_size;
        arena->num_of_seg            = 1;
        SHO_NULL(segments,arena);

        SHO_DLO_FQUE(next,&(arena->segment),struct segment,segments,arena,struct arena);

        {
	register int               i;
	register struct free_slot *fs;

        for (i=0; i<FREE_SLOT_SIZE; i++) {
	   /* arena->free_slots[i] */
           fs= (struct free_slot *)(((char *)(arena->free_slots))+(i<<3));
	   SHO_NULL(units,fs);
	   fs->next_largest = NULL;
	   }
        }

        /*set arena marker flag - corruption test value and busy flag*/
        TAG(&(arena->marker2)) = setbusy(setsize(0,mark_value+one));

        /*make initial unit*/
        unit=(UNIT)(((WORD)arena) + Xwords_for_arena);
	
	size = words_gotten - (Xwords_for_arena+TOP_TAG);
	as(!sizeovrflo(size));
        TAG((WORD)unit) = TAG2((WORD)unit,size) = clearbusy(setsize(0,size));

        DRO_NULL(free.list,unit);
        free_unit(unit,arena);
	
	RO_VO(arena,arenav,struct arena);
	UNLOCK(arena);

#ifdef DEBUG
        fprintf(stderr,"    free_size is %d, busy_size is %d, size is %d\n", 
                arena->free_size, arena->busy_size, arena->size);
#endif DEBUG
        
        return((char *)arenav); /*an ^> is returned*/
        }

#ifdef DEBUG
   fprintf(stderr,"x_allocate: Going to allocate %d bytes.\n",nbytes);
#endif DEBUG

   VO_RO(arenav,arena,struct arena,RW);

   as(!corrupt_arena(arena));
        
   if (!nbytes) {
        /*Note that return is an ^> if this is compiled for OBJECT*/
	UNLOCK(arena);
        return((char *)(P(top,arena)+1));
        }

   if ((nwords=words(nbytes+(SZU-SZF)+(SZW-1))) < words(SZU)) 
        nwords = words(SZU);

   if (sizeovrflo(nwords)) { 
#ifdef DEBUGI
        fprintf(stderr,"%d bytes is too many in one request.\n",nbytes);
#endif DEBUGI
        UNLOCK(arena);
	return(NULL);
	}

#ifdef OBJECT
   if (nwords > words(BLOCK)-(Xwords_for_segment+TOP_TAG)) {
        fprintf(stderr,"x_allocate: Request for %d bytes > %d. Not implemented.\n",
	      bytes(nwords),bytes(words(BLOCK)-(Xwords_for_segment+TOP_TAG)));
	UNLOCK(arena);
        return(NULL);
	}
#endif OBJECT

   slot_index(nwords,index);

   if (index < NUMBER_OF_SLOTS) { /*use slots for allocation*/

        register struct free_slot *slot;

        /*   &(arena->free_slots[index]);*/
        slot=(struct free_slot *)(((char *)(arena->free_slots))+(index<<3));

        if ((unit=F(units,slot))) {
             VO_RO(unit,unit,struct unit,RW);
	     }
        else {
             register int inindex;
	     register struct free_slot *iterator;

             if (index > 0)
                  (slot-1)->next_largest=NULL;

	     iterator=slot;

             do {
                if ((inindex=iterator->next_largest)) {
		     /*         &(arena->free_slots[inindex]);*/
                     iterator =(struct free_slot *)(((char *)(arena->free_slots))+(inindex<<3));
   	             index=inindex;
 	             }
                else {
                     iterator++;
	             index++;
	             }

                if (index >= FREE_SLOT_SIZE) break;

                if ((unit=F(units,iterator))) {
                     VO_RO(unit,unit,struct unit,RW);
	             }
                else (iterator-1)->next_largest=NULL;
                }
                while (!unit);

             slot->next_largest=index;
 	     }
        }
   else {                      /*use linear search*/
        FO(free_slots[NUMBER_OF_SLOTS].units,arena,unit,struct unit,RW);
        while (unit) {
	    if (SIZE(((WORD)unit)) >= nwords) break;
	    RO_FNEXT(free.list,unit,struct unit,free_slots[NUMBER_OF_SLOTS].units,arena,RW);
	    }
        }

   if (!unit) { /*getmore storage*/

	p = getblock(nwords,arenao,&words_gotten);

#ifdef DEBUG
        fprintf(stderr,"x_allocate: Gotten more: p=%d, bytes_gotten=%d\n",
	               p,bytes(words_gotten));
        fprintf(stderr,"    free_size was %d, busy_size was %d, size was %d\n", 
                arena->free_size, arena->busy_size, arena->size);
#endif DEBUG

        if((int)p == -1) {
	     UNLOCK(arena);
             return(NULL);
             }

        top  = p + words_gotten - 1;
        RO_VO(p,vbottom,struct word);
	vbottom=(WORD)Xclearobject(vbottom);

        mbytes=bytes(words_gotten);
        arena->size      += mbytes;
        arena->busy_size += mbytes;   /*create a new unit then free it*/

#ifdef DEBUG
        fprintf(stderr,"    free_size is %d, busy_size is %d, size is %d\n", 
                arena->free_size, arena->busy_size, arena->size);
#endif DEBUG

        /* separate blocks are considered individual segments in the OBJECT
           mode to eliminate (except for large units) units which would
	   otherwise overlap block bounds and cause pageing*/

#ifndef OBJECT
        if (vbottom!=(((WORD)Xclearobject(P(top,arena)))+1)) {
#ifdef DEBUG
             fprintf(stderr,"Non-contiguous storage obtained. ");
             fprintf(stderr,"Arena top '%d'; getblock '%d'\n",
                               Xclearobject(P(top,arena)),vbottom);
#endif DEBUG
#endif OBJECT

make_segment:
             arena->num_of_seg++;
             
	     /*make new segment*/
             PDO((SEG)p,this,(SEG)p,struct segment);
             DLO_NULL(next,(SEG)p);
             TAG(&(((SEG)p)->lower_tag)) = TAG(top) = setbusy(setsize(0,words_gotten));
             SHO_DLO_FQUE(next,(SEG)p,struct segment,segments,arena,struct arena);

	     /*make new unit*/
             size = words_gotten - Xwords_for_segment - TOP_TAG;
             unit = (UNIT)(p     + Xwords_for_segment);
             TAG((WORD)unit) = TAG2((WORD)unit,size) = setbusy(setsize(0,size));

             /*adjust arena bounds as necessary*/
             RO_VO(top,vtop,struct word);
	     vtop=(WORD)Xclearobject(vtop);
	     if (vtop > ((WORD)Xclearobject(P(top,arena)))) {
	          PDO(top,top,arena,struct word);
	          }
             else 
             if (vbottom < ((WORD)Xclearobject(P(bottom,arena)))) {
	          PDO((WORD)unit,bottom,arena,struct word);
	          }

             XFREE((char *)(((WORD)unit)+1),arenao);
             }

#ifndef OBJECT
        else { /*got contiguous storage*/
            
	     PO(top,arena,q,struct word,RO);
             size = SIZE(q);              /*size of this segment*/
	     UNLOCK(q);
	     
	     if (sizeovrflo(size+words_gotten)) 
	          goto make_segment;
             
	     /*fixup segment*/
	     q = P(top,arena) - (size-1);
	     VO_RO(q,q,struct word,RW);
             TAG(top) = TAG(&(((SEG)q)->lower_tag)) = setbusy(setsize(0,size+words_gotten));
	     UNLOCK(q);
             
	     PDO(top,top,arena,struct word);

             /*make new unit*/
             p=p-TOP_TAG;     /*the previous highest location was a high-tag*/
             TAG(p) = TAG2(p,words_gotten) = setbusy(setsize(0,words_gotten));

             XFREE((char *)(p+1),arenao);
	     UNLOCK(arena);
             return(XMEM(nbytes,arenao));
             }
        }         
#endif OBJECT

   /*gotspace*/

   grabunit(unit,arena,(unsigned)nwords);
   
   UNLOCK(arena);             

/* x_darena((char *)arena); x_dunit("q",(char *)(q+1)); */

   return((char *)(((WORD)unit) + 1));
}


void
XFREE(po,arenao)

   register char *po, **arenao;
{
   register struct arena *arena;
   register struct word  *p = ((WORD)po)-1;
#ifdef DEBUGI
   register struct word  *vp;
   register struct word  *vlower, *vupper;
#endif DEBUGI
   register struct word  *lower, *upper;
   register unsigned      size, sizel, sizeu;
   unsigned               mbytes;

   RO_ADRCK(arenao);
   VO_RO((ARENA)(*arenao),arena,struct arena,RW);

   as(!corrupt_arena(arena));

#ifdef DEBUGI
   RO_VO(p,vp,struct word);
   vp=(WORD)Xclearobject(vp);
   as(!address_fault(vp,arena));
   as(!address_fault(vp+SIZE(p),arena));
#endif DEBUGI
   as(testbusy(TAG(p)));
   as(testbusy(TAG(p))==testbusy(TAG2(p,SIZE(p))));
   as(SIZE(p)==SIZE2(p,SIZE(p)));

   as(full_address_check(p, arena));

   DRO_NULL(free.list,(UNIT)p);

   size = SIZE(p);

   mbytes = bytes(size);

#ifdef DEBUG
   fprintf(stderr,"x_pool arena=%d unit=%d size=%d (%d bytes)\n",
           arena, p, size, mbytes);
   fprintf(stderr,"    free_size was %d, busy_size was %d\n", 
           arena->free_size, arena->busy_size);
#endif DEBUG

   arena->free_size += mbytes;
   arena->busy_size -= mbytes;

#ifdef DEBUG
   fprintf(stderr,"    free_size is %d, busy_size is %d\n", 
           arena->free_size, arena->busy_size);
#endif DEBUG

   upper = p + size;
#ifdef DEBUGI
   RO_VO(upper,vupper,struct word);
   vupper=(WORD)Xclearobject(vupper);
   as(!address_fault(vupper,arena));
#endif DEBUGI
   sizeu = SIZE(upper);

   if (!testbusy(TAG(p-1))) {                /*lower block is free*/

        sizel = SIZE(p-1);
        lower = p - sizel;

#ifdef DEBUGI
        RO_VO(lower,vlower,struct word);
	vlower=(WORD)Xclearobject(vlower);
	as(!address_fault(vlower,arena));
#endif DEBUGI
        as(SIZE(lower)==SIZE(p-1));
	as(testbusy(TAG(lower))==testbusy(TAG(p-1)));

        subpoena_unit((UNIT)lower);

        TAG(p-1) = TAG(p) = NULL;

        if (!testbusy(TAG(upper))) {        /*upper block is also free*/
                 
#ifdef DEBUGI
             RO_VO(upper+sizeu,vupper,struct word);
	     vupper=(WORD)Xclearobject(vupper);
             as(!address_fault(vupper,arena));
#endif DEBUGI
             as(SIZE(upper)==SIZE2(upper,sizeu));

             subpoena_unit((UNIT)upper);
             
             size += sizel + sizeu;

             as(!sizeovrflo(size));
             TAG(lower)=TAG2(lower,size)=clearbusy(setsize(TAG(lower),size));
	     free_unit((UNIT)lower,arena);

             /*TAG2(p,SIZE(p)) = TAG(upper) = NULL;*//*SIZE(p) is gone*/
	     TAG(upper-1) = TAG(upper) = NULL;
             }
        else {                                 /*only lower is free*/
             size += sizel;

             as(!sizeovrflo(size));
             TAG(lower)=TAG2(lower,size)=clearbusy(setsize(TAG(lower),size));

             free_unit((UNIT)lower,arena);
             }
        }
   else {
        if (!testbusy(TAG(upper))) {          /*upper block is free*/
                                              /*lower block is busy*/
#ifdef DEBUGI
             RO_VO(upper+sizeu,vupper,struct word);
	     vupper=(WORD)Xclearobject(vupper);
             as(!address_fault(vupper,arena));
#endif DEBUGI
             as(SIZE(upper)==SIZE2(upper,sizeu));

             subpoena_unit((UNIT)upper);    
             
             size += sizeu;
             
             as(!sizeovrflo(size));
             TAG(p) = TAG2(p,size) = clearbusy(setsize(TAG(p),size));

             free_unit((UNIT)p,arena);
	     
	     TAG(upper-1) = TAG(upper) = NULL;
             }
        else {                                     /*neither is free*/
             TAG(p) = TAG2(p,size) = clearbusy(TAG(p));
             
             free_unit((UNIT)p,arena);
             }
        }

   UNLOCK(arena);
}

#ifdef MAKE_THIS_NOT_OBJECT_WHEN_THE_BELOW_IS_DEBUGGED

int 
x_save(fildes,arenao)

   register int fildes;
   register char *arenao;
{
   register struct arena *arena=(ARENA)arenao;
   register struct segment *seg;

   if (arenao==NULL) return(-2);
   ap(!corrupt_arena(arena));
   seg = P(segment.this,arena);
   do {
      if (save_seg(fildes,seg,arena)!=0) {
           return(-1);
           }
      L_FNEXT(next,seg);
      } while (seg);

   return(0);
}


static int 
save_seg(fildes,seg,arena)

   register struct arena *arena;
   register int fildes;
   register struct segment *seg;
{
   register int size, bytes;

   bytes = bytes(SIZE(seg->lower_tag));
   while (bytes>0) {
       if (bytes>=MAX_BYTES_PER_WRITE) size = MAX_BYTES_PER_WRITE;
       else                            size = bytes;
       as((size%SZW)==0);
       /*printf("seg=%d this=%d size=%d bytes=%d\n",seg,seg->this,size,bytes);*/
       as(!address_fault((WORD)seg,arena));
       as(!address_fault(((WORD)seg)+(size/SZW)-(SZU/SZW)-1,arena));
       if (size!=write(fildes,(char *)seg,size)) {
            return(-1);
            }
       bytes -= size;
       seg = (SEG)( ((WORD)seg) + words(size) );
       }
   return(0);
}

static struct segment *mnext, *mlow;
static union store *mhigh;
static int virgin_load;
char *x_restore(fildes,arenao,error)

register char *arenao;
register int fildes, *error;
{
char *sbrk();
int read_seg();
static struct segment dummy, *seg={&dummy};
register struct arena *arena;
register int size; 
   
   if ( (arenao==NULL) || (arenao+SZA+SZU>sbrk(0)) ) virgin_load = -1;
   else {
        ap(!corrupt_arena(((ARENA)arenao)));
        virgin_load = 0;
        mnext = &(((ARENA)arenao)->segment);
        mlow = mnext->this;
        mhigh= (WORD)(mnext->this)+mnext->size.tag/SZW;
        mnext=mnext->next;
        }

   arena = NULL;
   for (;;) { 
      if ( ( size=read(fildes,(char *)seg,SZ_SEG) )!=SZ_SEG) {
           if (size==0) {
                return((char *)arena); }
           else {*error = -10; return(NULL);}
           }
      /*printf("this=%d,size=%d,next=%d,lower_tag=%o\n",seg->this,seg->size,
                                                    seg->next,seg->lower_tag);*/
      if (arena!=NULL) {
           if ( ((WORD)seg->this<arena->bottom.ptr)||
              (((WORD)seg->this)+(seg->size.tag/SZW)-1>arena->top.ptr)) {
                *error = -11; return(NULL);}
           }
      if (seg->lower_tag.tag!=setbusy(mark_value+one)) {
           *error = -12;return(NULL);
           }
      if ( virgin_load && ((char *)(seg->this) < sbrk(0)) ) {
           *error = -20; return(NULL);
           }
      if ((*error=read_seg(fildes,seg))!=0) return(NULL);
      if (arena==NULL) arena=(ARENA)(seg->this);
   }
}


static int read_seg(fildes,seg)

register int fildes;
register struct segment *seg;
{
int read();
char *sbrk(), *brk();
register char *sys_break, *new_break;
register int i, bytes, size;
register union store *restore;
  
   sys_break = sbrk(0);
   
   if ( virgin_load ) {
        if ((new_break=(char *)((WORD)(seg->this)+(seg->size.tag)/SZW))>sys_break){
             /*printf("newbrk=%d\n",new_break);*/
             if (brk(new_break)!=0) return(-30);
             }
        }
   else {
        while( !( ( mlow  <= seg->this ) &&
                  ( mhigh >= (WORD)(seg->this)+seg->size.tag/SZW )
                                                           ) ) {
             if (mnext==NULL) {/* file seg must fit into last mem seg + sbrk()*/
                  if ( (mlow<=seg->this) && (mhigh==(WORD)sys_break) ) {
                       virgin_load = -1;
                       return(read_seg(fildes,seg));
                       }
                  else return(-22);
                  }
             else {
                  ap((char *)mnext<sys_break);
                  mlow = mnext->this;
                  mhigh= (WORD)(mnext->this)+mnext->size.tag/SZW;
                  mnext=mnext->next;
                  }
             }
        }
   
   for (i=0; i<(SZ_SEG/SZW); i++) {
       ( (WORD)(seg->this)+i )->ptr = ( ((WORD)seg)+i )->ptr;
       }
   
   bytes = seg->size.tag - SZ_SEG;
   restore = (WORD)(seg->this) + (SZ_SEG/SZW);
   while (bytes>0) {
       if (bytes>=MAX_BYTES_PER_WRITE) size = MAX_BYTES_PER_WRITE;
       else                            size = bytes;
       /*printf("restore=%d size=%d bytes=%d\n",restore,size,bytes);*/
       if (size!=read(fildes,(char *)restore,size)) {
            return(-13);
            }
       bytes -= size;
       restore = restore + size/SZW;
       }
   return(0);
}

#endif OBJECT
