#ifndef VM_H_INCLUDED
#define VM_H_INCLUDED
/* This file is included for the benefit of the Bob Floyd library.
   It can be eliminated when they have been rewritten without the
   homebrew VM stuff. */

#ifndef BDS_M_INCLUDED    /*save a little time for most cases*/
#include "../bds/bds.m.h"
#endif BDS_M_INCLUDED

#define VO_ADRCK(vo) ADRCK(vo);
#define RO_ADRCK(ro) ADRCK(ro);

#define PAGE_SIZE     1024  /*in bytes, a power of two*/
#define PAGE_POWER      10  /*page size as a power of two*/



/*--------------------------------------------------------------------------*/

/*convert virtual object pointer into real object pointer, lock the object.

  vo   => ^> to object, in virtual space.
  ro   => -> to object, in real space: set in macro.
  type => type of ro (-> is assumed).
  dirty=> either RW, or RO, to indicate read/write or read-only access.
                                                                          */

#define V_R(vo,ro,type,dirty) (ro=vo)


#define VO_RO(vo,ro,type,dirty) V_R(vo,ro,type,dirty)

/*--------------------------------------------------------------------------*/

/*convert real object pointer into virtual object pointer.

  ro   => -> to object, in real space.
  vo   => ^> to object, in virtual space; set in macro.
  type => type of ro (-> is assumed).

                                                                          */
#define R_V(ro,vo,type) (vo = ro)

#define RO_VO(ro,vo,type) R_V(ro,vo,type)

/*--------------------------------------------------------------------------*/

/*lock a real object

  ro   => -> to object, in real space.

  BEWARE: Lock does not make the object writeable.
                                                                           */
#define LOCK(ro) NOP(ro)

/*--------------------------------------------------------------------------*/

/*unlock a real object

  ro   => -> to object, in real space.
                                                                           */
#ifdef lint
#define UNLOCK(ro) {if (ro) ;} /* so it gets "used" for lint's purposes */
#define UNLOCK_IF_E(ro) {if (ro) ;} /* so it gets "used" for lint's purposes */
#else
#define UNLOCK(ro) NOP(ro)
#define UNLOCK_IF_E(ro) NOP(ro)
#endif lint

/*--------------------------------------------------------------------------*/

/*dirty a real object

  ro   => -> to object, in real space.
                                                                           */
#define DIRTY(ro) NOP(ro)

#define RW(ro)  DIRTY(ro)
#define RO(ro)  ;


/*--------------------------------------------------------------------------*/

/*
   check locks
*/

#define LOCKED_PAGES 0!=0

#define UPDATE       NOP(x)

#define Xtestobject(p)  (0!=0)
#define Xsetobject(p)   ((int)(p))
#define Xclearobject(p) ((int)(p))


#endif VM_H_INCLUDED
