#ifndef BDS_M_INCLUDED
#define BDS_M_INCLUDED

#include "../misc/constants.h"
#include "bds.s.h"
#include "vm.h"


/*                M A N I P U L A T I N G      M A C R O S                    */

/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Null an SH structure

   rec_sh  ==> name within record of SH member (variable) to be nulled.
   rec     ==> -> to record containing the SH structure to be nulled. */

#define SH_NULL(rec_sh,rec)\
{\
as((rec) E);\
(rec)->rec_sh.fp = NULL;\
}

#define SHO_NULL SH_NULL

/*----------------------------------------------------------------------------*/

/* Null an SL structure

   rec_sl  ==> name within record of SL member (variable) to be nulled.
   rec     ==> -> to record containing the SL structure to be nulled. */

#define SL_NULL(rec_sr,rec)\
{\
as((rec) E);\
(rec)->rec_sr.fpl = NULL;\
}

#define SLO_NULL SL_NULL

/*----------------------------------------------------------------------------*/

/* Null a PTR or DPTR structure

   rec_ptr ==> name within record of PTR or DPTR member (variable) to be
		  nulled.
   rec     ==> -> to record containing the PTR or DPTR structure to be
		  nulled. */

#define PTR_NULL(rec_ptr,rec)\
{\
as((rec) E);\
(rec)->rec_ptr.p = NULL;\
}

#define DPTR_NULL PTR_NULL

#define PTRO_NULL PTR_NULL

#define DPTRO_NULL PTRO_NULL

/*----------------------------------------------------------------------------*/

/* Null a DRH

   rec_drh ==> name within record of DRH member to be nulled.
   rec     ==> -> to record containing the DRH structure to be nulled.
									      */

#define DRH_NULL(rec_drh,rec)\
{\
as((rec) E);\
(rec)->rec_drh.fp = (rec)->rec_drh.bp = NULL;\
(rec)->rec_drh.hp = NULL;\
}

#define DRHO_NULL DRH_NULL

/*----------------------------------------------------------------------------*/

/* Null a DR structure

   rec_dr  ==> name within record of DR member to be nulled.
   rec     ==> -> to record containing the DR structure to be nulled.
									      */

#define DR_NULL(rec_dr,rec)\
{\
as((rec) E);\
(rec)->rec_dr.fp = (rec)->rec_dr.bp = NULL;\
}

#define DRO_NULL DR_NULL

#define DL_NULL(rec_drcl,rec)\
as(rec);\
(rec)->rec_drcl.fpl = (rec)->rec_drcl.bpl = NULL

#define DLO_NULL DL_NULL

/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/

/*
    SR operations -- operations on a singly linked ring, with binding element
    (SRH) pointing to the rearmost element.
*/

#define SHR_NULL(rec_hd,hd)\
    { as(hd); (hd)->rec_hd.tailp = NULL; }

#define SR_NULL(rec_sr,rec)\
    { as(rec); (rec)->rec_sr.srp = NULL; }

/* Return head */
#define SH_SR_HEAD(rec_sr, rec_hd, hd)\
    ((hd)->rec_hd.tailp ? (hd)->rec_hd.tailp->rec_sr.srp : 0)

/* Return next element in ring -- 0 if current element is rearmost. */
#define SH_SR_NEXT(rec_sr, rec, rec_hd, hd)\
    ((rec) == (hd)->rec_hd.tailp ? 0 : (rec)->rec_sr.srp)

/* Rotate so that second element becomes head, head becomes rearmost */
#define SH_SR_ROTATE(rec_sr, rec_hd, hd)\
    { if ((hd)->rec_hd.tailp) (hd)->rec_hd.tailp = (hd)->rec_hd.tailp->rec_sr.srp; }

/* Insert at head */
#define SH_SR_FQUE(rec_sr, rec, rec_hd, hd)\
{\
    as(!((rec)->rec_sr.srp));\
    if (!((hd)->rec_hd.tailp)) (hd)->rec_hd.tailp = (rec)->rec_sr.srp = (rec);\
    else {\
        (rec)->rec_sr.srp = (hd)->rec_hd.tailp->rec_sr.srp;\
	(hd)->rec_hd.tailp->rec_sr.srp = (rec);\
	}\
}
    
/* Insert at rear */
#define SH_SR_RQUE(rec_sr, rec, rec_hd, hd)\
{\
    SH_SR_FQUE(rec_sr, rec, rec_hd, hd);\
    (hd)->rec_hd.tailp = (hd)->rec_hd.tailp->rec_sr.srp; /* rotate */\
}

/* Insert after given (prev) element */
#define SH_SR_INSERT(rec_sr, rec, prev, rec_hd, hd)\
{\
    as(prev);  as(rec);  as(prev->rec_sr.srp);  as(!(rec->rec_sr.srp));\
    (rec)->rec_sr.srp = prev->rec_sr.srp;\
    prev->rec_sr.srp = (rec);\
    if ((hd)->rec_hd.tailp == (prev)) (hd)->rec_hd.tailp = (rec);\
}

/* Pick the specified element -- if prev is NULL, then topick must be head */
#define SH_SR_PICK(rec_sr, topick, prev, rec_hd, hd)\
{\
    as((hd)->rec_hd.tailp);\
    as(topick);\
    if (!(prev)) {\
	as((hd)->rec_hd.tailp->rec_sr.srp == (topick));\
	(hd)->rec_hd.tailp->rec_sr.srp = (topick)->rec_sr.srp;\
	}\
    else {\
	as((prev)->rec_sr.srp == (topick));\
	(prev)->rec_sr.srp = (topick)->rec_sr.srp;\
	if ((hd)->rec_hd.tailp == (topick)) (hd)->rec_hd.tailp = (prev);\
	}\
    if ((hd)->rec_hd.tailp == (topick)) (hd)->rec_hd.tailp = NULL;\
    SR_NULL(rec_sr, topick);\
}

/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Fetch the record which Binds (is the header for) the indicated DRH
   structure:

   rec_drh    ==> name within the record of DRH member grouped.
   rec        ==> -> to the record containing the grouped DRH member.

***Not assertion proofed.
									      */

#define B(rec_drh,rec)((rec)->rec_drh.hp)

#define BO(rec_drh,rec,val,type,dirty) (val=B(rec_drh,rec))

/*----------------------------------------------------------------------------*/

/* Fetch the record which is pointed to by the indicated PTR or DPTR structure:

   rec_ptr    ==> name within the record of PTR or DPTR member.
   rec        ==> -> to the record containing the PTR or DPTR member.     

***Not assertion proofed.
                                                                              */
#define P(rec_ptr,rec)((rec)->rec_ptr.p)

/*
   val           ==> set as -> to record pointed at by the above.
   type          ==> type of val, ie struct x.
   dirty         ==> RW or RO.
*/
#define PO(rec_ptr,rec,val,type,dirty)\
\
as((rec) E);\
if ((val=(rec)->rec_ptr.p) E) {\
     VO_RO(val,val,type,dirty);\
     }\
else val=NULL;

/*----------------------------------------------------------------------------*/

/* Set the indicated PTR or DPTR structure to point to the given record:
   Destroy any existing pointer.

   rec_ptr    ==> name within the record of PTR or DPTR member.
   rec        ==> -> to the record containing the PTR or DPTR member.      
   val        ==> set as -> to record pointed at by the above.
*/

#define PD(val,rec_ptr,rec) ((rec)->rec_ptr.p = val)
#define PDO(val,rec_ptr,rec,type) PD(val,rec_ptr,rec)


/*----------------------------------------------------------------------------*/

/* Set the indicated PTR or DPTR structure to point to the given record:

   rec_ptr    ==> name within the record of PTR or DPTR member.
   rec        ==> -> to the record containing the PTR or DPTR member.      */

#define PT(rec_ptr,rec)\
\
as((rec) E);\
as((rec)->rec_ptr.p DNE);\
(rec)->rec_ptr.p

/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Pick a DRH structure from it's SH list:

   rec_drh ==> name within record of DRH member to be picked.
   rec     ==> -> to the record containing the DRH structure to be picked.
   hd_sh   ==> name within head record of SH member to which the DRH
		  structure to be picked is grouped in.
   NOTE 1: SH queue contains same type records and DRH members. */

#define Xsh_drh_pick(rec_drh,reci,hd_sh)\
{\
as(((reci)->rec_drh.fp)->rec_drh.bp==(reci));\
as(((reci)->rec_drh.bp)->rec_drh.fp==(reci));\
as(((reci)->rec_drh.fp)->rec_drh.hp==(reci)->rec_drh.hp);\
as(((reci)->rec_drh.bp)->rec_drh.hp==(reci)->rec_drh.hp);\
((reci)->rec_drh.fp)->rec_drh.bp = (reci)->rec_drh.bp;\
((reci)->rec_drh.bp)->rec_drh.fp = (reci)->rec_drh.fp;\
if ((reci) == ((reci)->rec_drh.hp)->hd_sh.fp) {\
   if ((reci) == ((reci)->rec_drh.fp))\
	((reci)->rec_drh.hp)->hd_sh.fp = NULL;\
   else ((reci)->rec_drh.hp)->hd_sh.fp = (reci)->rec_drh.fp;\
   }\
DRH_NULL(rec_drh,(reci));\
}

#define SH_DRH_PICK(rec_drh,reci,type,hd_sh,htype) \
Xsh_drh_pick(rec_drh,reci,hd_sh)

#define SHO_DRHO_PICK SH_DRH_PICK

/*----------------------------------------------------------------------------*/

/* Pick a DR structure from it's SH list:

   rec_dr ==> name within record of DR member to be picked.
   rec     ==> -> to the record containing the DR structure to be picked.
   hd_sh    ==> name within head record of SH member to which the DR
		  structure to be picked is grouped in.
   hd         ==> -> to the head record containing the SH structure to which
		  the DR structure is queued.
   NOTE 1: SH queue contains same type records and DR members. */

#define SH_DR_PICK(rec_dr,reci,hd_sh,hdi)\
{\
ADRCK(reci);\
as(((reci)->rec_dr.fp)->rec_dr.bp == (reci));\
as(((reci)->rec_dr.bp)->rec_dr.fp == (reci));\
(reci)->rec_dr.fp->rec_dr.bp = (reci)->rec_dr.bp;\
(reci)->rec_dr.bp->rec_dr.fp = (reci)->rec_dr.fp;\
if ((reci) == (hdi)->hd_sh.fp) {\
   if ((reci) == ((reci)->rec_dr.fp))\
	(hdi)->hd_sh.fp = NULL;\
   else (hdi)->hd_sh.fp = (reci)->rec_dr.fp;\
   }\
DR_NULL(rec_dr, reci);\
}

#define SHO_DRO_PICK(rec_dr,rec,type,hd_sh,hd,htype) \
SH_DR_PICK(rec_dr,rec,hd_sh,hd)


/*----------------------------------------------------------------------------*/
/* Pick a DL structure from it's SH list:

   rec_dr ==> name within record of DL member to be picked.
   rec    ==> -> to the record containing the DR structure to be picked.
   type      ==> type of record, ie struct x.
   hd_sh   ==> name within head record of SH member to which the DL
		  structure to be picked is grouped in.
   hd        ==> -> to the head record containing the SH structure to which
		  the DL structure is queued.
   NOTE 1: SH queue contains same type records and DL members. */

#define Xsh_dl_pick(rec_dl,reci,hd_sh,hdi)\
{\
ADRCK((char *)(hdi));\
ADRCK((char *)(reci));\
if ((reci)->rec_dl.fpl) {\
     as((reci)->rec_dl.fpl->rec_dl.bpl==(reci));\
     (reci)->rec_dl.fpl->rec_dl.bpl = (reci)->rec_dl.bpl;\
     }\
if ((reci)->rec_dl.bpl) {\
     as((reci)->rec_dl.bpl->rec_dl.fpl==(reci));\
     (reci)->rec_dl.bpl->rec_dl.fpl = (reci)->rec_dl.fpl;\
     }\
if ((reci) == (hdi)->hd_sh.fp) (hdi)->hd_sh.fp = (reci)->rec_dl.fpl;\
DL_NULL(rec_dl,(reci));\
}

#define SH_DL_PICK(rec_dl,rec,type,hd_sh,hd,htype)\
\
Xsh_dl_pick(rec_dl,rec,hd_sh,hd)

#define SHO_DLO_PICK SH_DL_PICK


/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Queue a DRH structure to front of an SH:

   rec_drh ==> name within record of DRH member to be queued.
   rec     ==> -> to the record containing the DRH structure to be queued.
   hd_sh    ==> name within head record of SH member to which the DRH
		  structure to be queued.
   head       ==> -> to the head record containing the SH structure to which
		  the DRH structure will be queued.
   NOTE 1: SH queue contains same type records and DRH members.
   NOTE 2: Queues only from a header */

#define SH_DRH_FQUE(rec_drh,reci,hd_sh,hdi)\
{\
as(!((reci)->rec_drh.hp));\
as(!((reci)->rec_drh.fp));\
as(!((reci)->rec_drh.bp));\
(reci)->rec_drh.hp = (hdi);\
if ((hdi)->hd_sh.fp DNE) {\
     (hdi)->hd_sh.fp = (reci)->rec_drh.bp = (reci)->rec_drh.fp = (reci);\
     }\
else {\
     (reci)->rec_drh.fp = (hdi)->hd_sh.fp;\
     (reci)->rec_drh.bp = (reci)->rec_drh.fp->rec_drh.bp;\
     as((reci)->rec_drh.bp->rec_drh.fp==(hdi)->hd_sh.fp);\
     (hdi)->hd_sh.fp = (reci)->rec_drh.bp->rec_drh.fp = (reci)->rec_drh.fp->rec_drh.bp = (reci);\
     }\
}

#define SHO_DRHO_FQUE(rec_drh,reci,type,hd_sh,hdi,htype)\
SH_DRH_FQUE(rec_drh,reci,hd_sh,hdi)

/*----------------------------------------------------------------------------*/

/* Queue a DRH structure to the rear of an SH:

   rec_drh ==> name within record of DRH member to be queued.
   rec     ==> -> to the record containing the DRH structure to be queued.
   hd_sh    ==> name within head record of SH member to which the DRH
		  structure to be queued.
   head       ==> -> to the head record containing the SH structure to which
		  the DRH structure will be queued.
   NOTE 1: SH queue contains same type records and DRH members.
   NOTE 2: Queues only from a header */

#define SH_DRH_RQUE(rec_drh,reci,hd_sh,hdi)\
{\
as(!((reci)->rec_drh.hp));\
as(!((reci)->rec_drh.fp));\
as(!((reci)->rec_drh.bp));\
(reci)->rec_drh.hp = (hdi);\
if ((hdi)->hd_sh.fp  DNE) {\
     (hdi)->hd_sh.fp = (reci)->rec_drh.bp = (reci)->rec_drh.fp = (reci);\
     }\
else {\
     (reci)->rec_drh.fp = (hdi)->hd_sh.fp;\
     (reci)->rec_drh.bp = (reci)->rec_drh.fp->rec_drh.bp;\
     as((reci)->rec_drh.bp->rec_drh.fp==(hdi)->hd_sh.fp);\
     as((reci)->rec_drh.bp->rec_drh.hp==(hdi));\
     as((reci)->rec_drh.fp->rec_drh.hp==(hdi));\
     (reci)->rec_drh.bp->rec_drh.fp = (reci)->rec_drh.fp->rec_drh.bp = (reci);\
     }\
}


#define SHO_DRHO_RQUE(rec_drh,reci,type,hd_sh,hdi,htype)\
SH_DRH_RQUE(rec_drh,reci,hd_sh,hdi)

/*----------------------------------------------------------------------------*/

/* Queue a DR structure to front of an SH:
   (The SH member points to the front element.  The bp of the front element
    points to the rear element.  This macro creates a new front element.)

   rec_dr ==> name within record of DR member to be queued.
   rec    ==> -> to the record containing the DR structure to be queued.
   hd_sh  ==> name within head record of SH member to which the DR
	      structure will be queued.
   hd     ==> -> to the head record containing the SH structure to which
	      the DR structure will be queued.
   NOTE 1: SH queue contains same type records and DR members.
   NOTE 2: Queues only from a header */

#define SH_DR_FQUE(rec_dr,reci,hd_sh,hdi)\
{\
ADRCK(reci);\
ADRCK(hdi);\
as(!((reci)->rec_dr.fp));\
as(!((reci)->rec_dr.bp));\
if ((hdi)->hd_sh.fp DNE) {\
     (hdi)->hd_sh.fp = (reci)->rec_dr.bp = (reci)->rec_dr.fp = (reci);\
     }\
else {\
     (reci)->rec_dr.fp = (hdi)->hd_sh.fp;\
     (reci)->rec_dr.bp = (reci)->rec_dr.fp->rec_dr.bp;\
     as((reci)->rec_dr.bp->rec_dr.fp == (hdi)->hd_sh.fp);\
     (hdi)->hd_sh.fp = (reci)->rec_dr.bp->rec_dr.fp = (reci)->rec_dr.fp->rec_dr.bp = (reci);\
     }\
}


#define SHO_DRO_FQUE(rec_dr,reci,type,hd_sh,hdi,htype)\
SH_DR_FQUE(rec_dr,reci,hd_sh,hdi)


/*----------------------------------------------------------------------------*/
/* Queue a DL structure to front of an SH:

   rec_dl ==> name within record of DLO member to be queued.
   rec    ==> -> to the record containing the DLO structure to be queued.
   type   ==> type of rec, ie struct x.
   hd_sh  ==> name within head record of SHO member to which the DLO
	      structure will be queued.
   hd     ==> -> to the head record containing the SHO structure to which
	      the DLO structure will be queued.
   NOTE 1: SHO queue contains same type records and DLO members.
   NOTE 2: Queues only from a header */

#define SH_DL_FQUE(rec_dl,reci,hd_sh,hdi)\
{\
ADRCK(hdi);\
ADRCK(reci);\
as((reci)->rec_dl.fpl DNE);\
as((reci)->rec_dl.bpl DNE);\
if ((hdi)->hd_sh.fp DNE) {\
     (reci)->rec_dl.bpl = (reci)->rec_dl.fpl = NULL;\
     (hdi)->hd_sh.fp = (reci);\
     }\
else {\
     (reci)->rec_dl.fpl = (hdi)->hd_sh.fp;\
     (reci)->rec_dl.bpl = NULL;\
     (reci)->rec_dl.fpl->rec_dl.bpl = (reci);\
     (hdi)->hd_sh.fp = (reci);\
     }\
}

#define SHO_DLO_FQUE(rec_dl,rec,type,hd_sh,hd,htype)\
SH_DL_FQUE(rec_dl,rec,hd_sh,hd)


/*----------------------------------------------------------------------------*/

/* Queue a DR structure to the rear of an SH:
   (The SH member points to the front element, the bp of the front element
    points to the rear element.  This macro creates a new rear element.)

   rec_dr  ==> name within record of DR member to be queued.
   rec     ==> -> to the record containing the DR structure to be queued.
   hd_sh    ==> name within head record of SH member to which the DR
		  structure is to be queued.
   head       ==> -> to the head record containing the SH structure to which
		  the DR structure will be queued.
   NOTE 1: SH queue contains same type records and DR members.
   NOTE 2: Queues only from a header */

#define SH_DR_RQUE(rec_dr,reci,hd_sh,hdi)\
{\
ADRCK(hdi);\
ADRCK(reci);\
as(!((reci)->rec_dr.fp));\
as(!((reci)->rec_dr.bp));\
if (!((hdi)->hd_sh.fp)) {\
     (hdi)->hd_sh.fp = (reci)->rec_dr.bp = (reci)->rec_dr.fp = (reci);\
     }\
else {\
     (reci)->rec_dr.fp = (hdi)->hd_sh.fp;\
     (reci)->rec_dr.bp = (reci)->rec_dr.fp->rec_dr.bp;\
     as((reci)->rec_dr.bp->rec_dr.fp==(hdi)->hd_sh.fp);\
     (reci)->rec_dr.bp->rec_dr.fp = (reci)->rec_dr.fp->rec_dr.bp = (reci);\
     }\
}

#define SHO_DRO_RQUE(rec_dr,reci,type,hd_sh,hdi,htype)\
SH_DR_RQUE(rec_dr,reci,hd_sh,hdi)

/*----------------------------------------------------------------------------*/

/* Queue a DR structure to the front of an already linked DR structure:

   rec_dr     ==> name within the record of DR member to be queued, also  
		     the name within the record of the linked DR member.
   rec        ==> -> to the record containing the DR structure to be queued.
   linked_rec ==> -> to the record containing the already queued
		     DR structure.
   
   NOTE 1: SH queue contains same type records and DRH members.
   NOTE 1: DR queue contains same type record. */

#define SH_DR_FINS(rec_dr,rec,linked_rec)\
{\
ADRCK(rec);\
ADRCK(linked_rec);\
as(!((rec)->rec_dr.fp));\
as(!(rec)->rec_dr.bp));\
as(linked_rec->rec_dr.fp);\
as(linked_rec->rec_dr.bp);\
(rec)->rec_dr.fp = linked_rec->rec_dr.fp;\
(rec)->rec_dr.bp = linked_rec;\
as((rec)->rec_dr.fp->rec_dr.bp==(rec)->rec_dr.bp);\
(rec)->rec_dr.bp->rec_dr.fp = (rec)->rec_dr.fp->rec_dr.bp = (rec);\
}

#define SHO_DRO_FINS(rec_dr,rec,linked_rec,type)\
SH_DR_FINS(rec_dr, rec, linked_rec)

/*----------------------------------------------------------------------------*/

/* Queue a DR structure to the rear of an already linked DR structure:

   rec_dr    ==> name within the record of DR member to be queued, also  
		     the name within the record of the linked DR member.
   rec        ==> -> to the record containing the DR structure to be queued.
   linked_rec ==> -> to the record containing the already queued
		     DR structure.
   
   NOTE 1: SH queue contains same type records and DR members. */

#define SH_DR_RINS(rec_dr,rec,linked_rec,hd_sh,hd)\
{\
ADRCK(hd);\
ADRCK(rec);\
ADRCK(linked_rec);\
as(!((rec)->rec_dr.fp));\
as(!((rec)->rec_dr.bp));\
as((linked_rec)->rec_dr.fp);\
as((linked_rec)->rec_dr.bp);\
(rec)->rec_dr.fp = (linked_rec);\
(rec)->rec_dr.bp = (linked_rec)->rec_dr.bp;\
as((rec)->rec_dr.bp->rec_dr.fp==(rec)->rec_dr.fp);\
as((rec)->rec_dr.fp->rec_dr.bp==(rec)->rec_dr.bp);\
(rec)->rec_dr.bp->rec_dr.fp = (rec)->rec_dr.fp->rec_dr.bp = (rec);\
if ((linked_rec) == hd->hd_sh.fp)\
     hd->hd_sh.fp = (rec);\
}


#define SHO_DRO_RINS(rec_dr,rec,linked_rec,type,hd_sh,hd)\
SH_DR_RINS(rec_dr,rec,linked_rec,hd_sh,hd)


/*----------------------------------------------------------------------------*/

/* Queue a DRH structure to the front of an already linked DRH structure:

   rec_drh    ==> name within the record of DRH member to be queued, also  
		     the name within the record of the linked DRH member.
   rec        ==> -> to the record containing the DRH structure to be queued.
   linked_rec ==> -> to the record containing the already queued
		     DRH structure.
   
   NOTE 1: SH queue contains same type records and DRH members.
   NOTE 1: DRH queue contains same type record. */

#define SH_DRH_FINS(rec_drh,rec,linked_rec)\
{\
ADRCK(rec);\
ADRCK(linked_rec);\
as(!((rec)->rec_drh.hp));\
as(!((rec)->rec_drh.fp));\
as(!((rec)->rec_drh.bp));\
as(linked_rec->rec_drh.hp);\
as(linked_rec->rec_drh.fp);\
as(linked_rec->rec_drh.bp);\
(rec)->rec_drh.hp = linked_rec->rec_drh.hp;\
(rec)->rec_drh.fp = linked_rec->rec_drh.fp;\
(rec)->rec_drh.bp = linked_rec;\
as((rec)->rec_drh.fp->rec_drh.bp==(rec)->rec_drh.bp);\
(rec)->rec_drh.bp->rec_drh.fp = (rec)->rec_drh.fp->rec_drh.bp = (rec);\
}


#define SHO_DRHO_FINS(rec_drh,rec,linked_rec,type)\
SH_DRH_FINS(rec_drh, rec, linked_rec)

/*----------------------------------------------------------------------------*/

/* Queue a DRH structure to the rear of an already linked DRH structure:

   rec_drh    ==> name within the record of DRH member to be queued, also  
		     the name within the record of the linked DRH member.
   rec        ==> -> to the record containing the DRH structure to be queued.
   linked_rec ==> -> to the record containing the already queued
		     DRH structure.
   
   NOTE 1: SH queue contains same type records and DRH members. */

#define SH_DRH_RINS(rec_drh,rec,linked_rec,hd_sh)\
{\
ADRCK(rec);\
ADRCK(linked_rec);\
as(!((rec)->rec_drh.hp));\
as(!((rec)->rec_drh.fp));\
as(!((rec)->rec_drh.bp));\
as(linked_rec->rec_drh.hp);\
as(linked_rec->rec_drh.fp);\
as(linked_rec->rec_drh.bp);\
(rec)->rec_drh.hp = linked_rec->rec_drh.hp;\
(rec)->rec_drh.fp = linked_rec;\
(rec)->rec_drh.bp = linked_rec->rec_drh.bp;\
as((rec)->rec_drh.bp->rec_drh.fp==(rec)->rec_drh.fp);\
as((rec)->rec_drh.fp->rec_drh.bp==(rec)->rec_drh.bp);\
as((rec)->rec_drh.fp->rec_drh.hp==(rec)->rec_drh.bp->rec_drh.hp);\
(rec)->rec_drh.bp->rec_drh.fp = (rec)->rec_drh.fp->rec_drh.bp = (rec);\
if ((linked_rec) == (linked_rec)->rec_drh.hp->hd_sh.fp)\
     (linked_rec)->rec_drh.hp->hd_sh.fp = (rec);\
}


#define SHO_DRHO_RINS(rec_drh,rec,linked_rec,type,hd_sh,htype)\
SH_DRH_RINS(rec_drh,rec,linked_rec,hd_sh)


/*----------------------------------------------------------------------------*/

/* Merge two SH --> DR constructions into one single SH --> DR construction
   that is, one SH --> DR construction is merged to the end of the other:

   hd_sh         ==> name within head record of SH member to which the DR
		     structures are queued.
   hd_to_mrg     ==> -> to the head containing the SH-->DR construction which
		     will be merged into the other SH-->DR.
   into_hd     ==> -> to the head containing the SH-->DR construction which
		     will have reverse-queued to it the hd_to_mrg construction.
   rec_DR       ==> name within record of DR structure in both constructions.
   rec_type      ==> type of record containing DR member.
   
   NOTE 1: Both SH-->DR constructions are identical */

#define SH_DR_RMRG(hd_sh,hd_to_mrg,into_hd,rec_dr,rec_type)\
{\
struct rec_type *temp_rec;\
as(hd_to_mrg);\
as(into_hd);\
if (hd_to_mrg->hd_sh.fp) {\
   if (into_hd->hd_sh.fp) {\
     temp_rec = hd_to_mrg->hd_sh.fp->rec_dr.bp;\
     hd_to_mrg->hd_sh.fp->rec_dr.bp=into_hd->hd_sh.fp->rec_dr.bp;\
     into_hd->hd_sh.fp->rec_dr.bp->rec_dr.fp = hd_to_mrg->hd_sh.fp;\
     temp_rec->rec_dr.fp=into_hd->hd_sh.fp;\
     into_hd->hd_sh.fp->rec_dr.bp = temp_rec;\
     }\
   else into_hd->hd_sh.fp = hd_to_mrg->hd_sh.fp;\
\
   hd_to_mrg->hd_sh.fp=NULL;\
   }\
}

/*----------------------------------------------------------------------------*/

/* Merge two SH --> DRH constructions into one single SH --> DRH construction
   that is, one SH --> DRH construction is merged to the end of the other:

   hd_sh         ==> name within head record of SH member to which the DRH
		     structures are queued.
   hd_to_mrg     ==> -> to the head containing the SH-->DRH construction which
		     will be merged into the other SH-->DRH.
   into_hd     ==> -> to the head containing the SH-->DRH construction which
		     will have reverse-queued to it the hd_to_mrg construction.
   rec_drh       ==> name within record of DRH structure in both constructions.
   rec_type      ==> type of record containing DRH member.
   
   NOTE 1: Both SH-->DRH constructions are identical */

#define SH_DRH_RMRG(hd_sh,hd_to_mrg,into_hd,rec_drh,rec_type)\
{\
register struct rec_type *temp_rec, *fst_rec;\
as(hd_to_mrg);\
as(into_hd);\
if (fst_rec=temp_rec=hd_to_mrg->hd_sh.fp) {\
   do {\
      temp_rec->rec_drh.hp = into_hd;\
      temp_rec = temp_rec->rec_drh.fp;\
      }\
   while (temp_rec != fst_rec);\
\
   if (into_hd->hd_sh.fp) {\
     temp_rec = hd_to_mrg->hd_sh.fp->rec_drh.bp;\
     hd_to_mrg->hd_sh.fp->rec_drh.bp=into_hd->hd_sh.fp->rec_drh.bp;\
     into_hd->hd_sh.fp->rec_drh.bp->rec_drh.fp = hd_to_mrg->hd_sh.fp;\
     temp_rec->rec_drh.fp=into_hd->hd_sh.fp;\
     into_hd->hd_sh.fp->rec_drh.bp = temp_rec;\
     }\
   else into_hd->hd_sh.fp = hd_to_mrg->hd_sh.fp;\
\
   hd_to_mrg->hd_sh.fp=NULL;\
   }\
}

/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/

/* Fetch the pointer to the record indicated by the fp or bp of a bds:

   rec_bds    ==> name within the record of bds member.
   rec        ==> -> to the record containing the bds member.

***Not assertion proofed.
                                                                              */
#define F(rec_bds,rec)((rec)->rec_bds.fp)
#define R(rec_bds,rec)((rec)->rec_bds.bp)
#define FL(rec_bds,rec)((rec)->rec_bds.fpl)
#define RL(rec_bds,rec)((rec)->rec_bds.bpl)

/*
   val           ==> set as -> to record pointed at by the above.
   type          ==> type of val, ie struct x.
   dirty         ==> RW or RO.
*/                                                                            
#define Xf(rec_bds,rec,val,type,dirty,vr,roadrck)\
\
roadrck((char *)rec);\
if ((val=F(rec_bds,rec)) E) {\
     vr(val,val,type,dirty);\
     }

#define FO(rec_bds,rec,val,type,dirty) Xf(rec_bds,rec,val,type,dirty,VO_RO,RO_ADRCK)


#define Xrv(rec_bds,rec,val,type,dirty,vr,roadrck)\
\
roadrck((char *)rec);\
if ((val=R(rec_bds,rec)) E) {\
     vr(val,val,type,dirty);\
     }

#define RVO(rec_bds,rec,val,type,dirty) Xrv(rec_bds,rec,val,type,dirty,VO_RO,RO_ADRCK)\


#define Xfl(rec_bds,rec,val)\
\
ADRCK((char *)rec);\
val=(rec)->rec_bds.fpl

#define FLO(rec_bds,rec,val,type,dirty) Xfl(rec_bds,rec,val)\


#define Xrvl(rec_bds,rec,val)\
\
ADRCK((char *)rec);\
val=(rec)->rec_bds.bpl

#define RVLO(rec_bds,rec,val,type,dirty) Xrvl(rec_bds,rec,val)\

/*----------------------------------------------------------------------------*/

/* Check if record is the last member in a ring

   rec_bds   ==> name within the record of bds member.
   rec       ==> -> to the record containing the bds member.
   hd_s      ==> name within head record of SH member to which the DRH,
		   DR or SR structures are queued.
   hd        ==> -> to the head record containing the SH structure to
		   which the DRH DR or SR structures are queued.
									      */

#define LAST(rec_bds,rec,hd_s,hd) (F(rec_bds,(rec))==F(hd_s,(hd)))

/*----------------------------------------------------------------------------*/

/* Forward scan rings:

   rec_rs   ==> name within tmp_rec of DRH, DR or SR member which
		   indicates the next record to be obtained by following the 
		   member's fp.
   tmp_rec ==> -> which is incremented to the next record queued
		   to the SR or DR or DRH structure by following fp.
   hd_s      ==> name within head record of SH member to which the DRH,
		   DR or SR structures are queued.
   head        ==> -> to the head record containing the SH structure to
		   which the DRH DR or SR structures are queued.
   NOTE 1: SH queue contains same type records and DRH members.               */
   
#define R_FNEXT(rec_rs,tmp_rec,hd_s,hd)\
{\
ADRCK(tmp_rec);\
ADRCK(hd);\
as((tmp_rec)->rec_rs.fp);\
if ((tmp_rec)->rec_rs.fp == (hd)->hd_s.fp) (tmp_rec) = NULL;\
else (tmp_rec) = (tmp_rec)->rec_rs.fp;\
}

#define RO_FNEXT(rec_rs,tmp_rec,type,hd_s,hd,dirty)\
R_FNEXT(rec_rs,tmp_rec,hd_s,hd)


/*----------------------------------------------------------------------------*/

/* Reverse scan rings:

   rec_rs   ==> name within tmp_rec of DRH, DR or SR member which
		   indicates the next record to be obtained by following the 
		   member's fp.
   tmp_rec ==> -> which is incremented to the next record queued
		   to the SR or DR or DRH structure by following fp.
   hd_s      ==> name within head record of SH member to which the DRH,
		   DR or SR structures are queued.
   head        ==> -> to the head record containing the SH structure to
		   which the DRH DR or SR structures are queued.
   NOTE 1: SH queue contains same type records and DRH members.               */
   
#define R_RNEXT(rec_rs,tmp_rec,hd_s,hd)\
{\
ADRCK(tmp_rec);\
ADRCK(hd);\
as((tmp_rec)->rec_rs.fp);\
if ((tmp_rec) == (hd)->hd_s.fp) (tmp_rec) = NULL;\
else (tmp_rec) = (tmp_rec)->rec_rs.bp;\
}
#define RO_RNEXT(rec_rs,tmp_rec,type,hd_s,hd,dirty) R_RNEXT(rec_rs,tmp_rec,hd_s,hd)

/*----------------------------------------------------------------------------*/

/* Forward scan lists:

   rec_rs   ==> name within tmp_rec of SL member which
		   indicates the next record to be obtained by following the 
		   member's fp.
   tmp_rec ==> -> which is incremented to the next record queued
		   to the SL structure by following fp.
   type        ==> type of tmp_rec, ie struct x.
   dirty       ==> RW or RO.
*/
   
#define L_FNEXT(rec_rs,tmp_rec)\
as(tmp_rec);\
(tmp_rec)=(tmp_rec)->rec_rs.fpl;

#define LO_FNEXT(rec_rs, tmp_rec, type, dirty) L_FNEXT(rec_rs, tmp_rec)

/*----------------------------------------------------------------------------*/

/* Inorder loop of homogeneous tree.
   
   rec_tree ==> name within homogeneous tree record of tree member.
   found    ==> -> to record containing tree member forming the tree, which is
	        incremented inorder through all records in the tree.
   type     ==> type of record which forms the tree.
   hd_tree  ==> name within record of tree-root member.
   hd       ==> -> to record containing tree-root member.
   stack    ==> some unique name which has been used in INORDER_STACK
                to define an inorder work area.

   Note: Useage here is:
         {
	 INORDER_STACK(stack_a,type);
	 INORDER(tree,rec,type,tree_root,root,stack_a,RW);
	 if ((rec) E) {
	      do {
		 INORDER_WHILE(tree,rec,type,stack_a,RW);
	      }
         } end of stack_a scope
									      */

#define Xinorder_stack(rec_tree,vfrom,type,stack,vr,unlock)\
{\
register type *XXrf, *XXvn;\
vr(vfrom,XXrf,type,RO);\
if ((XXvn=Xavllsp(XXrf->rec_tree.lsp,type)) E) {\
     do {\
        unlock(XXrf);\
	as(stack.entries<INORDER_STACK_WORK_SIZE);\
        stack.Xavlstack[stack.entries  ].ptr=vfrom;\
        stack.Xavlstack[stack.entries++].path=Xavlright;\
        vfrom=XXvn;\
        vr(vfrom,XXrf,type,RO);\
        XXvn=Xavllsp(XXrf->rec_tree.lsp,type);\
        }\
        while (XXvn E);\
     }\
if ((XXvn=XXrf->rec_tree.fp) E) {\
     as(stack.entries<INORDER_STACK_WORK_SIZE);\
     stack.Xavlstack[stack.entries  ].ptr=XXvn;\
     stack.Xavlstack[stack.entries++].path=Xavlleft;\
     }\
unlock(XXrf);\
}

#define Xinorderl(rec_tree,found,type,Xvfound,stack,dirty,vr,rv,unlock,roadrck)\
{\
stack.entries=0;\
if (Xvfound E) {\
     Xinorder_stack(rec_tree,Xvfound,type,stack,vr,unlock);\
     vr(Xvfound,found,type,dirty);\
     }\
else found=NULL;\
}

#define Xinorder(rec_tree,found,type,hd_tree,hd,stack,dirty,vr,rv,unlock,roadrck)\
{\
register type *Xvfound;\
stack.entries=0;\
roadrck(hd);\
if ((Xvfound=(hd)->hd_tree.root) E) {\
     Xinorderl(rec_tree,found,type,Xvfound,stack,dirty,vr,rv,unlock,roadrck);\
     }\
else found=NULL;\
}

#define INORDER(rec_tree,found,type,hd_tree,hd,stack,dirty)\
\
Xinorder(rec_tree,found,type,hd_tree,hd,stack,NOP,V_R,R_V,NOP,ADRCK)

#define INORDERO(rec_tree,found,type,hd_tree,hd,stack,dirty)\
\
Xinorder(rec_tree,found,type,hd_tree,hd,stack,dirty,VO_RO,RO_VO,UNLOCK,RO_ADRCK)


#define INORDERL(rec_tree,found,type,tree_top,stack,dirty)\
\
Xinorderl(rec_tree,found,type,tree_top,stack,NOP,V_R,R_V,NOP,ADRCK)

#define INORDERLO(rec_tree,found,type,tree_top,stack,dirty)\
\
Xinorderl(rec_tree,found,type,tree_top,stack,dirty,VO_RO,RO_VO,UNLOCK,RO_ADRCK)


#define Xinorder_while(rec_tree,found,type,stack,dirty,vr,rv,unlock,roadrck)\
\
unlock(found);\
if (--stack.entries<0)\
     found=NULL;\
else {\
     register type *Xvn, *Xvr;\
     Xvn=stack.Xavlstack[stack.entries].ptr;\
     if (stack.Xavlstack[stack.entries].path == Xavlleft) {\
          Xinorder_stack(rec_tree,Xvn,type,stack,vr,unlock);\
          vr(Xvn,found,type,dirty);\
	  }\
     else {\
          vr(Xvn,found,type,dirty);\
          if ((Xvr=(found)->rec_tree.fp) E) {\
 	      as(stack.entries<INORDER_STACK_WORK_SIZE);\
              stack.Xavlstack[stack.entries  ].ptr=Xvr;\
              stack.Xavlstack[stack.entries++].path=Xavlleft;\
              }\
          }\
     }\
}/*end of do*/\
while (found E)
	  
#define INORDER_WHILE(rec_tree,found,type,stack,dirty)\
\
Xinorder_while(rec_tree,found,type,stack,NOP,V_R,R_V,NOP,ADRCK)


#define INORDERO_WHILE(rec_tree,found,type,stack,dirty)\
\
Xinorder_while(rec_tree,found,type,stack,dirty,VO_RO,RO_VO,UNLOCK,RO_ADRCK)

#define Xinorder_next(rec_tree,found,type,stack,dirty,vr,rv,unlock,roadrck)\
{\
if (found) unlock(found);\
if (--stack.entries<0) {\
     found=NULL;\
     stack.entries=0;\
     }\
else {\
     register type *Xvn, *Xvr;\
     Xvn=stack.Xavlstack[stack.entries].ptr;\
     if (stack.Xavlstack[stack.entries].path == Xavlleft) {\
          Xinorder_stack(rec_tree,Xvn,type,stack,vr,unlock);\
          vr(Xvn,found,type,dirty);\
	  }\
     else {\
          vr(Xvn,found,type,dirty);\
          if ((Xvr=(found)->rec_tree.fp) E) {\
 	      as(stack.entries<INORDER_STACK_WORK_SIZE);\
              stack.Xavlstack[stack.entries  ].ptr=Xvr;\
              stack.Xavlstack[stack.entries++].path=Xavlleft;\
              }\
          }\
     }\
}
	  
#define INORDER_NEXT(rec_tree,found,type,stack,dirty)\
\
Xinorder_next(rec_tree,found,type,stack,NOP,V_R,R_V,NOP,ADRCK)


#define INORDERO_NEXT(rec_tree,found,type,stack,dirty)\
\
Xinorder_next(rec_tree,found,type,stack,dirty,VO_RO,RO_VO,UNLOCK,RO_ADRCK)

/*----------------------------------------------------------------------------*/

/*
    SLH manipulations -- analogous to DRH manipulations, but with a
    singly linked list instead of a doubly linked ring, so there are
    fewer operations.
*/

#define SLH_NULL(rec_slh, rec)\
{\
    as(rec);\
    (rec)->slh.hp = NULL;  (rec)->rec_slh.fpl = NULL;\
}

#define SH_SLH_FQUE(rec_slh, rec, rec_hd, hd)\
{\
    as(rec);  as(hd); as(!((rec)->rec_slh.fpl)); as(!((rec)->rec_slh.hp));\
    (rec)->rec_slh.hp = hd;\
    (rec)->rec_slh.fpl = (hd)->rec_hd.fp;\
    (hd)->rec_hd.fp = rec;\
}

#define SLH_FNEXT(rec_slh, rec)\
    { as(rec); (rec) = (rec)->rec_slh.fpl; }

/* hd_to_mrg's list is inserted in front of into_hd's list */
#define SH_SLH_FMRG(hd_sh, hd_to_mrg, into_hd, rec_dlh, rec_type) \
{\
    register struct rec_type *temp;\
    as(hd_to_mrg);  as(into_hd); as((hd_to_mrg) != (into_hd));\
    if (temp = (hd_to_mrg)->hd_sh.fp) {\
	while (temp->rec_dlh.fpl) {\
	    temp->rec_dlh.hp = (into_hd);\
	    temp = temp->rec_dlh.fpl;\
	    }\
	temp->rec_dlh.hp = (into_hd);\
	temp->rec_dlh.fpl = (into_hd)->hd_sh.fp;\
	(into_hd)->hd_sh.fp = temp;\
	(hd_to_mrg)->hd_sh.fp = NULL;\
	}\
}


/*----------------------------------------------------------------------------*/
/*----------------------------------------------------------------------------*/



#endif BDS_M_INCLUDED
