






#ifndef ER_SCALDDIR_H
#define ER_SCALDDIR_H
#include "Clib/stringt.h"

/*
    A scald directory description -- consists of a name  and
    a "which" (SCALDDIR or LIBRARY) and a directory type.
*/
class erule_scalddir {
    string _name;
    int _which; // Uses Scald Data Locater values
    string _type;
public:
    // Internal to erule subsystem
    erule_scalddir(const string& name, int which, const string& dirtype);
    erule_scalddir(const erule_scalddir&);
    erule_scalddir();
    ~erule_scalddir();

    erule_scalddir& erule_scalddir::operator=(const erule_scalddir&);
    boolean operator==(const erule_scalddir&);
    boolean operator!=(const erule_scalddir&);

    const string& name();
    int which();
    char* which(boolean capitalized);   // Text suitable for error message
    const string& type();
    void clear();
};

inline erule_scalddir::erule_scalddir() { _which = 0; }
inline erule_scalddir::erule_scalddir(const string& name, int which, const string& type)
    : _name(name), _type(type) { _which = which; }
inline erule_scalddir::erule_scalddir(const erule_scalddir& d)
    : _name(d._name), _type(d._type) { _which = d._which; }
inline erule_scalddir::~erule_scalddir() {};

inline void erule_scalddir::clear() { _name = 0;  _which = 0;  _type = 0; }

inline erule_scalddir& erule_scalddir::operator=(const erule_scalddir& d)
    { _name = d._name;  _which = d._which;  _type = d._type; return *this; }
inline boolean erule_scalddir::operator==(const erule_scalddir& d)
    { return _name == d._name && _which == d._which; }
inline boolean erule_scalddir::operator!=(const erule_scalddir& d)
    { return !operator==(d); }

inline const string& erule_scalddir::name() { return _name; }
inline int erule_scalddir::which() { return _which; }
inline const string& erule_scalddir::type() { return _type; }

extern erule_scalddir erule_current_scalddir;
#endif









































































