.DS L

.BC
An expression and its associated rule.
Intended for internal use only.
.EC
.PV
#ifndef ER_RULE_H
#define ER_RULE_H
#include "Clib/gring.h"
#include "Clib/stringt.h"
#include "er_heap.h"
#include "extension.h"
class erule_lex;
class erule_entry;

gring_define(next,erule_rule);

.EP
class erule_rule {
.PV
    gring_inst(next,erule_rule);
    gringroot(next,erule_extension) extensions;
    erule_expression _expression;
    void append(erule_extension*);	// assumed legal
    void append(const string& extension, const string& attribute); // ditto
    void check_logic();			// Force LOGIC to appear in rule
.EP
public:
    erule_rule(const char* expression);
    erule_rule(erule_entry*);		// Makes the default rule
    ~erule_rule();
    boolean parse(erule_lex*, erule_entry* parent);
					// If called on 0, just a syntax check

    void push_exception(erule_extension*);
    void pop_exception(erule_extension*);

    const erule_expression& expression();
					// for building error messages

    boolean is_default();
    boolean evaluate();

    int ord(erule_drawing_extension*, int max_value = 0);
    int ord(erule_drawing_special*, int max_value = 0);
    // Return 0 if not found or if max value is non-zero and the returned
    // value would exceed or equal it.

    boolean forced_to_primitive(erule_drawing_extension*);
    void dump(ostream&, const char* compile_type);
};
.PV

inline erule_rule::erule_rule(const char* expression)
: _expression(expression) 
{
    AS(!this);
    this = (erule_rule*)erule_heap.mem(sizeof(*this));
}

#ifndef VAX
gring_inline(next,erule_rule);
#endif
inline boolean erule_rule::is_default()
    { return _expression.is_default(); }
inline boolean erule_rule::evaluate()
    { return _expression.evaluate(); }
inline const erule_expression& erule_rule::expression()
    { return _expression; }
inline void erule_rule::push_exception(erule_extension* e)
    { extensions.insert_front(e); }
inline void erule_rule::pop_exception(erule_extension* e)
    { ASSERT(e==extensions.first());  extensions.remove_first(); }
#endif
.EP
.DE
