.DS L
.PV
#ifdef PASCAL_XFACE
#ifndef PASCAL_H
#define PASCAL_H

#include "lib/misc/platform.h"
.EP

.BC
Class that knows how to call a pascal function.  Each instance calls
a specific function.  There are some restrictions on the functions that
can be called.

For SVS pascal, the function can be any level as long as when it is called
its static link is the same as when the instance of this object is created.
(This occurs when its call occurs during the same activation of its
static parent as its definition by instantiation of this object.)
For level 1 functions, this is always true, as the static parent is the
program itself.

For SUN pascal, the same should hold true, though I have never tested this
on other than a level 1 function.

For VAX pascal this works ONLY on level 1 functions, as the static link
is not in fact used in the function call -- it would need to be put into
R1 to make this complete.
.EC

typedef int (*pfuncP)(...);

.PV
#ifdef SVS
// Assembly language wrappers -- see handlerw.s in compiler source area.
// (There's one for the PC and one for the S32.)
extern handler_wrap(pfuncP, void* static_link);
extern handler_wrap1(pfuncP, void* static_link, void* param);
#endif

.EP
enum pfunc { EXPRESSION, 
             ERR,
             ERR_ASSERTION_FAILURE,
	     ERR_INT,
	     ERR_INDENT,
	     ERR_XTRING, 
	     ERR_CONTEXT, 
	     ERR_CRLF, 
	     ERR_SDL,           // Scald Data Locator errors
	     SENTINEL_PFUNC };  // Not executable

.PV
struct pascal_table_entry {
    pfuncP func;
    void* link;
};
extern pascal_table_entry pascal_table[];
.EP

class pascal {
.PV
    pfunc _which;
.EP
protected:
    // This class can't be used directly -- create its descendents
    int operator()();
    int operator()(void* p);
public:
    pascal(pfunc which);
};


class pascal_no_parameters : pascal {
public:
    pascal_no_parameters(pfunc which);
    operator()();
};


class pascal_ptr_parameter : pascal {
public:
    pascal_ptr_parameter(pfunc which);
    operator()(void*);
};


class pascal_int_parameter : public pascal_ptr_parameter {
public:
    operator()(int);
};


extern pascal_ptr_parameter pascal_expression;
extern pascal_int_parameter pascal_err;
extern pascal_int_parameter pascal_assert;
extern pascal_int_parameter pascal_err_int;
extern pascal_no_parameters pascal_err_indent;
extern pascal_ptr_parameter pascal_err_xtring;
extern pascal_no_parameters pascal_err_context;
extern pascal_no_parameters pascal_err_sdl;
extern pascal_no_parameters pascal_err_crlf;

extern void pascal_err_string(const char*);
.PV

inline pascal::pascal(pfunc which) { _which = which; }

inline int pascal::operator()()
#ifdef SVS
{ 
    return handler_wrap(pascal_table[_which].func,
                        pascal_table[_which].link);
}
#endif
#if SUN || PMAX
    { return (*(pascal_table[_which].func))(pascal_table[_which].link); }
#endif
#if VAX
    { return (*(pascal_table[_which].func))(); }
#endif

inline int pascal::operator()(void* p)
#ifdef SVS
{ 
    return handler_wrap1(pascal_table[_which].func,
                         pascal_table[_which].link, p);
}
#endif
#if SUN || PMAX
    { return (*(pascal_table[_which].func))(p, pascal_table[_which].link); }
#endif
#if VAX
    { return (*(pascal_table[_which].func))(&p); }
#endif


inline pascal_no_parameters::pascal_no_parameters(pfunc which) : (which) {}
inline int pascal_no_parameters::operator()()
    { return pascal::operator()(); }

inline pascal_ptr_parameter::pascal_ptr_parameter(pfunc which) : (which) {}
inline int pascal_ptr_parameter::operator()(void* p)
    { return pascal::operator()(p); }

inline int pascal_int_parameter::operator()(int i)
    { return pascal::operator()((void*)i); }

#endif
#endif
.EP
.DE
