.so macros.ms
.NM
.TL
Expansion Control -- IRS
.AU
Bill Hunsicker
.AI
Valid Logic Systems, Inc.
.CR
.NH 1
Introduction
.LP
The current implementation deals with only one compile type.  Information
dealing with other compile types is discarded on input.

There are 2 basic data structures -- a table of expansion rules for
the specified compile type and a table of available drawings (with
their extensions and pages enumerated.  The former is built by
parsing the expansion rules files during compiler directives processing.
It is represented by an instance of class \fBerule_drawing_table\fP.
The latter is built on the fly, as drawings are requested by the compiler.
It is represented by an instance of class \fBerule_table\fP.

Each of these tables is, of course, implemented by a variety of sub-classes.
These (along with their interfaces) are enumerated below.
.NH 1
Style
.LP
A few words about how the code is organized:
.NH 2
Pascal Interface
.LP
This subsystem is designed to work with the next-generation (2.0) 
ValidCOMPILER, so
it is a C++ subsystem with its interface defined by the classes \fBerule\fP
and \fBerule_selection\fP.

On top of this, a collection of procedures is defined that allows 
initialization and access by the current PASCAL implementation of the 
compiler.  For the most part, all internal work is done in C++.  
The following functions are exceptions to
this and are handled by leveraging the PASCAL code
that already exists for them.  
.IP 1.
Error reporting.
.IP 2.
Expression parsing.
.LP
Ultimately, the member functions that currently
call PASCAL code will be reimplemented in C++ for the 2.0 ValidCOMPILER.
The code that exists to call PASCAL will be conditionally compiled when
PASCAL_XFACE is defined to the preprocessor, and the C++ versions of this
same functionality will be compiled when that is not defined.
.NH 2
Class Names
.LP
Use of prefixing to group modules within some distinct subsystem 
provides 2 obvious benefits.
.IP 1.
It allows a module to be quickly identified as to what subsystem it belongs.
.IP 2.
It prevents global name collisions between subsystems.
.LP
All class names and global data names within this subsystem are
prefixed with \fBerule_\fP.  
The classes within the drawing table structure
are further prefixed with \fBdrawing_\fP, that is, they they begin with
\fBerule_drawing_\fP.  The other classes are part of the rules table or
are basic building blocks used by both.
.NH 2
File Names
.LP
Each internal class has its own .cl (short for class) 
file which is the source file for its .h file
and documentation.  The .h files are derived from this by use of "make".
Each class also has a .C file which implements the non-inline member
functions of the class.  Misc. documentation files have the .ms suffix
(indicating nroff/troff source using the ms macro package).n

The interface classes are defined in erule.cl -- users include erule.h
to define the interface to their programs.

Files implementing the drawing table classes are prefixed with \fBdwg_\fP.
Files implementing the rules table classes are unprefixed.  The PASCAL
interface is in pascal.cl and pascal.C, with support from a couple of
wrappers for calling SVS PASCAL already defined in the compiler's code.
These are in source files named handlerw.s (one in S32 area and
one in PC area).
.NH 2
Coding
.LP
Nroff/troff macros defined in file "macros.ms" are used in the .cl files to
distinguish interface code from implementation code.  In this manner the .h
files for each class is generated from the same source as
the interface specification (below).  Each class is preceeded by a comment that
describes its function.  Other comments follow Bjarne Stroustrups 
recommendations.

A consistent indentation style is used in presenting the classes and
their impelementations -- this should be obvious from the code.

The public portions of the classes contain only member-functions and
member-classes.
The state members are all private.

Inline implementations of member functions are included in the impelmentation
portion of that classes definition where they depend only on other members of
that class or on its sub-classes.  (The classes are intended to be declared
in bottom-up order).  Inline functions that depend on a higher-level class
defintion are all gathered in the file erule.h, with is the only .h
file not derived from a .cl file.  This file (erule.h) includes all .h files
in the proper order, so including this file provides all definitions needed
for this subsystem.
.NH 1
Classes Implemented
.NH 2
C++ Interface
.LP
.so erule.cl
.NH 2
Building Blocks
.LP
.so pascal.cl
.so scalddir.cl
.so expression.cl
.NH 2
The Drawing Table
.LP
.so dwg_table.cl
.so dwg_entry.cl
.so dwg_version.cl
.so dwg_extension.cl
.so dwg_page.cl
.NH 2
The Rule Table
.LP
.so table.cl
.so entry.cl
.so rule.cl
.so extension.cl
