.so macros
.ds VR NEW
.NM
.RP
.TL
Expansion Control -- ERS
.AU
Bill Hunsicker
.AI
Valid Logic Systems, Inc.
.AB
.CR 1987

Proposes a way to customize expansion rules in the SCALD language
to facilitate multi-level simulation and simplify the specification
(to the system) of
the existence of special (non-schematic) models.  The introduction
describes the problems being addressed and the ways in which they
are addressed.  The remainder of the document gives the specific
details of how the mechanism is used.  Note the last section which
describes a limitaion on the use of the mechanism over a network.

.AE
.NH 1
Introduction
.LP
The existing SCALD Language has a very restricted notion of how to
expand a hierarchy down to primitives.  This is described in the 
SCALDsystem manual.  This mechanism causes several difficulties.

.IP 1.
Some tools require textual (or other) descriptions be associated
with some "primitives".  REALCHIPtm descriptions (used by the simulator)
and "chips" files (used by the packager) are examples.
The current method requires that PRIM (or PART) drawings exist for
these components (to tell the compiler where to stop)
and that the location of the additional information be determined by
other means.  Currently, the simulator gets REALCHIP descriptions via
its own directives and the packager gets chips files by knowing about
libraries and the convention adopted for naming the chips files therein.
This is very clumsy.
.IP 2.
Mixed-mode simulation (such as use of behavior models for some
drawings and expansion to primitives for others) requires that the
use fake out the compiler in a manner similar to that used for REALCHIPtm.
.IP 3.
There is a potential for producing combined simulator/timing verifier
models for some components.  Currently, there is no good way to
represent the integrated model, if it were produced.  (It would
need to be copied or linked into both SIM.* and TIME.* files.)
.IP 4.
There is no good way to specify exceptions to the rules.
Given a behavioral description for some drawing along with an
implementation of the drawing (which expands into lower-level models),
one might want to pick the behavioral model for some simulations and
expand further for others.  It would be nice to be able to do this
without having to move around the files in the "database" to fool
the system into stopping at the right place.
.IP 5.
Some components (such as resistors) are meaningful in both analog
and digital circuits.
A mixed analog-digital simulator must be able to choose between
an analog model and a digital model on an instance-by-instance basis.
Currently, this would have to be done by using a different drawing
name to identify the 2 different types.
.LP
The proposed solution is intended to address these problems in a way that
is general, user configurable, consistent in flavor with the SCALD language,
backward-compatible and "sufficiently" easy to use.

The first two of these are addressed by providing a way to define (to
the system) "special" files (containing non-schematic models for some
target tool).
Where these files are encountered in
drawing directrories (while compiling for the target for which
the special file is defined),
primitives (called herein psuedo-primitives) are
manufactured with the expansion
data reflecting both the kind of primitive and the full name of the
file that represents it.  The tool does not then need to be told in
other ways how to find the information.  Note that this does away with
the need for the simulator to have directives which give the location of
realchip models.  It also does away with the need for the packager to
know anything at all about libraries.

The third problem is addressed by providing configurable expansion
rules.  This also handles the problem of what precedence to assign
to the psuedo-primitives discussed above.  The syntax for specifying
these rules also provides the way to specify the names of the
non-schematic model files.
Each compile type is given its own set of rules.  Compile types not
explicitly given rules will be treated as they are now.

The fifth problem is best addressed within the tool itself.  Given an analog
psuedo-primitive for a resistor, the simulator can choose to substitue a
digital model where more appropriate.  However; in discussions with the
mixed-mode simulator group at Valid, they have requested that the user also
be allowed to make an explicit specification where he wishes to do so.
This is most 
naturally addressed by some way of distinguishing
the different kinds of components by parameterization -- the system already
contains mechanisms for dealing with this form of context sensitivity.
Selection expressions are added to the rules to allow them to be varied
according to the parameterization on the body.  For example, the expansion
rule for a mixed mode simulation can specify that if CKT_DOMAIN=ANALOG then
a SUBCKT file takes precedence over a SIM drawing, but if CKT_DOMAIN=DIGITAL
then the SIM drawing takes precedence.  Resistors (having both of these)
could then be characterized by parameterization.

The fourth problem (exceptions generated to limit the complexity of the
resulting curcuit) could be addressed by clever use of the above mechanisms,
but this is too cumbersome for most users.  A mechanism for specifying
explicit exceptions by drawing name is provided.  Later this may be expanded
to allow more instance-dependent exceptions to be made, but for the first
cut only drawings may be specified.  The exception is applied wherever
the drawing is encountered.
.NH 1 
Expansion Rules
.LP
Expansion rule specifications are made in expansion rule files.
The expansion rules for a given compile type are completely defined in one 
file.  A user can specify his own rules by writing an expansion rules file
and informing the compiler of its existence with the
EXP_RULES_FILE
directives, which take a list of file names as usual.
When rules for a compile type are found in some rules file, any rules for
that compile type previously found in other files are discarded.

These files follow usual SCALD conventions.  The syntax is as follows.

.DS
file :== FILE_TYPE = EXPANSION_RULES ;
         compile_type_spec_list
	 END .

compile_type_spec_list :== compile_type_spec |
                           compile_type_spec_list compile_type_spec
compile_type_spec :== compile_type selection_expression : drawing_type_list ;

compile_type :== identifier
drawing_type_list :== drawing_type_list drawing_type | null
drawing_type :== identifier | 
                 identifier ( attribute ) |
		 standard_prim
standard_prim :== PRIM ( directory_type ) |
                  PART ( directory_type )
directory_type :== identifier;

attribute :== PRIMITIVE | SPECIAL
.DE
The non-terminal "selection_expression" follows the syntax of
SCALD selection expressions.

The order of specification of the drawing types determines their
precedence.  (Earlier ones win over later ones.)

Any drawing type without the attribute SPECIAL is taken to be a
(GED) drawing extension name (such as LOGIC or SIM).

Drawing types (other than PRIM or PART) without attributes are taken to
be hierarchical (non-primitive) drawings.  If they turn out to be leaf
drawings, an oversight is emitted unless the TERMINAL property exists
on the drawing body.  (This is consistent with current behaviour.)

Drawing types with the attribute PRIMITIVE are GED drawings that will be
regarded as primitive.  
.ie '\*(VR'OLD' \{
When compiling primitives, any internal 
connectivity is ignored -- they are compiled only to obtain any
properties attached to the drawing body.
\}
.el \{
These are not compiled -- their presence causes the generation of a primitive.
\}


The PRIM and PART drawing types are special and equivalent --
this is required for backward compatibility.
They are
always considered primitive when encountered.  They are considered only
when they appear in a drawing that was found in a SCALD directory of the
right type.  Note that the SCALD directory for the sim library starts with
the line "FILE_TYPE=SIM_DIR;".  This line gives the directory the type "SIM".
User directories are given the type "LOGIC" (their first line will
be "FILE_TYPE=LOGIC_DIR;").  The expansion rules allow the specification 
of the directory types that contain primitives recognized by the target
program.  Note that the specification of such in the expansion rules
does not by itself make the target tool understand the primitive -- it
just declares (to the compiler) that the drawings are primitive.

Drawing types with the SPECIAL attribute are taken to be the names of
non-GED files for which psuedo-primitives are to be generated.  The compiler
gives them 2 body properties to identify them to the target tool and 
tell it where to get them.
.IP 1.
The PRIM_TYPE property has the drawing type as its value.
.IP 2.
The PRIM_FILE property contains the rooted name of the special file.
(This should contain whatever modelling information is needed by the tool.)
.LP
One such (expansion rules) 
file will be provided, giving default rules for Valid-supplied
tools.  It consists (in part) of the following (the simulator
material being hypothetical):
.DS
FILE_TYPE=EXPANSION_RULES;
SPICE: subckt(special), prim(spice), spice, logic;
SIM: realchip(special), prim(sim), prim(simtv), sim, simtv, logic;
MIXED_SIM DEFAULT: realchip(special), subckt(special), 
    prim(spice), spice, prim(sim), prim(simtv), sim, simtv, logic;
MIXED_SIM ckt_domain=digital: realchip(special), subckt(special), 
    prim(spice), spice, prim(sim), prim(simtv), sim, simtv, logic;
TIME: prim(time), prim(simtv), time, simtv, logic;
LOGIC: chips_prt(special), prim(logic), logic;
END.
.DE

Note that compile for MIXED_SIM will pick an analog description for a
component whereever that exists unless the component is given the
parameter ckt_domain=digital.  

.NH 2
Default Rules
.LP
When compiling for a target whose rules are unspecified, the compiler
will behave as previous compilers behaved.
Compile for logic (barring expansion rule specification) is equivalent to use
of the rule 
.DS
LOGIC: prim(logic), logic;
.DE
and compile for FOO (other than logic) is equivalent to use of
.DS
FOO: prim(foo), foo, logic;
.DE
.NH 2
LOGIC is Special
.LP
The drawing/directory type LOGIC is special in the following ways:
.IP 1.
Directories of type logic are ALWAYS read (for any compile type).
Directories of other types are read only if they could contain
PRIM (or PART) drawings.
.IP 2.
Drawings of type LOGIC can always be used -- if LOGIC is not explicitly
mentioned in the expansion rule for some compile type then the rule
is treated as if LOGIC were appended to the end of the list.
Thus "FOO:\ prim(foo),\ foo;" is 
equivalent to "FOO:\ pim(foo),\ foo,\ logic;".
.IP 3.
Plumbing bodies can have only LOGIC (and, of course, BODY) drawings.
This is because they are compiled out within the pages where they
occur so thier meanings can not be dependent on compile type.
.LP
In general, drawings of type LOGIC are created to implement something and
other types are created to model the behavior of something in a way that
is significant to some particular tool or set of tools.
.NH 2
Mixing primitives and psuedo-primitives
.LP
Where a non-schematic model has been chosen for a drawing, but a primitive
also exists (and whould have been chosen over other schematic 
representations), the compiler will combine them.  This results in adding
the properties on the DRAWING body within the primitive to the list of
properties on the pseudo-primitive.  It also results in the processing
of special SCALD properties on the drawing body (such as the dreaded
PART_NAME property).  (In some of our library components, the packager 
counts on the part name to select between alternate package types
for a component.  The part name is changed by the presence of a property
of the form PART_NAME=prefix%param.)

For most components, this mechanism is not necessary and the PART drawings
could be deleted from their library representations.
.NH 1
Rules for Naming Special Files
.LP
Special files (non-schematic models) are kept in the drawing directory of
the drawing with which they are associated.  Their names correspond to
the identifier used to represent them in expansion rules.
On UNIX systems the file name is a lower-case version of this identifier.
On VMS machines the names
are case-insensitive and are (the same) identifiers but with the added
file type ".DAT".  
References to special file types in the rules definition files are 
case-insensitive.

To avoid confusion with GED files, user-defined names should
not contain the underscore
character ('_'), though this is not specifically prohibited, as the
Valid defined file chips_prt contains it.

These rules result in the contents of expansion rules files being
system independent
and are consistent with the way that drawing directories are transported
between UNIX and VMS systems with netcopy.
.NH 1
Specifying Exceptions
.LP
Exceptions cover both wanting to delete some portion of the hierarchy
to save time and wanting to force the selection of some particular
extension (or special) file for selected drawings in violation of the
normal precedence rules.  Both of these could be done by clever use
of parameterization and expansion rule selection expressions, but that
is cumbersome.

A compiler directive allows the specification of specific extensions to
be chosen for certain drawings for specified compile types.  The compile
type for which the directive is effective is included so that the same
directives file can be used to compile for multiple compile
types.
Its syntax
is:
.DS
pick_directive :== PICK ( compile_type ) extension_to_use drawing_list ;
compile_type :== identifier
.ie '\*(VR'OLD' \{
extension_to_use :== identifier
.el \{
extension_to_use :== drawing_type
(drawing_type takes same syntax as in rules file)
\}
drawing_list :== drawing_name more_drawings
more_drawings :== , drawing_name more_drawings | null
drawing_name :== string
.DE
The directive can be specified as many times as desired.
.NH 1
Limitation on Backward Compatibility
.LP
The PRIM_FILE property is included in the 
expanded netlist for "special" primitives to identify
the file containing their model.
As NFS does not contain the concept of a "network
rooted" name, the name given can only be guaranteed to be good for the 
node on which the compilation occurred (and only as long as the mount
table remains consistent regarding those file names).  

For tools using the linker, this is not much of a problem -- the file name
is guaranteed to be used on the node that calculated it, and remapping the
directories while programs are running
can be considered playing with a loaded gun -- if you get shot, 
its your fault.

For tools using expansion files this means that an expansion file
produced on one node may not be valid on other nodes if the design
contains references to special models.

This effect can be minimized by mounting libraries in the same locations
on all nodes that will be used by project personnel; however, this
assumes that all such nodes are either UNIX or VMS nodes -- not a mixture.

This problem can be overcome entirely given a mechanism that makes
the project drawing name space available to all tools in some
automatic manner.  Then the PRIM_FILE property becomes redundant --
the tool simply asks the file name server for the name of the
file of type \fIspecial\fP
(as given the PRIM_TYPE property) that goes with the current drawing.
