.DS L

.BC
exception.cl -- A drawing for which a specific extension has been chosen;
bypassing the selection rules.
.EC
.PV
#ifndef ER_EXCEPTION_H
#define ER_EXCEPTION_H 1
#include "er_heap.h"
#include "Clib/stringt.h"
#include "dwg_special.h"
#include "dwg_version.h"
class erule_drawing_extension;
class erule_rule;
class erule_scalddir;
class erule_lex;

gavl_define(_name,erule_drawing_entry,string);
.EP
class erule_drawing_entry {
.PV
    gavl_inst(_name,erule_drawing_entry,string);
    gringroot(_next,erule_drawing_special) specials;
    gringroot(next,erule_drawing_version) versions;
    boolean expressions_read;
    erule_drawing_version* enter_version(int);
    erule_drawing_special* enter_special(const string& extension, 
					 const erule_scalddir&);
    void selection_error(int errnum, erule_rule*);
    void read_expressions();
    void parse_menu_body(erule_lex*);
    void parse_menu_properties(erule_lex*);
    void delete_menu(erule_drawing_version*);
.EP
public:
    erule_drawing_entry(const string&);
    ~erule_drawing_entry() 
	{ fault("~erule_drawing_entry() not implemented"); }
    erule_drawing_special* select_special(erule_rule*);
    boolean is_single_versioned();

    const string& name();
    erule_drawing_extension* select_extension(erule_rule*, 
					      boolean special_found);
    void read_pages(const erule_scalddir&);
    void read_special_files(const erule_scalddir&);
    void read_menu(erule_drawing_extension* menu);
    void set_expression_from_menu(int version, const erule_expression&);
    void menu_error(int, const char* property = 0);

    void dump(ostream&);
};
.PV
gavl_inline(_name,erule_drawing_entry,string);

inline erule_drawing_entry::erule_drawing_entry(const string& name)
{ 
    AS(!this);
    this = (erule_drawing_entry*)erule_heap.mem(sizeof(*this));
    _name = name;  expressions_read = FALSE;
}

inline const string& erule_drawing_entry::name() { return _name; }
#endif
.EP
.DE
